/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class FloorSpawnConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>>[] floorSpawns;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>>[] treasureFloorSpawns;
    private final List<WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>>> floorSpawnsRandomLists = new ArrayList<WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>>>(100);
    private final List<WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>>> treasureFloorSpawnsRandomLists = new ArrayList<WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>>>(100);
    public final List<List<String>> floor_list = List.of(List.of("tensura:one_eyed_owl,200,1,3", "tensura:slime,1000,1,3", "tensura:bulldeer,1000,1,1", "tensura:hover_lizard,600,1,1", "tensura:horned_rabbit:1000,1,2", "tensura:barghest,50,1,1", "tensura:leech_lizard,50,1,1", "tensura:direwolf,50,1,1"), List.of("tensura:bulldeer,600,1,1", "tensura:one_eyed_owl,100,3,3", "tensura:slime,1000,2,3", "tensura:hover_lizard,1000,1,1", "tensura:horned_rabbit,1000,2,4", "tensura:barghest,100,1,1", "tensura:leech_lizard,100,1,1", "tensura:direwolf,100,1,1", "tensura:giant_bear,20,1,1", "tensura:giant_bat,10,1,1"), List.of("tensura:one_eyed_owl,100,3,5", "tensura:slime,1000,1,3", "tensura:bulldeer,1000,1,1", "tensura:hover_lizard,600,1,1", "tensura:horned_rabbit:1000,3,4", "tensura:barghest,200,1,1", "tensura:leech_lizard,200,1,1", "tensura:direwolf,200,1,1", "tensura:giant_bear,40,1,1", "tensura:giant_bat,40,1,1"), List.of("tensura:slime,200,1,3", "tensura:bulldeer,200,1,1", "tensura:hell_moth,200,1,1", "tensura:giant_bear,200,1,1", "tensura:hover_lizard,600,1,1", "tensura:horned_rabbit,200,3,4", "tensura:barghest,1000,1,1", "tensura:leech_lizard,1000,1,1", "tensura:direwolf,1000,1,1", "tensura:winged_cat,5,1,1", "tensura:salamander,5,1,1", "tensura:feathered_serpent,5,1,1", "tensura:beast_gnome,5,1,1", "tensura:aqua_frog,5,1,1"), List.of("tensura:slime,75,1,3", "tensura:hover_lizard,75,1,1", "tensura:horned_rabbit,75,3,4", "tensura:barghest,800,2,3", "tensura:leech_lizard,800,2,3", "tensura:direwolf,800,2,3", "tensura:horned_bear,120,1,1", "tensura:giant_bat,120,1,1", "tensura:giant_bear,200,1,1", "tensura:hell_moth,200,1,1", "tensura:winged_cat,8,1,1", "tensura:salamander,8,1,1", "tensura:feathered_serpent,8,1,1", "tensura:beast_gnome,8,1,1", "tensura:aqua_frog,8,1,1"), List.of("tensura:slime,50,1,3", "tensura:hover_lizard,50,1,1", "tensura:horned_rabbit,50,3,4", "tensura:barghest,700,2,4", "tensura:leech_lizard,700,2,4", "tensura:direwolf,700,2,4", "tensura:horned_bear,300,1,1", "tensura:giant_bat,300,1,1", "tensura:armoursaurus,40,1,1", "tensura:black_spider,40,1,1", "tensura:winged_cat,10,1,1", "tensura:salamander,10,1,1", "tensura:feathered_serpent,10,1,1", "tensura:beast_gnome,10,1,1", "tensura:aqua_frog,10,1,1", "trbeyond:blue_slime_doll,10,1,1", "trbeyond:green_slime_doll,10,1,1", "trbeyond:yellow_slime_doll,10,1,1", "trbeyond:red_slime_doll,10,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1"), List.of("tensura:slime,50,1,3", "tensura:hover_lizard,50,1,1", "tensura:horned_rabbit,50,3,4", "tensura:barghest,600,2,4", "tensura:leech_lizard,600,2,4", "tensura:direwolf,600,2,4", "tensura:horned_bear,350,2,3", "tensura:giant_bat,350,2,3", "tensura:armoursaurus,60,1,2", "tensura:black_spider,60,1,2", "tensura:winged_cat,12,1,1", "tensura:salamander,12,1,1", "tensura:feathered_serpent,12,1,1", "tensura:beast_gnome,12,1,1", "tensura:aqua_frog,12,1,1", "trbeyond:blue_slime_doll,12,1,1", "trbeyond:green_slime_doll,12,1,1", "trbeyond:yellow_slime_doll,12,1,1", "trbeyond:red_slime_doll,12,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1"), List.of("tensura:slime,50,1,3", "tensura:hover_lizard,50,1,1", "tensura:horned_rabbit,50,3,4", "tensura:barghest,500,2,6", "tensura:leech_lizard,500,2,6", "tensura:direwolf,500,2,6", "tensura:horned_bear,200,1,3", "tensura:giant_bat,200,1,3", "tensura:armoursaurus,120,1,1", "tensura:black_spider,120,1,1", "trbeyond:grave_lizard,40,1,1", "trbeyond:king_crawler,40,1,1", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "trbeyond:blue_slime_doll,15,1,1", "trbeyond:green_slime_doll,15,1,1", "trbeyond:yellow_slime_doll,15,1,1", "trbeyond:red_slime_doll,15,1,1", "trbeyond:stellar_mimic_boss,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1"), List.of(), List.of("tensura:slime,50,1,3", "tensura:one_eyed_owl,50,3,5", "tensura:bulldeer,50,1,1", "tensura:leech_lizard,300,3,6", "tensura:direwolf,450,3,6", "tensura:horned_bear,200,1,3", "tensura:black_spider,200,1,1", "tensura:giant_bear,200,1,3", "trbeyond:grave_lizard,120,1,1", "trbeyond:king_crawler,120,1,1", "tensura:giant_ant,160,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "trbeyond:blue_slime_doll,15,1,1", "trbeyond:green_slime_doll,15,1,1", "trbeyond:yellow_slime_doll,15,1,1", "trbeyond:red_slime_doll,15,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,40,1,3", "tensura:one_eyed_owl,40,3,5", "tensura:bulldeer,40,1,1", "tensura:leech_lizard,250,3,6", "tensura:direwolf,400,3,6", "tensura:horned_bear,240,1,3", "tensura:black_spider,240,1,1", "tensura:giant_bear,240,1,3", "trbeyond:grave_lizard,150,1,1", "trbeyond:king_crawler,150,1,1", "tensura:giant_ant,170,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "trbeyond:blue_slime_doll,15,1,1", "trbeyond:green_slime_doll,15,1,1", "trbeyond:yellow_slime_doll,15,1,1", "trbeyond:red_slime_doll,15,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,30,1,3", "tensura:one_eyed_owl,30,3,5", "tensura:bulldeer,30,1,1", "tensura:leech_lizard,200,3,6", "tensura:direwolf,350,3,6", "tensura:horned_bear,270,1,3", "tensura:black_spider,270,1,1", "tensura:giant_bear,270,1,3", "trbeyond:grave_lizard,180,1,1", "trbeyond:king_crawler,180,1,1", "tensura:giant_ant,180,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "trbeyond:blue_slime_doll,15,1,1", "trbeyond:green_slime_doll,15,1,1", "trbeyond:yellow_slime_doll,15,1,1", "trbeyond:red_slime_doll,15,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,20,1,3", "tensura:one_eyed_owl,20,3,5", "tensura:bulldeer,20,1,1", "tensura:leech_lizard,100,3,6", "tensura:direwolf,300,3,6", "tensura:horned_bear,300,1,3", "tensura:black_spider,300,1,1", "tensura:giant_bear,300,1,3", "trbeyond:grave_lizard,200,1,1", "trbeyond:king_crawler,200,1,1", "tensura:giant_ant,190,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "trbeyond:blue_slime_doll,15,1,1", "trbeyond:green_slime_doll,15,1,1", "trbeyond:yellow_slime_doll,15,1,1", "trbeyond:red_slime_doll,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,20,1,3", "tensura:one_eyed_owl,20,3,5", "tensura:bulldeer,20,1,1", "tensura:hover_lizard,30,1,1", "tensura:horned_rabbit,50,3,4", "tensura:barghest,260,2,3", "tensura:giant_bat,270,2,4", "trbeyond:grave_lizard,220,1,1", "trbeyond:king_crawler,220,1,1", "tensura:horned_bear,300,1,3", "tensura:giant_bear,300,1,3", "tensura:black_spider,300,1,1", "tensura:armoursaurus,200,1,1", "tensura:giant_ant,160,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:blue_slime_doll,30,1,1", "trbeyond:green_slime_doll,30,1,1", "trbeyond:yellow_slime_doll,30,1,1", "trbeyond:red_slime_doll,30,1,1", "trbeyond:slime_doll_fusion,10,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:tempest_serpent,50,1,1", "tensura:army_wasp,50,1,1", "tensura:evil_centipede,50,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,20,1,3", "tensura:one_eyed_owl,20,3,5", "tensura:bulldeer,20,1,1", "tensura:barghest,220,2,3", "tensura:giant_bat,250,2,4", "trbeyond:grave_lizard,240,1,1", "trbeyond:king_crawler,240,1,1", "tensura:horned_bear,300,1,3", "tensura:giant_bear,300,1,3", "tensura:black_spider,300,1,1", "tensura:armoursaurus,180,1,1", "tensura:giant_ant,180,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:blue_slime_doll,30,1,1", "trbeyond:green_slime_doll,30,1,1", "trbeyond:yellow_slime_doll,30,1,1", "trbeyond:red_slime_doll,30,1,1", "trbeyond:slime_doll_fusion,10,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:tempest_serpent,60,1,1", "tensura:army_wasp,60,1,1", "tensura:evil_centipede,60,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,20,1,3", "tensura:one_eyed_owl,20,3,5", "tensura:bulldeer,20,1,1", "tensura:barghest,180,2,3", "tensura:giant_bat,200,2,4", "trbeyond:grave_lizard,260,1,1", "trbeyond:king_crawler,260,1,1", "tensura:horned_bear,300,1,3", "tensura:giant_bear,300,1,3", "tensura:black_spider,300,1,1", "tensura:armoursaurus,160,1,1", "tensura:giant_ant,200,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:blue_slime_doll,30,1,1", "trbeyond:green_slime_doll,30,1,1", "trbeyond:yellow_slime_doll,30,1,1", "trbeyond:red_slime_doll,30,1,1", "trbeyond:slime_doll_fusion,10,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:tempest_serpent,80,1,1", "tensura:army_wasp,80,1,1", "tensura:evil_centipede,80,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,20,1,3", "tensura:one_eyed_owl,20,3,5", "tensura:bulldeer,20,1,1", "tensura:barghest,140,2,3", "tensura:giant_bat,180,2,4", "trbeyond:grave_lizard,280,1,1", "trbeyond:king_crawler,280,1,1", "tensura:horned_bear,300,1,3", "tensura:giant_bear,300,1,3", "tensura:black_spider,300,1,1", "tensura:armoursaurus,150,1,1", "tensura:giant_ant,200,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:blue_slime_doll,30,1,1", "trbeyond:green_slime_doll,30,1,1", "trbeyond:yellow_slime_doll,30,1,1", "trbeyond:red_slime_doll,30,1,1", "trbeyond:slime_doll_fusion,10,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:tempest_serpent,90,1,1", "tensura:army_wasp,90,1,1", "tensura:evil_centipede,90,1,1", "trbeyond:minh_slime,1,1,3"), List.of("tensura:slime,20,1,3", "tensura:one_eyed_owl,20,3,5", "tensura:bulldeer,20,1,1", "tensura:barghest,100,2,3", "tensura:giant_bat,150,2,4", "trbeyond:grave_lizard,300,1,1", "trbeyond:king_crawler,300,1,1", "tensura:horned_bear,300,1,3", "tensura:giant_bear,300,1,3", "tensura:black_spider,300,1,1", "tensura:armoursaurus,200,1,1", "tensura:giant_ant,200,1,2", "tensura:hell_moth,100,1,2", "tensura:winged_cat,15,1,1", "tensura:salamander,15,1,1", "tensura:feathered_serpent,15,1,1", "tensura:beast_gnome,15,1,1", "tensura:aqua_frog,15,1,1", "tensura:kiara_mizutani,5,1,1", "tensura:kyoya_tachibana,5,1,1", "tensura:mai_furuki,5,1,1", "tensura:mark_lauren,5,1,1", "tensura:shinji_tanimura,5,1,1", "tensura:shin_ryusei,5,1,1", "tensura:shogo_taguchi,5,1,1", "trbeyond:blue_slime_doll,30,1,1", "trbeyond:green_slime_doll,30,1,1", "trbeyond:yellow_slime_doll,30,1,1", "trbeyond:red_slime_doll,30,1,1", "trbeyond:slime_doll_fusion,10,1,1", "trbeyond:stellar_mimic_boss,10,1,1", "tensura:tempest_serpent,100,1,1", "tensura:army_wasp,100,1,1", "tensura:evil_centipede,100,1,1", "trbeyond:minh_slime,1,1,3"), List.of());
    public final List<List<String>> treasure_floor_list = List.of(List.of("tensura:barghest,600,2,3", "tensura:leech_lizard,600,2,3", "tensura:direwolf,50,2,3", "tensura:horned_bear,50,2,2", "tensura:giant_bat,50,2,2", "tensura:winged_cat,10,1,1", "tensura:salamander,10,1,1", "tensura:feathered_serpent,10,1,1", "tensura:beast_gnome,10,1,1", "tensura:aqua_frog,10,1,1", "trbeyond:minh_slime,5,1,1"), List.of("tensura:horned_bear,50,2,2", "tensura:giant_bat,50,2,2", "tensura:barghest,600,2,3", "tensura:leech_lizard,600,2,3", "tensura:direwolf,600,2,3", "tensura:winged_cat,10,1,1", "tensura:salamander,10,1,1", "tensura:feathered_serpent,10,1,1", "tensura:beast_gnome,10,1,1", "tensura:aqua_frog,10,1,1", "trbeyond:minh_slime,5,1,1"), List.of("tensura:horned_bear,200,2,2", "tensura:giant_bat,200,2,2", "tensura:barghest,600,2,4", "tensura:leech_lizard,600,2,4", "tensura:direwolf,600,2,4", "tensura:winged_cat,10,1,1", "tensura:salamander,10,1,1", "tensura:feathered_serpent,10,1,1", "tensura:beast_gnome,10,1,1", "tensura:aqua_frog,10,1,1", "trbeyond:minh_slime,5,1,1"), List.of("tensura:horned_bear,600,2,2", "tensura:giant_bat,600,2,2", "tensura:armoursaurus,300,1,2", "tensura:black_spider,300,1,2", "tensura:winged_cat,20,1,1", "tensura:salamander,20,1,1", "tensura:feathered_serpent,20,1,1", "tensura:beast_gnome,20,1,1", "tensura:aqua_frog,20,1,1", "trbeyond:blue_slime_doll,20,1,1", "trbeyond:green_slime_doll,20,1,1", "trbeyond:yellow_slime_doll,20,1,1", "trbeyond:red_slime_doll,20,1,1", "trbeyond:minh_slime,5,1,1"), List.of("tensura:horned_bear,600,3,4", "tensura:giant_bat,600,3,4", "tensura:armoursaurus,100,1,2", "tensura:black_spider,100,1,2", "trbeyond:grave_lizard,50,1,1", "trbeyond:king_crawler,50,1,1", "tensura:winged_cat,25,1,1", "tensura:salamander,25,1,1", "tensura:feathered_serpent,25,1,1", "tensura:beast_gnome,25,1,1", "tensura:aqua_frog,25,1,1", "trbeyond:blue_slime_doll,25,1,1", "trbeyond:green_slime_doll,25,1,1", "trbeyond:yellow_slime_doll,25,1,1", "trbeyond:red_slime_doll,25,1,1", "trbeyond:stellar_mimic_boss,25,1,1", "trbeyond:minh_slime,5,1,1"), List.of("trbeyond:grave_lizard,200,1,1", "trbeyond:king_crawler,200,1,1", "tensura:armoursaurus,600,1,2", "tensura:black_spider,600,1,2", "tensura:winged_cat,30,1,1", "tensura:salamander,30,1,1", "tensura:feathered_serpent,30,1,1", "tensura:beast_gnome,30,1,1", "tensura:aqua_frog,30,1,1", "trbeyond:blue_slime_doll,30,1,1", "trbeyond:green_slime_doll,30,1,1", "trbeyond:yellow_slime_doll,30,1,1", "trbeyond:red_slime_doll,30,1,1", "trbeyond:stellar_mimic_boss,30,1,1", "trbeyond:minh_slime,5,1,1"), List.of("trbeyond:grave_lizard,200,1,2", "trbeyond:king_crawler,200,1,2", "tensura:armoursaurus,700,1,3", "tensura:black_spider,700,1,3", "tensura:winged_cat,35,1,1", "tensura:salamander,35,1,1", "tensura:feathered_serpent,35,1,1", "tensura:beast_gnome,35,1,1", "tensura:aqua_frog,35,1,1", "trbeyond:blue_slime_doll,35,1,1", "trbeyond:green_slime_doll,35,1,1", "trbeyond:yellow_slime_doll,35,1,1", "trbeyond:red_slime_doll,35,1,1", "trbeyond:stellar_mimic_boss,35,1,1", "trbeyond:minh_slime,5,1,1"), List.of("trbeyond:grave_lizard,200,1,2", "trbeyond:king_crawler,200,1,2", "tensura:armoursaurus,700,1,3", "tensura:black_spider,700,1,3", "tensura:winged_cat,40,1,1", "tensura:salamander,40,1,1", "tensura:feathered_serpent,40,1,1", "tensura:beast_gnome,40,1,1", "tensura:aqua_frog,40,1,1", "trbeyond:blue_slime_doll,40,1,1", "trbeyond:green_slime_doll,40,1,1", "trbeyond:yellow_slime_doll,40,1,1", "trbeyond:red_slime_doll,40,1,1", "trbeyond:stellar_mimic_boss,40,1,1", "trbeyond:minh_slime,5,1,1"), List.of(), List.of("tensura:army_wasp,50,1,1", "tensura:evil_centipede,100,1,1", "tensura:tempest_serpent,100,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:army_wasp,70,1,1", "tensura:evil_centipede,110,1,1", "tensura:tempest_serpent,110,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:army_wasp,90,1,1", "tensura:evil_centipede,120,1,1", "tensura:tempest_serpent,120,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:army_wasp,100,1,1", "tensura:evil_centipede,150,1,1", "tensura:tempest_serpent,150,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:armoursaurus,150,1,3", "tensura:black_spider,350,1,3", "tensura:army_wasp,150,1,1", "tensura:evil_centipede,150,1,1", "tensura:tempest_serpent,150,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:armoursaurus,140,1,3", "tensura:black_spider,340,1,3", "tensura:army_wasp,180,1,1", "tensura:evil_centipede,180,1,1", "tensura:tempest_serpent,180,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:armoursaurus,120,1,3", "tensura:black_spider,320,1,3", "tensura:army_wasp,220,1,1", "tensura:evil_centipede,220,1,1", "tensura:tempest_serpent,220,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:armoursaurus,110,1,3", "tensura:black_spider,310,1,3", "tensura:army_wasp,260,1,1", "tensura:evil_centipede,260,1,1", "tensura:tempest_serpent,260,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of("tensura:armoursaurus,100,1,3", "tensura:black_spider,300,1,3", "tensura:army_wasp,300,1,1", "tensura:evil_centipede,300,1,1", "tensura:tempest_serpent,300,1,1", "tensura:supermassive_slime,10,1,1", "trbeyond:boss_black_spider,5,1,1", "tensura:akash,5,1,1", "tensura:sylphide,5,1,1", "tensura:war_gnome,5,1,1", "tensura:ifrit,5,1,1", "tensura:undine,5,1,1"), List.of());
    public static final int FLOORS = 19;

    public FloorSpawnConfig(ForgeConfigSpec.Builder builder) {
        int i;
        this.floorSpawns = new ForgeConfigSpec.ConfigValue[19];
        this.treasureFloorSpawns = new ForgeConfigSpec.ConfigValue[19];
        for (i = 0; i < 19; ++i) {
            int floorNumber = i + 2;
            builder.push("floor" + floorNumber);
            this.floorSpawns[i] = builder.comment("List of mobs and weights for floor " + floorNumber + " format: modid:entity,weight,min,max").defineList("floorMobs", this.floor_list.get(i), o -> o instanceof String);
            this.treasureFloorSpawns[i] = builder.comment("List of mobs and weights for treasure rooms on floor " + floorNumber + " format: modid:entity,weight,min,max").defineList("treasureFloorMobs", this.treasure_floor_list.get(i), o -> o instanceof String);
            builder.pop();
        }
        this.floorSpawnsRandomLists.clear();
        this.treasureFloorSpawnsRandomLists.clear();
        for (i = 0; i < 100; ++i) {
            this.floorSpawnsRandomLists.add(null);
            this.treasureFloorSpawnsRandomLists.add(null);
        }
    }

    public List<? extends String> getFloorRawEntries(int floorNumber) {
        if (floorNumber < 1 || floorNumber > 19) {
            return Collections.emptyList();
        }
        return (List)this.floorSpawns[floorNumber - 2].get();
    }

    public List<? extends String> getTreasureFloorRawEntries(int floorNumber) {
        if (floorNumber < 1 || floorNumber > 19) {
            return Collections.emptyList();
        }
        return (List)this.treasureFloorSpawns[floorNumber - 2].get();
    }

    private WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>> parseWeightedEntries(List<? extends String> entries) {
        ArrayList<WeightedEntry.Wrapper> list = new ArrayList<WeightedEntry.Wrapper>();
        for (String string : entries) {
            ResourceLocation rl;
            EntityType type;
            String[] parts = string.split(",");
            if (parts.length != 4 || (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl = new ResourceLocation(parts[0].trim()))) == null) continue;
            try {
                int weight = Integer.parseInt(parts[1].trim());
                int min = Integer.parseInt(parts[2].trim());
                int max = Integer.parseInt(parts[3].trim());
                list.add(WeightedEntry.m_146290_((Object)new SpawnParams(type, min, max), (int)weight));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return WeightedRandomList.m_146328_(list);
    }

    public WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>> getFloorRandomEntryList(int floorNumber) {
        int floorIndex = floorNumber - 2;
        if (this.floorSpawnsRandomLists.get(floorIndex) == null) {
            this.floorSpawnsRandomLists.set(floorIndex, this.parseWeightedEntries(this.getFloorRawEntries(floorNumber)));
        }
        return this.floorSpawnsRandomLists.get(floorIndex);
    }

    public WeightedRandomList<WeightedEntry.Wrapper<SpawnParams>> getTreasureFloorRandomEntryList(int floorNumber) {
        int floorIndex = floorNumber - 2;
        if (this.treasureFloorSpawnsRandomLists.get(floorIndex) == null) {
            this.treasureFloorSpawnsRandomLists.set(floorIndex, this.parseWeightedEntries(this.getTreasureFloorRawEntries(floorNumber)));
        }
        return this.treasureFloorSpawnsRandomLists.get(floorIndex);
    }

    public record SpawnParams(EntityType<?> entityType, int minCount, int maxCount) {
    }
}

