/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.config;

import io.github.Memoires.trbeyond.client.screen.KurobeShopEnum;
import java.util.EnumMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class NpcConfig {
    public final ForgeConfigSpec.ConfigValue<String> highValueItem;
    public final ForgeConfigSpec.ConfigValue<String> medValueItem;
    public final ForgeConfigSpec.ConfigValue<String> lowValueItem;
    public final ForgeConfigSpec.ConfigValue<String> lowestValueItem;
    public final ForgeConfigSpec.ConfigValue<String> nameSpace;
    public final Map<KurobeShopEnum.KurobeShop, ForgeConfigSpec.IntValue> item_prices = new EnumMap<KurobeShopEnum.KurobeShop, ForgeConfigSpec.IntValue>(KurobeShopEnum.KurobeShop.class);

    public NpcConfig(ForgeConfigSpec.Builder builder) {
        builder.push("customCoinItems");
        this.highValueItem = builder.comment("name of item to use for NPC shops, highest value").define("highCoin", (Object)"stellar_gold_coin");
        this.medValueItem = builder.comment("name of item to use for NPC shops, medium value").define("medCoin", (Object)"gold_coin");
        this.lowValueItem = builder.comment("name of item to use for NPC shops, low value").define("lowCoin", (Object)"silver_coin");
        this.lowestValueItem = builder.comment("name of item to use for NPC shops, lowest value").define("lowestCoin", (Object)"bronze_coin");
        this.nameSpace = builder.comment("namespace for items, used to prevent conflicts with other mods").define("name_space", (Object)"tensura");
        builder.pop();
        builder.push("itemPrices");
        for (KurobeShopEnum.KurobeShop item : KurobeShopEnum.KurobeShop.values()) {
            this.item_prices.put(item, builder.comment("Price for " + item.name()).defineInRange(item.name().toLowerCase() + "_price", item.cost, 1, 64));
        }
        builder.pop();
    }
}

