/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.container;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class SubspacePocketContainer
extends SimpleContainer {
    private final int maxStackSize;
    private final int subordinateCapacity;
    private final NonNullList<ItemStack> subordinates;

    public SubspacePocketContainer(int size, int stackSize, int subordinateCapacity) {
        super(size);
        this.maxStackSize = stackSize;
        this.subordinateCapacity = subordinateCapacity;
        this.subordinates = NonNullList.m_122780_((int)subordinateCapacity, (Object)ItemStack.f_41583_);
    }

    public int m_6893_() {
        return this.maxStackSize;
    }

    public boolean canStoreSubordinate() {
        for (int i = 0; i < this.subordinates.size(); ++i) {
            if (this.subordinates.get(i) != ItemStack.f_41583_) continue;
            return true;
        }
        return false;
    }

    public void storeSubordinate(ItemStack shadow) {
        for (int i = 0; i < this.subordinates.size(); ++i) {
            if (this.subordinates.get(i) != ItemStack.f_41583_) continue;
            this.setSubordinateItem(i, shadow);
            return;
        }
    }

    public int getSubordinateCapacity() {
        return this.subordinateCapacity;
    }

    public int getFirstSubordinateItemIndex() {
        for (int i = 0; i < this.subordinates.size(); ++i) {
            if (this.subordinates.get(i) == ItemStack.f_41583_) continue;
            return i;
        }
        return -1;
    }

    public void setSubordinateItem(int index, ItemStack stack) {
        this.subordinates.set(index, (Object)stack);
    }

    public ItemStack getSubordinateItem(int index) {
        return index >= 0 && index < this.subordinates.size() ? (ItemStack)this.subordinates.get(index) : ItemStack.f_41583_;
    }

    public void removeSubordinateItem(int index) {
        this.setSubordinateItem(index, ItemStack.f_41583_);
    }

    public void m_7797_(ListTag tag) {
        int i;
        for (i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        for (i = 0; i < this.getSubordinateCapacity(); ++i) {
            this.setSubordinateItem(i, ItemStack.f_41583_);
        }
        for (i = 0; i < tag.size(); ++i) {
            CompoundTag iTag = tag.m_128728_(i);
            int k = iTag.m_128451_("Slot");
            boolean isSubordinate = iTag.m_128471_("s");
            if (isSubordinate && k < this.subordinates.size()) {
                ItemStack shadow = ItemStack.m_41712_((CompoundTag)iTag);
                this.subordinates.set(k, (Object)shadow);
            }
            if (isSubordinate || k >= this.m_6643_()) continue;
            ItemStack item = ItemStack.m_41712_((CompoundTag)iTag);
            this.m_6836_(k, item);
        }
    }

    public ListTag m_7927_() {
        int i;
        ListTag storageNbt = new ListTag();
        for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            itemTag.m_128379_("s", false);
            itemStack.m_41739_(itemTag);
            storageNbt.add((Object)itemTag);
        }
        for (i = 0; i < this.subordinates.size(); ++i) {
            ItemStack subordinateItem = this.getSubordinateItem(i);
            if (subordinateItem.m_41619_()) continue;
            CompoundTag subordinateTag = new CompoundTag();
            subordinateTag.m_128405_("Slot", i);
            subordinateTag.m_128379_("s", true);
            subordinateItem.m_41739_(subordinateTag);
            storageNbt.add((Object)subordinateTag);
        }
        return storageNbt;
    }
}

