/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.core;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.unique.ShadowStrikerSkill;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trbeyond.items.weapons.NinjatoItem;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShadowStrikerSkill.class})
public abstract class MixinShadowStrikerSkill {
    @Inject(method={"onDamageEntity"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e, CallbackInfo ci) {
        DamageSource source;
        if (((ShadowStrikerSkill)UniqueSkills.SHADOW_STRIKER.get()).isInSlot(attacker) && instance.getMode() == 2 && !instance.onCoolDown() && (source = e.getSource()).m_7639_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)source) && !SkillHelper.outOfMagicule((LivingEntity)attacker, (ManasSkillInstance)instance) && this.isHoldingNinjato(attacker)) {
            LivingEntity living = e.getEntity();
            DamageSourceHelper.directSpiritualHurt((LivingEntity)living, (Entity)attacker, (float)1000.0f);
            instance.setCoolDown(instance.isMastered(living) ? 5 : 10);
            if (!living.m_6084_()) {
                e.setCanceled(true);
            }
            ci.cancel();
        }
    }

    private boolean isHoldingNinjato(LivingEntity attacker) {
        ItemStack mainHandStack = attacker.m_21205_();
        ItemStack offHandStack = attacker.m_21206_();
        return mainHandStack.m_41720_() instanceof NinjatoItem || offHandStack.m_41720_() instanceof NinjatoItem;
    }

    @Inject(method={"onPressed"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onUseSkill(ManasSkillInstance instance, LivingEntity entity, CallbackInfo ci) {
        if (instance.getMode() == 1 && entity.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            ci.cancel();
        }
    }
}

