/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.core;

import com.github.manasmods.tensura.ability.SkillUtils;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.Memoires.trbeyond.enchantment.InfusionEnchantment;
import io.github.Memoires.trbeyond.enchantment.SpatialInfusionEnchantment;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.entity.custom.EvilCentipedeBossEntity;
import io.github.Memoires.trbeyond.entity.custom.GozulEntity;
import io.github.Memoires.trbeyond.entity.custom.MezulEntity;
import io.github.Memoires.trbeyond.entity.custom.OgreLordEntity;
import io.github.Memoires.trbeyond.entity.custom.TempestSerpentBossEntity;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={SkillUtils.class})
public class MixinSkillUtils {
    @Unique
    private static final Enchantment trbeyond$SPATIAL = (Enchantment)BeyondEnchantments.SPATIAL_INFUSION.get();

    @ModifyReturnValue(method={"canAutoSmelt"}, at={@At(value="RETURN")}, remap=false)
    private static boolean canAutoSmelt(boolean original, Entity entity) {
        if (original) {
            return true;
        }
        if (!(entity instanceof LivingEntity)) {
            return original;
        }
        if (InfusionEnchantment.hasFullSetEffect((LivingEntity)entity, (Enchantment)BeyondEnchantments.FLAME_INFUSION.get())) {
            original = true;
        }
        return original;
    }

    @ModifyReturnValue(method={"haveSeveranceAttack"}, at={@At(value="RETURN")}, remap=false)
    private static boolean haveSeveranceAttack(boolean original, DamageSource damageSource, LivingEntity target) {
        LivingEntity attacker;
        ItemStack weapon;
        if (MixinSkillUtils.trbeyond$hasSpatialInfusionInArmor(target)) {
            return false;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity && (weapon = (attacker = (LivingEntity)entity).m_21205_()).m_41793_() && weapon.getEnchantmentLevel(trbeyond$SPATIAL) > 0) {
            return true;
        }
        return original;
    }

    @Unique
    private static boolean trbeyond$hasSpatialInfusionInArmor(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Map enchantments;
            ItemStack armorItem;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorItem = entity.m_6844_(slot)).m_41619_() || !(enchantments = EnchantmentHelper.m_44831_((ItemStack)armorItem)).keySet().stream().anyMatch(e -> e instanceof SpatialInfusionEnchantment)) continue;
            return true;
        }
        return false;
    }

    @ModifyReturnValue(method={"reducingResistances"}, at={@At(value="RETURN")}, remap=false)
    private static boolean reducingResistances(boolean original, LivingEntity entity) {
        if (entity.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
            return original || entity instanceof BossBlackSpiderEntity || entity instanceof EvilCentipedeBossEntity || entity instanceof TempestSerpentBossEntity || entity instanceof GozulEntity || entity instanceof MezulEntity || entity instanceof OgreLordEntity;
        }
        return original;
    }
}

