/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.effect;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.effect.template.SkillMobEffect;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class LimitedEffect
extends SkillMobEffect {
    protected static final String LIMITED = "e0ac7155-4c03-4533-b5ef-bd87e7f2ed35";

    public LimitedEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
        this.m_19472_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get(), LIMITED, 1.0, AttributeModifier.Operation.ADDITION);
        this.m_19472_((Attribute)TensuraAttributeRegistry.MAX_AURA.get(), LIMITED, 1.0, AttributeModifier.Operation.ADDITION);
    }

    public void m_6385_(LivingEntity target, AttributeMap pAttributeMap, int pAmplifier) {
        if (target instanceof Player) {
            Player player = (Player)target;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                double limit = DungeonCapability.getEpLimit(target);
                if (limit <= 0.0) {
                    return;
                }
                for (Map.Entry entry : this.m_19485_().entrySet()) {
                    AttributeInstance instance = pAttributeMap.m_22146_((Attribute)entry.getKey());
                    if (instance == null) continue;
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    instance.m_22130_(modifier);
                    double value = instance.m_22099_().equals(TensuraAttributeRegistry.MAX_MAGICULE.get()) ? cap.getBaseMagicule() : cap.getBaseAura();
                    instance.m_22125_(new AttributeModifier(modifier.m_22209_(), this.m_19481_() + " " + pAmplifier, limit / 2.0 - value, modifier.m_22217_()));
                }
                cap.setAura(Math.min(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), cap.getAura()));
                cap.setMagicule(Math.min(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), cap.getMagicule()));
                TensuraPlayerCapability.sync((Player)player);
                TensuraEPCapability.updateEP((LivingEntity)target);
            });
        }
    }

    public void m_6386_(LivingEntity target, AttributeMap map, int pAmplifier) {
        super.m_6386_(target, map, pAmplifier);
        double maxMP = target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
        double maxAP = target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
        if (target instanceof Player) {
            Player player = (Player)target;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setMagicule(Math.min(maxMP, cap.getMagicule() + maxMP)));
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setAura(Math.min(maxAP, cap.getAura() + maxAP)));
            TensuraPlayerCapability.sync((Player)player);
        }
        TensuraEPCapability.updateEP((LivingEntity)target);
    }

    public void m_6742_(LivingEntity target, int pAmplifier) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)target);
        for (ManasSkillInstance instance : storage.getLearnedSkills()) {
            if (!(instance.getSkill() instanceof ResistSkill) || !instance.isToggled()) continue;
            instance.setToggled(false);
            instance.onToggleOff(target);
            instance.markDirty();
        }
        storage.syncChanges();
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 20 == 0;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }
}

