/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.enchantment;

import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trbeyond.enchantment.InfusionEnchantment;
import net.minecraft.ChatFormatting;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class BattleInfusionEnchantment
extends InfusionEnchantment {
    public BattleInfusionEnchantment() {
        super(EnchantmentCategory.BREAKABLE);
    }

    public ChatFormatting getNameFormatting() {
        return ChatFormatting.GRAY;
    }

    public float getDamageProtection(int pLevel, DamageSource source, LivingEntity wearer, EquipmentSlot slot, float damage) {
        if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return 0.0f;
        }
        if (!this.canActivate(wearer.m_6844_(slot))) {
            return 0.0f;
        }
        float protection = 0.0f;
        if (DamageSourceHelper.isNaturalEffects((DamageSource)source)) {
            protection = 0.1f * (float)pLevel * damage;
        }
        return protection;
    }

    public float getDamageBonus(int level, DamageSource source, LivingEntity attacker, LivingEntity target, EquipmentSlot slot, float damage) {
        TensuraDamageSource damageSource;
        if (slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR)) {
            return 0.0f;
        }
        ItemStack stack = attacker.m_6844_(slot);
        if (!this.canActivate(stack)) {
            return 0.0f;
        }
        float bonus = 0.0f;
        if (slot.equals((Object)EquipmentSlot.MAINHAND) && attacker.m_21023_((MobEffect)TensuraMobEffects.OGRE_GUILLOTINE.get()) && DamageSourceHelper.isPhysicalAttack((DamageSource)source)) {
            bonus = damage;
        }
        if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getSkill() != null && damageSource.getSkill().getSkill() instanceof Battewill) {
            return bonus + damage * (float)level * 0.2f;
        }
        float newDamage = 10.0f * (float)level;
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            newDamage = sword.m_43299_() * (float)level;
        }
        if ((item = stack.m_41720_()) instanceof DiggerItem) {
            DiggerItem digger = (DiggerItem)item;
            newDamage = digger.m_41008_() * (float)level;
        }
        return bonus + newDamage * 0.1f;
    }
}

