/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.enchantment;

import com.github.manasmods.manascore.api.attribute.AttributeModifierHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.enchantment.IInherentEngrave;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;

public class InfusionEnchantment
extends EngravingEnchantment
implements IInherentEngrave {
    public InfusionEnchantment(EnchantmentCategory pCategory) {
        super(Enchantment.Rarity.VERY_RARE, pCategory, EquipmentSlot.values());
    }

    public int m_6586_() {
        return 1;
    }

    public static boolean canGainInfusion(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return false;
        }
        return stack.m_41783_().m_128459_("EP") >= 1000000.0;
    }

    public boolean canActivate(ItemStack stack) {
        return InfusionEnchantment.canGainInfusion(stack);
    }

    public static boolean hasFullSetEffect(LivingEntity entity, Enchantment enchantment) {
        return InfusionEnchantment.hasFullSetEffect(entity, enchantment, 2);
    }

    public static boolean hasFullSetEffect(LivingEntity entity, Enchantment enchantment, int number) {
        int i = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) continue;
            if (entity.m_6844_(slot).getEnchantmentLevel(enchantment) >= 1) {
                ++i;
            }
            if (i < number) continue;
            return true;
        }
        return false;
    }

    public boolean shouldHasFoil(ItemStack stack) {
        return false;
    }

    public boolean canDuplicate() {
        return false;
    }

    public static void addInfusionAttribute(LivingEquipmentChangeEvent event, Enchantment enchantment, Attribute attribute, UUID uuid, float amount) {
        LivingEntity entity = event.getEntity();
        int oldLevel = event.getTo().getEnchantmentLevel(enchantment);
        int newLevel = event.getFrom().getEnchantmentLevel(enchantment);
        if (newLevel != oldLevel) {
            int level = InfusionEnchantment.getEnchantmentLevel(enchantment, entity);
            AttributeModifierHelper.removeModifier((LivingEntity)entity, (Attribute)attribute, (UUID)uuid);
            if (level > 0) {
                AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)attribute, (AttributeModifier)new AttributeModifier(uuid, "Infusion Attributes", (double)(amount * (float)level), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public static int getEnchantmentLevel(Enchantment enchantment, LivingEntity entity) {
        int i = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) continue;
            i += entity.m_6844_(slot).getEnchantmentLevel(enchantment);
        }
        return i;
    }
}

