/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.Memoires.trbeyond.entity.client.GlendaBulletModel;
import io.github.Memoires.trbeyond.entity.projectile.GlendaBulletProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class GlendaBulletRenderer
extends EntityRenderer<GlendaBulletProjectile> {
    private ResourceLocation Texture = new ResourceLocation("trbeyond", "textures/entity/bullet.png");
    private final GlendaBulletModel model;

    public GlendaBulletRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new GlendaBulletModel(pContext.m_174023_(GlendaBulletModel.LAYER_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GlendaBulletProjectile pEntity) {
        return this.Texture;
    }

    public void render(GlendaBulletProjectile entity, float pEntityYaw, float pPartialTicks, PoseStack poseStack, @NotNull MultiBufferSource buffer, int pPackedLight) {
        poseStack.m_85836_();
        double dx = entity.m_20184_().m_7096_();
        double dy = entity.m_20184_().m_7098_();
        double dz = entity.m_20184_().m_7094_();
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            dx = 1.0E-4;
        }
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx));
        float pitch = (float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-yaw - 90.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        poseStack.m_85837_(0.0, -1.25, 0.0);
        VertexConsumer vertexConsumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexConsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, pEntityYaw, pPartialTicks, poseStack, buffer, pPackedLight);
    }

    public static int getOverlayCoords(GlendaBulletProjectile pLivingEntity, float pU) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)pU), (int)OverlayTexture.m_118096_((boolean)false));
    }
}

