/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import io.github.Memoires.trbeyond.TRBeyond;
import io.github.Memoires.trbeyond.entity.custom.FireBreathEntity;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import java.util.Comparator;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BabyDragonEntity
extends Monster
implements RangedAttackMob,
IAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(BabyDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(BabyDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(BabyDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public BabyDragonEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BabyDragonEntity>)((EntityType)BeyondEntities.BABY_DRAGON.get()), world);
    }

    public BabyDragonEntity(EntityType<BabyDragonEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"babydragon");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 20){

            protected Vec3 m_7037_() {
                RandomSource random = BabyDragonEntity.this.m_217043_();
                double dir_x = BabyDragonEntity.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_y = BabyDragonEntity.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_z = BabyDragonEntity.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new DragonBiteAttack(this, 1.2, false));
        this.f_21345_.m_25352_(4, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return BabyDragonEntity.this.m_5448_() != null && !BabyDragonEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return BabyDragonEntity.this.m_21566_().m_24995_() && BabyDragonEntity.this.m_5448_() != null && BabyDragonEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = BabyDragonEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                BabyDragonEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = BabyDragonEntity.this.m_5448_();
                if (BabyDragonEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    BabyDragonEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = BabyDragonEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        BabyDragonEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 300, 32.0f){

            @Override
            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public void m_6504_(LivingEntity target, float flval) {
        this.setAnimation("animation.model.chaos_breath");
        Level world = this.m_9236_();
        TRBeyond.queueServerWork(40, () -> {
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                FireBreathEntity.shoot((LivingEntity)this, target);
                this.setAnimation("empty");
                TRBeyond.queueServerWork(5, () -> {
                    if (world instanceof ServerLevel) {
                        ServerLevel _levell = (ServerLevel)world;
                        FireBreathEntity.shoot((LivingEntity)this, target);
                        this.setAnimation("empty");
                    }
                });
            }
        });
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 100.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.3);
        return builder;
    }

    public boolean m_7327_(Entity target) {
        return false;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.animationprocedure.equals("empty")) {
            if (!this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState procedurePredicate(AnimationEvent<E> event) {
        BabyDragonEntity entity = this;
        Level world = ((Entity)entity).f_19853_;
        boolean loop = false;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!loop && this.lastloop) {
            this.lastloop = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            event.getController().clearAnimationCache();
            return PlayState.STOP;
        }
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            if (!loop) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                    this.animationprocedure = "empty";
                    event.getController().markNeedsReload();
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.lastloop = true;
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "procedure", 4.0f, this::procedurePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class DragonBiteAttack
    extends MeleeAttackGoal {
        public DragonBiteAttack(BabyDragonEntity dragon, double speed, boolean chaseIfLost) {
            super((PathfinderMob)dragon, speed, chaseIfLost);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.f_25540_.m_5448_() != null) {
                Level world = this.f_25540_.m_9236_();
                LivingEntity entity = this.f_25540_.m_5448_();
                PathfinderMob sourceentity = this.f_25540_;
                if (entity == null || sourceentity == null) {
                    return;
                }
                double rnd = 0.0;
                double waittick = 0.0;
                if ("empty".equals(((BabyDragonEntity)sourceentity).animationprocedure) && !world.m_6443_(Player.class, AABB.m_165882_((Vec3)new Vec3(sourceentity.m_20185_(), sourceentity.m_20186_(), sourceentity.m_20189_()), (double)8.0, (double)8.0, (double)8.0), e -> true).isEmpty() && !sourceentity.getPersistentData().m_128471_("dmg")) {
                    if (sourceentity instanceof BabyDragonEntity) {
                        ((BabyDragonEntity)sourceentity).setAnimation("animation.model.bite");
                    }
                    sourceentity.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
                    sourceentity.getPersistentData().m_128379_("dmg", true);
                    for (int index0 = 0; index0 < 50; ++index0) {
                        TRBeyond.queueServerWork((int)waittick, () -> DragonBiteAttack.lambda$tick$1((Entity)sourceentity, (Entity)entity));
                        waittick += 1.0;
                    }
                    TRBeyond.queueServerWork(40, () -> this.lambda$tick$5(world, (Entity)sourceentity, (Entity)entity));
                }
            }
        }

        protected double m_6639_(LivingEntity entity) {
            return 64.0;
        }

        private /* synthetic */ void lambda$tick$5(Level world, Entity sourceentity, Entity entity) {
            if (!world.m_6443_(Player.class, AABB.m_165882_((Vec3)new Vec3(sourceentity.m_20185_(), sourceentity.m_20186_(), sourceentity.m_20189_()), (double)6.0, (double)6.0, (double)6.0), e -> true).isEmpty() && "animation.model.bite".equals(((BabyDragonEntity)sourceentity).animationprocedure)) {
                ((Entity)world.m_6443_(Player.class, AABB.m_165882_((Vec3)new Vec3(sourceentity.m_20185_(), sourceentity.m_20186_(), sourceentity.m_20189_()), (double)6.0, (double)6.0, (double)6.0), e -> true).stream().sorted(new Object(){

                    Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                        return Comparator.comparingDouble(_entcnd -> _entcnd.m_20275_(_x, _y, _z));
                    }
                }.compareDistOf(sourceentity.m_20185_(), sourceentity.m_20186_(), sourceentity.m_20189_())).findFirst().orElse(null)).m_6469_((DamageSource)new EntityDamageSource("Physical", entity), 10.0f);
            }
            TRBeyond.queueServerWork(30, () -> {
                sourceentity.getPersistentData().m_128379_("dmg", false);
                if (sourceentity instanceof BabyDragonEntity) {
                    ((BabyDragonEntity)sourceentity).setAnimation("empty");
                }
            });
        }

        private static /* synthetic */ void lambda$tick$1(Entity sourceentity, Entity entity) {
            sourceentity.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
        }
    }

    public class RangedAttackGoal
    extends Goal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public RangedAttackGoal(RangedAttackMob p_25768_, double p_25769_, int p_25770_, float p_25771_) {
            this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
        }

        public RangedAttackGoal(RangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
            if (!(p_25773_ instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackMob = p_25773_;
            this.mob = (Mob)p_25773_;
            this.speedModifier = p_25774_;
            this.attackIntervalMin = p_25775_;
            this.attackIntervalMax = p_25776_;
            this.attackRadius = p_25777_;
            this.attackRadiusSqr = p_25777_ * p_25777_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
            ((BabyDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    ((BabyDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
                    return;
                }
                ((BabyDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)true);
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackMob.m_6504_(this.target, f1);
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            } else {
                ((BabyDragonEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
            }
        }
    }
}

