/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BenimaruEntity
extends HumanoidNPCEntity
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(BenimaruEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;
    protected ServerBossEvent bossEvent;

    public BenimaruEntity(EntityType<? extends BenimaruEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.miscAnimationHandler();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_20088_().m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8000.0).m_22268_(Attributes.f_22284_, 400.0).m_22268_(Attributes.f_22281_, 500.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackcontroller", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                // empty if block
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case 1 -> 30;
            default -> 100;
        };
    }

    public boolean canSleep() {
        return !this.m_21525_();
    }

    protected void sleepHandler() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5803_() && (this.m_5448_() != null || this.isInFluidType() || ++this.sleepingTime > this.maxSleepTime && this.m_9236_().m_46461_())) {
                this.setSleeping(false);
            } else if (this.m_9236_().m_46462_() && this.f_19796_.m_188503_(100) == 0) {
                if (this.f_19796_.m_188499_()) {
                    this.setSleeping(true);
                } else {
                    this.sleepingTime = 0;
                    this.maxSleepTime = 100 + this.f_19796_.m_188503_(600);
                }
            }
        }
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public int getMiscAnimation() {
        return (Integer)this.m_20088_().m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
    }

    static class BenimaruAttackGoal
    extends Goal {
        private static final Logger logger = LogUtils.getLogger();
        private final BenimaruEntity benimaru;

        public BenimaruAttackGoal(BenimaruEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.benimaru = entity;
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity target = this.benimaru.m_5448_();
            if (target instanceof Player && (player = (Player)target).m_7500_()) {
                this.benimaru.m_21661_();
                return false;
            }
            return target != null && target.m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.benimaru.m_21561_(true);
        }

        public void m_8037_() {
        }
    }
}

