/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.ai.LeapWithStrengthGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.block.SpiderEggBlock;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.BlackSpiderEntity;
import com.github.manasmods.tensura.entity.template.ClimbingEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.custom.HitboxPartEntity;
import io.github.Memoires.trbeyond.entity.projectile.BossWebBulletProjectile;
import io.github.Memoires.trbeyond.network.PlayerVariablesHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BossBlackSpiderEntity
extends ClimbingEntity
implements IAnimatable,
IGiantMob {
    private final ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(BossBlackSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EGGS = SynchedEntityData.m_135353_(BossBlackSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STRIPED = SynchedEntityData.m_135353_(BossBlackSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int miscAnimationTicks = 0;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final HitboxPartEntity[] subEntities;

    public BossBlackSpiderEntity(EntityType<? extends BossBlackSpiderEntity> type, Level level) {
        super(type, level);
        this.f_19793_ = 3.0f;
        this.f_21364_ = 250;
        this.f_21342_ = new BossBlackSpiderMoveControl(this);
        this.f_21365_ = new BossBlackSpiderLookControl(this);
        this.bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_20);
        this.subEntities = new HitboxPartEntity[]{new HitboxPartEntity<BossBlackSpiderEntity>(this, 2.0f, 1.5f, new Vec3(2.0, 1.75, 0.0)), new HitboxPartEntity<BossBlackSpiderEntity>(this, 2.5f, 3.0f, new Vec3(-1.0, 0.0, 3.5)), new HitboxPartEntity<BossBlackSpiderEntity>(this, 2.5f, 3.0f, new Vec3(1.0, 0.0, 3.5)), new HitboxPartEntity<BossBlackSpiderEntity>(this, 2.5f, 3.0f, new Vec3(-1.0, 0.0, -3.5)), new HitboxPartEntity<BossBlackSpiderEntity>(this, 2.5f, 3.0f, new Vec3(1.0, 0.0, -3.5)), new HitboxPartEntity<BossBlackSpiderEntity>(this, 3.0f, 3.5f, new Vec3(-3.75, 1.5, 0.0))};
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(this.m_19879_() + i + 1);
        }
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    public void updatePartPositions() {
        if (this.subEntities == null) {
            return;
        }
        for (HitboxPartEntity part : this.subEntities) {
            part.updatePosition();
        }
    }

    public Component m_5446_() {
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)Component.m_237115_((String)"entity.trbeyond.boss_black_spider")).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22288_, 1.5).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new SpiderLayEggsGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.2, 20.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new BossBlackSpiderLeapGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TensuraTamableEntity.WanderAroundPosGoal((TensuraTamableEntity)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new BossBlackSpiderAttackGoal(this, 1.2, true));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, null));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Villager.class, false, null));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, entity -> !(entity instanceof BossBlackSpiderEntity)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, IronGolem.class, false, null));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        return entity instanceof BlackSpiderEntity;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (!this.m_21824_()) {
            this.bossEvent.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(EGGS, (Object)0);
        this.f_19804_.m_135372_(STRIPED, (Object)Boolean.FALSE);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("Eggs", this.getEggs());
        compound.m_128379_("Striped", this.isStriped());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setEggs(compound.m_128451_("Eggs"));
        this.setStriped(compound.m_128471_("Striped"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public int getEggs() {
        return (Integer)this.f_19804_.m_135370_(EGGS);
    }

    public void setEggs(int egg) {
        this.f_19804_.m_135381_(EGGS, (Object)egg);
    }

    public boolean isStriped() {
        return (Boolean)this.f_19804_.m_135370_(STRIPED);
    }

    public void setStriped(boolean striped) {
        this.f_19804_.m_135381_(STRIPED, (Object)striped);
    }

    public boolean m_5957_() {
        return super.m_5957_() && this.getEggs() <= 0;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return !this.m_21824_() ? false : super.m_7848_(pOtherAnimal);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        if (pEffectInstance.m_19544_().equals(TensuraMobEffects.WEBBED.get())) {
            return false;
        }
        if (pEffectInstance.m_19544_().equals(TensuraMobEffects.FATAL_POISON.get())) {
            return false;
        }
        if (pEffectInstance.m_19544_().equals(MobEffects.f_19614_)) {
            return false;
        }
        return super.m_7301_(pEffectInstance);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
            if (pEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)pEntity;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 4));
            }
        }
        return flag;
    }

    public int m_5792_() {
        return 1;
    }

    public void m_6043_() {
    }

    public boolean cantBreakBlock(LivingEntity entity, boolean ignoreCollision) {
        Level level = entity.m_9236_();
        if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            return true;
        }
        return true;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        return this.m_6162_() ? entitydimensions.m_20390_(0.4f, 0.4f) : entitydimensions;
    }

    public void m_7334_(Entity pEntity) {
        if (!(pEntity instanceof BossBlackSpiderEntity)) {
            super.m_7334_(pEntity);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.updatePartPositions();
        this.targetingMovementHelper();
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 25) {
                this.areaAttack();
                TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, (int)5, (float)5.0f);
                TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, (int)5, (float)4.0f);
                TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, (int)5, (float)3.0f);
                TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, (int)5, (float)2.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.getMiscAnimation() == 4 && this.miscAnimationTicks == 15) {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.performRangedAttack(target, this.m_6162_() ? -0.3 : -1.5, this.m_6162_() ? 1.0 : 5.0, false);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getMiscAnimation() == 6 && this.miscAnimationTicks == 15) {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.performRangedAttack(target, this.m_6162_() ? -0.3 : -1.5, this.m_6162_() ? 1.0 : 5.0, true);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getMiscAnimation() == -2) {
                this.m_21573_().m_26573_();
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -1, 4, 6 -> 25;
            default -> 5;
            case 2 -> 27;
            case 3, 5 -> 30;
            case -2 -> 100;
        };
    }

    public void areaAttack() {
        AABB aabb = this.m_20191_().m_82400_(5.0);
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !this.m_7307_((Entity)entity) && !entity.equals((Object)this));
        if (!livingEntityList.isEmpty()) {
            for (LivingEntity target : livingEntityList) {
                double damageMultiplier = 2.0;
                target.m_6469_(DamageSourceHelper.addSkillAndCost((DamageSource)DamageSource.m_19370_((LivingEntity)this).m_19389_(), (double)20.0), (float)(this.m_21133_(Attributes.f_22281_) * damageMultiplier));
                target.m_20184_().m_82520_(0.0, 0.5 * damageMultiplier, 0.0);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 4));
            }
        }
    }

    private void performRangedAttack(@NotNull LivingEntity target, double xzOffset, double yOffset, boolean slinger) {
        BossWebBulletProjectile spit = new BossWebBulletProjectile(this.f_19853_, (LivingEntity)this, true, ((Item)TensuraToolItems.STICKY_STEEL_WEB_CARTRIDGE.get()).m_7968_());
        spit.setSlinger(slinger);
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double xOffset = xzOffset * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = xzOffset * (double)Mth.m_14089_((float)angle);
        spit.m_7678_(this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, this.m_146908_(), this.m_146909_());
        double d0 = target.m_20186_() + (double)(target.m_20206_() / 2.0f);
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - spit.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        spit.m_6686_(d1, d2 + f, d3, 2.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)spit);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            this.commanding(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult handleEating(Player pPlayer, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_8035_();
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            int i = this.m_146764_();
            if (!this.f_19853_.m_5776_() && i == 0 && this.m_5957_()) {
                this.m_142075_(pPlayer, hand, itemstack);
                this.m_27595_(pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(pPlayer, hand, itemstack);
                this.m_8035_();
                this.m_146740_(BossBlackSpiderEntity.m_216967_((int)(-i)), true);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setMiscAnimation(1);
        this.m_5634_(5.0f);
    }

    public boolean m_6898_(ItemStack pStack) {
        return !(pStack.m_41720_() instanceof HealingPotionItem) && pStack.m_41614_();
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source == DamageSource.f_19309_ || source == TensuraDamageSources.STEEL_THREAD || super.m_6673_(source);
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.m_204336_(TensuraTags.Blocks.WEB_BLOCKS)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    protected float m_6041_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_6041_();
    }

    protected float m_20098_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_20098_();
    }

    protected float getClimbSpeedMultiplier() {
        return this.m_6162_() ? 1.5f : 3.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (this.f_19796_.m_188499_()) {
            this.setStriped(true);
        }
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderArmor.get()).doubleValue());
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderMaxHealth.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderFollowRange.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderAttackDamage.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderMovementSpeed.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderKnockbackResistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22288_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderJumpStrength.get()).doubleValue());
        this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.blackSpiderSwimSpeed.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        AttributeInstance spiritualHP = this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        AttributeInstance maxHP = this.m_21051_(Attributes.f_22276_);
        double sHP = maxHP.m_22135_() * 2.0;
        if (spiritualHP != null) {
            spiritualHP.m_22100_(sHP);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)this, (double)sHP);
        }
        if (this.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)this);
            for (ManasSkill manasSkill : SkillAPI.getSkillRegistry()) {
                Optional existing;
                ResistSkill resist;
                if (!(manasSkill instanceof ResistSkill) || (resist = (ResistSkill)manasSkill).getResistType() != ResistSkill.ResistType.RESISTANCE || !(existing = storage.getSkill(manasSkill)).isEmpty()) continue;
                ManasSkillInstance instance = manasSkill.createDefaultInstance();
                storage.learnSkill(instance);
            }
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                ResistSkill resist;
                ManasSkill skill = instance.getSkill();
                if (!(skill instanceof ResistSkill) || (resist = (ResistSkill)skill).getResistType() != ResistSkill.ResistType.RESISTANCE) continue;
                instance.setMastery(0);
                instance.setToggled(true);
                storage.updateSkill(instance);
            }
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_6667_(DamageSource pDamageSource) {
        Entity i2;
        super.m_6667_(pDamageSource);
        if (!this.m_9236_().m_5776_() && !this.m_6162_()) {
            int additionalAmount = this.m_217043_().m_216339_(6, 9);
            int eggAmount = this.getEggs() + additionalAmount;
            if (eggAmount > 0) {
                for (int i2 = 0; i2 < eggAmount; ++i2) {
                    BlackSpiderEntity spider = (BlackSpiderEntity)((EntityType)TensuraEntityTypes.BLACK_SPIDER.get()).m_20615_(this.m_9236_());
                    if (spider == null) continue;
                    spider.m_146762_(-24000);
                    spider.m_6027_(this.m_20185_() + 0.3, this.m_20186_(), this.m_20189_() + 0.3);
                    spider.m_20334_((double)(this.f_19796_.m_188501_() - 0.5f), (double)this.f_19796_.m_188501_(), (double)(this.f_19796_.m_188501_() - 0.5f));
                    spider.f_19864_ = true;
                    this.m_9236_().m_7967_((Entity)spider);
                }
            }
        }
        if ((i2 = pDamageSource.m_7639_()) instanceof Player) {
            Player player = (Player)i2;
            player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                if (!capability.KilledSpider) {
                    ItemStack slotItem;
                    int i;
                    int coinsRemaining = (Integer)ServerConfig.INSTANCE.bossConfig.blackSpiderGoldDrop.get();
                    Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                    int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                    for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                        slotItem = player.m_150109_().m_8020_(i);
                        if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                        int spaceLeft = maxStackSize - slotItem.m_41613_();
                        int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                        slotItem.m_41769_(amountToAdd);
                        player.m_150109_().m_6836_(i, slotItem);
                        coinsRemaining -= amountToAdd;
                    }
                    if (coinsRemaining > 0) {
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (!slotItem.m_41619_()) continue;
                            int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                            ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                            player.m_150109_().m_6836_(i, newCoinStack);
                            coinsRemaining -= amountToAdd;
                        }
                    }
                    capability.KilledSpider = true;
                    capability.syncPlayerVariables((Entity)player);
                }
                ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondToolItems.SPIDER_DAGGER_SPECIAL.get())};
                EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                    if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                        ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                        if (!player.m_150109_().m_36054_(drop)) {
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                        }
                    }
                });
            });
        } else {
            TamableAnimal tame;
            LivingEntity owner;
            LivingEntity attacker;
            i2 = pDamageSource.m_7639_();
            if (i2 instanceof LivingEntity && (attacker = (LivingEntity)i2) instanceof TamableAnimal && (owner = (tame = (TamableAnimal)attacker).m_21826_()) instanceof Player) {
                Player player = (Player)owner;
                player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    if (!capability.KilledSpider) {
                        ItemStack slotItem;
                        int i;
                        int coinsRemaining = 3;
                        Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                        int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                            int spaceLeft = maxStackSize - slotItem.m_41613_();
                            int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                            slotItem.m_41769_(amountToAdd);
                            player.m_150109_().m_6836_(i, slotItem);
                            coinsRemaining -= amountToAdd;
                        }
                        if (coinsRemaining > 0) {
                            for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                                slotItem = player.m_150109_().m_8020_(i);
                                if (!slotItem.m_41619_()) continue;
                                int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                                ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                                player.m_150109_().m_6836_(i, newCoinStack);
                                coinsRemaining -= amountToAdd;
                            }
                        }
                        capability.KilledSpider = true;
                        capability.syncPlayerVariables((Entity)player);
                    }
                    ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondToolItems.SPIDER_DAGGER_SPECIAL.get())};
                    EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                        if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                            ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                            if (!player.m_150109_().m_36054_(drop)) {
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                            }
                        }
                    });
                });
            }
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == -2) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.player_dragging", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.getMiscAnimation() != 0 && this.getMiscAnimation() != 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.still", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.stay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.leap", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.slam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.web_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.lay_eggs", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.black_spider.web_grab", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static class BossBlackSpiderMoveControl
    extends MoveControl {
        private final BossBlackSpiderEntity entity;

        public BossBlackSpiderMoveControl(BossBlackSpiderEntity this$0) {
            super((Mob)this$0);
            this.entity = this$0;
        }

        public void m_8126_() {
            if (this.entity.m_5803_()) {
                return;
            }
            if (this.entity.getMiscAnimation() != 3 && this.entity.getMiscAnimation() != -2 && this.entity.getMiscAnimation() != 5) {
                super.m_8126_();
            }
        }
    }

    public static class BossBlackSpiderLookControl
    extends LookControl {
        private final BossBlackSpiderEntity entity;

        public BossBlackSpiderLookControl(BossBlackSpiderEntity this$0) {
            super((Mob)this$0);
            this.entity = this$0;
        }

        public void m_8128_() {
            if (this.entity.m_5803_()) {
                return;
            }
            if (this.entity.getMiscAnimation() != 3 && this.entity.getMiscAnimation() != 5) {
                super.m_8128_();
            }
        }
    }

    static class SpiderLayEggsGoal
    extends MoveToBlockGoal {
        private final BossBlackSpiderEntity spider;
        private int coolDown = 200;

        SpiderLayEggsGoal(BossBlackSpiderEntity spider, double pSpeedModifier) {
            super((PathfinderMob)spider, pSpeedModifier, 20);
            this.spider = spider;
        }

        public boolean m_8036_() {
            if (!super.m_8036_() || this.spider.m_21827_()) {
                return false;
            }
            if (this.spider.getMiscAnimation() == -2) {
                return false;
            }
            LivingEntity target = this.spider.m_5448_();
            if (target == null) {
                return true;
            }
            if (target.m_20270_((Entity)this.spider) < 3.0f) {
                return false;
            }
            return target.m_21023_((MobEffect)TensuraMobEffects.WEBBED.get());
        }

        public void m_8056_() {
            super.m_8056_();
            this.coolDown = 0;
        }

        public void m_8037_() {
            --this.coolDown;
            if (this.coolDown > 0) {
                return;
            }
            super.m_8037_();
            BlockPos blockpos = this.spider.m_20183_();
            Level level = this.spider.f_19853_;
            if (this.m_25625_()) {
                level.m_5594_(null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)level.m_8055_(blockpos.m_7495_())));
                if (this.spider.getMiscAnimation() == 5) {
                    this.spider.f_21344_.m_26573_();
                    if (this.spider.miscAnimationTicks == 15) {
                        level.m_7731_(this.f_25602_.m_7494_(), ((Block)BeyondBlocks.BOSS_SPIDER_EGG.get()).m_49966_(), 3);
                        level.m_186460_(blockpos, (Block)BeyondBlocks.BOSS_SPIDER_EGG.get(), 600);
                        this.coolDown = 200;
                        this.spider.setMiscAnimation(0);
                    }
                } else {
                    this.spider.setMiscAnimation(5);
                }
            }
        }

        protected BlockPos m_6669_() {
            BlockPos newPos = new BlockPos((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5);
            return newPos.m_7494_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_46859_(pPos.m_7494_()) && SpiderEggBlock.canLayEgg((BlockGetter)pLevel, (BlockPos)pPos);
        }
    }

    static class BossBlackSpiderLeapGoal
    extends LeapWithStrengthGoal {
        private final BossBlackSpiderEntity spider;

        public BossBlackSpiderLeapGoal(BossBlackSpiderEntity spider) {
            super((Mob)spider, 0.7f, 2.0f, 10.0, 20.0, 40);
            this.spider = spider;
        }

        public boolean m_8036_() {
            if (this.spider.getMiscAnimation() != 0) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.spider.setMiscAnimation(2);
        }

        public boolean m_8045_() {
            if (this.spider.getMiscAnimation() != 0) {
                return false;
            }
            return !this.spider.m_20096_();
        }
    }

    static class BossBlackSpiderAttackGoal
    extends MeleeAttackGoal {
        private final BossBlackSpiderEntity spider;

        public BossBlackSpiderAttackGoal(BossBlackSpiderEntity spider, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)spider, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.spider = spider;
        }

        public boolean m_8036_() {
            return !this.spider.m_21827_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.spider.m_21827_() && super.m_8045_();
        }

        public void m_8037_() {
            if (this.spider.getMiscAnimation() == 0) {
                super.m_8037_();
            }
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double distance = this.m_6639_(pEnemy);
            if (this.spider.getMiscAnimation() == 0) {
                double attackRange;
                int randomAttack = this.randomAttack(distance);
                switch (randomAttack) {
                    case 3: {
                        this.spider.m_21573_().m_26573_();
                        double d = 25.0;
                        break;
                    }
                    case 4: 
                    case 6: {
                        double d = 400.0;
                        break;
                    }
                    default: {
                        double d = attackRange = distance;
                    }
                }
                if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                    this.m_25563_();
                    this.spider.setMiscAnimation(randomAttack);
                    if (randomAttack == 1) {
                        this.spider.m_7327_((Entity)pEnemy);
                    }
                }
            }
        }

        protected int randomAttack(double distance) {
            if (this.spider.f_19796_.m_188503_(5) == 2 && this.spider.m_6688_() == null && !this.spider.m_6162_()) {
                return 3;
            }
            double d = this.spider.m_6162_() ? 1.6 : 8.0;
            if (distance >= d && (this.spider.m_5448_() == null || !this.spider.m_5448_().m_21023_((MobEffect)TensuraMobEffects.WEBBED.get()))) {
                if ((double)this.spider.f_19796_.m_188501_() <= 0.4) {
                    return 6;
                }
                if ((double)this.spider.f_19796_.m_188501_() <= 0.4) {
                    return 4;
                }
            }
            return 1;
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + pAttackTarget.m_20205_();
        }
    }
}

