/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import io.github.Memoires.trbeyond.capability.boss.BeyondBossCapability;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.custom.HitboxPartEntity;
import io.github.Memoires.trbeyond.network.PlayerVariablesHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EvilCentipedeBossEntity
extends Monster
implements IAnimatable,
IGiantMob {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(EvilCentipedeBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;
    private final HitboxPartEntity[] subEntities;

    public EvilCentipedeBossEntity(EntityType<? extends EvilCentipedeBossEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 100;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.trbeyond.evil_centipede_boss"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7005_(true);
        this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
        this.subEntities = new HitboxPartEntity[]{new HitboxPartEntity<EvilCentipedeBossEntity>(this, 2.0f, 3.0f, new Vec3(1.75, 0.0, 0.0)), new HitboxPartEntity<EvilCentipedeBossEntity>(this, 1.5f, 1.0f, new Vec3(3.5, 2.0, 0.0)), new HitboxPartEntity<EvilCentipedeBossEntity>(this, 1.5f, 1.0f, new Vec3(-1.5, 0.0, 0.0)), new HitboxPartEntity<EvilCentipedeBossEntity>(this, 1.5f, 1.0f, new Vec3(-3.0, 0.0, 0.0)), new HitboxPartEntity<EvilCentipedeBossEntity>(this, 1.5f, 1.0f, new Vec3(-4.5, 0.0, 0.0)), new HitboxPartEntity<EvilCentipedeBossEntity>(this, 1.5f, 1.0f, new Vec3(-6.0, 0.0, 0.0))};
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(this.m_19879_() + i + 1);
        }
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    public void updatePartPositions() {
        if (this.subEntities == null) {
            return;
        }
        for (HitboxPartEntity part : this.subEntities) {
            part.updatePosition();
        }
    }

    public Component m_5446_() {
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)Component.m_237115_((String)"entity.trbeyond.evil_centipede_boss")).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public boolean cantBreakBlock(LivingEntity entity, boolean ignoreCollision) {
        Level level = entity.m_9236_();
        if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            return true;
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return source == DamageSource.f_19305_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || super.m_6673_(source);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22288_, 1.5).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 50.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22285_, 25.0).m_22268_(Attributes.f_22283_, 5.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22268_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get(), 1000.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 40.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new EvilCentipedeBossAttackGoal(this, 1.2, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false));
    }

    public void m_6043_() {
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.evil_centipede.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.evil_centipede.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.evil_centipede.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.evil_centipede.ram", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.evil_centipede.grab_slam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "movement", 0.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attacks", 0.0f, this::miscPredicate));
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        this.bossEvent.m_7706_();
        Entity entity = cause.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BeyondBossCapability.getFrom(player).ifPresent(cap -> {
                int killedCentipede = cap.killedCentipede();
                cap.setKilledCentipede(killedCentipede + 1);
            });
            BeyondBossCapability.sync(player);
            player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                if (!capability.KilledCentipede) {
                    ItemStack slotItem;
                    int i;
                    int coinsRemaining = (Integer)ServerConfig.INSTANCE.bossConfig.evilCentipedeGoldDrop.get();
                    Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                    int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                    for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                        slotItem = player.m_150109_().m_8020_(i);
                        if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                        int spaceLeft = maxStackSize - slotItem.m_41613_();
                        int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                        slotItem.m_41769_(amountToAdd);
                        player.m_150109_().m_6836_(i, slotItem);
                        coinsRemaining -= amountToAdd;
                    }
                    if (coinsRemaining > 0) {
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (!slotItem.m_41619_()) continue;
                            int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                            ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                            player.m_150109_().m_6836_(i, newCoinStack);
                            coinsRemaining -= amountToAdd;
                        }
                    }
                    if (coinsRemaining > 0) {
                        while (coinsRemaining > 0) {
                            int dropAmount = Math.min(coinsRemaining, maxStackSize);
                            ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                            coinsRemaining -= dropAmount;
                        }
                    }
                    capability.KilledCentipede = true;
                    capability.syncPlayerVariables((Entity)player);
                }
                ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondToolItems.CENTIPEDE_DAGGER_SPECIAL.get())};
                EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                    if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                        ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                        if (!player.m_150109_().m_36054_(drop)) {
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                        }
                    }
                });
            });
        } else {
            TamableAnimal tame;
            LivingEntity owner;
            LivingEntity attacker;
            entity = cause.m_7639_();
            if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) instanceof TamableAnimal && (owner = (tame = (TamableAnimal)attacker).m_21826_()) instanceof Player) {
                Player player = (Player)owner;
                player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    if (!capability.KilledCentipede) {
                        ItemStack slotItem;
                        int i;
                        int coinsRemaining = 5;
                        Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                        int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                            int spaceLeft = maxStackSize - slotItem.m_41613_();
                            int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                            slotItem.m_41769_(amountToAdd);
                            player.m_150109_().m_6836_(i, slotItem);
                            coinsRemaining -= amountToAdd;
                        }
                        if (coinsRemaining > 0) {
                            for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                                slotItem = player.m_150109_().m_8020_(i);
                                if (!slotItem.m_41619_()) continue;
                                int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                                ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                                player.m_150109_().m_6836_(i, newCoinStack);
                                coinsRemaining -= amountToAdd;
                            }
                        }
                        if (coinsRemaining > 0) {
                            while (coinsRemaining > 0) {
                                int dropAmount = Math.min(coinsRemaining, maxStackSize);
                                ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                                coinsRemaining -= dropAmount;
                            }
                        }
                        capability.KilledCentipede = true;
                        capability.syncPlayerVariables((Entity)player);
                    }
                    ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondToolItems.CENTIPEDE_DAGGER_SPECIAL.get())};
                    EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                        if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                            ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                            if (!player.m_150109_().m_36054_(drop)) {
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                            }
                        }
                    });
                });
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_((SoundEvent)BeyondSoundEvents.evil_centipede_movement.get(), 0.25f, 0.5f);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public boolean shouldAttack(LivingEntity target) {
        return target instanceof Player && ((Player)target).m_7500_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.updatePartPositions();
        LivingEntity target = this.m_5448_();
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.m_6084_() && this.m_5448_() != null && this.m_5448_().m_6084_()) {
                if (this.getMiscAnimation() == 1) {
                    if (this.miscAnimationTicks == 10 && (double)this.m_20270_((Entity)target) < 5.0) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.evil_centipede_bite.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 100, 5));
                    }
                } else if (this.getMiscAnimation() == 2) {
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 40) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.m_20334_(this.m_20154_().f_82479_ * 0.5, this.m_20184_().f_82480_, this.m_20154_().f_82481_ * 0.5);
                        if ((double)this.m_20270_((Entity)target) < 2.0) {
                            target.m_20334_(this.m_20154_().f_82479_ * 0.5, target.m_20184_().f_82480_, this.m_20154_().f_82481_ * 0.5);
                        }
                    } else if (this.miscAnimationTicks == 50 && (double)this.m_20270_((Entity)target) < 3.0) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.evil_centipede_floor_slam.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 0.5f);
                    }
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 40 && this.miscAnimationTicks % 10 == 0 && (double)this.m_20270_((Entity)target) < 3.0) {
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 0.5f);
                    }
                } else if (this.getMiscAnimation() == 3) {
                    if (this.miscAnimationTicks == 1) {
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.evil_centipede_grab_slam.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (this.miscAnimationTicks == 0) {
                        if ((double)this.m_20270_((Entity)target) < 20.0) {
                            this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        }
                    } else if (this.miscAnimationTicks == 22) {
                        target.m_147240_(4.0, this.m_20185_(), this.m_20189_());
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 4.0f);
                    } else if (this.miscAnimationTicks == 30 && (double)this.m_20270_((Entity)target) < 20.0) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                    }
                    if (this.miscAnimationTicks > 10 && this.miscAnimationTicks < 45) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                    }
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        int var10000 = switch (miscAnimation) {
            case 1 -> 58;
            case 2 -> 72;
            case 3 -> 70;
            default -> 12;
        };
        return var10000;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
        }
        return flag;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_21051_(Attributes.f_22288_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeJumpStrength.get()).doubleValue());
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeMaxHealth.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeAttackDamage.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeKnockbackResistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeArmor.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeArmorToughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22283_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeAttackSpeed.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeAttackKnockback.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeFollowRange.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeMovementSpeed.get()).doubleValue());
        this.m_21051_((Attribute)ForgeMod.ATTACK_RANGE.get()).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeAttackRange.get()).doubleValue());
        this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.evilCentipedeMaxSpiritualHealth.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        AttributeInstance spiritualHP = this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        AttributeInstance maxHP = this.m_21051_(Attributes.f_22276_);
        double sHP = maxHP.m_22135_() * 2.0;
        if (spiritualHP != null) {
            spiritualHP.m_22100_(sHP);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)this, (double)sHP);
        }
        this.getPersistentData().m_128379_("isBoss", true);
        if (this.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)this);
            for (ManasSkill manasSkill : SkillAPI.getSkillRegistry()) {
                Optional existing;
                ResistSkill resist;
                if (!(manasSkill instanceof ResistSkill) || (resist = (ResistSkill)manasSkill).getResistType() != ResistSkill.ResistType.RESISTANCE || !(existing = storage.getSkill(manasSkill)).isEmpty()) continue;
                ManasSkillInstance instance = manasSkill.createDefaultInstance();
                storage.learnSkill(instance);
            }
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                ResistSkill resist;
                ManasSkill skill = instance.getSkill();
                if (!(skill instanceof ResistSkill) || (resist = (ResistSkill)skill).getResistType() != ResistSkill.ResistType.RESISTANCE) continue;
                instance.setMastery(0);
                instance.setToggled(true);
                storage.updateSkill(instance);
            }
        }
        return data;
    }

    class EvilCentipedeBossAttackGoal
    extends MeleeAttackGoal {
        private final EvilCentipedeBossEntity boss;

        public EvilCentipedeBossAttackGoal(EvilCentipedeBossEntity boss, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)boss, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.boss = boss;
        }

        public boolean m_8036_() {
            return this.boss.getMiscAnimation() == 0;
        }

        public boolean m_8045_() {
            return this.boss.getMiscAnimation() == 0;
        }

        public void m_8037_() {
            if (this.boss.getMiscAnimation() == 0) {
                super.m_8037_();
            }
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double reach = super.m_6639_(pEnemy);
            if (this.boss.getMiscAnimation() == 0 && pEnemy.m_6084_()) {
                int randomAttack = this.randomAttack(pDistToEnemySqr);
                if (pDistToEnemySqr <= reach && this.m_25564_()) {
                    this.m_25563_();
                    this.boss.setMiscAnimation(randomAttack);
                }
            }
        }

        protected int randomAttack(double distance) {
            int random;
            int n = random = this.boss.f_19796_.m_188503_(100) < 20 ? 2 : (this.boss.f_19796_.m_188503_(100) < 20 ? 3 : 1);
            if (random == 3 & (int)(Math.random() * 2.0) + 1 == 1) {
                random = this.boss.f_19796_.m_188503_(100) < 20 ? 2 : (this.boss.f_19796_.m_188503_(100) < 20 ? 3 : 1);
                return random;
            }
            return random;
        }
    }
}

