/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GobweEntity
extends HumanoidNPCEntity
implements IAnimatable {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(GobweEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final AnimationBuilder idle1 = new AnimationBuilder().addAnimation("idle1", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder idle2 = new AnimationBuilder().addAnimation("idle2", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder idle3 = new AnimationBuilder().addAnimation("idle3", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder sleep = new AnimationBuilder().addAnimation("sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder walk = new AnimationBuilder().addAnimation("walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder run = new AnimationBuilder().addAnimation("run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder jump = new AnimationBuilder().addAnimation("jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder dagger_strike = new AnimationBuilder().addAnimation("dagger_strike", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder double_dagger_strike = new AnimationBuilder().addAnimation("double_dagger_strike", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int miscAnimationTicks = 0;
    private static final double WALK_SPEED = 0.3;
    private static final double RUN_SPEED = 0.6;
    private boolean isRunning = false;
    private int movementStateTicks = 0;
    private static final EntityDataAccessor<Boolean> DAGGER_STRIKE = SynchedEntityData.m_135353_(GobweEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DOUBLE_DAGGER_STRIKE = SynchedEntityData.m_135353_(GobweEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GobweEntity(EntityType<? extends GobweEntity> type, Level level) {
        super(type, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.miscAnimationHandler();
        this.updateMovementSpeed();
        this.updateMovementState();
        if (!this.f_19853_.m_5776_() && this.f_19797_ % 20 == 0) {
            Vec3 velocity = this.m_20184_();
            double speed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
            if (speed > 0.01) {
                System.out.println("Entity moving - Speed: " + speed + ", OnGround: " + this.f_19861_ + ", Target: " + (this.m_5448_() != null) + ", IsRunning: " + this.isRunning);
            }
        }
    }

    private void updateMovementState() {
        boolean targetRunning;
        Vec3 velocity = this.m_20184_();
        double speed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
        boolean hasPath = this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_();
        boolean shouldRun = this.m_5448_() != null && this.m_5912_() || this.m_21660_();
        boolean bl = targetRunning = shouldRun && (speed > 0.02 || hasPath) && this.f_19861_;
        if (targetRunning != this.isRunning) {
            ++this.movementStateTicks;
            if (this.movementStateTicks > 2) {
                this.isRunning = targetRunning;
                this.movementStateTicks = 0;
                System.out.println("Movement state changed - IsRunning: " + this.isRunning + ", Speed: " + speed + ", ShouldRun: " + shouldRun);
            }
        } else {
            this.movementStateTicks = 0;
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_7327_(Entity target) {
        boolean result = super.m_7327_(target);
        if (!this.f_19853_.m_5776_()) {
            System.out.println("Attempted damage to " + String.valueOf(target) + " - Success: " + result + " at tick: " + this.miscAnimationTicks);
        }
        return result;
    }

    public boolean forceHurtTarget(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            float damage = (float)this.m_21133_(Attributes.f_22281_);
            DamageSource damageSource = DamageSource.m_19370_((LivingEntity)this);
            int originalInvulnerableTime = livingTarget.f_19802_;
            livingTarget.f_19802_ = 0;
            boolean result = livingTarget.m_6469_(damageSource, damage);
            if (!this.f_19853_.m_5776_() && result) {
                System.out.println("Force damage applied: " + damage + " to " + String.valueOf(target));
            }
            return result;
        }
        return super.m_7327_(target);
    }

    private void updateMovementSpeed() {
        if (this.m_5448_() != null && this.m_5912_() && !this.m_5803_()) {
            if (this.m_21051_(Attributes.f_22279_).m_22115_() != 0.6) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.6);
            }
        } else if (this.m_21051_(Attributes.f_22279_).m_22115_() != 0.3) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22283_, 4.0).m_22266_(Attributes.f_22282_).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GobweAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CustomMeleeGoal(2.0, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveToAttackerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int tick) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)tick);
        if (tick == 0) {
            this.miscAnimationTicks = 0;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(DAGGER_STRIKE, (Object)false);
        this.f_19804_.m_135372_(DOUBLE_DAGGER_STRIKE, (Object)false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() != 0) {
            return PlayState.STOP;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(sleep);
            return PlayState.CONTINUE;
        } else {
            boolean isActuallyMoving;
            Vec3 velocity = this.m_20184_();
            double speed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
            boolean hasPath = this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_();
            boolean bl = isActuallyMoving = (speed > 0.02 || hasPath) && this.f_19861_;
            if (isActuallyMoving) {
                boolean shouldRunAnimation;
                boolean bl2 = shouldRunAnimation = this.m_5448_() != null && this.m_5912_() || this.m_21660_();
                if (shouldRunAnimation) {
                    event.getController().setAnimation(run);
                    System.out.println("Playing RUN animation - Speed: " + speed + ", HasTarget: " + (this.m_5448_() != null));
                    return PlayState.CONTINUE;
                } else {
                    event.getController().setAnimation(walk);
                    System.out.println("Playing WALK animation - Speed: " + speed);
                }
                return PlayState.CONTINUE;
            } else {
                boolean shouldPlayIdle;
                boolean bl3 = shouldPlayIdle = event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationState.Stopped || !event.getController().getCurrentAnimation().animationName.equals("walk") && !event.getController().getCurrentAnimation().animationName.equals("run");
                if (!shouldPlayIdle) return PlayState.STOP;
                int random = this.f_19796_.m_188503_(300);
                if (random == 1 && !this.m_21660_()) {
                    event.getController().setAnimation(idle1);
                    return PlayState.CONTINUE;
                } else if (random == 2 && !this.m_21660_()) {
                    event.getController().setAnimation(idle2);
                    return PlayState.CONTINUE;
                } else {
                    if (random != 3 || this.m_21660_()) return PlayState.STOP;
                    event.getController().setAnimation(idle3);
                }
            }
        }
        return PlayState.CONTINUE;
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() == 0) {
            return;
        }
        ++this.miscAnimationTicks;
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            LivingEntity target = this.m_5448_();
            switch (this.getMiscAnimation()) {
                case 1: {
                    if (this.miscAnimationTicks == 18) {
                        this.f_19804_.m_135381_(DAGGER_STRIKE, (Object)true);
                        if (target != null) {
                            this.m_7327_((Entity)target);
                        }
                    }
                    if (this.miscAnimationTicks != 19) break;
                    this.f_19804_.m_135381_(DAGGER_STRIKE, (Object)false);
                    break;
                }
                case 2: {
                    if (this.miscAnimationTicks != 12) break;
                    this.jumpAway();
                    break;
                }
                case 3: {
                    if (this.miscAnimationTicks == 12) {
                        this.f_19804_.m_135381_(DOUBLE_DAGGER_STRIKE, (Object)true);
                        if (target != null && target.m_6084_()) {
                            this.m_7327_((Entity)target);
                            System.out.println("First dagger hit at tick: " + this.miscAnimationTicks);
                        }
                    }
                    if (this.miscAnimationTicks == 13) {
                        this.f_19804_.m_135381_(DOUBLE_DAGGER_STRIKE, (Object)false);
                    }
                    if (this.miscAnimationTicks == 18) {
                        this.f_19804_.m_135381_(DOUBLE_DAGGER_STRIKE, (Object)true);
                        if (target != null && target.m_6084_()) {
                            this.forceHurtTarget((Entity)target);
                            System.out.println("Second dagger hit (forced) at tick: " + this.miscAnimationTicks);
                        }
                    }
                    if (this.miscAnimationTicks != 19) break;
                    this.f_19804_.m_135381_(DOUBLE_DAGGER_STRIKE, (Object)false);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationDuration(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.f_19804_.m_135381_(DAGGER_STRIKE, (Object)false);
                this.f_19804_.m_135381_(DOUBLE_DAGGER_STRIKE, (Object)false);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationDuration(int variant) {
        return switch (variant) {
            case 1, 2 -> 30;
            case 3 -> 35;
            default -> 0;
        };
    }

    public void jumpAway() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            Vec3 jump = this.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82542_(0.8, 0.0, 0.8).m_82520_(0.0, 0.6, 0.0);
            this.m_20256_(jump);
            this.m_6862_(true);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::miscPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        int anim = this.getMiscAnimation();
        if (anim != 0) {
            if (event.getController().getAnimationState() == AnimationState.Stopped) {
                event.getController().markNeedsReload();
            }
            switch (anim) {
                case 1: {
                    event.getController().setAnimation(dagger_strike);
                    break;
                }
                case 2: {
                    event.getController().setAnimation(jump);
                    break;
                }
                case 3: {
                    event.getController().setAnimation(double_dagger_strike);
                }
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void performDaggerStrike(LivingEntity target) {
        if (target == null) {
            return;
        }
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
    }

    public void performDoubleDaggerStrike(LivingEntity target) {
        if (target == null) {
            return;
        }
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
    }

    public void daggerStrike(LivingEntity target) {
        if (this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
            this.performDaggerStrike(target);
        }
    }

    public void doubleDaggerStrike(LivingEntity target) {
        if (this.getMiscAnimation() == 0) {
            this.setMiscAnimation(3);
            this.performDoubleDaggerStrike(target);
        }
    }

    public boolean canSleep() {
        return !this.m_21525_();
    }

    protected void sleepHandler() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5803_() && (this.m_5448_() != null || this.isInFluidType() || ++this.sleepingTime > this.maxSleepTime && this.m_9236_().m_46461_())) {
                this.setSleeping(false);
            } else if (this.m_9236_().m_46462_() && this.f_19796_.m_188503_(100) == 0) {
                if (this.f_19796_.m_188499_()) {
                    this.setSleeping(true);
                } else {
                    this.sleepingTime = 0;
                    this.maxSleepTime = 100 + this.f_19796_.m_188503_(600);
                }
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class GobweAttackGoal
    extends Goal {
        private final GobweEntity gobwe;
        private int attackCooldown = 0;

        public GobweAttackGoal(GobweEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.gobwe = entity;
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity target = this.gobwe.m_5448_();
            if (target instanceof Player && (player = (Player)target).m_7500_()) {
                this.gobwe.m_21661_();
                return false;
            }
            return target != null && target.m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.gobwe.m_21561_(true);
            this.attackCooldown = 0;
        }

        public void m_8037_() {
            LivingEntity target = this.gobwe.m_5448_();
            if (target == null) {
                return;
            }
            double distance = this.gobwe.m_20280_((Entity)target);
            double maxAttackDistance = 4.0;
            if (this.gobwe.getMiscAnimation() == 0 && distance <= maxAttackDistance && this.attackCooldown <= 0) {
                if (this.gobwe.m_142582_((Entity)target)) {
                    this.gobwe.m_21573_().m_26573_();
                    this.gobwe.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    int random = this.gobwe.f_19796_.m_188503_(100);
                    if (random < 60) {
                        this.gobwe.daggerStrike(target);
                    } else if (random < 90) {
                        this.gobwe.doubleDaggerStrike(target);
                    } else {
                        this.gobwe.setMiscAnimation(2);
                        this.gobwe.jumpAway();
                    }
                    this.attackCooldown = 40;
                }
            } else if (distance > maxAttackDistance && this.gobwe.getMiscAnimation() == 0) {
                this.gobwe.m_21573_().m_5624_((Entity)target, 1.2);
            }
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
        }

        public void m_8041_() {
            this.gobwe.m_21561_(false);
        }
    }

    class CustomMeleeGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public CustomMeleeGoal(double speed, boolean useMemory) {
            super((HumanoidNPCEntity)GobweEntity.this, (PathfinderMob)GobweEntity.this, speed, useMemory);
        }

        public boolean m_8036_() {
            return false;
        }

        protected double m_6639_(LivingEntity target) {
            double widthSum = GobweEntity.this.m_20205_() + target.m_20205_();
            return widthSum + 1.0;
        }
    }

    public class MoveToAttackerGoal
    extends Goal {
        private final GobweEntity gobwe;
        private LivingEntity lastDamager;

        public MoveToAttackerGoal(GobweEntity gobwe) {
            this.gobwe = gobwe;
        }

        public boolean m_8036_() {
            if (this.gobwe.getMiscAnimation() != 0) {
                return false;
            }
            this.lastDamager = this.gobwe.m_21188_();
            return this.lastDamager != null && this.lastDamager.m_6084_();
        }

        public void m_8056_() {
            this.gobwe.m_21573_().m_5624_((Entity)this.lastDamager, 1.0);
        }

        public void m_8037_() {
            if (this.lastDamager != null && this.lastDamager.m_6084_() && this.gobwe.getMiscAnimation() == 0) {
                this.gobwe.m_21573_().m_5624_((Entity)this.lastDamager, 1.0);
            }
        }

        public void m_8041_() {
            this.gobwe.m_21573_().m_26573_();
        }
    }
}

