/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import io.github.Memoires.trbeyond.entity.custom.HitboxPartEntity;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GraveLizard
extends Monster
implements IAnimatable {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(GraveLizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(GraveLizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final int LEN_BITE_T = 20;
    private static final int LEN_STOMP_T = 40;
    private static final int LEN_SPIN_T = 60;
    private final HitboxPartEntity[] subEntities = new HitboxPartEntity[]{new HitboxPartEntity<GraveLizard>(this, 2.0f, 1.5f, new Vec3(3.0, 2.5, 0.0)), new HitboxPartEntity<GraveLizard>(this, 2.0f, 1.5f, new Vec3(-3.0, 0.5, 0.0))};

    public GraveLizard(EntityType<? extends GraveLizard> type, Level level) {
        super(type, level);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(this.m_19879_() + i + 1);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(ANIM_TICK, (Object)0);
    }

    private int getAnimState() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    private int getAnimTick() {
        return (Integer)this.f_19804_.m_135370_(ANIM_TICK);
    }

    private void setAnimState(int state) {
        AnimationController c;
        this.f_19804_.m_135381_(ANIM_STATE, (Object)state);
        this.f_19804_.m_135381_(ANIM_TICK, (Object)0);
        if (this.f_19853_.f_46443_ && (c = (AnimationController)this.factory.getOrCreateAnimationData(this.m_19879_()).getAnimationControllers().get("controller")) != null) {
            c.markNeedsReload();
        }
    }

    private void incAnimTick() {
        this.f_19804_.m_135381_(ANIM_TICK, (Object)(this.getAnimTick() + 1));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new GraveLizardAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        return super.m_6518_(world, difficulty, reason, data, tag);
    }

    public boolean m_7327_(Entity target) {
        if (this.getAnimState() == 0 && target instanceof LivingEntity) {
            int choice = this.f_19796_.m_188503_(3) + 1;
            this.setAnimState(choice);
            this.m_21573_().m_26573_();
            return false;
        }
        return false;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    public void updatePartPositions() {
        if (this.subEntities == null) {
            return;
        }
        for (HitboxPartEntity part : this.subEntities) {
            part.updatePosition();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.updatePartPositions();
        int state = this.getAnimState();
        if (state == 0) {
            return;
        }
        this.m_21573_().m_26573_();
        if (!this.f_19853_.f_46443_) {
            this.incAnimTick();
            int t = this.getAnimTick();
            LivingEntity target = this.m_5448_();
            switch (state) {
                case 1: {
                    if (t == 10 && target != null && (double)this.m_20270_((Entity)target) < 8.0) {
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), 12.0f);
                    }
                    if (t < 20) break;
                    this.setAnimState(0);
                    break;
                }
                case 2: {
                    if (t == 35) {
                        AABB area = this.m_20191_().m_82400_(10.0);
                        List list = this.f_19853_.m_6443_(LivingEntity.class, area, e -> e != this);
                        for (LivingEntity e2 : list) {
                            double dx = e2.m_20185_() - this.m_20185_();
                            double dz = e2.m_20189_() - this.m_20189_();
                            e2.m_5997_(dx * 0.4, 0.2, dz * 0.4);
                            e2.m_6469_(DamageSource.m_19370_((LivingEntity)this), 10.0f);
                        }
                    }
                    if (t < 60) break;
                    this.setAnimState(0);
                    break;
                }
                case 3: {
                    if (t == 18) {
                        AABB area = this.m_20191_().m_82400_(12.0);
                        List list = this.f_19853_.m_6443_(LivingEntity.class, area, e -> e != this);
                        for (LivingEntity e3 : list) {
                            e3.m_6469_(DamageSource.m_19370_((LivingEntity)this), 16.0f);
                            e3.m_147240_(1.5, this.m_20185_() - e3.m_20185_(), this.m_20189_() - e3.m_20189_());
                        }
                        for (int i = 0; i < 30; ++i) {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 5.0, this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 5.0, 0.0, 0.15, 0.0);
                        }
                    }
                    if (t < 40) break;
                    this.setAnimState(0);
                }
            }
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 8.0f, this::animationPredicate));
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        int state = this.getAnimState();
        AnimationController c = event.getController();
        if (state != 0) {
            if (state == 1) {
                c.setAnimation(new AnimationBuilder().addAnimation("animation.model.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (state == 2) {
                c.setAnimation(new AnimationBuilder().addAnimation("animation.model.spinattack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (state == 3) {
                c.setAnimation(new AnimationBuilder().addAnimation("animation.model.stomp", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            c.setAnimation(new AnimationBuilder().addAnimation("animation.model.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            c.setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class GraveLizardAttackGoal
    extends MeleeAttackGoal {
        private final GraveLizard lizard;

        public GraveLizardAttackGoal(GraveLizard mob, double speed, boolean follow) {
            super((PathfinderMob)mob, speed, follow);
            this.lizard = mob;
        }

        public boolean m_8036_() {
            return this.lizard.getAnimState() == 0 && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.lizard.getAnimState() == 0 && super.m_8045_();
        }

        protected void m_6739_(LivingEntity target, double dist) {
            if (this.lizard.getAnimState() != 0) {
                return;
            }
            if (dist <= this.m_6639_(target) && this.m_25565_() <= 0) {
                this.m_25563_();
                this.lizard.m_7327_((Entity)target);
            }
        }
    }
}

