/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.effects.BeyondEffects;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface ILimiter {
    default public boolean shouldAttack(Mob mob, LivingEntity entity) {
        double selfEP;
        if (entity == mob || mob.m_7307_((Entity)entity)) {
            return false;
        }
        if (entity == mob.m_5448_()) {
            return true;
        }
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        return EP < (selfEP = TensuraEPCapability.getEP((LivingEntity)mob));
    }

    default public void applyLimitation(Mob mob) {
        if (!mob.m_6084_()) {
            return;
        }
        LivingEntity target = mob.m_5448_();
        int limit = this.getLimitation();
        if (target == null) {
            if (limit != 0) {
                this.setLimitation(0);
            }
            return;
        }
        this.limitHighEP(mob, target, limit);
        if (!mob.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        List list = mob.m_9236_().m_6443_(LivingEntity.class, mob.m_20191_().m_82400_(10.0), entity -> entity != mob && entity != target && !mob.m_7307_((Entity)entity));
        if (list.isEmpty()) {
            return;
        }
        DungeonSaveData saveData = DungeonSaveData.getOverworld(mob.f_19853_);
        if (saveData == null) {
            return;
        }
        Vec3 pos = saveData.getStartGenPos();
        for (LivingEntity entity2 : list) {
            Player player;
            if (entity2 instanceof Player && ((player = (Player)entity2).m_7500_() || player.m_5833_())) continue;
            entity2.m_19877_();
            entity2.m_20324_(7.0, 167.0, 349.0);
        }
    }

    default public void limitHighEP(Mob mob, LivingEntity target, int limit) {
        if (limit == Limitation.NO_TOGGLE.getId()) {
            Player player;
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)target);
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                if (instance.getSkill() instanceof ResistSkill || !instance.isToggled()) continue;
                instance.setToggled(false);
                instance.onToggleOff(target);
                instance.markDirty();
            }
            storage.syncChanges();
            if (target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_()) {
                player.m_36321_();
                player.m_150110_().f_35935_ = false;
                player.m_150110_().f_35936_ = false;
                player.m_6885_();
            }
        } else if (limit == Limitation.NO_RESISTANCE.getId()) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)target);
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                if (!(instance.getSkill() instanceof ResistSkill) || !instance.isToggled()) continue;
                instance.setToggled(false);
                instance.onToggleOff(target);
                instance.markDirty();
            }
            storage.syncChanges();
        } else if (limit == Limitation.NO_SKILL.getId()) {
            Player player;
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ANTI_SKILL.get(), 100, 0, false, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 100, 0, false, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SILENCE.get(), 100, 0, false, false, false));
            if (target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_()) {
                player.m_36321_();
                player.m_150110_().f_35935_ = false;
                player.m_150110_().f_35936_ = false;
                player.m_6885_();
            }
        } else if (limit == Limitation.LOWER_SELF.getId()) {
            DungeonCapability.setEpLimit(target, TensuraEPCapability.getEP((LivingEntity)mob));
            target.m_7292_(new MobEffectInstance((MobEffect)BeyondEffects.LIMITED.get(), 100, 0, false, false, false));
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)target);
            Player player = storage.getLearnedSkills().iterator();
            while (player.hasNext()) {
                ManasSkillInstance instance = (ManasSkillInstance)player.next();
                if (!(instance.getSkill() instanceof ResistSkill) || !instance.isToggled()) continue;
                instance.setToggled(false);
                instance.onToggleOff(target);
                instance.markDirty();
            }
            storage.syncChanges();
            if (target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_()) {
                player.m_36321_();
                player.m_150110_().f_35935_ = false;
                player.m_150110_().f_35936_ = false;
                player.m_6885_();
            }
        } else {
            this.limitLowEP(mob, target);
        }
    }

    default public void limitLowEP(Mob mob, LivingEntity target) {
        double selfEP;
        double EP = TensuraEPCapability.getEP((LivingEntity)target);
        if (EP < (selfEP = TensuraEPCapability.getEP((LivingEntity)mob)) * (double)0.1f) {
            Player player;
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ANTI_SKILL.get(), 100, 0, false, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 100, 0, false, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SILENCE.get(), 100, 0, false, false, false));
            if (target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_()) {
                player.m_36321_();
                player.m_150110_().f_35935_ = false;
                player.m_150110_().f_35936_ = false;
                player.m_6885_();
            }
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)target);
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                if (!instance.isToggled()) continue;
                instance.setToggled(false);
                instance.onToggleOff(target);
                instance.markDirty();
            }
            storage.syncChanges();
        } else if (EP < selfEP * (double)0.3f) {
            Player player;
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ANTI_SKILL.get(), 100, 0, false, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 100, 0, false, false, false));
            if (target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_()) {
                player.m_36321_();
                player.m_150110_().f_35935_ = false;
                player.m_150110_().f_35936_ = false;
                player.m_6885_();
            }
        } else if (EP < selfEP * 0.5) {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ANTI_SKILL.get(), 100, 0, false, false, false));
        }
    }

    public int getLimitation();

    public void setLimitation(int var1);

    public static enum Limitation {
        NO_TOGGLE(1),
        NO_RESISTANCE(2),
        NO_SKILL(3),
        LOWER_SELF(4);

        private final int id;

        public int getId() {
            return this.id;
        }

        private Limitation(int id) {
            this.id = id;
        }
    }
}

