/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.api.entity.subclass.ITeleportation;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import io.github.Memoires.trbeyond.handlers.DungeonRulesHandler;
import io.github.Memoires.trbeyond.util.TimerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KillerDryadEntity
extends TensuraTamableEntity
implements IAnimatable,
ITeleportation {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public KillerDryadEntity(EntityType<? extends TensuraTamableEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            protected double m_6639_(LivingEntity pAttackTarget) {
                return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 2.0f + pAttackTarget.m_20205_() + 100.0f;
            }
        });
    }

    public static AttributeSupplier setAttributes() {
        return Villager.m_21183_().m_22268_(Attributes.f_22276_, 420.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 69.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 3.0).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return !damageSource.equals(DamageSource.f_19317_);
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6043_() {
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity.m_6469_(DamageSource.f_19319_.m_19381_().m_19382_().m_238403_().m_19380_(), 100000.0f)) {
            this.f_19853_.m_5594_(null, pEntity.m_20183_(), SoundEvents.f_11900_, this.m_5720_(), 1.0f, 1.0f);
            pEntity.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.rule_violation.eliminated").m_130940_(ChatFormatting.RED));
            return true;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity owner = this.m_21826_();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            double dist = owner.m_20270_((Entity)this);
            if (dist > 5.0) {
                this.teleportTowards((LivingEntity)this, (Entity)owner, 5.0);
            }
            this.m_21563_().m_148051_((Entity)owner);
            this.m_21391_((Entity)owner, 180.0f, 180.0f);
            TimerUtils.Timer timerBoss = TimerUtils.getOrCreateTimer(owner.m_5446_().getString() + "_boss");
            if (timerBoss.getTicks() >= 100) {
                this.resetOwner(null);
                timerBoss.reset();
                this.m_6710_(owner);
                this.m_21011_(InteractionHand.MAIN_HAND, true);
                this.m_7327_((Entity)owner);
                return;
            }
            if (timerBoss.active) {
                return;
            }
            if (DungeonRulesHandler.playerPositions.get(player.m_20148_()) == null) {
                this.m_146870_();
                return;
            }
            if (!owner.m_6084_() || !DungeonRulesHandler.isWithinArea(owner.m_20183_(), DungeonRulesHandler.playerPositions.get(player.m_20148_()))) {
                this.m_146870_();
                return;
            }
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer(owner.m_5446_().getString() + "_idle");
            if (timer.getTicks() >= 11999) {
                this.resetOwner(null);
                timer.reset();
                this.m_6710_(owner);
                this.m_21011_(InteractionHand.MAIN_HAND, true);
                this.m_7327_((Entity)owner);
            }
        } else if (this.f_19797_ % 40 == 0) {
            this.m_146870_();
        }
    }

    public void teleport(LivingEntity entity, double pX, double pY, double pZ, double minY) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        if (this.shouldCountMotionBlock()) {
            while (pos.m_123342_() > entity.f_19853_.m_141937_() && !entity.f_19853_.m_8055_((BlockPos)pos).m_60767_().m_76334_()) {
                pos.m_122173_(Direction.DOWN);
            }
        } else if ((double)pos.m_123342_() > minY) {
            while ((double)pos.m_123342_() > minY && !entity.f_19853_.m_8055_((BlockPos)pos).m_60767_().m_76334_()) {
                pos.m_122173_(Direction.DOWN);
            }
        }
        BlockState state = entity.f_19853_.m_8055_((BlockPos)pos);
        if ((!this.shouldCountMotionBlock() || state.m_60767_().m_76334_()) && state.m_60819_().m_76178_()) {
            Vec3 vec3 = entity.m_20182_();
            if (this.randomTeleport(entity, pX, pY, pZ, true)) {
                entity.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
                if (!entity.m_20067_() && this.getTeleportSound() != null) {
                    entity.f_19853_.m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, this.getTeleportSound(), entity.m_5720_(), 1.0f, 1.0f);
                    entity.m_5496_(this.getTeleportSound(), 1.0f, 1.0f);
                }
            }
        }
    }

    public void commanding(Player player) {
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackPredicate(AnimationEvent<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.killerdryad.swipe", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

