/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.entity.magic.breath.ParalysingBreathProjectile;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import io.github.Memoires.trbeyond.entity.custom.HitboxPartEntity;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KingCrawlerEntity
extends PathfinderMob
implements IAnimatable {
    private static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(KingCrawlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int animTick = 0;
    private final HitboxPartEntity[] subEntities = new HitboxPartEntity[]{new HitboxPartEntity<KingCrawlerEntity>(this, 2.0f, 1.5f, new Vec3(1.5, 2.75, 0.0)), new HitboxPartEntity<KingCrawlerEntity>(this, 2.0f, 1.5f, new Vec3(-2.0, 0.0, 0.0)), new HitboxPartEntity<KingCrawlerEntity>(this, 2.0f, 1.5f, new Vec3(-4.0, 0.0, 0.0)), new HitboxPartEntity<KingCrawlerEntity>(this, 2.0f, 1.5f, new Vec3(-6.0, 0.0, 0.0)), new HitboxPartEntity<KingCrawlerEntity>(this, 1.0f, 3.0f, new Vec3(-7.5, 0.5, 0.0))};

    public KingCrawlerEntity(EntityType<? extends KingCrawlerEntity> type, Level level) {
        super(type, level);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(this.m_19879_() + i + 1);
        }
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(pId + i + 1);
        }
    }

    public void updatePartPositions() {
        if (this.subEntities == null) {
            return;
        }
        for (HitboxPartEntity part : this.subEntities) {
            part.updatePosition();
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 175.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 96.0).m_22268_(Attributes.f_22278_, 0.5).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        AnimationController controller;
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)state);
        this.animTick = 0;
        if (this.f_19853_.f_46443_ && (controller = (AnimationController)this.factory.getOrCreateAnimationData(this.m_19879_()).getAnimationControllers().get("controller")) != null) {
            controller.markNeedsReload();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AttackState", this.getAttackState());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAttackState(compound.m_128451_("AttackState"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public boolean m_7327_(Entity target) {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (this.getAttackState() == 0 && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            int choice = this.f_19796_.m_188503_(3) + 1;
            this.setAttackState(choice);
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, livingTarget.m_20182_());
            this.m_21573_().m_26573_();
            return true;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updatePartPositions();
        if (this.getAttackState() != 0) {
            ++this.animTick;
            LivingEntity target = this.m_5448_();
            switch (this.getAttackState()) {
                case 1: {
                    if (!this.f_19853_.f_46443_ && this.animTick == 15 && target != null && this.m_20280_((Entity)target) < 25.0) {
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), 12.0f);
                    }
                    if (this.animTick <= 40) break;
                    this.setAttackState(0);
                    break;
                }
                case 2: {
                    if (!this.f_19853_.f_46443_ && this.animTick == 24) {
                        List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(8.0), e -> e != this);
                        for (LivingEntity e2 : list) {
                            e2.m_6469_(DamageSource.m_19370_((LivingEntity)this), 10.0f);
                            e2.m_147240_((double)0.8f, this.m_20185_() - e2.m_20185_(), this.m_20189_() - e2.m_20189_());
                        }
                    }
                    if (this.animTick <= 33) break;
                    this.setAttackState(0);
                    break;
                }
                case 3: {
                    if (!this.f_19853_.f_46443_) {
                        if (this.animTick == 20 && target != null) {
                            ParalysingBreathProjectile spit = new ParalysingBreathProjectile((EntityType)TensuraEntityTypes.PARALYSING_BREATH.get(), this.f_19853_);
                            spit.m_6034_(this.m_20185_(), this.m_20188_() - 0.1, this.m_20189_());
                            spit.m_5602_((Entity)this);
                            double dx = target.m_20185_() - this.m_20185_();
                            double dy = target.m_20188_() - spit.m_20186_();
                            double dz = target.m_20189_() - this.m_20189_();
                            spit.m_6686_(dx, dy, dz, 1.2f, 0.0f);
                            this.f_19853_.m_7967_((Entity)spit);
                        }
                    } else if (this.animTick == 20 && target != null) {
                        ParticleOptions particle = (ParticleOptions)TensuraParticles.PARALYSING_BUBBLE.get();
                        for (int i = 0; i < 20; ++i) {
                            double t = (double)i / 20.0;
                            double dx = this.m_20185_() + (target.m_20185_() - this.m_20185_()) * t;
                            double dy = this.m_20188_() + (target.m_20188_() - this.m_20188_()) * t;
                            double dz = this.m_20189_() + (target.m_20189_() - this.m_20189_()) * t;
                            this.f_19853_.m_7106_(particle, dx, dy, dz, 0.0, 0.0, 0.0);
                        }
                    }
                    if (this.animTick <= 30) break;
                    this.setAttackState(0);
                }
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.f_20883_ = this.m_146908_();
    }

    public int m_8085_() {
        return 45;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        switch (this.getAttackState()) {
            case 1: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            case 2: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.tendril", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            case 3: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.spit", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                break;
            }
            default: {
                if (event.isMoving()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    break;
                }
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_12434_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData groupData = super.m_6518_(world, difficulty, reason, data, tag);
        AttributeInstance spiritualHP = this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        if (spiritualHP != null) {
            double sHP = (double)this.m_21233_() * 2.0;
            spiritualHP.m_22100_(sHP);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)this, (double)sHP);
        }
        return groupData;
    }

    public static class CustomAttackGoal
    extends MeleeAttackGoal {
        private final KingCrawlerEntity crawler;

        public CustomAttackGoal(KingCrawlerEntity mob) {
            super((PathfinderMob)mob, 1.2, true);
            this.crawler = mob;
        }

        protected void m_6739_(LivingEntity target, double dist) {
            if (dist <= this.m_6639_(target) && this.m_25565_() <= 0) {
                this.m_25563_();
                if (this.crawler.m_7327_((Entity)target)) {
                    this.crawler.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
            }
        }

        protected double m_6639_(LivingEntity target) {
            return 100.0;
        }
    }
}

