/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.registry.items.TensuraArmorItems;
import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class KobyMerchant
implements Merchant {
    private Player tradingPlayer;
    private final Map<UUID, MerchantOffers> playerOffers = new HashMap<UUID, MerchantOffers>();
    private final Map<UUID, LocalDateTime> lastRestockTimes = new HashMap<UUID, LocalDateTime>();
    private final Map<UUID, Boolean> needsRestockMap = new HashMap<UUID, Boolean>();

    public void initializeOffersForPlayer(UUID playerUUID) {
        int tradeCount = 100;
        MerchantOffers offers = new MerchantOffers();
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 4), new ItemStack((ItemLike)TensuraConsumableItems.LOW_POTION.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 35), new ItemStack((ItemLike)TensuraConsumableItems.HIGH_POTION.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraMaterialItems.GOLD_COIN.get(), 5), new ItemStack((ItemLike)TensuraConsumableItems.FULL_POTION.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.SPIDER_BOW.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.ANT_CROSSBOW.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.GOBLIN_CLUB.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.CENTIPEDE_DAGGER.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.SPIDER_DAGGER.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_HELMET.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_CHESTPLATE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_LEGGINGS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_BOOTS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_HELMET.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_CHESTPLATE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_LEGGINGS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_BOOTS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 30), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.BLADE_TIGER_SCYTHE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.KANABO.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.BEAST_HORN_SPEAR.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.UNICORN_HORN_SPEAR.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_HELMET.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_CHESTPLATE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_LEGGINGS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_BOOTS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_HELMET.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_CHESTPLATE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_LEGGINGS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_BOOTS.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get(), 50), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.ICE_BLADE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.VORTEX_SPEAR.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_SWORD.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_KNIFE.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 1), tradeCount, 0, 0.0f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_SHIELD.get(), 1), new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), 1), tradeCount, 0, 0.0f));
        this.playerOffers.put(playerUUID, offers);
        this.lastRestockTimes.put(playerUUID, LocalDateTime.now());
        this.needsRestockMap.put(playerUUID, false);
    }

    public void m_7189_(Player player) {
        UUID playerUUID;
        this.tradingPlayer = player;
        if (player != null && !this.playerOffers.containsKey(playerUUID = player.m_20148_())) {
            this.initializeOffersForPlayer(playerUUID);
        }
    }

    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        if (this.tradingPlayer == null) {
            return new MerchantOffers();
        }
        UUID playerUUID = this.tradingPlayer.m_20148_();
        if (!this.playerOffers.containsKey(playerUUID)) {
            this.initializeOffersForPlayer(playerUUID);
        }
        return this.playerOffers.get(playerUUID);
    }

    public void m_6255_(@NotNull MerchantOffers pOffers) {
        if (this.tradingPlayer != null) {
            this.playerOffers.put(this.tradingPlayer.m_20148_(), pOffers);
        }
    }

    public void m_6996_(@NotNull MerchantOffer offer) {
        if (this.tradingPlayer == null) {
            return;
        }
        UUID playerUUID = this.tradingPlayer.m_20148_();
        offer.m_45374_();
        if (this.needsToRestock(playerUUID)) {
            this.needsRestockMap.put(playerUUID, true);
        }
    }

    public void m_7713_(@NotNull ItemStack pStack) {
    }

    public void m_6621_(int xp) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return null;
    }

    public int m_7809_() {
        return 0;
    }

    public boolean m_183595_() {
        return false;
    }

    public void checkDespawn() {
    }

    private boolean needsToRestock(UUID playerUUID) {
        if (!this.playerOffers.containsKey(playerUUID)) {
            return false;
        }
        for (MerchantOffer offer : this.playerOffers.get(playerUUID)) {
            if (!offer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    public void restock(UUID playerUUID) {
        MerchantOffers offers;
        if (this.canRestock(playerUUID) && (offers = this.playerOffers.get(playerUUID)) != null) {
            for (MerchantOffer offer : offers) {
                offer.m_45372_();
            }
            this.lastRestockTimes.put(playerUUID, LocalDateTime.now());
            this.needsRestockMap.put(playerUUID, false);
        }
    }

    private boolean has24HoursPassed(UUID playerUUID) {
        LocalDateTime lastRestock = this.lastRestockTimes.get(playerUUID);
        if (lastRestock == null) {
            return true;
        }
        LocalDateTime now = LocalDateTime.now();
        long hoursPassed = ChronoUnit.HOURS.between(lastRestock, now);
        return hoursPassed >= 24L;
    }

    public boolean canRestock(UUID playerUUID) {
        Boolean needsRestock = this.needsRestockMap.getOrDefault(playerUUID, false);
        return needsRestock != false && this.has24HoursPassed(playerUUID);
    }

    public void checkAndRestock() {
        for (UUID playerUUID : this.playerOffers.keySet()) {
            if (!this.canRestock(playerUUID)) continue;
            this.restock(playerUUID);
        }
    }

    public void saveToNBT(CompoundTag tag) {
        CompoundTag offersTag = new CompoundTag();
        for (Map.Entry<UUID, MerchantOffers> entry : this.playerOffers.entrySet()) {
            String string = entry.getKey().toString();
            offersTag.m_128365_(string, (Tag)entry.getValue().m_45388_());
        }
        tag.m_128365_("PlayerOffers", (Tag)offersTag);
        CompoundTag restockTimesTag = new CompoundTag();
        for (Map.Entry<UUID, LocalDateTime> entry : this.lastRestockTimes.entrySet()) {
            String uuidString = entry.getKey().toString();
            restockTimesTag.m_128359_(uuidString, entry.getValue().toString());
        }
        tag.m_128365_("RestockTimes", (Tag)restockTimesTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<UUID, Boolean> entry : this.needsRestockMap.entrySet()) {
            String uuidString = entry.getKey().toString();
            compoundTag.m_128379_(uuidString, entry.getValue().booleanValue());
        }
        tag.m_128365_("NeedsRestock", (Tag)compoundTag);
    }

    public void loadFromNBT(CompoundTag tag) {
        UUID playerId;
        this.playerOffers.clear();
        if (tag.m_128441_("PlayerOffers")) {
            CompoundTag offersTag = tag.m_128469_("PlayerOffers");
            for (String key : offersTag.m_128431_()) {
                playerId = UUID.fromString(key);
                MerchantOffers offers = new MerchantOffers(offersTag.m_128469_(key));
                this.playerOffers.put(playerId, offers);
            }
        }
        this.lastRestockTimes.clear();
        if (tag.m_128441_("RestockTimes")) {
            CompoundTag timesTag = tag.m_128469_("RestockTimes");
            for (String key : timesTag.m_128431_()) {
                playerId = UUID.fromString(key);
                LocalDateTime time = LocalDateTime.parse(timesTag.m_128461_(key));
                this.lastRestockTimes.put(playerId, time);
            }
        }
        this.needsRestockMap.clear();
        if (tag.m_128441_("NeedsRestock")) {
            CompoundTag restockTag = tag.m_128469_("NeedsRestock");
            for (String key : restockTag.m_128431_()) {
                playerId = UUID.fromString(key);
                boolean needsRestock = restockTag.m_128471_(key);
                this.needsRestockMap.put(playerId, needsRestock);
            }
        }
    }
}

