/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import io.github.Memoires.trbeyond.capability.boss.BeyondBossCapability;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.client.screen.BossLimiterScreen;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.custom.GozulEntity;
import io.github.Memoires.trbeyond.entity.custom.ILimiter;
import io.github.Memoires.trbeyond.network.PlayerVariablesHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.procedures.MezulAttackDamagingProcedure;
import io.github.Memoires.trbeyond.procedures.MezulAttackingProcedure;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.registry.items.BeyondArmorItems;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MezulEntity
extends TensuraTamableEntity
implements IAnimatable,
ILimiter,
IGiantMob {
    public static final EntityDataAccessor<Integer> LIMITATION = SynchedEntityData.m_135353_(GozulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(MezulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(MezulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private final ServerBossEvent bossEvent;

    public MezulEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MezulEntity>)((EntityType)BeyondEntities.MEZUL.get()), world);
    }

    public MezulEntity(EntityType<MezulEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 2.0f;
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);
    }

    public Component m_5446_() {
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)Component.m_237115_((String)"entity.trbeyond.mezul")).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"mezul_retexture1");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Limitation", this.getLimitation());
        pCompound.m_128359_("Animation", this.getSyncedAnimation());
        pCompound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.f_19804_.m_135381_(LIMITATION, (Object)pCompound.m_128451_("Limitation"));
        this.f_19804_.m_135381_(ANIMATION, (Object)pCompound.m_128461_("Animation"));
        this.f_19804_.m_135381_(TEXTURE, (Object)pCompound.m_128461_("Texture"));
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    public void setLimitation(int id) {
        this.f_19804_.m_135381_(LIMITATION, (Object)id);
    }

    @Override
    public int getLimitation() {
        return (Integer)this.f_19804_.m_135370_(LIMITATION);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6673_(DamageSource source) {
        if (this.m_5448_() == null) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean cantBreakBlock(LivingEntity entity, boolean ignoreCollision) {
        Level level = entity.m_9236_();
        if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            return true;
        }
        return true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new MezulAttack(this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, e -> true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, target -> this.shouldAttack((Mob)this, (LivingEntity)target)));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            this.applyLimitation((Mob)this);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_((SoundEvent)BeyondSoundEvents.mezul_step_loop.get(), 0.25f, 0.5f);
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public void m_6075_() {
        super.m_6075_();
        MezulAttackDamagingProcedure.execute((LevelAccessor)this.f_19853_, (Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 2000.0);
        builder = builder.m_22268_(Attributes.f_22284_, 200.0);
        builder = builder.m_22268_(Attributes.f_22281_, 500.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        builder = builder.m_22268_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get(), 4000.0);
        return builder;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_6084_() || this.m_5448_() != null) {
            return super.m_6071_(player, hand);
        }
        if (TensuraEPCapability.getEP((LivingEntity)player) < TensuraEPCapability.getEP((LivingEntity)this)) {
            return InteractionResult.PASS;
        }
        if (this.m_5912_()) {
            return InteractionResult.PASS;
        }
        if (player.f_19853_.f_46443_) {
            this.openBossLimiterScreen(this.m_20148_());
        }
        return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openBossLimiterScreen(UUID mobUUID) {
        Minecraft.m_91087_().m_91152_((Screen)new BossLimiterScreen(mobUUID));
    }

    public boolean m_7327_(Entity target) {
        return false;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BeyondBossCapability.getFrom(player).ifPresent(cap -> {
                int killedMezul = cap.killedMezul();
                cap.setKilledMezul(killedMezul + 1);
            });
            BeyondBossCapability.sync(player);
            player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                if (!capability.KilledMezul) {
                    ItemStack slotItem;
                    int i;
                    int coinsRemaining = (Integer)ServerConfig.INSTANCE.bossConfig.mezulGoldDrop.get();
                    Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                    int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                    for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                        slotItem = player.m_150109_().m_8020_(i);
                        if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                        int spaceLeft = maxStackSize - slotItem.m_41613_();
                        int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                        slotItem.m_41769_(amountToAdd);
                        player.m_150109_().m_6836_(i, slotItem);
                        coinsRemaining -= amountToAdd;
                    }
                    if (coinsRemaining > 0) {
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (!slotItem.m_41619_()) continue;
                            int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                            ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                            player.m_150109_().m_6836_(i, newCoinStack);
                            coinsRemaining -= amountToAdd;
                        }
                    }
                    if (coinsRemaining > 0) {
                        while (coinsRemaining > 0) {
                            int dropAmount = Math.min(coinsRemaining, maxStackSize);
                            ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                            coinsRemaining -= dropAmount;
                        }
                    }
                    capability.KilledMezul = true;
                    capability.syncPlayerVariables((Entity)player);
                }
                ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondArmorItems.MINOS_HELMET_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.MINOS_CHESTPLATE_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.MINOS_LEGGINGS_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.MINOS_BOOTS_UNIQUE.get()), new ItemStack((ItemLike)BeyondToolItems.MINOS_TRIDENT_UNIQUE.get())};
                EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                    if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                        ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                        if (!player.m_150109_().m_36054_(drop)) {
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                        }
                    }
                });
            });
        } else {
            TamableAnimal tame;
            LivingEntity owner;
            LivingEntity attacker;
            entity = source.m_7639_();
            if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) instanceof TamableAnimal && (owner = (tame = (TamableAnimal)attacker).m_21826_()) instanceof Player) {
                Player player = (Player)owner;
                player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    if (!capability.KilledMezul) {
                        ItemStack slotItem;
                        int i;
                        int coinsRemaining = 100;
                        Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                        int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                            int spaceLeft = maxStackSize - slotItem.m_41613_();
                            int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                            slotItem.m_41769_(amountToAdd);
                            player.m_150109_().m_6836_(i, slotItem);
                            coinsRemaining -= amountToAdd;
                        }
                        if (coinsRemaining > 0) {
                            for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                                slotItem = player.m_150109_().m_8020_(i);
                                if (!slotItem.m_41619_()) continue;
                                int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                                ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                                player.m_150109_().m_6836_(i, newCoinStack);
                                coinsRemaining -= amountToAdd;
                            }
                        }
                        if (coinsRemaining > 0) {
                            while (coinsRemaining > 0) {
                                int dropAmount = Math.min(coinsRemaining, maxStackSize);
                                ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                                coinsRemaining -= dropAmount;
                            }
                        }
                        capability.KilledMezul = true;
                        capability.syncPlayerVariables((Entity)player);
                    }
                    ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondArmorItems.MINOS_HELMET_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.MINOS_CHESTPLATE_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.MINOS_LEGGINGS_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.MINOS_BOOTS_UNIQUE.get()), new ItemStack((ItemLike)BeyondToolItems.MINOS_TRIDENT_UNIQUE.get())};
                    EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                        if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                            ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                            if (!player.m_150109_().m_36054_(drop)) {
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                            }
                        }
                    });
                });
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulMovementSpeed.get()).doubleValue());
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulMaxHealth.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulArmor.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulAttackDamage.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulFollowRange.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulKnockbackResistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulAttackKnockback.get()).doubleValue());
        this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.mezulMaxSpiritualHealth.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        AttributeInstance spiritualHP = this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        AttributeInstance maxHP = this.m_21051_(Attributes.f_22276_);
        double sHP = maxHP.m_22135_() * 2.0;
        if (spiritualHP != null) {
            spiritualHP.m_22100_(sHP);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)this, (double)sHP);
        }
        this.getPersistentData().m_128379_("isBoss", true);
        if (this.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)this);
            for (ManasSkill manasSkill : SkillAPI.getSkillRegistry()) {
                Optional existing;
                ResistSkill resist;
                if (!(manasSkill instanceof ResistSkill) || (resist = (ResistSkill)manasSkill).getResistType() != ResistSkill.ResistType.RESISTANCE || !(existing = storage.getSkill(manasSkill)).isEmpty()) continue;
                ManasSkillInstance instance = manasSkill.createDefaultInstance();
                storage.learnSkill(instance);
            }
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                ResistSkill resist;
                ManasSkill skill = instance.getSkill();
                if (!(skill instanceof ResistSkill) || (resist = (ResistSkill)skill).getResistType() != ResistSkill.ResistType.RESISTANCE) continue;
                instance.setMastery(0);
                instance.setToggled(true);
                storage.updateSkill(instance);
            }
        }
        return data;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState procedurePredicate(AnimationEvent<E> event) {
        MezulEntity entity = this;
        Level world = ((Entity)entity).f_19853_;
        boolean loop = false;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!loop && this.lastloop) {
            this.lastloop = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            event.getController().clearAnimationCache();
            return PlayState.STOP;
        }
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            if (!loop) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                    this.animationprocedure = "empty";
                    event.getController().markNeedsReload();
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.lastloop = true;
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "procedure", 4.0f, this::procedurePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class MezulAttack
    extends MeleeAttackGoal {
        public MezulAttack(MezulEntity mezul, double speed, boolean chaseIfLost) {
            super((PathfinderMob)mezul, speed, chaseIfLost);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.f_25540_.m_5448_() != null) {
                MezulAttackingProcedure.execute((LevelAccessor)this.f_25540_.m_9236_(), (Entity)this.f_25540_.m_5448_(), (Entity)this.f_25540_);
            }
        }

        protected double m_6639_(LivingEntity entity) {
            return 64.0;
        }
    }
}

