/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import io.github.Memoires.trbeyond.entity.custom.LivingArmorEntity;
import io.github.Memoires.trbeyond.entity.custom.MageEntity;
import io.github.Memoires.trbeyond.entity.custom.SkullNightEntity;
import io.github.Memoires.trbeyond.procedures.SlimeAttacksProcedure;
import io.github.Memoires.trbeyond.procedures.SlimeTickProcedure;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MilimSlimeScarletEntity
extends Monster
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(MilimSlimeScarletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(MilimSlimeScarletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(MilimSlimeScarletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final Random RANDOM = new Random();
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public MilimSlimeScarletEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MilimSlimeScarletEntity>)((EntityType)BeyondEntities.MILIM_SLIME_SCARLET.get()), world);
    }

    public MilimSlimeScarletEntity(EntityType<MilimSlimeScarletEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"goz");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new SlimeAttack(this, 1.5, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> target.getClass() != LivingArmorEntity.class && target.getClass() != MageEntity.class && target.getClass() != SkullNightEntity.class && target.getClass() != MilimSlimeScarletEntity.class));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        this.setAnimation("animation.model.charged_attack");
        return retval;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (RANDOM.nextFloat() <= 0.1f) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public void m_6075_() {
        super.m_6075_();
        SlimeTickProcedure.execute((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (LevelAccessor)this.m_9236_());
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 250.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 100.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }

    public boolean m_7327_(Entity target) {
        return false;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.m_5912_())) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.m_5912_() && event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.zigzag", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState procedurePredicate(AnimationEvent<E> event) {
        MilimSlimeScarletEntity entity = this;
        Level world = ((Entity)entity).f_19853_;
        boolean loop = false;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!loop && this.lastloop) {
            this.lastloop = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            event.getController().clearAnimationCache();
            return PlayState.STOP;
        }
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            if (!loop) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                    this.animationprocedure = "empty";
                    event.getController().markNeedsReload();
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.lastloop = true;
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "procedure", 4.0f, this::procedurePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class SlimeAttack
    extends MeleeAttackGoal {
        public SlimeAttack(MilimSlimeScarletEntity slime, double speed, boolean chaseIfLost) {
            super((PathfinderMob)slime, speed, chaseIfLost);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.f_25540_.m_5448_() != null) {
                SlimeAttacksProcedure.execute((LevelAccessor)this.f_25540_.m_9236_(), (Entity)this.f_25540_.m_5448_(), (Entity)this.f_25540_);
            }
        }

        protected double m_6639_(LivingEntity entity) {
            return 64.0;
        }
    }
}

