/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.entity.magic.projectile.WindBladeProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.WindSphereProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MomijiEntity
extends HumanoidNPCEntity
implements IAnimatable {
    public static final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("animation.momiji.idle", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder RUN = new AnimationBuilder().addAnimation("animation.momiji.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder SLEEP = new AnimationBuilder().addAnimation("animation.momiji.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder WALK = new AnimationBuilder().addAnimation("animation.momiji.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder JUMP = new AnimationBuilder().addAnimation("animation.momiji.jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder FAN_ATTACK_NORMAL = new AnimationBuilder().addAnimation("animation.momiji.fan_attack_normal", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder MELEE = new AnimationBuilder().addAnimation("animation.momiji.melee_attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder LARGE_ATTACK = new AnimationBuilder().addAnimation("animation.momiji.big_fan_attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(MomijiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;
    private int rangedCooldown = 0;
    private int largeAttackCooldown = 0;

    public MomijiEntity(EntityType<? extends MomijiEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.miscAnimationHandler();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_20088_().m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8000.0).m_22268_(Attributes.f_22284_, 400.0).m_22268_(Attributes.f_22281_, 500.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MomijiAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackcontroller", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 0) {
            if (this.m_5803_()) {
                event.getController().setAnimation(SLEEP);
            } else if (event.isMoving()) {
                if (this.m_21660_()) {
                    event.getController().setAnimation(RUN);
                } else {
                    event.getController().setAnimation(WALK);
                }
            } else if (!event.isMoving() && event.getController().getCurrentAnimation() != null && event.getController().getCurrentAnimation().loop == ILoopType.EDefaultLoopTypes.LOOP) {
                if (this.f_19796_.m_188503_(1000) == 1 && !this.m_21660_()) {
                    event.getController().setAnimation(IDLE);
                } else {
                    event.getController().clearAnimationCache();
                    return PlayState.STOP;
                }
            }
        }
        return PlayState.CONTINUE;
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                LivingEntity target;
                if (this.getMiscAnimation() == 1 && (this.miscAnimationTicks == 18 || this.miscAnimationTicks == 26) && (target = this.m_5448_()) != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    if (this.m_20280_((Entity)target) <= 64.0 && this.m_142582_((Entity)target)) {
                        if (target.f_19802_ <= 12 && target.m_21188_() == this) {
                            target.f_19802_ = 0;
                        }
                        this.m_7327_((Entity)target);
                    }
                }
                if (this.getMiscAnimation() == 2 && (this.miscAnimationTicks == 20 || this.miscAnimationTicks == 27) && (target = this.m_5448_()) != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    MomijiEntity.windAttack((LivingEntity)this);
                }
                if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 12 && (target = this.m_5448_()) != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    this.jumpAway();
                }
                if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 116 && (target = this.m_5448_()) != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    MomijiEntity.largeAttack((LivingEntity)this);
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case 1 -> 40;
            case 2 -> 40;
            case 3 -> 140;
            default -> 100;
        };
    }

    public boolean canSleep() {
        return !this.m_21525_();
    }

    protected void sleepHandler() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5803_() && (this.m_5448_() != null || this.isInFluidType() || ++this.sleepingTime > this.maxSleepTime && this.m_9236_().m_46461_())) {
                this.setSleeping(false);
            } else if (this.m_9236_().m_46462_() && this.f_19796_.m_188503_(100) == 0) {
                if (this.f_19796_.m_188499_()) {
                    this.setSleeping(true);
                } else {
                    this.sleepingTime = 0;
                    this.maxSleepTime = 100 + this.f_19796_.m_188503_(600);
                }
            }
        }
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            switch (this.getMiscAnimation()) {
                case 1: {
                    event.getController().setAnimation(MELEE);
                    break;
                }
                case 2: {
                    event.getController().setAnimation(FAN_ATTACK_NORMAL);
                    break;
                }
                case 3: {
                    event.getController().setAnimation(LARGE_ATTACK);
                    break;
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public int getMiscAnimation() {
        return (Integer)this.m_20088_().m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.m_20088_().m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public static void windAttack(LivingEntity entity) {
        WindBladeProjectile blade = new WindBladeProjectile(entity.m_9236_(), entity);
        float angle = (float)Math.PI / 180 * entity.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        blade.m_7678_(entity.m_20185_() + xOffset, entity.m_20188_() - 0.5, entity.m_20189_() + zOffset, entity.m_146908_(), entity.m_146909_());
        blade.setDamage((float)entity.m_21133_(Attributes.f_22281_) * 1.5f);
        blade.setSpeed(5.0f);
        blade.m_20242_(true);
        blade.shootFromRot(entity.m_20154_());
        entity.f_19853_.m_7967_((Entity)blade);
        entity.m_216990_(SoundEvents.f_12520_);
    }

    public static void largeAttack(LivingEntity entity) {
        WindSphereProjectile sphere = new WindSphereProjectile(entity.m_9236_(), entity);
        float angle = (float)Math.PI / 180 * entity.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        sphere.m_7678_(entity.m_20185_() + xOffset, entity.m_20188_() - 0.5, entity.m_20189_() + zOffset, entity.m_146908_(), entity.m_146909_());
        sphere.setDamage((float)entity.m_21133_(Attributes.f_22281_) * 2.0f);
        sphere.setSpeed(3.0f);
        sphere.m_20242_(true);
        sphere.shootFromRot(entity.m_20154_());
        entity.f_19853_.m_7967_((Entity)sphere);
        entity.m_216990_(SoundEvents.f_12520_);
    }

    public void jumpAway() {
        Vec3 jump = this.m_20182_().m_82546_(this.m_5448_().m_20182_()).m_82541_().m_82542_(0.8, 0.0, 0.8).m_82520_(0.0, 0.6, 0.0);
        this.m_20256_(jump);
        this.m_6862_(true);
        this.m_216990_(SoundEvents.f_12317_);
    }

    static class MomijiAttackGoal
    extends Goal {
        private final MomijiEntity momiji;

        public MomijiAttackGoal(MomijiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.momiji = entity;
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity target = this.momiji.m_5448_();
            if (target instanceof Player && (player = (Player)target).m_7500_()) {
                this.momiji.m_21661_();
                return false;
            }
            return target != null && target.m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.momiji.m_21561_(true);
        }

        public void m_8037_() {
            --this.momiji.rangedCooldown;
            --this.momiji.largeAttackCooldown;
            if (this.momiji.getMiscAnimation() == 0) {
                LivingEntity target = this.momiji.m_5448_();
                if (target == null) {
                    return;
                }
                double dist = this.momiji.m_20280_((Entity)target);
                double cooldownMultiplier = 1.0f - (this.momiji.m_21233_() - this.momiji.m_21223_()) / this.momiji.m_21233_() / 2.0f;
                if (dist > 100.0 && this.momiji.rangedCooldown <= 0 && this.momiji.m_142582_((Entity)target)) {
                    this.momiji.rangedCooldown = (int)(200.0 * cooldownMultiplier) + this.momiji.getAnimationTick(2);
                    this.momiji.m_21573_().m_26573_();
                    this.momiji.setMiscAnimation(2);
                } else if (dist > 64.0 && this.momiji.largeAttackCooldown <= 0 && this.momiji.m_142582_((Entity)target)) {
                    this.momiji.largeAttackCooldown = (int)(400.0 * cooldownMultiplier) + this.momiji.getAnimationTick(3);
                    this.momiji.m_21573_().m_26573_();
                    this.momiji.setMiscAnimation(3);
                } else if (dist < 25.0) {
                    this.momiji.m_21573_().m_5624_((Entity)target, this.momiji.m_21204_().m_22181_(Attributes.f_22279_) * 3.0);
                    this.momiji.setMiscAnimation(1);
                } else {
                    Path path = this.momiji.m_21573_().m_26570_();
                    if (path == null || 9.0 < path.m_77406_().m_203193_((Position)target.m_20182_())) {
                        this.momiji.m_21573_().m_5624_((Entity)target, this.momiji.m_21204_().m_22181_(Attributes.f_22279_) * 9.0);
                    }
                }
            }
        }
    }
}

