/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.FlareCircleEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import io.github.Memoires.trbeyond.capability.boss.BeyondBossCapability;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.custom.OgreSubEntity;
import io.github.Memoires.trbeyond.network.PlayerVariablesHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.registry.items.BeyondArmorItems;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OgreLordEntity
extends Monster
implements IAnimatable,
IGiantMob {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossEvent;
    protected static final EntityDataAccessor<BlockPos> FLARE_POS;
    private static final EntityDataAccessor<Integer> MAGIC_ID;
    private static final EntityDataAccessor<Integer> MISC_ANIMATION;
    public int miscAnimationTicks = 0;

    public OgreLordEntity(EntityType<? extends OgreLordEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 100;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237113_((String)"Ogre Lord"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7005_(true);
        this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
    }

    public Component m_5446_() {
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)Component.m_237115_((String)"entity.trbeyond.ogreboss")).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(FLARE_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(MAGIC_ID, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128347_("FlareX", (double)this.getFlarePos().m_123341_());
        compound.m_128347_("FlareY", (double)this.getFlarePos().m_123342_());
        compound.m_128347_("FlareZ", (double)this.getFlarePos().m_123343_());
        compound.m_128405_("MagicID", this.getMagicID());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setFlarePos(compound.m_128459_("FlareX"), compound.m_128459_("FlareY"), compound.m_128459_("FlareZ"));
        this.setMagicID(compound.m_128451_("MagicID"));
    }

    public BlockPos getFlarePos() {
        return (BlockPos)this.f_19804_.m_135370_(FLARE_POS);
    }

    public void setFlarePos(double x, double y, double z) {
        this.f_19804_.m_135381_(FLARE_POS, (Object)new BlockPos(x, y, z));
    }

    public int getMagicID() {
        return (Integer)this.f_19804_.m_135370_(MAGIC_ID);
    }

    public void setMagicID(int id) {
        this.f_19804_.m_135381_(MAGIC_ID, (Object)id);
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return source == DamageSource.f_19305_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || super.m_6673_(source) || source.m_7639_() instanceof OgreLordEntity || source.m_7639_() instanceof OgreSubEntity;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public void m_6043_() {
    }

    public boolean cantBreakBlock(LivingEntity entity, boolean ignoreCollision) {
        Level level = entity.m_9236_();
        if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            return true;
        }
        return true;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22288_, 1.5).m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22285_, 25.0).m_22268_(Attributes.f_22283_, 5.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get(), 500.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new OgreLordAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 40.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> target.getClass() != ((Object)((Object)this)).getClass() && target.getClass() != OgreSubEntity.class));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            System.out.println("-------------------- ATTACK ANIMATION INSIDE -------------------");
            event.getController().markNeedsReload();
            System.out.println(this.getMiscAnimation());
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.double_swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.meteor_smash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.ogre_flame", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "movement", 5.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attacks", 5.0f, this::miscPredicate));
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        this.bossEvent.m_7706_();
        Entity entity = cause.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BeyondBossCapability.getFrom(player).ifPresent(cap -> {
                int killedOgre = cap.killedOgre();
                cap.setKilledOgre(killedOgre + 1);
            });
            BeyondBossCapability.sync(player);
            player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                if (!capability.KilledOgre) {
                    ItemStack slotItem;
                    int i;
                    int coinsRemaining = (Integer)ServerConfig.INSTANCE.bossConfig.ogreLordGoldDrop.get();
                    Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                    int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                    for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                        slotItem = player.m_150109_().m_8020_(i);
                        if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                        int spaceLeft = maxStackSize - slotItem.m_41613_();
                        int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                        slotItem.m_41769_(amountToAdd);
                        player.m_150109_().m_6836_(i, slotItem);
                        coinsRemaining -= amountToAdd;
                    }
                    if (coinsRemaining > 0) {
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (!slotItem.m_41619_()) continue;
                            int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                            ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                            player.m_150109_().m_6836_(i, newCoinStack);
                            coinsRemaining -= amountToAdd;
                        }
                    }
                    if (coinsRemaining > 0) {
                        while (coinsRemaining > 0) {
                            int dropAmount = Math.min(coinsRemaining, maxStackSize);
                            ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                            coinsRemaining -= dropAmount;
                        }
                    }
                    capability.KilledOgre = true;
                    capability.syncPlayerVariables((Entity)player);
                }
                ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondArmorItems.OGRE_CHESTPLATE_RARE.get()), new ItemStack((ItemLike)BeyondArmorItems.OGRE_LEGGINGS_RARE.get()), new ItemStack((ItemLike)BeyondArmorItems.OGRE_BOOTS_RARE.get()), new ItemStack((ItemLike)BeyondToolItems.OGRE_AXE_RARE.get())};
                EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                    if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                        ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                        if (!player.m_150109_().m_36054_(drop)) {
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                        }
                    }
                });
            });
        } else {
            TamableAnimal tame;
            LivingEntity owner;
            LivingEntity attacker;
            entity = cause.m_7639_();
            if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) instanceof TamableAnimal && (owner = (tame = (TamableAnimal)attacker).m_21826_()) instanceof Player) {
                Player player = (Player)owner;
                player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    if (!capability.KilledOgre) {
                        ItemStack slotItem;
                        int i;
                        int coinsRemaining = 10;
                        Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                        int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                            int spaceLeft = maxStackSize - slotItem.m_41613_();
                            int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                            slotItem.m_41769_(amountToAdd);
                            player.m_150109_().m_6836_(i, slotItem);
                            coinsRemaining -= amountToAdd;
                        }
                        if (coinsRemaining > 0) {
                            for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                                slotItem = player.m_150109_().m_8020_(i);
                                if (!slotItem.m_41619_()) continue;
                                int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                                ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                                player.m_150109_().m_6836_(i, newCoinStack);
                                coinsRemaining -= amountToAdd;
                            }
                        }
                        if (coinsRemaining > 0) {
                            while (coinsRemaining > 0) {
                                int dropAmount = Math.min(coinsRemaining, maxStackSize);
                                ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                                coinsRemaining -= dropAmount;
                            }
                        }
                        capability.KilledOgre = true;
                        capability.syncPlayerVariables((Entity)player);
                    }
                    ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondArmorItems.OGRE_CHESTPLATE_RARE.get()), new ItemStack((ItemLike)BeyondArmorItems.OGRE_LEGGINGS_RARE.get()), new ItemStack((ItemLike)BeyondArmorItems.OGRE_BOOTS_RARE.get()), new ItemStack((ItemLike)BeyondToolItems.OGRE_AXE_RARE.get())};
                    EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                        if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                            ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                            if (!player.m_150109_().m_36054_(drop)) {
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                            }
                        }
                    });
                });
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 0.25f, 0.5f);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.summonSubsRandomPos();
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_21051_(Attributes.f_22288_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordJumpStrength.get()).doubleValue());
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordMaxHealth.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordAttackDamage.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordKnockbackResistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordArmor.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordArmorToughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22283_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordAttackSpeed.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordAttackKnockback.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordFollowRange.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordMovementSpeed.get()).doubleValue());
        this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.ogreLordMaxSpiritualHealth.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        AttributeInstance spiritualHP = this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        AttributeInstance maxHP = this.m_21051_(Attributes.f_22276_);
        double sHP = maxHP.m_22135_() * 2.0;
        if (spiritualHP != null) {
            spiritualHP.m_22100_(sHP);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)this, (double)sHP);
        }
        this.getPersistentData().m_128379_("isBoss", true);
        if (this.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)this);
            for (ManasSkill manasSkill : SkillAPI.getSkillRegistry()) {
                Optional existing;
                ResistSkill resist;
                if (!(manasSkill instanceof ResistSkill) || (resist = (ResistSkill)manasSkill).getResistType() != ResistSkill.ResistType.RESISTANCE || !(existing = storage.getSkill(manasSkill)).isEmpty()) continue;
                ManasSkillInstance instance = manasSkill.createDefaultInstance();
                storage.learnSkill(instance);
            }
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                ResistSkill resist;
                ManasSkill skill = instance.getSkill();
                if (!(skill instanceof ResistSkill) || (resist = (ResistSkill)skill).getResistType() != ResistSkill.ResistType.RESISTANCE) continue;
                instance.setMastery(0);
                instance.setToggled(true);
                storage.updateSkill(instance);
            }
        }
        return data;
    }

    protected void summonSubsRandomPos() {
        Level var2 = this.m_9236_();
        if (var2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var2;
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)this.m_20186_());
            int k = Mth.m_14107_((double)this.m_20189_());
            block0: for (int subs = 0; subs < 5; ++subs) {
                OgreSubEntity sub = new OgreSubEntity((EntityType<? extends OgreSubEntity>)((EntityType)BeyondEntities.OGRE_SUB.get()), (Level)serverLevel);
                for (int l = 0; l < 50; ++l) {
                    int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)7) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                    int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)7) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                    int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)7) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                    BlockPos blockpos = new BlockPos(i1, j1, k1);
                    EntityType entitytype = (EntityType)BeyondEntities.OGRE_SUB.get();
                    SpawnPlacements.Type type = SpawnPlacements.m_21752_((EntityType)entitytype);
                    if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)serverLevel, (BlockPos)blockpos, (EntityType)entitytype) || !SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)serverLevel.f_46441_)) continue;
                    sub.m_6034_(i1, j1, k1);
                    if (!serverLevel.m_45784_((Entity)sub) || !serverLevel.m_45786_((Entity)sub)) continue;
                    sub.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(sub.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    sub.m_6710_(this.m_5448_());
                    serverLevel.m_47205_((Entity)sub);
                    SkillUtils.learnSkill((LivingEntity)sub, (ManasSkill)((ManasSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get()));
                    ManasSkillInstance instance = SkillUtils.getSkillOrNull((Entity)sub, (ManasSkill)((ManasSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get()));
                    if (instance == null || !instance.canBeToggled((LivingEntity)sub)) continue block0;
                    instance.setToggled(true);
                    continue block0;
                }
            }
        }
    }

    private void createHelixParticles(Level pLevel, LivingEntity pLivingEntity, int stateTimer) {
        double baseRadius = 1.5;
        double heightIncrement = 0.1;
        int maxParticlesCount = Math.min(100, stateTimer / 2);
        for (int i = 0; i < maxParticlesCount; ++i) {
            double angle = (double)(i * 2) * Math.PI / 10.0 + (double)stateTimer * 0.2;
            double x = baseRadius * Math.cos(angle);
            double y = (double)i * heightIncrement + 1.0;
            double z = baseRadius * Math.sin(angle);
            double particleX = pLivingEntity.m_20185_() + (x += this.randomOffset());
            double particleY = pLivingEntity.m_20186_() + (y += this.randomOffset());
            double particleZ = pLivingEntity.m_20189_() + (z += this.randomOffset());
            TensuraParticleHelper.spawnServerParticles((Level)pLevel, (ParticleOptions)((ParticleOptions)TensuraParticles.RED_FIRE.get()), (double)particleX, (double)particleY, (double)particleZ, (int)1, (double)0.0, (double)0.25, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    private void createFirePillar(Level pLevel, int FIRE_PILLAR_DURATION, int firePillarTimer, LivingEntity pLivingEntity) {
        double radius = 6.5;
        double height = 5.0;
        int particlesPerRevolution = 4;
        int totalParticles = particlesPerRevolution * FIRE_PILLAR_DURATION;
        Vec3 targetPosition = pLivingEntity.m_20318_(0.0f);
        for (int i = 0; i < totalParticles; ++i) {
            double t = (double)i / (double)particlesPerRevolution;
            double angle = Math.PI * 2 * t + (double)firePillarTimer * (Math.PI / (double)FIRE_PILLAR_DURATION);
            double x = radius * Math.cos(angle);
            double y = height * t;
            double z = radius * Math.sin(angle);
            double particleX = targetPosition.f_82479_ + (x += this.randomOffset());
            double particleY = targetPosition.f_82480_ + (y += this.randomOffset());
            double particleZ = targetPosition.f_82481_ + (z += this.randomOffset());
            TensuraParticleHelper.spawnServerParticles((Level)pLevel, (ParticleOptions)((ParticleOptions)TensuraParticles.RED_FIRE.get()), (double)particleX, (double)particleY, (double)particleZ, (int)1, (double)0.0, (double)0.25, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    private void createLineParticles(Level pLevel, LivingEntity pLivingEntity) {
        Vec3 lookVec = this.m_20154_();
        Vec3 startPos = this.m_20299_(1.0f);
        BlockHitResult hitResult = pLevel.m_45547_(new ClipContext(startPos, Objects.requireNonNull(this.m_5448_()).m_20318_(0.1f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)pLivingEntity));
        int particleCount = 20;
        double swerveAmplitude = 0.8;
        double swerveFrequency = 2.0;
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            Vec3 swerveVec = this.calculateSwerve(lookVec, t, swerveAmplitude, swerveFrequency);
            Vec3 pos = startPos.m_82549_(lookVec.m_82490_(hitResult.m_82450_().m_82554_(startPos) * t)).m_82549_(swerveVec);
            double speedMultiplier = 0.5 + (1.0 - t) * 0.1;
            for (double j = 0.0; j < 5.0; j += 1.0) {
                TensuraParticleHelper.spawnServerParticles((Level)pLevel, (ParticleOptions)((ParticleOptions)TensuraParticles.RED_FIRE.get()), (double)pos.f_82479_, (double)(pos.f_82480_ - 0.3), (double)pos.f_82481_, (int)1, (double)(lookVec.f_82479_ * speedMultiplier), (double)(lookVec.f_82480_ * speedMultiplier), (double)(lookVec.f_82481_ * speedMultiplier), (double)0.1, (boolean)true);
            }
        }
    }

    private Vec3 calculateSwerve(Vec3 lookVec, double t, double amplitude, double frequency) {
        double swerveX = Math.sin(t * Math.PI * frequency) * amplitude;
        double swerveY = Math.cos(t * Math.PI * frequency) * amplitude;
        return lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(swerveX).m_82549_(lookVec.m_82537_(new Vec3(1.0, 0.0, 0.0)).m_82541_().m_82490_(swerveY)).m_82549_(new Vec3((this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1));
    }

    private double randomOffset() {
        return (this.f_19796_.m_188500_() - 0.5) * 0.2;
    }

    public boolean shouldAttack(LivingEntity target) {
        return target instanceof Player && ((Player)target).m_7500_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getMiscAnimation() != 0) {
            LivingEntity target;
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 1) {
                if (this.miscAnimationTicks == 22) {
                    target = this.m_5448_();
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.ogre_lord_double_strike.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (target != null && (double)target.m_20270_((Entity)this) <= 5.0) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.m_7327_((Entity)target);
                    }
                }
                if (this.miscAnimationTicks == 47 && (target = this.m_5448_()) != null && (double)target.m_20270_((Entity)this) <= 5.0) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                    this.m_7327_((Entity)target);
                }
            }
            if (this.getMiscAnimation() == 2 && (target = this.m_5448_()) != null) {
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                if (this.miscAnimationTicks > 24 && this.miscAnimationTicks < 40 && this.m_20096_()) {
                    double x = target.m_20185_() - this.m_20185_();
                    double z = target.m_20189_() - this.m_20189_();
                    double xz = Math.sqrt(x * x + z * z);
                    this.m_20334_(x / xz * 1.3, 1.0, z / xz * 1.3);
                }
                if (this.miscAnimationTicks % 2 == 0 && this.miscAnimationTicks < 55 && this.miscAnimationTicks > 25) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 1.1, 1.0));
                }
                if (this.miscAnimationTicks == 50) {
                    this.m_20256_(this.m_20184_().m_82542_(0.0, 0.0, 0.0));
                    this.m_20242_(true);
                }
                if (this.miscAnimationTicks == 60) {
                    this.m_20242_(false);
                    this.m_20334_(0.0, -8.0, 0.0);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.ogre_lord_meteorite_strike.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (this.miscAnimationTicks == 65) {
                    if (this.m_20096_()) {
                        AABB aabb = new AABB(this.m_20183_()).m_82400_(5.0);
                        List entities = this.f_19853_.m_45976_(LivingEntity.class, aabb);
                        for (LivingEntity entity : entities) {
                            if (entity == this) continue;
                            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * 4.0));
                        }
                    }
                    TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, (int)75, (float)3.0f);
                }
            }
            if (this.getMiscAnimation() == 3) {
                if (this.miscAnimationTicks <= 70 && this.miscAnimationTicks >= 20) {
                    target = this.m_5448_();
                    this.createHelixParticles(this.f_19853_, (LivingEntity)this, this.miscAnimationTicks);
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                    }
                } else if (this.miscAnimationTicks == 72) {
                    target = this.m_5448_();
                    if (target != null) {
                        Vec3 pos = target.m_20182_();
                        this.createLineParticles(this.f_19853_, target);
                        this.setFlarePos(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                        this.setMagicID(0);
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.ogre_lord_ogre_flame.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                } else if (this.miscAnimationTicks >= 90 && (target = this.m_5448_()) != null) {
                    this.createFirePillar(this.f_19853_, 40, 40, target);
                    this.flareCircle(this.miscAnimationTicks);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        int var10000 = switch (miscAnimation) {
            case 1 -> 60;
            case 2 -> 80;
            case 3 -> 110;
            default -> 20;
        };
        return var10000;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
        }
        return flag;
    }

    private void flareCircle(int heldTicks) {
        BlockPos pos = this.getFlarePos();
        if (heldTicks >= 91) {
            int flareID = this.getMagicID();
            if (flareID == 0) {
                FlareCircleEntity barrier = new FlareCircleEntity((EntityType)TensuraEntityTypes.FLARE_CIRCLE.get(), this.f_19853_);
                barrier.m_5602_((Entity)this);
                barrier.setDamage((float)this.m_21133_(Attributes.f_22281_));
                barrier.setRadius(4.0f);
                barrier.setHeight(5.0f);
                barrier.setLife(30);
                barrier.setHealth(200.0f);
                barrier.m_146884_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                barrier.setMpCost(2000.0);
                barrier.setSkill((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SpiritualMagics.FLARE_CIRCLE.get()).orElse(null));
                this.m_9236_().m_7967_((Entity)barrier);
                this.setMagicID(barrier.m_19879_());
            } else {
                Entity entity = this.m_9236_().m_6815_(flareID);
                if (entity instanceof BarrierEntity) {
                    BarrierEntity barrier = (BarrierEntity)entity;
                    barrier.increaseLife(5);
                } else {
                    this.setMagicID(0);
                }
            }
            this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
        } else {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:flare_circle_circle"), pos, 0.0, 0.0, 0.0, 0, true));
        }
    }

    static {
        MISC_ANIMATION = SynchedEntityData.m_135353_(OgreLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FLARE_POS = SynchedEntityData.m_135353_(OgreLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
        MAGIC_ID = SynchedEntityData.m_135353_(OgreLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    class OgreLordAttackGoal
    extends MeleeAttackGoal {
        private final OgreLordEntity ogre;

        public OgreLordAttackGoal(OgreLordEntity ogre, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)ogre, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.ogre = ogre;
        }

        public void m_8037_() {
            if (this.ogre.getMiscAnimation() == 0) {
                super.m_8037_();
            }
        }

        protected void m_6739_(@NotNull LivingEntity pEnemy, double pDistToEnemySqr) {
            double reach = this.m_6639_(pEnemy);
            if (this.ogre.getMiscAnimation() == 0 && pEnemy.m_6084_()) {
                double var10000;
                int randomAttack = this.randomAttack(pDistToEnemySqr);
                double var10001 = switch (randomAttack) {
                    case 3 -> {
                        this.ogre.m_21573_().m_26573_();
                        var10000 = 400.0;
                        yield 25.0;
                    }
                    case 2 -> {
                        var10000 = 100.0;
                        yield 25.0;
                    }
                    default -> {
                        var10000 = reach;
                        yield 1.0;
                    }
                };
                double attackRange = var10000;
                double minRange = var10001;
                if (pDistToEnemySqr <= attackRange && pDistToEnemySqr >= minRange && this.m_25564_()) {
                    this.m_25563_();
                    this.ogre.setMiscAnimation(randomAttack);
                }
            }
        }

        protected int randomAttack(double distance) {
            if (distance > 25.0 && distance < 400.0 && this.ogre.m_217043_().m_188503_(10) == 0) {
                return 3;
            }
            return distance > 25.0 && distance < 100.0 && this.ogre.m_217043_().m_188503_(5) == 0 ? 2 : 1;
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + pAttackTarget.m_20205_();
        }
    }
}

