/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import io.github.Memoires.trbeyond.entity.custom.OgreLordEntity;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OgreSubEntity
extends Monster
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(OgreLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;

    public OgreSubEntity(EntityType<? extends OgreSubEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 100;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return source == DamageSource.f_19305_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || super.m_6673_(source) || source.m_7639_() instanceof OgreLordEntity || source.m_7639_() instanceof OgreSubEntity;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22288_, 1.5).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22285_, 15.0).m_22268_(Attributes.f_22283_, 5.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new OgreSubAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 40.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> target.getClass() != OgreLordEntity.class && target.getClass() != OgreSubEntity.class));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            System.out.println("-------------------- ATTACK ANIMATION INSIDE -------------------");
            event.getController().markNeedsReload();
            System.out.println(this.getMiscAnimation());
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.double_swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.meteor_smash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ogrelord.ogre_flame", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "movement", 5.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attacks", 5.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 0.25f, 0.5f);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public boolean shouldAttack(LivingEntity target) {
        return target instanceof Player && ((Player)target).m_7500_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getMiscAnimation() != 0) {
            LivingEntity target;
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 1) {
                float damage;
                if (this.miscAnimationTicks == 22) {
                    target = this.m_5448_();
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.ogre_lord_double_strike.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (target != null && (double)target.m_20270_((Entity)this) <= 5.0) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        damage = (float)(this.m_21133_(Attributes.f_22281_) + 30.0);
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
                    }
                }
                if (this.miscAnimationTicks == 47 && (target = this.m_5448_()) != null && (double)target.m_20270_((Entity)this) <= 5.0) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                    damage = (float)(this.m_21133_(Attributes.f_22281_) + 30.0);
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
                }
            }
            if (this.getMiscAnimation() == 2 && (target = this.m_5448_()) != null) {
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                if (this.miscAnimationTicks > 24 && this.miscAnimationTicks < 35 && this.m_20096_()) {
                    double x = target.m_20185_() - this.m_20185_();
                    double z = target.m_20189_() - this.m_20189_();
                    double xz = Math.sqrt(x * x + z * z);
                    this.m_20334_(x / xz * 1.3, 1.0, z / xz * 1.3);
                }
                if (this.miscAnimationTicks % 2 == 0 && this.miscAnimationTicks < 55 && this.miscAnimationTicks > 25) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 1.1, 1.0));
                }
                if (this.miscAnimationTicks == 50) {
                    this.m_20256_(this.m_20184_().m_82542_(0.0, 0.0, 0.0));
                    this.m_20242_(true);
                }
                if (this.miscAnimationTicks == 60) {
                    this.m_20242_(false);
                    this.m_20334_(0.0, -8.0, 0.0);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.ogre_lord_meteorite_strike.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (this.miscAnimationTicks == 65) {
                    if (this.m_20096_()) {
                        AABB aabb = new AABB(this.m_20183_()).m_82400_(5.0);
                        List entities = this.f_19853_.m_45976_(LivingEntity.class, aabb);
                        for (LivingEntity entity : entities) {
                            if (entity == this) continue;
                            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * 10.0));
                        }
                    }
                    TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, (int)75, (float)3.0f);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        int var10000 = switch (miscAnimation) {
            case 1 -> 60;
            case 2 -> 80;
            default -> 20;
        };
        return var10000;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
        }
        return flag;
    }

    class OgreSubAttackGoal
    extends MeleeAttackGoal {
        private final OgreSubEntity ogre;

        public OgreSubAttackGoal(OgreSubEntity ogre, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)ogre, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.ogre = ogre;
        }

        public void m_8037_() {
            if (this.ogre.getMiscAnimation() == 0) {
                super.m_8037_();
            }
        }

        protected void m_6739_(@NotNull LivingEntity pEnemy, double pDistToEnemySqr) {
            double reach = this.m_6639_(pEnemy);
            if (this.ogre.getMiscAnimation() == 0 && pEnemy.m_6084_()) {
                double var10001;
                double var10000;
                int randomAttack = this.randomAttack(pDistToEnemySqr);
                if (randomAttack == 2) {
                    var10000 = 100.0;
                    var10001 = 25.0;
                } else {
                    var10000 = reach;
                    var10001 = 1.0;
                }
                double attackRange = var10000;
                double minRange = var10001;
                if (pDistToEnemySqr <= attackRange && pDistToEnemySqr >= minRange && this.m_25564_()) {
                    this.m_25563_();
                    this.ogre.setMiscAnimation(randomAttack);
                }
            }
        }

        protected int randomAttack(double distance) {
            return distance > 25.0 && distance < 100.0 && this.ogre.m_217043_().m_188503_(20) == 0 ? 2 : 1;
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + pAttackTarget.m_20205_();
        }
    }
}

