/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.ability.skill.unique.CookSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.projectile.AuraBulletProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.AuraSlashProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ShionEntity
extends HumanoidNPCEntity
implements IAnimatable {
    public static final AnimationBuilder IDLE_1 = new AnimationBuilder().addAnimation("animation.shion.idle_1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder IDLE_2 = new AnimationBuilder().addAnimation("animation.shion.idle_2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder IDLE_4 = new AnimationBuilder().addAnimation("animation.shion.idle_4", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder SLEEP = new AnimationBuilder().addAnimation("animation.shion.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder RUN = new AnimationBuilder().addAnimation("animation.shion.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder WALK = new AnimationBuilder().addAnimation("animation.shion.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder JUMP_KICK = new AnimationBuilder().addAnimation("animation.shion.jump_kick", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder SWORD_REFLECTION = new AnimationBuilder().addAnimation("animation.shion.sword_reflection", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder SHEATH = new AnimationBuilder().addAnimation("animation.shion.sheath", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder UNSHEATH = new AnimationBuilder().addAnimation("animation.shion.unsheath", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder SPIN_PUNCH = new AnimationBuilder().addAnimation("animation.shion.spin_punch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder MAGIC_BULLET_PUSH = new AnimationBuilder().addAnimation("animation.shion.magic_bullet_push", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder OGRE_SWORD_CANNON = new AnimationBuilder().addAnimation("animation.shion.ogre_sword_cannon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder QUICK_PUNCHES = new AnimationBuilder().addAnimation("animation.shion.quick_punches", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder DASH_SWORD_STRIKE = new AnimationBuilder().addAnimation("animation.shion.dash_sword_strike", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder DOUBLE_SWORD_STRIKE = new AnimationBuilder().addAnimation("animation.shion.double_sword_strike", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder JUMP_SWORD_SMASH = new AnimationBuilder().addAnimation("animation.shion.jump_sword_smash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(ShionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> COOK_TICKS = SynchedEntityData.m_135353_(ShionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SWORD_DRAWN = SynchedEntityData.m_135353_(ShionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int miscAnimationTicks = 0;
    public int deflectCooldown = 0;
    public int cookCooldown = 0;
    public boolean swordDrawn = false;

    public ShionEntity(EntityType<? extends ShionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(COOK_TICKS, (Object)0);
        this.f_19804_.m_135372_(SWORD_DRAWN, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        this.miscAnimationHandler();
        --this.deflectCooldown;
        --this.cookCooldown;
        if (this.swordDrawn && this.deflectCooldown <= 0 && (this.getMiscAnimation() == 0 || this.getMiscAnimation() == 11)) {
            AABB projectileDetection = this.m_20191_().m_82400_(5.0);
            List projectiles = this.f_19853_.m_45976_(Projectile.class, projectileDetection);
            for (Projectile projectile : projectiles) {
                if (projectile.m_37282_() == this) continue;
                projectile.m_20242_(true);
                projectile.m_20334_(0.0, 0.0, 0.0);
                if (this.getMiscAnimation() != 0) continue;
                this.setMiscAnimation(11);
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("CookTicks", this.cookCooldown);
        compound.m_128379_("SwordDrawn", this.swordDrawn);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.m_20088_().m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.cookCooldown = compound.m_128451_("CookTicks");
        this.swordDrawn = compound.m_128471_("SwordDrawn");
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 28000.0).m_22268_(Attributes.f_22284_, 1400.0).m_22268_(Attributes.f_22281_, 1750.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new ShionAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackcontroller", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 0) {
            if (this.m_5803_()) {
                event.getController().setAnimation(SLEEP);
            } else if (event.isMoving()) {
                if (this.m_21660_() && this.swordDrawn) {
                    event.getController().setAnimation(RUN);
                } else {
                    event.getController().setAnimation(WALK);
                }
            } else if (!event.isMoving() && event.getController().getCurrentAnimation() != null && event.getController().getCurrentAnimation().loop == ILoopType.EDefaultLoopTypes.LOOP) {
                if (this.f_19796_.m_188503_(3000) == 1 && !this.m_21660_()) {
                    switch (this.f_19796_.m_216332_(1, 3)) {
                        case 1: {
                            event.getController().setAnimation(IDLE_1);
                            break;
                        }
                        case 2: {
                            event.getController().setAnimation(IDLE_2);
                            break;
                        }
                        case 3: {
                            event.getController().setAnimation(IDLE_4);
                            break;
                        }
                    }
                } else {
                    event.getController().clearAnimationCache();
                    return PlayState.STOP;
                }
            }
        }
        return PlayState.CONTINUE;
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                switch (this.getMiscAnimation()) {
                    case 3: {
                        LivingEntity target;
                        if (this.miscAnimationTicks != 8 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if (!(this.m_20280_((Entity)target) <= 64.0) || !this.m_142582_((Entity)target)) break;
                        this.doHurtTarget((Entity)target, 0.2f, 10.0f);
                        break;
                    }
                    case 4: {
                        LivingEntity target;
                        if (this.miscAnimationTicks < 21 || this.miscAnimationTicks > 69 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if (!(this.m_20280_((Entity)target) <= 64.0) || !this.m_142582_((Entity)target) || target.m_21188_() != this) break;
                        target.f_19802_ = 0;
                        this.doHurtTarget((Entity)target, 0.1f, 0.25f);
                        break;
                    }
                    case 5: {
                        LivingEntity target;
                        if (this.miscAnimationTicks == 8) {
                            LivingEntity target2 = this.m_5448_();
                            if (target2 == null) break;
                            Vec3 jump = target2.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82542_(2.0, 0.0, 2.0).m_82520_(0.0, 0.2, 0.0);
                            this.m_20256_(jump);
                            this.m_6862_(true);
                            break;
                        }
                        if (this.miscAnimationTicks != 15 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if (!(this.m_20280_((Entity)target) <= 64.0) || !this.m_142582_((Entity)target)) break;
                        this.doHurtTarget((Entity)target, 0.25f, 10.0f);
                        break;
                    }
                    case 6: {
                        LivingEntity target;
                        if (this.miscAnimationTicks != 8 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        ShionEntity.magicBullet((LivingEntity)this);
                        break;
                    }
                    case 7: {
                        LivingEntity target;
                        if (this.miscAnimationTicks != 20 && this.miscAnimationTicks != 28 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if (!(this.m_20280_((Entity)target) <= 64.0) || !this.m_142582_((Entity)target)) break;
                        if (target.f_19802_ <= 12 && target.m_21188_() == this) {
                            target.f_19802_ = 0;
                        }
                        this.doHurtTarget((Entity)target, 1.0f, 1.0f);
                        break;
                    }
                    case 8: {
                        LivingEntity target;
                        if (this.miscAnimationTicks == 28 && (target = this.m_5448_()) != null) {
                            Vec3 jump = target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82542_(3.0, 0.0, 3.0).m_82520_(0.0, 0.3, 0.0);
                            this.m_20256_(jump);
                            this.m_6862_(true);
                        }
                        if (this.miscAnimationTicks < 28 || this.miscAnimationTicks > 40 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if (!(this.m_20280_((Entity)target) <= 64.0) || !this.m_142582_((Entity)target)) break;
                        this.doHurtTarget((Entity)target, 1.25f, 1.0f);
                        break;
                    }
                    case 9: {
                        LivingEntity target;
                        if (this.miscAnimationTicks == 8) {
                            LivingEntity target3 = this.m_5448_();
                            if (target3 == null) break;
                            Vec3 jump = target3.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82542_(2.0, 0.0, 2.0).m_82520_(0.0, 0.8, 0.0);
                            this.m_20256_(jump);
                            this.m_6862_(true);
                            break;
                        }
                        if (this.miscAnimationTicks != 26 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        if (!(this.m_20280_((Entity)target) <= 64.0) || !this.m_142582_((Entity)target)) break;
                        this.doHurtTarget((Entity)target, 1.5f, 3.0f);
                        break;
                    }
                    case 10: {
                        LivingEntity target;
                        if (this.miscAnimationTicks != 45 || (target = this.m_5448_()) == null) break;
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        ShionEntity.ogreSwordCannon((LivingEntity)this);
                        break;
                    }
                    case 11: {
                        if (this.miscAnimationTicks != 13) break;
                        AABB projectileDetection = this.m_20191_().m_82400_(6.0);
                        List projectiles = this.f_19853_.m_45976_(Projectile.class, projectileDetection);
                        for (Projectile projectile : projectiles) {
                            if (projectile.m_37282_() == this) continue;
                            if (projectile.m_37282_() == null || projectile.m_37282_().m_9236_() != this.m_9236_()) {
                                projectile.m_20256_(projectile.m_20318_(0.0f).m_82546_(this.m_20318_(0.0f)).m_82541_().m_82490_(10.0));
                                projectile.m_20242_(false);
                                continue;
                            }
                            projectile.m_20256_(projectile.m_37282_().m_20318_(0.0f).m_82546_(this.m_20318_(0.0f)).m_82541_().m_82490_(10.0));
                        }
                        break;
                    }
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                switch (this.getMiscAnimation()) {
                    case 1: {
                        this.swordDrawn = false;
                        this.f_19804_.m_135381_(SWORD_DRAWN, (Object)false);
                        break;
                    }
                    case 2: {
                        this.swordDrawn = true;
                        this.f_19804_.m_135381_(SWORD_DRAWN, (Object)true);
                        break;
                    }
                    case 11: {
                        this.deflectCooldown = 200;
                        break;
                    }
                }
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case 1 -> 20;
            case 2 -> 20;
            case 3 -> 30;
            case 4 -> 100;
            case 5 -> 33;
            case 6 -> 20;
            case 7 -> 60;
            case 8 -> 50;
            case 9 -> 60;
            case 10 -> 100;
            case 11 -> 30;
            default -> 100;
        };
    }

    public boolean canSleep() {
        return !this.m_21525_() && !this.m_21660_();
    }

    public boolean doHurtTarget(@NotNull Entity pEntity, float damageMultiplier, float knockbackMultiplier) {
        float damage = (float)this.m_21133_(Attributes.f_22281_) * damageMultiplier;
        float knockback = (float)this.m_21133_(Attributes.f_22282_) * knockbackMultiplier;
        boolean flag = pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
        if (flag) {
            if (knockback > 0.0f && pEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pEntity;
                living.m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                ItemStack itemStack = this.inventory.m_8020_(4);
                itemStack.m_41720_().m_7579_(itemStack, living, (LivingEntity)this);
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.m_21223_() < this.m_21233_() * 0.5f && !this.m_21023_((MobEffect)TensuraMobEffects.OGRE_BERSERKER.get()) && !this.m_21023_((MobEffect)TensuraMobEffects.FRAGILITY.get())) {
            this.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.OGRE_BERSERKER.get(), 7200, 3, false, false, false));
            this.m_216990_(SoundEvents.f_12363_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123747_, (double)3.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123747_, (double)2.0);
            TensuraParticleHelper.spawnServerParticles((Level)this.m_9236_(), (ParticleOptions)((ParticleOptions)TensuraParticles.PURPLE_LIGHTNING_SPARK.get()), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
        }
        if (this.m_21223_() < this.m_21233_() * 0.25f) {
            this.m_216990_(SoundEvents.f_12002_);
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void sleepHandler() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5803_() && (this.m_5448_() != null || this.isInFluidType() || ++this.sleepingTime > this.maxSleepTime && this.m_9236_().m_46461_())) {
                this.setSleeping(false);
            } else if (this.m_9236_().m_46462_() && this.f_19796_.m_188503_(100) == 0) {
                if (this.f_19796_.m_188499_()) {
                    this.setSleeping(true);
                } else {
                    this.sleepingTime = 0;
                    this.maxSleepTime = 100 + this.f_19796_.m_188503_(600);
                }
            }
        }
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            switch (this.getMiscAnimation()) {
                case 1: {
                    event.getController().setAnimation(SHEATH);
                    break;
                }
                case 2: {
                    event.getController().setAnimation(UNSHEATH);
                    break;
                }
                case 3: {
                    event.getController().setAnimation(SPIN_PUNCH);
                    break;
                }
                case 4: {
                    event.getController().setAnimation(QUICK_PUNCHES);
                    break;
                }
                case 5: {
                    event.getController().setAnimation(JUMP_KICK);
                    break;
                }
                case 6: {
                    event.getController().setAnimation(MAGIC_BULLET_PUSH);
                    break;
                }
                case 7: {
                    event.getController().setAnimation(DOUBLE_SWORD_STRIKE);
                    break;
                }
                case 8: {
                    event.getController().setAnimation(DASH_SWORD_STRIKE);
                    break;
                }
                case 9: {
                    event.getController().setAnimation(JUMP_SWORD_SMASH);
                    break;
                }
                case 10: {
                    event.getController().setAnimation(OGRE_SWORD_CANNON);
                    break;
                }
                case 11: {
                    event.getController().setAnimation(SWORD_REFLECTION);
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public int getMiscAnimation() {
        return (Integer)this.m_20088_().m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.m_20088_().m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public void cookEffects(LivingEntity entity, double damage) {
        AttributeInstance barrier;
        if (TensuraEPCapability.getEP((LivingEntity)entity) < TensuraEPCapability.getEP((LivingEntity)this) * 2.0 && (barrier = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get())) != null) {
            barrier.m_22132_();
        }
        if (this.cookCooldown < 0) {
            AttributeInstance health = entity.m_21051_(Attributes.f_22276_);
            if (health != null) {
                AttributeModifier chefModifier = health.m_22111_(CookSkill.COOK);
                if (chefModifier != null) {
                    damage -= chefModifier.m_22218_();
                }
                AttributeModifier attributeModifier = new AttributeModifier(CookSkill.COOK, "Cook", damage * -1.0, AttributeModifier.Operation.ADDITION);
                health.m_22130_(attributeModifier);
                health.m_22125_(attributeModifier);
                this.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
            }
            this.cookCooldown = 200;
        }
    }

    public static void magicBullet(LivingEntity entity) {
        AuraBulletProjectile bullet = new AuraBulletProjectile(entity.m_9236_(), entity);
        float angle = (float)Math.PI / 180 * entity.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        bullet.m_7678_(entity.m_20185_() + xOffset, entity.m_20188_() - 0.5, entity.m_20189_() + zOffset, entity.m_146908_(), entity.m_146909_());
        bullet.setDamage((float)entity.m_21133_(Attributes.f_22281_) * 1.5f);
        bullet.setSpeed(5.0f);
        bullet.m_20242_(true);
        bullet.shootFromRot(entity.m_20154_());
        bullet.setColor(AuraBulletProjectile.AuraColor.PURPLE);
        bullet.setSize(2.0f);
        entity.f_19853_.m_7967_((Entity)bullet);
        entity.m_216990_(SoundEvents.f_12520_);
    }

    public static void ogreSwordCannon(LivingEntity entity) {
        AuraSlashProjectile slash = new AuraSlashProjectile(entity.m_9236_(), entity);
        slash.setSpeed(0.5f);
        slash.setDamage((float)entity.m_21133_(Attributes.f_22281_));
        slash.setLife(100);
        slash.setSize(5.0f);
        slash.m_20242_(true);
        slash.shootFromRot(entity.m_20154_());
        entity.f_19853_.m_7967_((Entity)slash);
        entity.m_216990_(SoundEvents.f_215778_);
    }

    static class ShionAttackGoal
    extends Goal {
        private static final Logger logger = LogUtils.getLogger();
        private final ShionEntity shion;

        public ShionAttackGoal(ShionEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.shion = entity;
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity target = this.shion.m_5448_();
            if (target instanceof Player && (player = (Player)target).m_7500_()) {
                this.shion.m_21661_();
                return false;
            }
            if (target != null && target.m_6084_()) {
                return true;
            }
            if (this.shion.swordDrawn && this.shion.getMiscAnimation() == 0) {
                this.shion.setMiscAnimation(1);
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.shion.m_21561_(true);
        }

        public void m_8037_() {
            if (this.shion.getMiscAnimation() == 0) {
                LivingEntity target = this.shion.m_5448_();
                if (target == null) {
                    return;
                }
                double targetEP = TensuraEPCapability.getEP((LivingEntity)target);
                double currentEP = TensuraEPCapability.getEP((LivingEntity)this.shion);
                double targetDist = this.shion.m_20280_((Entity)target);
                if (targetEP > currentEP * 10.0 && !this.shion.swordDrawn) {
                    this.shion.setMiscAnimation(2);
                }
                if (this.shion.swordDrawn) {
                    if (targetDist > 100.0 && targetDist < 400.0 && this.shion.f_19796_.m_216332_(1, 100) < 20) {
                        this.shion.setMiscAnimation(9);
                    } else if (targetDist < 25.0) {
                        this.shion.m_21573_().m_5624_((Entity)target, 1.0);
                        this.shion.setMiscAnimation(7);
                    } else if (targetDist > 64.0 && targetDist < 225.0 && this.shion.f_19796_.m_188499_()) {
                        this.shion.m_21573_().m_26573_();
                        this.shion.setMiscAnimation(8);
                    } else if (targetDist > 64.0 && targetDist < 225.0 && this.shion.f_19796_.m_188503_(20) < 18) {
                        this.shion.m_21573_().m_26573_();
                        this.shion.setMiscAnimation(9);
                    } else if (targetDist > 100.0 && targetDist < 625.0) {
                        this.shion.m_21573_().m_26573_();
                        this.shion.setMiscAnimation(10);
                    } else {
                        Path path = this.shion.m_21573_().m_26570_();
                        if (path == null || 9.0 < path.m_77406_().m_203193_((Position)target.m_20182_())) {
                            this.shion.m_21573_().m_5624_((Entity)target, this.shion.m_21204_().m_22181_(Attributes.f_22279_) * 9.0);
                        }
                    }
                } else if (targetDist > 225.0 && this.shion.f_19796_.m_188503_(20) < 2) {
                    this.shion.m_21573_().m_26573_();
                    this.shion.setMiscAnimation(6);
                } else if (targetDist > 64.0 && targetDist < 144.0 && this.shion.f_19796_.m_188499_()) {
                    this.shion.m_21573_().m_26573_();
                    this.shion.setMiscAnimation(5);
                } else if (targetDist < 25.0 && this.shion.f_19796_.m_188503_(20) < 15) {
                    this.shion.m_21573_().m_26573_();
                    this.shion.setMiscAnimation(3);
                } else if (targetDist < 25.0) {
                    this.shion.setMiscAnimation(4);
                } else {
                    Path path = this.shion.m_21573_().m_26570_();
                    if (path == null || 9.0 < path.m_77406_().m_203193_((Position)target.m_20182_())) {
                        this.shion.m_21573_().m_5624_((Entity)target, this.shion.m_21204_().m_22181_(Attributes.f_22279_) * 9.0);
                    }
                }
            }
        }
    }
}

