/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.entity.custom.SlimeDollBossEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SlimeDollMinions
extends Monster
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_ID = SynchedEntityData.m_135353_(SlimeDollMinions.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MODE = SynchedEntityData.m_135353_(SlimeDollMinions.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_SEQ = SynchedEntityData.m_135353_(SlimeDollBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lastSeenAttackSeq = -1;
    private static final double MAX_HP = 50.0;
    private static final double BASE_DAMAGE = 25.0;
    private static final int ATK_NONE = 0;
    private static final int ATK_WALK_BOULDER = 2;
    private static final int ATK_WALK_BOULDER_2 = 3;
    private static final int ATK_CRUSH = 4;
    private static final int ATK_THRUST = 14;
    private static final int ATK_DOUBLE_THRUST = 15;
    private static final int ATK_JUMP_ANIM = 16;
    private static final int ATK_BOULDER_ANIM = 22;
    private static final int ATK_BOULDER_TO_ARMS = 27;
    private static final int ATK_MELT_BOULDER = 35;
    private static final int ATK_MELTED_JUMP = 11;
    private static final int ATK_MELTED_GRAB = 12;
    private static final int ATK_ENCASE_IDLE = 13;
    private static final int LEN_CRUSH = 20;
    private static final int LEN_BOULDER_MELT = 30;
    private static final int LEN_WALKATTACK_BOULDER = 18;
    private static final int LEN_WALKATTACK_BOULDER2 = 18;
    private static final int LEN_MELTED_JUMP_ATTACK = 40;
    private static final int LEN_ENCASEPLAYERIDLE = 20;
    private static final int LEN_BOULDER = 45;
    private static final int LEN_MELTEDGRAB = 35;
    private static final int LEN_BOULDER_TO_ARMS = 40;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_BOULDER = 1;
    private static final int MODE_MELT = 5;
    private int attackTicks = 0;
    private int lastAnimAttackId = -1;
    private int queuedFollowup = 0;
    private boolean fightStarted = false;
    private int modeTicks = 0;

    public SlimeDollMinions(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ATTACK_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_MODE, (Object)0);
        this.f_19804_.m_135372_(DATA_ATTACK_SEQ, (Object)0);
    }

    public int getAttackId() {
        return (Integer)this.f_19804_.m_135370_(DATA_ATTACK_ID);
    }

    public void setAttackId(int id) {
        if (id == 0 || id != this.getAttackId()) {
            this.f_19804_.m_135381_(DATA_ATTACK_ID, (Object)id);
            int seq = (Integer)this.f_19804_.m_135370_(DATA_ATTACK_SEQ);
            this.f_19804_.m_135381_(DATA_ATTACK_SEQ, (Object)(seq + 1));
            this.lastAnimAttackId = -1;
            if (id != 0) {
                this.attackTicks = 0;
            }
        }
    }

    public int getMode() {
        return (Integer)this.f_19804_.m_135370_(DATA_MODE);
    }

    public void setMode(int mode) {
        this.f_19804_.m_135381_(DATA_MODE, (Object)mode);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("BossAttackId", this.getAttackId());
        tag.m_128405_("BossAttackTicks", this.attackTicks);
        tag.m_128405_("BossQueuedFollowup", this.queuedFollowup);
        tag.m_128405_("BossAnimMode", this.getMode());
        tag.m_128405_("BossModeTicks", this.modeTicks);
        tag.m_128379_("BossFightStarted", this.fightStarted);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ATTACK_ID, (Object)tag.m_128451_("BossAttackId"));
        this.attackTicks = tag.m_128451_("BossAttackTicks");
        this.queuedFollowup = tag.m_128451_("BossQueuedFollowup");
        int loadedMode = tag.m_128441_("BossAnimMode") ? tag.m_128451_("BossAnimMode") : 0;
        this.f_19804_.m_135381_(DATA_MODE, (Object)loadedMode);
        this.setMode(loadedMode);
        this.modeTicks = tag.m_128441_("BossModeTicks") ? tag.m_128451_("BossModeTicks") : 0;
        this.fightStarted = tag.m_128441_("BossFightStarted") && tag.m_128471_("BossFightStarted");
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BossAttackGoal(this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    private boolean isPhysical(DamageSource src) {
        if (src.m_19372_() || src.m_19387_() || src == DamageSource.f_19317_) {
            return false;
        }
        if (src == DamageSource.f_19320_) {
            return false;
        }
        return src == DamageSource.f_19318_ || src == DamageSource.f_19315_ || src == DamageSource.f_19322_ || src == DamageSource.f_19321_ || src == DamageSource.f_19314_ || src == DamageSource.f_19325_ || src.m_19360_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            int chosen;
            LivingEntity t = this.m_5448_();
            if (!this.fightStarted && t != null) {
                this.fightStarted = true;
                this.setMode(1);
                this.setAttackId(22);
            }
            if (this.getAttackId() != 0) {
                this.processAttackTick();
                return;
            }
            if (t != null && this.f_19861_ && this.m_217043_().m_188501_() < 0.02f && (chosen = this.chooseWeightedAttack(t.m_20280_((Entity)this))) != 0) {
                this.setAttackId(chosen);
            }
        }
    }

    private void processAttackTick() {
        ++this.attackTicks;
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (!this.attackAllowedInMode(this.getAttackId(), this.getMode())) {
            this.endAttackOrQueue();
            return;
        }
        switch (this.getAttackId()) {
            case 13: {
                if (target instanceof Player) {
                    Player p = (Player)target;
                    this.m_21573_().m_26573_();
                    if (this.attackTicks < 20 && this.isInMeleeRange(target)) {
                        p.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        p.m_146922_(this.m_146908_() + 180.0f);
                        this.m_20334_(0.0, 0.0, 0.0);
                        this.hitTarget(target, 0.8f, 0.0);
                    }
                }
                if (this.attackTicks < 20) break;
                this.setMode(1);
                this.endAttackOrQueue();
                break;
            }
            case 2: {
                if (this.attackTicks == 10 && target != null && this.isInMeleeRange(target)) {
                    this.hitTarget(target, 1.0f, 0.2);
                }
                if (this.attackTicks < 18) break;
                this.endAttackOrQueue();
                break;
            }
            case 3: {
                if (this.attackTicks == 12 && target != null && this.isInMeleeRange(target)) {
                    this.hitTarget(target, 1.0f, 0.2);
                }
                if (this.attackTicks < 18) break;
                this.endAttackOrQueue();
                break;
            }
            case 4: {
                this.m_21573_().m_26573_();
                if (this.attackTicks == 15 && target != null && this.isInMeleeRange(target)) {
                    this.hitTarget(target, 2.0f, 0.6);
                    target.m_5997_(this.m_20154_().f_82479_ * 2.5, 0.1, this.m_20154_().f_82481_ * 2.5);
                }
                if (this.attackTicks < 20) break;
                this.endAttackOrQueue();
                break;
            }
            case 11: {
                if (this.attackTicks == 12 && target != null) {
                    this.leapToward(target, 1.2, 0.6);
                } else if (this.attackTicks == 23 && target != null) {
                    this.hitTarget(target, 1.0f, 0.2);
                }
                if (this.attackTicks < 40) break;
                this.setMode(1);
                this.endAttackOrQueue();
                break;
            }
            case 12: {
                if (this.attackTicks > 10 && target != null && this.isInMeleeRange(target)) {
                    Vec3 front = this.getFrontPosition(1.0, 0.0);
                    target.m_6021_(front.f_82479_, front.f_82480_, front.f_82481_);
                    this.hitTarget(target, 0.5f, 0.0);
                }
                if (this.attackTicks < 35) break;
                this.queuedFollowup = 13;
                this.endAttackOrQueue();
                break;
            }
            case 22: {
                if (this.attackTicks < 45) break;
                this.endAttackOrQueue();
                break;
            }
            case 27: {
                this.m_21573_().m_26573_();
                if (this.attackTicks < 40) break;
                this.setMode(0);
                this.endAttackOrQueue();
                break;
            }
            case 35: {
                this.m_21573_().m_26573_();
                if (this.attackTicks < 30) break;
                if (this.queuedFollowup > 0) {
                    int next = this.queuedFollowup;
                    this.queuedFollowup = 0;
                    this.setAttackId(next);
                    break;
                }
                this.endAttackOrQueue();
                break;
            }
            default: {
                this.endAttackOrQueue();
            }
        }
    }

    private void endAttackOrQueue() {
        this.f_19804_.m_135381_(DATA_ATTACK_ID, (Object)0);
        if (this.queuedFollowup > 0) {
            int next = this.queuedFollowup;
            this.queuedFollowup = 0;
            this.setAttackId(next);
            return;
        }
        this.attackTicks = 0;
        this.queuedFollowup = 0;
        this.lastAnimAttackId = -1;
    }

    private boolean attackAllowedInMode(int attackId, int mode) {
        return switch (attackId) {
            case 2, 3, 4, 11, 12, 13, 22, 27, 35 -> {
                if (mode == 1 || mode == 5) {
                    yield true;
                }
                yield false;
            }
            case 0 -> true;
            default -> true;
        };
    }

    public int chooseWeightedAttack(double dist2) {
        double reachPref = 16.0;
        int mode = this.getMode();
        for (int attempt = 0; attempt < 6; ++attempt) {
            float r = this.f_19796_.m_188501_();
            int candidate = 0;
            switch (mode) {
                case 1: {
                    if ((double)r < 0.4) {
                        candidate = 3;
                        break;
                    }
                    if ((double)r < 0.6) {
                        candidate = 4;
                        break;
                    }
                    if ((double)r < 0.9) {
                        candidate = 2;
                        break;
                    }
                    candidate = 3;
                    break;
                }
                case 5: {
                    if (dist2 > reachPref * 4.0) {
                        candidate = 11;
                        break;
                    }
                    if ((double)r < 0.5) {
                        candidate = 12;
                        break;
                    }
                    candidate = 11;
                    break;
                }
                case 0: {
                    candidate = 22;
                    this.setMode(1);
                }
            }
            if (!this.attackAllowedInMode(candidate, mode)) continue;
            return candidate;
        }
        return 0;
    }

    private boolean isInMeleeRange(LivingEntity target) {
        double reach = this.m_20205_() * this.m_20205_() * 10.0f + target.m_20205_();
        return this.m_20280_((Entity)target) <= reach;
    }

    private void hitTarget(LivingEntity target, float damageMultiplier, double knockUp) {
        if (target != null) {
            float base = (float)this.m_21133_(Attributes.f_22281_);
            target.m_6469_(TensuraDamageSources.CORROSION, base * damageMultiplier);
            if (knockUp > 0.0) {
                target.m_5997_(0.0, knockUp, 0.0);
            }
        }
    }

    private Vec3 getFrontPosition(double distance, double yOffset) {
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double x = this.m_20185_() - Math.sin(yawRad) * distance;
        double z = this.m_20189_() + Math.cos(yawRad) * distance;
        double y = this.m_20186_() + yOffset;
        return new Vec3(x, y, z);
    }

    private void leapToward(LivingEntity target, double forward, double up) {
        Vec3 cur = this.m_20184_();
        Vec3 dir = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_();
        double nx = cur.f_82479_ * 0.4 + dir.f_82479_ * forward;
        double nz = cur.f_82481_ * 0.4 + dir.f_82481_ * forward;
        double ny = Math.max(cur.f_82480_, up);
        this.m_20334_(nx, ny, nz);
        this.m_21569_().m_24901_();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 0.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attacks", 0.0f, this::attacksPredicate));
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.getAttackId() != 0) {
            return PlayState.STOP;
        }
        String walk = "";
        String idle = "";
        switch (this.getMode()) {
            case 1: {
                walk = "animation.model.walk_boulder";
                idle = "animation.model.idleball";
                break;
            }
            case 5: {
                walk = "animation.model.meltwalk";
                idle = "animation.model.meltwalk";
                break;
            }
            case 0: {
                walk = "animation.model.walk";
                idle = "animation.model.idle";
            }
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(walk, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(idle, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attacksPredicate(AnimationEvent<E> event) {
        int id = this.getAttackId();
        if (id == 0) {
            if (event.getController().getAnimationState() == AnimationState.Stopped) {
                this.lastAnimAttackId = -1;
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        }
        if (!this.attackAllowedInMode(id, this.getMode())) {
            this.endAttackOrQueue();
            this.lastAnimAttackId = -1;
            return PlayState.STOP;
        }
        int seq = (Integer)this.f_19804_.m_135370_(DATA_ATTACK_SEQ);
        if (seq != this.lastAnimAttackId) {
            event.getController().markNeedsReload();
            switch (id) {
                case 13: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.encaseplayeridle", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 2: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walkattack_boulder", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 3: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walkattack_boulder2", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 4: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.crush", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 14: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.thrust", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 15: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.double_thrust", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 16: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 22: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.boulder", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 11: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.melted_jump_attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 12: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.meltedgrab", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 27: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.boulder_to_arms", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 35: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.melt_boulder", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            }
            this.lastAnimAttackId = seq;
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private static class BossAttackGoal
    extends MeleeAttackGoal {
        private final SlimeDollMinions boss;

        BossAttackGoal(SlimeDollMinions mob, double speedModifier, boolean longMemory) {
            super((PathfinderMob)mob, speedModifier, longMemory);
            this.boss = mob;
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            boolean melee;
            if (this.boss.getAttackId() != 0 || !enemy.m_6084_()) {
                return;
            }
            if (!this.m_25564_()) {
                return;
            }
            int chosen = this.boss.chooseWeightedAttack(distToEnemySqr);
            if (chosen == 0) {
                return;
            }
            boolean bl = melee = chosen == 2 || chosen == 3 || chosen == 4 || chosen == 13;
            if (melee && distToEnemySqr > this.m_6639_(enemy)) {
                return;
            }
            this.m_25563_();
            this.boss.setAttackId(chosen);
        }

        public void m_8037_() {
            if (this.boss.getAttackId() == 0) {
                super.m_8037_();
            } else {
                LivingEntity t = this.boss.m_5448_();
                if (t != null) {
                    this.boss.m_21563_().m_24960_((Entity)t, 30.0f, 30.0f);
                }
            }
        }

        protected double m_6639_(LivingEntity target) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + target.m_20205_();
        }
    }
}

