/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.entity.SlimeEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.items.armor.SerpentArmorItem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SlimeWallEntity
extends TensuraTamableEntity
implements IAnimatable {
    private boolean trappingTarget = false;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SlimeWallEntity(EntityType<? extends SlimeWallEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 1000;
        this.f_19793_ = 2.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new WallMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 0.2, 20.0f, 5.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
    }

    public int m_8132_() {
        return 180;
    }

    public int m_8085_() {
        return 180;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19314_ || source == DamageSource.f_19309_ || source == DamageSource.f_19325_ || super.m_6673_(source);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public static boolean isSlime(Entity entity) {
        return entity instanceof SlimeEntity || entity instanceof SlimeWallEntity || entity instanceof Slime;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_21830_((LivingEntity)pEntity)) {
            return;
        }
        if (!this.m_6142_()) {
            return;
        }
        this.trapping((Entity)pEntity);
        this.damageCollidedEntity((Entity)pEntity);
        if (this.m_6688_() instanceof Player && !pEntity.equals((Object)this.m_6688_())) {
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19599_, 30, 1, false, false, false), (Entity)this);
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 30, 1, false, false, false), (Entity)this);
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false, false), (Entity)this);
        }
        if (!pEntity.m_7500_() && !pEntity.m_5833_() && (double)this.m_20270_((Entity)pEntity) < 3.5) {
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 20, 2, false, false, false), (Entity)this);
            if (pEntity.equals((Object)this.m_5448_())) {
                this.trappingTarget = true;
            }
        }
    }

    public void m_7334_(Entity pEntity) {
        LivingEntity living;
        super.m_7334_(pEntity);
        if (!this.m_6142_()) {
            return;
        }
        if (!SlimeWallEntity.isSlime(pEntity) && pEntity.m_20184_().m_7098_() < 0.0) {
            pEntity.m_183634_();
            pEntity.m_20256_(pEntity.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        if (SlimeWallEntity.isSlime(pEntity) && this.m_5448_() != pEntity) {
            return;
        }
        if (this.m_7307_(pEntity)) {
            return;
        }
        if (pEntity instanceof LivingEntity && this.m_21830_(living = (LivingEntity)pEntity)) {
            return;
        }
        this.trapping(pEntity);
        this.damageCollidedEntity(pEntity);
    }

    protected void trapping(Entity entity) {
        if (this.trappingTarget) {
            return;
        }
        this.trappingTarget = true;
        if (this.m_20270_(entity) > 8.0f) {
            return;
        }
        entity.m_7998_((Entity)this, true);
    }

    protected void damageCollidedEntity(Entity entity) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        this.dealDamage(entity, damage, entity == this.m_5448_());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack slotStack = living.m_6844_(slot);
                if (slotStack.m_41720_() instanceof SerpentArmorItem) continue;
                slotStack.m_41622_(3, living, player -> player.m_21166_(slot));
            }
        }
    }

    protected boolean dealDamage(Entity entity, float damage, boolean aggro) {
        if (damage < 0.0f) {
            return false;
        }
        if (!this.m_6084_()) {
            return false;
        }
        DamageSource damageSource = TensuraDamageSources.corrosion((Entity)this);
        if (!aggro) {
            damageSource = damageSource.m_181120_();
        }
        if (entity.m_20202_() == this) {
            damage *= 2.0f;
        }
        if (this.m_20270_(entity) < this.m_20205_() / 2.0f + 1.0f && entity.m_6469_(damageSource, damage)) {
            this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19970_((LivingEntity)this, entity);
            return true;
        }
        return false;
    }

    public void m_7332_(Entity passenger) {
        LivingEntity living;
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = -0.25f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() + 1.5 + this.m_6048_() + passenger.m_6049_();
        if (!(passenger instanceof LivingEntity) || !this.m_21830_(living = (LivingEntity)passenger)) {
            yOffset -= 3.0;
        }
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (!this.m_6084_()) {
            return;
        }
        this.targetingMovementHelper();
        if (this.trappingTarget && (this.m_5448_() == null || this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 3.0)) {
            this.trappingTarget = false;
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12388_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class WallMeleeAttackGoal
    extends MeleeAttackGoal {
        public WallMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        }
    }
}

