/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.network.SyncAnimationPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class StellarMimicBossEntity
extends Monster
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> ATTACK_ID = SynchedEntityData.m_135353_(StellarMimicBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int attackTicks = 0;
    private int queuedFollowup = 0;
    private int lastAnimAttackId = -1;
    private static final int ATK_NONE = 0;
    private static final int ATK_BITE = 1;
    private static final int ATK_HEAVY = 2;
    private static final int ATK_LICK = 3;
    private static final int ATK_LICK2 = 4;
    private static final int ATK_LICK_GRAB = 5;
    private static final int ATK_HOP_SLAM = 6;
    private static final int ATK_EAT = 7;
    private static final int ATK_HOP_ONLY = 8;
    private static final int LEN_BITE = 30;
    private static final int LEN_HEAVY = 80;
    private static final int LEN_LICK = 40;
    private static final int LEN_LICK2 = 40;
    private static final int LEN_LICK_GRAB = 50;
    private static final int LEN_HOP_SLAM = 70;
    private static final int LEN_EAT = 155;
    private static final int LEN_HOP_ONLY = 16;
    private int hopCooldown = 0;
    private static final int HOP_CD_MIN = 1;
    private static final int HOP_CD_MAX = 2;
    private static final double HOP_Y = 0.5;
    private static final double HOP_FWD = 0.7;
    private int storedSilver = 0;
    private int storedGold = 0;
    private int storedStellar = 0;
    private static final int MAX_COIN_HP = 10000;
    private final ServerBossEvent bossEvent;

    public StellarMimicBossEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 20;
        this.bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.trbeyond.stellar_mimic_boss"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_10);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 50.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_ID, (Object)0);
    }

    public void m_21153_(float health) {
        super.m_21153_(health);
        if (this.bossEvent != null) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public int getAttackId() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ID);
    }

    public void setAttackId(int id) {
        if (id == 0 || id != this.getAttackId()) {
            this.f_19804_.m_135381_(ATTACK_ID, (Object)id);
            if (id != 0) {
                this.attackTicks = 0;
                this.lastAnimAttackId = -1;
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MimicAttackGoal(this, 1.1, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 35.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("MimicAttackId", this.getAttackId());
        tag.m_128405_("MimicAttackTicks", this.attackTicks);
        tag.m_128405_("MimicQueuedFollowup", this.queuedFollowup);
        tag.m_128405_("HopCooldown", this.hopCooldown);
        tag.m_128405_("StoredSilver", this.storedSilver);
        tag.m_128405_("StoredGold", this.storedGold);
        tag.m_128405_("StoredStellar", this.storedStellar);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(ATTACK_ID, (Object)tag.m_128451_("MimicAttackId"));
        this.attackTicks = tag.m_128451_("MimicAttackTicks");
        this.queuedFollowup = tag.m_128451_("MimicQueuedFollowup");
        this.hopCooldown = tag.m_128451_("HopCooldown");
        this.storedSilver = tag.m_128451_("StoredSilver");
        this.storedGold = tag.m_128451_("StoredGold");
        this.storedStellar = tag.m_128451_("StoredStellar");
    }

    public void m_8107_() {
        LivingEntity t;
        super.m_8107_();
        if (this.getAttackId() != 0) {
            ++this.attackTicks;
            LivingEntity target = this.m_5448_();
            if (target != null) {
                this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                this.m_146922_(yaw);
                this.f_20883_ = yaw;
                this.f_20885_ = yaw;
            }
            switch (this.getAttackId()) {
                case 1: {
                    if (this.attackTicks == 15 && target != null && this.isInMeleeRange(target)) {
                        this.hitTarget(target, 1.0f, 0.1);
                    }
                    if (this.attackTicks < 30) break;
                    this.endAttackOrQueue();
                    break;
                }
                case 2: {
                    if (this.attackTicks == 65 && target != null && this.isInMeleeRange(target)) {
                        this.hitTarget(target, 2.0f, 0.1);
                    }
                    if (this.attackTicks < 80) break;
                    this.endAttackOrQueue();
                    break;
                }
                case 3: {
                    if (this.attackTicks == 25 && target != null && this.isInMeleeRange(target)) {
                        this.hitTarget(target, 1.0f, 0.0);
                        float yaw = this.m_146908_() * ((float)Math.PI / 180);
                        double leftX = -Mth.m_14089_((float)yaw);
                        double leftZ = Mth.m_14031_((float)yaw);
                        target.m_5997_(leftX * 0.8, 0.2, leftZ * 0.8);
                    }
                    if (this.attackTicks < 40) break;
                    this.endAttackOrQueue();
                    break;
                }
                case 4: {
                    if (this.attackTicks == 25 && target != null && this.isInMeleeRange(target)) {
                        this.hitTarget(target, 1.0f, 0.0);
                        float yaw = this.m_146908_() * ((float)Math.PI / 180);
                        double leftX = Mth.m_14089_((float)yaw);
                        double leftZ = -Mth.m_14031_((float)yaw);
                        target.m_5997_(leftX * 0.8, 0.2, leftZ * 0.8);
                    }
                    if (this.attackTicks < 40) break;
                    this.endAttackOrQueue();
                    break;
                }
                case 5: {
                    if (this.attackTicks == 40 && target != null && this.m_20280_((Entity)target) < 25.0) {
                        this.hitTarget(target, 0.5f, 0.0);
                        Vec3 front = this.getFrontPosition(1.2, 0.0);
                        target.m_6021_(front.f_82479_, front.f_82480_, front.f_82481_);
                        target.m_146922_(this.m_146908_() + 180.0f);
                    }
                    if (this.attackTicks < 50) break;
                    if (this.queuedFollowup != 0) {
                        int next = this.queuedFollowup;
                        this.queuedFollowup = 0;
                        if (next == 7 && target != null && this.m_20280_((Entity)target) < 7.0) {
                            this.f_19804_.m_135381_(ATTACK_ID, (Object)7);
                            this.attackTicks = 0;
                            return;
                        }
                    }
                    this.endAttackOrQueue();
                    break;
                }
                case 6: {
                    if (this.attackTicks < 20) {
                        if (this.f_19861_) {
                            Vec3 v = this.m_20184_();
                            this.m_20334_(0.0, Math.min(v.f_82480_, 0.0), 0.0);
                        } else {
                            Vec3 v = this.m_20184_();
                            this.m_20334_(v.f_82479_ * 0.5, v.f_82480_, v.f_82481_ * 0.5);
                        }
                    } else if (this.attackTicks == 30) {
                        if (!this.f_19861_) {
                            --this.attackTicks;
                            return;
                        }
                        this.m_20334_(0.0, 1.0, 0.0);
                        this.f_19812_ = true;
                    } else if (this.attackTicks > 20 && this.attackTicks < 40 && target != null) {
                        Vec3 dir = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_();
                        this.m_20334_(dir.f_82479_ * 0.6, this.m_20184_().f_82480_, dir.f_82481_ * 0.6);
                    } else if (this.attackTicks == 50 && target != null) {
                        if (this.m_20280_((Entity)target) < 64.0) {
                            this.hitTarget(target, 4.0f, 0.2);
                            target.m_5997_(this.m_20154_().f_82479_ * 2.0, 0.1, this.m_20154_().f_82481_ * 2.0);
                        }
                    } else if (this.attackTicks > 50 && this.f_19861_) {
                        this.m_20256_(Vec3.f_82478_);
                    }
                    if (this.attackTicks < 70) break;
                    this.endAttackOrQueue();
                    break;
                }
                case 7: {
                    if (this.attackTicks >= 65 && target instanceof Player) {
                        Player player = (Player)target;
                        if ((this.attackTicks - 65) % 3 == 0) {
                            this.drainOneCoin(player);
                            this.hitTarget(target, 1.0f, 0.0);
                        }
                        Vec3 front = this.getFrontPosition(1.0, 0.0);
                        player.m_6021_(front.f_82479_, front.f_82480_, front.f_82481_);
                        player.m_146922_(this.m_146908_() + 180.0f);
                        if (this.attackTicks == 65) {
                            BeyondNetwork.toAll(new SyncAnimationPacket(player.m_19879_(), "eat_player_animation", true));
                        }
                        if (this.attackTicks >= 155) {
                            BeyondNetwork.toAll(new SyncAnimationPacket(player.m_19879_()));
                        }
                    }
                    if (this.attackTicks < 155) break;
                    this.endAttackOrQueue();
                    break;
                }
                case 8: {
                    this.attackTicks = 16;
                    this.endAttackOrQueue();
                }
            }
            return;
        }
        if (this.getAttackId() == 0 && this.f_19861_) {
            if (this.hopCooldown > 0) {
                --this.hopCooldown;
            } else {
                LivingEntity t2 = this.m_5448_();
                if (t2 != null) {
                    this.m_21563_().m_24960_((Entity)t2, 30.0f, 30.0f);
                    this.leapToward(t2, 0.7, 0.5);
                } else if (this.m_21573_().m_26572_()) {
                    Vec3 f = Vec3.m_82498_((float)0.0f, (float)this.m_146908_());
                    this.m_20334_(this.m_20184_().f_82479_ * 0.4 + f.f_82479_ * 0.7, Math.max(this.m_20184_().f_82480_, 0.5), this.m_20184_().f_82481_ * 0.4 + f.f_82481_ * 0.7);
                    this.m_21569_().m_24901_();
                }
                this.resetHopCooldown();
            }
        } else if (this.getAttackId() == 0 && !this.f_19861_ && (t = this.m_5448_()) != null) {
            double dx = t.m_20185_() - this.m_20185_();
            double dz = t.m_20189_() - this.m_20189_();
            float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.m_146922_(yaw);
            this.f_20883_ = yaw;
            this.f_20885_ = yaw;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_146707_()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    private void endAttackOrQueue() {
        this.setAttackId(0);
        this.attackTicks = 0;
        this.queuedFollowup = 0;
    }

    private boolean isInMeleeRange(LivingEntity target) {
        double extraRange = 4.0;
        double reach = this.m_20205_() * this.m_20205_() * 10.0f + target.m_20205_();
        return this.m_20280_((Entity)target) <= reach + extraRange;
    }

    private void hitTarget(LivingEntity target, float damageMultiplier, double knockUp) {
        float base = (float)this.m_21133_(Attributes.f_22281_);
        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), base * damageMultiplier);
        if (knockUp > 0.0) {
            target.m_5997_(0.0, knockUp, 0.0);
        }
    }

    private Vec3 getFrontPosition(double distance, double yOffset) {
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double x = this.m_20185_() - (double)Mth.m_14031_((float)yawRad) * distance;
        double z = this.m_20189_() + (double)Mth.m_14089_((float)yawRad) * distance;
        double y = this.m_20186_() + yOffset;
        return new Vec3(x, y, z);
    }

    private boolean drainOneCoin(Player player) {
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            double bonus = 0.0;
            if (stack.m_150930_((Item)TensuraMaterialItems.SILVER_COIN.get())) {
                bonus = 1.0;
                ++this.storedSilver;
            } else if (stack.m_150930_((Item)TensuraMaterialItems.GOLD_COIN.get())) {
                bonus = 100.0;
                ++this.storedGold;
            } else if (stack.m_150930_((Item)TensuraMaterialItems.STELLAR_GOLD_COIN.get())) {
                bonus = 10000.0;
                ++this.storedStellar;
            }
            if (!(bonus > 0.0)) continue;
            stack.m_41774_(1);
            AttributeInstance attr = this.m_21051_(Attributes.f_22276_);
            double newMax = attr.m_22115_() + bonus;
            attr.m_22100_(newMax);
            this.m_21153_((float)Math.min((double)this.m_21223_() + bonus, newMax));
            return true;
        }
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        if (this.storedSilver > 0) {
            this.m_19983_(new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get(), this.storedSilver));
        }
        if (this.storedGold > 0) {
            this.m_19983_(new ItemStack((ItemLike)TensuraMaterialItems.GOLD_COIN.get(), this.storedGold));
        }
        if (this.storedStellar > 0) {
            this.m_19983_(new ItemStack((ItemLike)TensuraMaterialItems.STELLAR_GOLD_COIN.get(), this.storedStellar));
        }
        if (this.f_19796_.m_188501_() < 0.01f) {
            this.m_19983_(new ItemStack((ItemLike)TensuraMaterialItems.STELLAR_GOLD_COIN.get(), 1));
        }
    }

    private void leapToward(LivingEntity target, double forward, double up) {
        Vec3 cur = this.m_20184_();
        Vec3 dir = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_();
        double nx = cur.f_82479_ * 0.4 + dir.f_82479_ * forward;
        double nz = cur.f_82481_ * 0.4 + dir.f_82481_ * forward;
        double ny = Math.max(cur.f_82480_, up);
        this.m_20334_(nx, ny, nz);
        this.m_21569_().m_24901_();
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        this.m_146922_(yaw);
        this.f_20883_ = yaw;
        this.f_20885_ = yaw;
    }

    private void resetHopCooldown() {
        this.hopCooldown = Mth.m_216271_((RandomSource)this.m_217043_(), (int)1, (int)2);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 1.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attacks", 1.0f, this::attacksPredicate));
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.getAttackId() != 0) {
            return PlayState.STOP;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("hop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attacksPredicate(AnimationEvent<E> event) {
        int id = this.getAttackId();
        if (id == 0) {
            if (event.getController().getAnimationState() == AnimationState.Stopped) {
                this.lastAnimAttackId = -1;
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        }
        if (id != this.lastAnimAttackId) {
            event.getController().markNeedsReload();
            event.getController().clearAnimationCache();
            switch (id) {
                case 1: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 2: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("heavy_bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 3: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lick", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 4: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lick2", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 5: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lick_grab", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 6: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("hop2", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 7: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 8: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("hop", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            }
            this.lastAnimAttackId = id;
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private static class MimicAttackGoal
    extends MeleeAttackGoal {
        private final StellarMimicBossEntity mimic;

        MimicAttackGoal(StellarMimicBossEntity mob, double speedModifier, boolean longMemory) {
            super((PathfinderMob)mob, speedModifier, longMemory);
            this.mimic = mob;
        }

        public void m_8037_() {
            if (this.mimic.getAttackId() == 0) {
                super.m_8037_();
            } else {
                LivingEntity t = this.mimic.m_5448_();
                if (t != null) {
                    this.mimic.m_21563_().m_24960_((Entity)t, 30.0f, 30.0f);
                }
            }
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            boolean melee;
            if (this.mimic.getAttackId() != 0 || !enemy.m_6084_()) {
                return;
            }
            double reach = this.m_6639_(enemy);
            int chosen = this.chooseWeightedAttack(this.f_25540_.m_217043_(), distToEnemySqr, reach);
            if (chosen == 0) {
                return;
            }
            boolean bl = melee = chosen == 1 || chosen == 2 || chosen == 3 || chosen == 4 || chosen == 5 || chosen == 7;
            if (melee && distToEnemySqr > reach) {
                return;
            }
            if (this.m_25564_()) {
                this.m_25563_();
                this.mimic.setAttackId(chosen);
            }
        }

        private int chooseWeightedAttack(RandomSource rng, double dist2, double reach) {
            double FAR2 = reach * 4.0;
            double MID2 = reach * 2.0;
            if (dist2 > FAR2) {
                return rng.m_188501_() < 0.65f ? 8 : 6;
            }
            if (dist2 > MID2) {
                float r = rng.m_188501_();
                if (r < 0.2f) {
                    return 1;
                }
                if (r < 0.35f) {
                    return 2;
                }
                if (r < 0.45f) {
                    return 3;
                }
                if (r < 0.55f) {
                    return 4;
                }
                if (r < 0.85f) {
                    return 8;
                }
                return 6;
            }
            float r = rng.m_188501_();
            if (r < 0.3f) {
                return 1;
            }
            if (r < 0.52f) {
                return 2;
            }
            if (r < 0.66f) {
                return 3;
            }
            if (r < 0.78f) {
                return 4;
            }
            if (r < 0.815f) {
                this.mimic.queuedFollowup = 7;
                return 5;
            }
            if (r < 0.995f) {
                return 6;
            }
            this.mimic.queuedFollowup = 0;
            return 5;
        }

        protected double m_6639_(LivingEntity target) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + target.m_20205_();
        }
    }
}

