/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.capability.boss.BeyondBossCapability;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.network.PlayerVariablesHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.items.BeyondArmorItems;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TempestSerpentBossEntity
extends Monster
implements IAnimatable,
IGiantMob {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(TempestSerpentBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;
    public LivingEntity constrictTarget;

    public TempestSerpentBossEntity(EntityType<? extends TempestSerpentBossEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21153_(this.m_21233_());
        this.f_21364_ = 100;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.trbeyond.tempest_serpent_boss"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7005_(true);
        this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
    }

    public Component m_5446_() {
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)Component.m_237115_((String)"entity.trbeyond.tempest_serpent_boss")).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return source == TensuraDamageSources.FATAL_POISON || source == TensuraDamageSources.CORROSION || source == DamageSource.f_19305_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || super.m_6673_(source);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public void m_6043_() {
    }

    public boolean cantBreakBlock(LivingEntity entity, boolean ignoreCollision) {
        Level level = entity.m_9236_();
        if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            return true;
        }
        return true;
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22288_, 1.5).m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 200.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 100.0).m_22268_(Attributes.f_22285_, 25.0).m_22268_(Attributes.f_22283_, 5.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get(), 2000.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new TempestSerpentBossAttackGoal(this, 1.5, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 40.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tempest_serpent.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tempest_serpent.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.tempest_serpent.bite"));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.tempest_serpent.tail_swipe"));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.tempest_serpent.constrict"));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.tempest_serpent.poison_cloud"));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "movement", 1.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attacks", 0.0f, this::miscPredicate));
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        this.bossEvent.m_7706_();
        Entity entity = cause.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BeyondBossCapability.getFrom(player).ifPresent(cap -> {
                int killedSerpent = cap.killedSerpent();
                cap.setKilledSerpent(killedSerpent + 1);
            });
            BeyondBossCapability.sync(player);
            player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                if (!capability.KilledSerpent) {
                    ItemStack slotItem;
                    int i;
                    int coinsRemaining = (Integer)ServerConfig.INSTANCE.bossConfig.tempestSerpentGoldDrop.get();
                    Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                    int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                    for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                        slotItem = player.m_150109_().m_8020_(i);
                        if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                        int spaceLeft = maxStackSize - slotItem.m_41613_();
                        int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                        slotItem.m_41769_(amountToAdd);
                        player.m_150109_().m_6836_(i, slotItem);
                        coinsRemaining -= amountToAdd;
                    }
                    if (coinsRemaining > 0) {
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (!slotItem.m_41619_()) continue;
                            int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                            ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                            player.m_150109_().m_6836_(i, newCoinStack);
                            coinsRemaining -= amountToAdd;
                        }
                    }
                    if (coinsRemaining > 0) {
                        while (coinsRemaining > 0) {
                            int dropAmount = Math.min(coinsRemaining, maxStackSize);
                            ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                            coinsRemaining -= dropAmount;
                        }
                    }
                    capability.KilledSerpent = true;
                    capability.syncPlayerVariables((Entity)player);
                }
                ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondArmorItems.SERPENT_HELMET_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.SERPENT_CHESTPLATE_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.SERPENT_LEGGINGS_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.SERPENT_BOOTS_UNIQUE.get())};
                EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                    if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                        ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                        if (!player.m_150109_().m_36054_(drop)) {
                            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                        }
                    }
                });
            });
        } else {
            TamableAnimal tame;
            LivingEntity onwer;
            LivingEntity attacker;
            entity = cause.m_7639_();
            if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) instanceof TamableAnimal && (onwer = (tame = (TamableAnimal)attacker).m_21826_()) instanceof Player) {
                Player player = (Player)onwer;
                player.getCapability(PlayerVariablesHandler.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    if (!capability.KilledSerpent) {
                        ItemStack slotItem;
                        int i;
                        int coinsRemaining = 20;
                        Item coinItem = (Item)TensuraMaterialItems.GOLD_COIN.get();
                        int maxStackSize = new ItemStack((ItemLike)coinItem).m_41741_();
                        for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                            slotItem = player.m_150109_().m_8020_(i);
                            if (slotItem.m_41619_() || !slotItem.m_150930_(coinItem) || slotItem.m_41613_() >= maxStackSize) continue;
                            int spaceLeft = maxStackSize - slotItem.m_41613_();
                            int amountToAdd = Math.min(spaceLeft, coinsRemaining);
                            slotItem.m_41769_(amountToAdd);
                            player.m_150109_().m_6836_(i, slotItem);
                            coinsRemaining -= amountToAdd;
                        }
                        if (coinsRemaining > 0) {
                            for (i = 0; i < 36 && coinsRemaining > 0; ++i) {
                                slotItem = player.m_150109_().m_8020_(i);
                                if (!slotItem.m_41619_()) continue;
                                int amountToAdd = Math.min(maxStackSize, coinsRemaining);
                                ItemStack newCoinStack = new ItemStack((ItemLike)coinItem, amountToAdd);
                                player.m_150109_().m_6836_(i, newCoinStack);
                                coinsRemaining -= amountToAdd;
                            }
                        }
                        if (coinsRemaining > 0) {
                            while (coinsRemaining > 0) {
                                int dropAmount = Math.min(coinsRemaining, maxStackSize);
                                ItemStack dropStack = new ItemStack((ItemLike)coinItem, dropAmount);
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dropStack));
                                coinsRemaining -= dropAmount;
                            }
                        }
                        capability.KilledSerpent = true;
                        capability.syncPlayerVariables((Entity)player);
                    }
                    ItemStack[] uniqueDrops = new ItemStack[]{new ItemStack((ItemLike)BeyondArmorItems.SERPENT_HELMET_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.SERPENT_CHESTPLATE_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.SERPENT_LEGGINGS_UNIQUE.get()), new ItemStack((ItemLike)BeyondArmorItems.SERPENT_BOOTS_UNIQUE.get())};
                    EliteMobCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                        if (this.f_19796_.m_188501_() < 0.05f || cap.isElite()) {
                            ItemStack drop = uniqueDrops[this.f_19796_.m_188503_(uniqueDrops.length)];
                            if (!player.m_150109_().m_36054_(drop)) {
                                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop));
                            }
                        }
                    });
                });
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_((SoundEvent)BeyondSoundEvents.tempest_serpent_movement.get(), 0.25f, 0.5f);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public boolean shouldAttack(LivingEntity target) {
        return target instanceof Player && ((Player)target).m_7500_();
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.m_6084_() && target != null && target.m_6084_() || this.getMiscAnimation() == 3 && this.constrictTarget != null && this.constrictTarget.m_6084_()) {
                if (this.getMiscAnimation() == 1) {
                    if (this.miscAnimationTicks == 15 && target != null && (double)this.m_20270_((Entity)target) < 4.0) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.tempest_serpent_bite.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 1.5f);
                    }
                } else if (this.getMiscAnimation() == 2) {
                    if (target != null && this.miscAnimationTicks == 13) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.tempest_serpent_tail_whip.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82377_(3.0, 1.0, 3.0))) {
                            if (!(entity instanceof LivingEntity)) continue;
                            LivingEntity ent = (LivingEntity)entity;
                            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                            ent.m_147240_(1.0, entity.m_20185_() - this.m_20185_(), entity.m_20189_() - this.m_20189_());
                        }
                    }
                } else if (this.getMiscAnimation() == 3) {
                    if (this.miscAnimationTicks == 1) {
                        if ((double)this.m_20270_((Entity)target) < 6.0) {
                            this.constrictTarget = target;
                        }
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.tempest_serpent_constrict.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (this.constrictTarget != null && this.constrictTarget.m_6084_()) {
                        if (this.miscAnimationTicks == 2 && this.constrictTarget != null && (double)this.m_20270_((Entity)this.constrictTarget) < 8.0) {
                            this.constrictTarget.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        }
                        if (this.miscAnimationTicks % 6 == 0 && this.constrictTarget != null && (double)this.m_20270_((Entity)this.constrictTarget) < 6.0) {
                            this.constrictTarget.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                            this.constrictTarget.m_20334_(0.0, this.constrictTarget.m_20184_().f_82480_, 0.0);
                            if (this.miscAnimationTicks % 24 == 0) {
                                this.constrictTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                                this.constrictTarget.m_20301_(0);
                            }
                        }
                    }
                    if (!(this.miscAnimationTicks < 60 || this.constrictTarget != null && this.constrictTarget.m_6084_())) {
                        this.miscAnimationTicks = 96;
                    }
                } else if (this.getMiscAnimation() == 4) {
                    if (this.miscAnimationTicks == 1) {
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BeyondSoundEvents.tempest_serpent_poison_cloud.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (this.miscAnimationTicks == 22) {
                        Vec3 endPos = target.m_20182_();
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                        Vec3 cloudPos = endPos.m_82520_(new Random().nextGaussian() * 0.5, new Random().nextGaussian() * 0.5 + 0.5, new Random().nextGaussian() * 0.5);
                        AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, cloudPos.f_82479_, cloudPos.f_82480_, cloudPos.f_82481_);
                        cloud.m_19712_(2.0f);
                        cloud.m_19740_(10);
                        cloud.m_19734_(200);
                        cloud.m_19738_(0.02f);
                        cloud.m_19716_(new MobEffectInstance((MobEffect)TensuraMobEffects.FATAL_POISON.get(), 100, 9));
                        cloud.m_19716_(new MobEffectInstance((MobEffect)TensuraMobEffects.CORROSION.get(), 100, 9));
                        cloud.m_19724_((ParticleOptions)TensuraParticles.POISON_EFFECT.get());
                        this.f_19853_.m_7967_((Entity)cloud);
                    }
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
            if (this.miscAnimationTicks % 40 == 0) {
                // empty if block
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        int var10000 = switch (miscAnimation) {
            case 1 -> 55;
            case 2 -> 56;
            case 3 -> 96;
            case 4 -> 120;
            default -> 12;
        };
        return var10000;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
        }
        return flag;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_21051_(Attributes.f_22288_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentJumpStrength.get()).doubleValue());
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentMaxHealth.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentAttackDamage.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentKnockbackResistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentArmor.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentArmorToughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22283_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentAttackSpeed.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentAttackKnockback.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentFollowRange.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentMovementSpeed.get()).doubleValue());
        this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()).m_22100_(((Double)ServerConfig.INSTANCE.bossConfig.tempestSerpentMaxSpiritualHealth.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        AttributeInstance spiritualHP = this.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        AttributeInstance maxHP = this.m_21051_(Attributes.f_22276_);
        double sHP = maxHP.m_22135_() * 2.0;
        if (spiritualHP != null) {
            spiritualHP.m_22100_(sHP);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)this, (double)sHP);
        }
        this.getPersistentData().m_128379_("isBoss", true);
        if (this.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)this);
            for (ManasSkill manasSkill : SkillAPI.getSkillRegistry()) {
                Optional existing;
                ResistSkill resist;
                if (!(manasSkill instanceof ResistSkill) || (resist = (ResistSkill)manasSkill).getResistType() != ResistSkill.ResistType.RESISTANCE || !(existing = storage.getSkill(manasSkill)).isEmpty()) continue;
                ManasSkillInstance instance = manasSkill.createDefaultInstance();
                storage.learnSkill(instance);
            }
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                ResistSkill resist;
                ManasSkill skill = instance.getSkill();
                if (!(skill instanceof ResistSkill) || (resist = (ResistSkill)skill).getResistType() != ResistSkill.ResistType.RESISTANCE) continue;
                instance.setMastery(0);
                instance.setToggled(true);
                storage.updateSkill(instance);
            }
        }
        return data;
    }

    class TempestSerpentBossAttackGoal
    extends MeleeAttackGoal {
        private final TempestSerpentBossEntity boss;

        public TempestSerpentBossAttackGoal(TempestSerpentBossEntity boss, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)boss, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.boss = boss;
        }

        public void m_8037_() {
            if (this.boss.getMiscAnimation() == 0) {
                super.m_8037_();
            }
        }

        protected void m_6739_(@NotNull LivingEntity pEnemy, double pDistToEnemySqr) {
            double reach = super.m_6639_(pEnemy);
            if (this.boss.getMiscAnimation() == 0 && pEnemy.m_6084_()) {
                int randomAttack = this.randomAttack(pDistToEnemySqr);
                if (randomAttack == 4) {
                    reach = 25.0;
                    this.boss.m_21573_().m_26573_();
                }
                if (pDistToEnemySqr <= reach && this.m_25564_()) {
                    this.m_25563_();
                    this.boss.setMiscAnimation(randomAttack);
                }
            }
        }

        protected int randomAttack(double distance) {
            return this.boss.f_19796_.m_188503_(100) < 5 ? 4 : (this.boss.f_19796_.m_188503_(100) < 2 ? 3 : (this.boss.f_19796_.m_188503_(100) < 20 ? 2 : 1));
        }
    }
}

