/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom.slime;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import io.github.Memoires.trbeyond.entity.custom.slime.SlimeDollEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BlueSlimeDollEntity
extends SlimeDollEntity
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public BlueSlimeDollEntity(EntityType<? extends BlueSlimeDollEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 4.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new BlueSlimeDollAttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{SlimeDollEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> !(entity instanceof SlimeDollEntity) && !entity.m_7307_((Entity)this)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 1 && this.miscAnimationTicks == 20) {
                this.setMelted(false);
            } else if (this.getMiscAnimation() == 2 && this.miscAnimationTicks == 20) {
                this.setMelted(true);
            }
            if (this.getMiscAnimation() == 3 && target != null) {
                if (this.miscAnimationTicks == 15 && (double)target.m_20270_((Entity)this) < this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get())) {
                    this.m_7327_((Entity)target);
                }
            } else if (this.getMiscAnimation() == 4 && this.miscAnimationTicks == 23) {
                AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()));
                List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !this.m_7307_((Entity)entity) && !entity.equals((Object)this));
                this.setMelted(false);
                if (!list.isEmpty()) {
                    for (LivingEntity entity2 : list) {
                        double damageMultiplier = 2.0;
                        entity2.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * damageMultiplier));
                        entity2.m_20184_().m_82520_(0.0, 0.5 * damageMultiplier, 0.0);
                        SkillHelper.knockBack((LivingEntity)this, (LivingEntity)entity2, (float)1.5f);
                    }
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        if (miscAnimation == 4) {
            return 40;
        }
        if (miscAnimation == 3) {
            return 25;
        }
        return 30;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.m_6084_()) {
            return;
        }
        if (this.m_20089_() == Pose.DYING) {
            this.setMiscAnimation(2);
        }
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 29) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setMiscAnimation(1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() != 0) {
            return PlayState.STOP;
        }
        if (this.isMelted()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.melt_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.spawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.melt", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.melted_slam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_blue.hammers", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class BlueSlimeDollAttackGoal
    extends MeleeAttackGoal {
        private final BlueSlimeDollEntity doll;

        public BlueSlimeDollAttackGoal() {
            super((PathfinderMob)BlueSlimeDollEntity.this, 2.0, true);
            this.doll = BlueSlimeDollEntity.this;
        }

        public boolean m_8036_() {
            if (this.doll.getMiscAnimation() == 1) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            if (!this.doll.isMelted()) {
                this.doll.setMiscAnimation(5);
            }
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0;
            if (this.doll.getMiscAnimation() != 0) {
                return;
            }
            int attack = this.getAttack(pDistToEnemySqr);
            double d = d0 = attack == 2 ? 400.0 : this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.doll.setMiscAnimation(attack);
            }
        }

        private int getAttack(double dist) {
            if (this.doll.isMelted()) {
                return 4;
            }
            if (this.doll.m_217043_().m_188501_() <= 0.3f && dist > 36.0) {
                return 2;
            }
            return 3;
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return super.m_6639_(pAttackTarget) + 9.0;
        }
    }
}

