/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom.slime;

import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.Memoires.trbeyond.entity.custom.slime.SlimeDollEntity;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GreenSlimeDollEntity
extends SlimeDollEntity
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> SUMMONED = SynchedEntityData.m_135353_(GreenSlimeDollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public GreenSlimeDollEntity(EntityType<? extends GreenSlimeDollEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 4.0).m_22265_();
    }

    public static AttributeSupplier setMinionAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 4.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new GreenSlimeDollAttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{SlimeDollEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> !(entity instanceof SlimeDollEntity) && !entity.m_7307_((Entity)this)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONED, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Summoned", this.isSummoned());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(SUMMONED, (Object)pCompound.m_128471_("Summoned"));
    }

    public boolean isSummoned() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONED);
    }

    public void setSummoned(boolean melted) {
        this.f_19804_.m_135381_(SUMMONED, (Object)melted);
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        return this.m_6095_() == BeyondEntities.GREEN_SLIME_DOLL_MINION.get() ? entitydimensions.m_20390_(0.5f, 0.53f) : entitydimensions;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            LivingEntity target = this.m_5448_();
            if (this.getMiscAnimation() == 3 && target != null) {
                if (this.miscAnimationTicks == 14 && (double)target.m_20270_((Entity)this) < this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get())) {
                    this.m_7327_((Entity)target);
                }
            } else if (this.getMiscAnimation() == 5) {
                this.m_21573_().m_26573_();
                if (this.miscAnimationTicks == 50) {
                    this.summonMinion(0, false);
                    this.summonMinion(1, true);
                    this.summonMinion(1, false);
                } else if (this.miscAnimationTicks == 69) {
                    this.summonMinion(1, true);
                    this.summonMinion(1, false);
                    this.setSummoned(true);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        if (miscAnimation == 1) {
            return 35;
        }
        if (miscAnimation == 5) {
            return 70;
        }
        return 25;
    }

    public void summonMinion(int multishotLevel, boolean negativeAngle) {
        GreenSlimeDollEntity doll = new GreenSlimeDollEntity((EntityType<? extends GreenSlimeDollEntity>)((EntityType)BeyondEntities.GREEN_SLIME_DOLL_MINION.get()), this.f_19853_);
        doll.setMiscAnimation(1);
        TensuraEPCapability.setLivingEP((LivingEntity)doll, (double)(TensuraEPCapability.getEP((LivingEntity)this) / 5.0));
        doll.m_6710_(this.m_5448_());
        doll.m_146884_(this.m_146892_());
        Vector3f vector3f = new Vector3f(this.m_20154_().m_82541_().m_82490_((double)0.3f));
        if (multishotLevel > 0) {
            vector3f.m_122251_(new Quaternion(new Vector3f(this.m_20289_(1.0f)), negativeAngle ? -10.0f * (float)multishotLevel : 10.0f * (float)multishotLevel, true));
        }
        doll.m_20334_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
        doll.f_19864_ = true;
        this.f_19853_.m_7967_((Entity)doll);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setMiscAnimation(1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() != 0) {
            return PlayState.STOP;
        }
        if (this.m_21660_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_red.walk_spear", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_red.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_red.spawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_red.slash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_green.split", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class GreenSlimeDollAttackGoal
    extends MeleeAttackGoal {
        private final GreenSlimeDollEntity doll;

        public GreenSlimeDollAttackGoal() {
            super((PathfinderMob)GreenSlimeDollEntity.this, 2.0, true);
            this.doll = GreenSlimeDollEntity.this;
        }

        public boolean m_8036_() {
            if (this.doll.getMiscAnimation() == 1) {
                return false;
            }
            return super.m_8036_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (this.doll.getMiscAnimation() != 0) {
                return;
            }
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.doll.setMiscAnimation(3);
            }
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.doll.m_6095_() != BeyondEntities.GREEN_SLIME_DOLL_MINION.get() && !this.doll.isSummoned()) {
                this.doll.setMiscAnimation(5);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.doll.isMelted()) {
                this.doll.setMiscAnimation(1);
            }
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return super.m_6639_(pAttackTarget) + 9.0;
        }
    }
}

