/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.custom.slime;

import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import io.github.Memoires.trbeyond.entity.custom.slime.SlimeDollEntity;
import io.github.Memoires.trbeyond.items.armor.SerpentArmorItem;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class YellowSlimeDollEntity
extends SlimeDollEntity
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public YellowSlimeDollEntity(EntityType<? extends YellowSlimeDollEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new YellowSlimeDollAttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{SlimeDollEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> !(entity instanceof SlimeDollEntity) && !entity.m_7307_((Entity)this)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7332_(Entity passenger) {
        passenger.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack slotStack = living.m_6844_(slot);
                if (slotStack.m_41720_() instanceof SerpentArmorItem) continue;
                slotStack.m_41622_(5, living, player -> player.m_21166_(slot));
            }
        }
        return flag;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 1 && this.miscAnimationTicks == 20) {
                this.setMelted(false);
            } else if (this.getMiscAnimation() == 2 && this.miscAnimationTicks == 20) {
                this.setMelted(true);
            } else if (this.getMiscAnimation() == 5 && (target == null || target.m_20270_((Entity)this) > 3.0f)) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
            if (target != null) {
                if (this.getMiscAnimation() == 3) {
                    if (target.m_20270_((Entity)this) < 3.0f) {
                        if (this.isMelted()) {
                            if (this.miscAnimationTicks == 34) {
                                target.m_19877_();
                                target.m_7998_((Entity)this, true);
                                this.setMelted(false);
                            }
                        } else if (this.miscAnimationTicks == 19) {
                            target.m_19877_();
                            target.m_7998_((Entity)this, true);
                            this.setMelted(false);
                        }
                    }
                } else if (this.getMiscAnimation() == 4 && target.m_20202_() == this && this.miscAnimationTicks == 19) {
                    this.setMelted(false);
                    this.setMiscAnimation(5);
                    this.miscAnimationTicks = 0;
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        if (miscAnimation == 5) {
            return 1200;
        }
        if (miscAnimation == 4) {
            return 20;
        }
        if (miscAnimation == 3) {
            return this.isMelted() ? 35 : 20;
        }
        return 30;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.m_6084_()) {
            return;
        }
        if (this.m_20089_() == Pose.DYING) {
            this.setMiscAnimation(2);
        }
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 29) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setMiscAnimation(1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 5) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.encasing", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.getMiscAnimation() != 0) {
            return PlayState.STOP;
        }
        if (this.m_146895_() != null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.grabbing", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isMelted()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.melt_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.spawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.melt", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                if (this.isMelted()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.melted_grab", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.grab", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.slime_yellow.encase_player", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class YellowSlimeDollAttackGoal
    extends MeleeAttackGoal {
        private final YellowSlimeDollEntity doll;

        public YellowSlimeDollAttackGoal() {
            super((PathfinderMob)YellowSlimeDollEntity.this, 2.0, true);
            this.doll = YellowSlimeDollEntity.this;
        }

        public boolean m_8036_() {
            if (this.doll.getMiscAnimation() == 1) {
                return false;
            }
            return super.m_8036_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (this.doll.getMiscAnimation() != 0 && this.doll.getMiscAnimation() != 5) {
                return;
            }
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)pEnemy);
                if (this.doll.getMiscAnimation() != 5) {
                    if (pEnemy.m_20202_() == this.f_25540_) {
                        this.doll.setMiscAnimation(4);
                    } else {
                        this.doll.setMiscAnimation(3);
                    }
                }
            }
        }

        public void m_8056_() {
            super.m_8056_();
            if (!this.doll.isMelted()) {
                this.doll.setMiscAnimation(2);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.doll.isMelted()) {
                this.doll.setMiscAnimation(1);
            }
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return super.m_6639_(pAttackTarget) + 4.0;
        }
    }
}

