/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.misc;

import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.controller.JumpingEntityMoveControl;
import com.github.manasmods.tensura.api.entity.navigator.StraightFlightNavigator;
import com.github.manasmods.tensura.api.entity.subclass.IJumpingEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.mojang.math.Vector3f;
import io.github.Memoires.trbeyond.block.DungeonChestBlock;
import io.github.Memoires.trbeyond.util.BeyondDamageSources;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MimicChestEntity
extends TensuraTamableEntity
implements IJumpingEntity,
IAnimatable {
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final boolean golden;

    public MimicChestEntity(EntityType<? extends MimicChestEntity> pEntityType, Level pLevel, boolean golden) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
        this.f_21365_ = new MimicLookControl((Mob)this);
        this.f_21342_ = new JumpingEntityMoveControl((PathfinderMob)this);
        this.f_21344_ = new StraightFlightNavigator((Mob)this, pLevel);
        this.golden = golden;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 2.0, 20.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 2.0));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new MimicAttackGoal((PathfinderMob)this, 2.0, true, 2.0f));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((MimicChestEntity)this).m_21674_(arg_0)));
    }

    public Vec3 m_20184_() {
        if (this.m_21660_()) {
            return super.m_20184_();
        }
        return Vec3.f_82478_;
    }

    public void m_20256_(Vec3 pMotion) {
        if (this.m_21660_()) {
            super.m_20256_(pMotion);
        }
    }

    public int m_8132_() {
        if (this.m_21660_()) {
            return super.m_8132_();
        }
        return 180;
    }

    public int m_8085_() {
        if (this.m_21660_()) {
            return super.m_8085_();
        }
        return 180;
    }

    protected float m_6118_() {
        if (this.f_19862_) {
            return 0.6f;
        }
        if (this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5) {
            return 0.6f;
        }
        Path path = this.f_21344_.m_26570_();
        if (path != null && !path.m_77392_()) {
            Vec3 vec3 = path.m_77380_((Entity)this);
            if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                return 0.6f;
            }
        }
        return this.f_21342_.m_24999_() <= 0.6 ? 0.3f : 0.4f;
    }

    protected void m_6135_() {
        double d1;
        if (this.m_21827_()) {
            return;
        }
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float pPartialTick) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + pPartialTick) / (float)this.jumpDuration;
    }

    public void m_6862_(boolean pJumping) {
        super.m_6862_(pJumping);
        if (!pJumping) {
            return;
        }
        this.m_5496_(this.getJumpSound(), this.getJumpSoundVolume(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void m_8024_() {
        if (this.getJumpDelay() > 0) {
            --this.jumpDelayTicks;
        }
        if (this.f_19861_) {
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.jumpDelayTicks = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
            }
            if (this.getJumpDelay() == 0) {
                if (this.setWantedTarget((PathfinderMob)this, 25.0)) {
                    LivingEntity livingentity = this.m_5448_();
                    assert (livingentity != null);
                    this.facePoint(livingentity.m_20185_(), livingentity.m_20189_());
                    this.startJumping();
                } else if (this.setWantedOwner((TamableAnimal)this, 25.0)) {
                    LivingEntity owner = this.m_21826_();
                    assert (owner != null);
                    this.facePoint(owner.m_20185_(), owner.m_20189_());
                    this.startJumping();
                }
            }
        }
        this.wasOnGround = this.f_19861_;
    }

    public boolean m_5843_() {
        return false;
    }

    private void facePoint(double pX, double pZ) {
        this.m_146922_((float)(Mth.m_14136_((double)(pZ - this.m_20189_()), (double)(pX - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        if (this.m_21660_()) {
            super.m_6453_(pX, pY, pZ, pYaw, pPitch, pPosRotationIncrements, pTeleport);
            return;
        }
        this.f_20903_ = 0;
        this.m_6034_(pX, pY, pZ);
        this.m_19915_(pYaw, pPitch);
    }

    public int getJumpDelay() {
        return this.jumpDelayTicks;
    }

    public void setJumpAnimation(boolean jump) {
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_5829_() {
        if (this.m_21660_()) {
            return super.m_5829_();
        }
        return this.m_6084_();
    }

    public boolean m_6673_(DamageSource pSource) {
        if (super.m_6673_(pSource)) {
            return true;
        }
        if (pSource.equals(BeyondDamageSources.PARALYSIS)) {
            return true;
        }
        return pSource.m_19372_();
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        if (pEffectInstance.m_19544_().equals(TensuraMobEffects.PARALYSIS.get())) {
            return false;
        }
        return super.m_7301_(pEffectInstance);
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.f_20883_ = 0.0f;
        this.f_20884_ = 0.0f;
    }

    public SoundEvent getJumpSound() {
        return SoundEvents.f_11748_;
    }

    public float getJumpSoundVolume() {
        return this.m_6121_();
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11749_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11747_;
    }

    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void m_7822_(byte pId) {
        if (pId == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(pId);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (!super.m_6071_(player, hand).m_19077_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
                this.commanding(player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            this.m_6710_((LivingEntity)player);
            for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(10.0))) {
                if (!(entity instanceof MimicChestEntity)) continue;
                MimicChestEntity mimic = (MimicChestEntity)entity;
                mimic.m_6710_((LivingEntity)player);
            }
            for (int x = -10; x < 10; ++x) {
                for (int y = -10; y < 10; ++y) {
                    for (int z = -10; z < 10; ++z) {
                        DungeonChestBlock chest;
                        Block block = this.f_19853_.m_8055_(this.m_20183_().m_7918_(x, y, z)).m_60734_();
                        if (!(block instanceof DungeonChestBlock) || (chest = (DungeonChestBlock)block).getType() != DungeonChestBlock.DungeonChestType.MIMIC) continue;
                        DungeonChestBlock.spawnMimic(this.f_19853_, this.m_20183_().m_7918_(x, y, z), player, this.f_19853_.m_8055_(this.m_20183_().m_7918_(x, y, z)));
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_146922_(0.0f);
        this.f_20885_ = this.m_146908_();
        this.m_146867_();
        if (!this.getPersistentData().m_128441_("respawn")) {
            this.getPersistentData().m_128379_("respawn", true);
        }
        this.getPersistentData().m_128347_("initialPosX", this.m_20185_());
        this.getPersistentData().m_128347_("initialPosY", this.m_20186_());
        this.getPersistentData().m_128347_("initialPosZ", this.m_20189_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21660_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.hop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.hidden", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isGolden() {
        return this.golden;
    }

    class MimicLookControl
    extends LookControl {
        public MimicLookControl(Mob pMob) {
            super(pMob);
        }

        protected void m_142586_() {
            if (MimicChestEntity.this.m_21660_()) {
                super.m_142586_();
            }
        }

        protected Optional<Float> m_180896_() {
            if (MimicChestEntity.this.m_21660_()) {
                return super.m_180896_();
            }
            Direction direction = Direction.DOWN;
            Vector3f vector3f = (Vector3f)Util.m_137537_(() -> {
                Vec3i vec3i = Direction.SOUTH.m_122436_();
                return new Vector3f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_());
            });
            vector3f.m_122251_(direction.m_122406_());
            Vec3i vec3i = direction.m_122436_();
            Vector3f vector3f1 = new Vector3f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_());
            vector3f1.m_122279_(vector3f);
            double d0 = this.f_24941_ - this.f_24937_.m_20185_();
            double d1 = this.f_24942_ - this.f_24937_.m_20188_();
            double d2 = this.f_24943_ - this.f_24937_.m_20189_();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f = vector3f1.m_122276_(vector3f2);
            float f1 = vector3f.m_122276_(vector3f2);
            return !(Math.abs(f) > 1.0E-5f) && !(Math.abs(f1) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(Mth.m_14136_((double)(-f), (double)f1) * 57.2957763671875)));
        }

        protected Optional<Float> m_180897_() {
            if (MimicChestEntity.this.m_21660_()) {
                return super.m_180897_();
            }
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    public static class MimicAttackGoal
    extends MeleeAttackGoal {
        float range;

        public MimicAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, float additionalRange) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.range = additionalRange;
        }

        protected double m_6639_(@NotNull LivingEntity pAttackTarget) {
            return (double)this.range + super.m_6639_(pAttackTarget);
        }
    }
}

