/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.misc;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PrimedDungeonChestEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(PrimedDungeonChestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> SOURCE_ITEM = SynchedEntityData.m_135353_(PrimedDungeonChestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Direction> SPAWN_DIRECTION = SynchedEntityData.m_135353_(PrimedDungeonChestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);

    public PrimedDungeonChestEntity(EntityType<? extends PrimedDungeonChestEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public PrimedDungeonChestEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends PrimedDungeonChestEntity>)((EntityType)BeyondEntities.PRIMED_CHEST.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
        this.unstableJump();
        this.setFuse(50);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    private void unstableJump() {
        double d0 = this.f_19853_.f_46441_.m_188500_() * Math.PI * 2.0;
        this.m_20334_(-Math.sin(d0) * 0.1, 0.3f, -Math.cos(d0) * 0.1);
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.unstableJump();
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (i % 10 != 0) {
                return;
            }
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123762_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123755_);
        }
    }

    protected void explode() {
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 12.0f, this.f_19853_.m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY ? Explosion.BlockInteraction.NONE : Explosion.BlockInteraction.DESTROY);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123812_, (double)4.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123762_, (double)4.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123747_, (double)4.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123747_, (double)3.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.SOLAR_FLASH.get()), (double)3.0);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
        this.f_19804_.m_135372_(SPAWN_DIRECTION, (Object)Direction.EAST);
        this.f_19804_.m_135372_(SOURCE_ITEM, (Object)((Block)BeyondBlocks.GOLD_CHEST.get()).m_5456_().m_7968_());
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128376_("Fuse", (short)this.getFuse());
        pCompound.m_128405_("Direction", this.m_6350_().m_122411_());
        if (pCompound.m_128425_("Source Item", 10)) {
            this.setSourceItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Source Item")));
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.setFuse(pCompound.m_128448_("Fuse"));
        this.setSpawnDirection(Direction.m_122376_((int)pCompound.m_128451_("Direction")));
        pCompound.m_128365_("Source Item", (Tag)this.getSourceItem().m_41739_(new CompoundTag()));
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return 0.15f;
    }

    public void setFuse(int pLife) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)pLife);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public void setSpawnDirection(Direction pLife) {
        this.f_19804_.m_135381_(SPAWN_DIRECTION, (Object)pLife);
    }

    public Direction getSpawnDirection() {
        return (Direction)this.f_19804_.m_135370_(SPAWN_DIRECTION);
    }

    public ItemStack getSourceItem() {
        return (ItemStack)this.f_19804_.m_135370_(SOURCE_ITEM);
    }

    public void setSourceItem(ItemStack pStack) {
        this.f_19804_.m_135381_(SOURCE_ITEM, (Object)pStack);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }
}

