/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.projectile;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.registry.effects.BeyondEffects;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChaosEaterProjectile
extends AbstractArrow {
    private int lifetime = 0;
    private static final float BASE_DAMAGE = 50.0f;
    private LivingEntity currentTarget;
    private float health = 200.0f;

    public ChaosEaterProjectile(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public ChaosEaterProjectile(Level pLevel, Vec3 pos) {
        super((EntityType)BeyondEntities.CHAOS_EATER.get(), pLevel);
        this.m_146884_(pos);
        this.m_20242_(true);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            try {
                this.calculateLifetime();
                AABB area = new AABB(this.m_20182_().m_82492_(20.0, 20.0, 20.0), this.m_20182_().m_82520_(20.0, 20.0, 20.0));
                List targets = this.f_19853_.m_6443_(LivingEntity.class, area, entity -> true);
                targets.sort(Comparator.comparingDouble(entity -> entity.m_20238_(this.m_20182_())));
                LivingEntity currentTarget = (LivingEntity)targets.get(0);
                Vec3 direction = !currentTarget.m_5833_() && currentTarget.m_6084_() && currentTarget != this.m_37282_() && this.hasLineOfSight((Entity)currentTarget) ? currentTarget.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82546_(this.m_20182_()).m_82541_() : this.m_20184_().m_82541_();
                Vec3 currentVelocity = this.m_20184_();
                Vec3 newVelocity = currentVelocity.m_82549_(direction.m_82490_(0.4)).m_82541_().m_82490_(0.5);
                this.m_20256_(newVelocity);
                this.f_19812_ = true;
                double dx = direction.f_82479_;
                double dy = direction.f_82480_;
                double dz = direction.f_82481_;
                float yaw = (float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232);
                float pitch = (float)(Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232);
                this.m_146922_(yaw);
                this.m_146926_(pitch);
                this.f_19859_ = yaw;
                this.f_19860_ = pitch;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        if (entity == null || this.f_19853_.f_46443_) {
            return;
        }
        Entity owner = this.m_37282_();
        if (owner != null) {
            entity.m_6469_(DamageSource.m_19346_((AbstractArrow)this, (Entity)owner), 50.0f);
        } else {
            entity.m_6469_(DamageSource.m_19346_((AbstractArrow)this, (Entity)this), 50.0f);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            if (owner instanceof LivingEntity) {
                MobEffect burdenEffect;
                LivingEntity livingOwner = (LivingEntity)owner;
                livingTarget.m_6469_(TensuraDamageSources.corrosion((Entity)livingOwner), 50.0f);
                DamageSourceHelper.directSpiritualHurt((LivingEntity)livingTarget, (Entity)livingOwner, (float)50.0f, (float)0.0f);
                MobEffect rotEffect = (MobEffect)BeyondEffects.ROT.get();
                if (rotEffect != null) {
                    SkillHelper.checkThenAddEffectSource((LivingEntity)livingTarget, (Entity)livingOwner, (MobEffect)((MobEffect)BeyondEffects.ROT.get()), (int)1200, (int)0, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
                }
                ItemStack mainHandItem = livingOwner.m_21205_();
                if ((EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BeyondEnchantments.LAND_INFUSION.get()), (ItemStack)mainHandItem) > 0 || EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BeyondEnchantments.EARTH_INFUSION.get()), (ItemStack)mainHandItem) > 0) && (burdenEffect = (MobEffect)TensuraMobEffects.BURDEN.get()) != null) {
                    SkillHelper.checkThenAddEffectSource((LivingEntity)livingTarget, (Entity)livingOwner, (MobEffect)((MobEffect)TensuraMobEffects.BURDEN.get()), (int)1200, (int)2, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
                }
                EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)livingOwner);
                EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingTarget);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (DamageSourceHelper.isPhysicalAttack((DamageSource)source) && !ChaosEaterProjectile.canBypassPhysical(source)) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.damageProjectile(amount);
        return true;
    }

    private void calculateLifetime() {
        if (++this.lifetime >= 120) {
            this.m_146870_();
        }
    }

    private void damageProjectile(float amount) {
        this.health -= amount;
        if (this.health <= 0.0f) {
            this.m_146870_();
        }
    }

    public boolean hasLineOfSight(Entity pEntity) {
        Vec3 vec31;
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(vec3, vec31 = new Vec3(pEntity.m_20185_(), pEntity.m_20188_(), pEntity.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    private static boolean canBypassPhysical(DamageSource source) {
        Entity srcEnt = source.m_7639_();
        if (srcEnt instanceof LivingEntity) {
            TensuraDamageSource tens;
            LivingEntity living = (LivingEntity)srcEnt;
            if (living.m_21023_((MobEffect)TensuraMobEffects.HAKI_COAT.get())) {
                return true;
            }
            if (living.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                return true;
            }
            MobEffectInstance sev = living.m_21124_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get());
            if (sev != null && sev.m_19564_() >= 4) {
                return true;
            }
            if (source instanceof TensuraDamageSource && (tens = (TensuraDamageSource)source).getIgnoreResistance() == 1.0f) {
                return true;
            }
            return SkillUtils.reducingResistances((LivingEntity)living);
        }
        return false;
    }
}

