/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.entity.projectile;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GlendaBulletProjectile
extends TensuraProjectile {
    @Nullable
    protected DamageSource damageSource;
    @Nullable
    protected Entity target;

    public GlendaBulletProjectile(EntityType<? extends GlendaBulletProjectile> entityType, Level level) {
        super(entityType, level);
        this.setSize(0.25f);
    }

    public GlendaBulletProjectile(Level pLevel, LivingEntity shooter) {
        super((EntityType)BeyondEntities.GLENDA_BULLET.get(), pLevel);
        this.m_5602_((Entity)shooter);
    }

    public GlendaBulletProjectile(Level pLevel, LivingEntity shooter, boolean right) {
        super((EntityType)BeyondEntities.GLENDA_BULLET.get(), pLevel);
        this.m_5602_((Entity)shooter);
        this.setSize(0.25f);
        float rot = shooter.f_20885_ + (float)(right ? 60 : -60);
        this.m_6034_(shooter.m_20185_() - (double)shooter.m_20205_() * 0.5 * (double)Mth.m_14031_((float)(rot * ((float)Math.PI / 180))), shooter.m_20188_() - (double)0.2f, shooter.m_20189_() + (double)shooter.m_20205_() * 0.5 * (double)Mth.m_14089_((float)(rot * ((float)Math.PI / 180))));
    }

    public boolean shouldDiscardInWater() {
        return false;
    }

    public boolean shouldDiscardInLava() {
        return false;
    }

    protected void dealDamage(Entity target) {
        if (!(this.damage <= 0.0f) && target != this.m_37282_()) {
            DamageSource source = TensuraDamageSources.shot((Projectile)this, (Entity)this.m_37282_());
            if (this.damageSource != null) {
                source = this.damageSource;
            }
            if (!target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost((DamageSource)source, (double)this.getMpCost(), (ManasSkillInstance)this.getSkill()), this.getDamage())) {
                this.m_146870_();
            }
        }
    }

    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_12018_);
    }

    public void hitParticles(double x, double y, double z) {
    }

    public void flyingParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_().m_82490_(2.0));
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
    }

    @Nullable
    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public void setDamageSource(@Nullable DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    @Nullable
    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
    }
}

