/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import io.github.Memoires.trbeyond.data.BeyondTags;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.entity.custom.EvilCentipedeBossEntity;
import io.github.Memoires.trbeyond.entity.custom.GozulEntity;
import io.github.Memoires.trbeyond.entity.custom.MezulEntity;
import io.github.Memoires.trbeyond.entity.custom.OgreLordEntity;
import io.github.Memoires.trbeyond.entity.custom.TempestSerpentBossEntity;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.List;
import java.util.Random;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trbeyond")
public class BeyondBossHandler {
    @SubscribeEvent
    public static void applyPresenceSence(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_6095_().getTags().toList().contains(BeyondTags.DUNGEON_BOSS)) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 720000, 10, false, false, false));
        }
    }

    @SubscribeEvent
    public static void setEp(LivingSpawnEvent event) {
        Mob entity = event.getEntity();
        Random random = new Random();
        if (entity instanceof EvilCentipedeBossEntity) {
            int min = 80000;
            int max = 90000;
            double ep = random.nextDouble(min, max);
            TensuraEPCapability.setLivingEP((LivingEntity)entity, (double)ep);
            TensuraEPCapability.setCurrentLivingEP((LivingEntity)entity, (double)TensuraEPCapability.getEP((LivingEntity)entity));
            TensuraEPCapability.sync((LivingEntity)entity);
        } else if (entity instanceof GozulEntity || entity instanceof MezulEntity) {
            TensuraEPCapability.setLivingEP((LivingEntity)entity, (double)130000.0);
            TensuraEPCapability.setCurrentLivingEP((LivingEntity)entity, (double)TensuraEPCapability.getEP((LivingEntity)entity));
            TensuraEPCapability.sync((LivingEntity)entity);
            SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)((ManasSkill)ExtraSkills.ULTRASPEED_REGENERATION.get()));
            ManasSkillInstance instance = SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)((ManasSkill)ExtraSkills.ULTRASPEED_REGENERATION.get()));
            if (instance != null && instance.canBeToggled((LivingEntity)entity)) {
                instance.setToggled(true);
            }
        } else if (entity instanceof TempestSerpentBossEntity) {
            int min = 90000;
            int max = 100000;
            double ep = random.nextDouble(min, max);
            TensuraEPCapability.setLivingEP((LivingEntity)entity, (double)ep);
            TensuraEPCapability.setCurrentLivingEP((LivingEntity)entity, (double)TensuraEPCapability.getEP((LivingEntity)entity));
            TensuraEPCapability.sync((LivingEntity)entity);
        } else if (entity instanceof OgreLordEntity) {
            TensuraEPCapability.setLivingEP((LivingEntity)entity, (double)50000.0);
            TensuraEPCapability.setCurrentLivingEP((LivingEntity)entity, (double)TensuraEPCapability.getEP((LivingEntity)entity));
            TensuraEPCapability.sync((LivingEntity)entity);
            SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)((ManasSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get()));
            ManasSkillInstance instance = SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)((ManasSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get()));
            if (instance != null && instance.canBeToggled((LivingEntity)entity)) {
                instance.setToggled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity target;
        LivingEntity boss;
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE) && attacker instanceof LivingEntity && ((boss = (LivingEntity)attacker) instanceof BossBlackSpiderEntity || boss instanceof EvilCentipedeBossEntity || boss instanceof TempestSerpentBossEntity || boss instanceof GozulEntity || boss instanceof MezulEntity || boss instanceof OgreLordEntity) && (target = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = target;
            SkillHelper.addEffectWithSource((LivingEntity)livingEntity, (LivingEntity)boss, (MobEffect)((MobEffect)TensuraMobEffects.ANTI_SKILL.get()), (int)10, (int)0);
        }
    }

    public static boolean isBoss(LivingEntity entity) {
        return entity instanceof EvilCentipedeBossEntity || entity instanceof TempestSerpentBossEntity || entity instanceof BossBlackSpiderEntity || entity instanceof GozulEntity || entity instanceof MezulEntity || entity instanceof OgreLordEntity;
    }

    public static boolean isBossUnique(LivingEntity entity) {
        return entity instanceof EvilCentipedeBossEntity || entity instanceof TempestSerpentBossEntity || entity instanceof GozulEntity || entity instanceof MezulEntity || entity instanceof OgreLordEntity;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            if (player == null) {
                return;
            }
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            if (player.f_19853_.m_46469_().m_46207_(BeyondGamerules.NIGHTMARE_MODE)) {
                List nearbyEntities = player.f_19853_.m_45933_((Entity)player, new AABB(player.m_20185_() - 30.0, player.m_20186_() - 30.0, player.m_20189_() - 30.0, player.m_20185_() + 30.0, player.m_20186_() + 30.0, player.m_20189_() + 30.0));
                for (Entity entity : nearbyEntities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || !BeyondBossHandler.isBoss(livingEntity = (LivingEntity)entity)) continue;
                    if (player.m_150110_().f_35936_) {
                        player.m_150110_().f_35936_ = false;
                        player.m_150110_().f_35935_ = false;
                        player.m_6885_();
                    }
                    SkillHelper.checkThenAddEffectSource((LivingEntity)player, (Entity)livingEntity, (MobEffect)((MobEffect)TensuraMobEffects.ANTI_SKILL.get()), (int)3, (int)0, (boolean)true, (boolean)true, (boolean)true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityBreaks(LivingDestroyBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        event.setCanceled(true);
    }
}

