/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.data.pack.EntityEPCount;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.handler.EntityEPHandler;
import com.github.manasmods.tensura.menu.RaceSelectionMenu;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.data.BeyondTags;
import io.github.Memoires.trbeyond.entity.custom.DryadEntity;
import io.github.Memoires.trbeyond.entity.custom.GuildLadyEntity;
import io.github.Memoires.trbeyond.entity.custom.KaijinEntity;
import io.github.Memoires.trbeyond.entity.custom.KaoruEntity;
import io.github.Memoires.trbeyond.entity.custom.KobyEntity;
import io.github.Memoires.trbeyond.entity.custom.MjollmileEntity;
import io.github.Memoires.trbeyond.handlers.BeyondBossHandler;
import io.github.Memoires.trbeyond.handlers.ChallengeEventHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BeyondEntityEPHandler
extends EntityEPHandler {
    private static final String[] UNIQUE_SKILL = new String[]{"OBSERVER", "REAPER", "SEER", "FIGHTER", "SHADOW_STRIKER", "SNIPER", "SURVIVOR", "TUNER", "GOURMAND", "ANTI_SKILL", "CHOSEN_ONE", "COMMANDER", "COOK", "ENGORGER", "GUARDIAN", "MARTIAL_MASTER", "MATHEMATICIAN"};
    private static final String[] EXTRA_SKILL = new String[]{"ALL_SEEING_EYE", "STRENGTHEN_BODY", "STEEL_STRENGTH", "BLACK_FLAME", "ULTRA_INSTINCT", "HEAVENLY_EYE", "MAGIC_JAMMING", "ULTRA_REGENERATION"};
    private static final Map<String, RegistryObject<? extends Skill>> UNIQUE_SKILL_MAP = new HashMap<String, RegistryObject<? extends Skill>>();
    private static final Map<String, RegistryObject<? extends Skill>> EXTRA_SKILL_MAP;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        TamableAnimal tame;
        LivingEntity owner;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!living.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY) && !BeyondGamerules.getBoolean(entity.m_9236_(), BeyondGamerules.UNIQUE_OVERWORLD)) {
            return;
        }
        if (entity instanceof CloneEntity) {
            return;
        }
        if (living instanceof TamableAnimal && (owner = (tame = (TamableAnimal)living).m_21826_()) != null) {
            return;
        }
        if (living.m_6095_().m_204039_(BeyondTags.NOT_ELITE) || living instanceof Player) {
            return;
        }
        if (!BeyondBossHandler.isBossUnique(living)) {
            int chancePercent = living.m_9236_().m_46469_().m_46215_(BeyondGamerules.UNIQUE_MONSTER_CHANCE);
            float chance = (float)chancePercent / 1000.0f;
            if (living.m_217043_().m_188501_() > chance && !living.getPersistentData().m_128441_("spawnElite") && !living.getPersistentData().m_128441_("challengeElite")) {
                return;
            }
        }
        TensuraEPCapability.getFrom((LivingEntity)living).ifPresent(cap -> EliteMobCapability.getFrom(living).ifPresent(cap1 -> {
            if (!cap1.isElite()) {
                cap1.setElite(true);
                EliteMobCapability.sync(living);
                BeyondEntityEPHandler.applyRandomSkillLogic(living);
                double energy = 0.0;
                boolean epSet = false;
                for (EntityEPCount entityEP : TensuraData.getEntityEP()) {
                    AttributeInstance aura;
                    if (!entityEP.getEntity().equals((Object)EntityType.m_20613_((EntityType)living.m_6095_()))) continue;
                    int minEP = entityEP.getMinEP();
                    int maxEP = Math.max(minEP + 1, entityEP.getMaxEP() + 1);
                    double randomEP = living.m_217043_().m_216339_(0, maxEP - minEP);
                    AttributeInstance magicule = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    if (magicule != null) {
                        magicule.m_22100_((double)minEP / 2.0);
                        randomEP += magicule.m_22135_();
                    }
                    if ((aura = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) != null) {
                        aura.m_22100_((double)minEP / 2.0);
                        randomEP += aura.m_22135_();
                    }
                    cap.setEP(living, randomEP);
                    energy = randomEP;
                    epSet = true;
                    for (ResourceLocation skillID : entityEP.getSkills()) {
                        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillID);
                        if (skill == null) continue;
                        TensuraSkillInstance instance = new TensuraSkillInstance(skill);
                        SkillAPI.getSkillsFrom((Entity)living).learnSkill((ManasSkillInstance)instance);
                        if (!instance.canBeToggled(living)) continue;
                        instance.setToggled(true);
                    }
                    RaceSelectionMenu.grantLearningResistance((LivingEntity)living);
                    break;
                }
                if (!epSet || cap.getEP() <= 0.0) {
                    AttributeInstance aura;
                    energy = 100.0f * living.m_21233_();
                    AttributeInstance magicule = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    if (magicule != null) {
                        energy += magicule.m_22135_();
                    }
                    if ((aura = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) != null) {
                        energy += aura.m_22135_();
                    }
                    cap.setEP(living, energy);
                }
                if (living.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
                    cap.setMajin(true);
                }
                BeyondEntityEPHandler.applyEPToEntity(living, cap.getEP(), true);
                TensuraEPCapability.sync((LivingEntity)living);
            }
        }));
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (event.player.f_19797_ % 600 != 0) {
            return;
        }
        Player entity = event.player;
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            BlockPos spawnPos;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.m_217043_().m_188501_() < 0.005f && (spawnPos = BeyondEntityEPHandler.findSafeSpawnPos((Level)serverLevel, entity.m_20183_(), 50)) != null) {
                EntityType minhSlimeType = (EntityType)BeyondEntities.MINH_SLIME.get();
                minhSlimeType.m_20592_(serverLevel, null, null, spawnPos, MobSpawnType.EVENT, true, false);
            }
        }
    }

    private static BlockPos findSafeSpawnPos(Level level, BlockPos center, int radius) {
        int y = center.m_123342_();
        if (y > 115) {
            return null;
        }
        for (int attempts = 0; attempts < 20; ++attempts) {
            int z;
            int x = center.m_123341_() + ChallengeEventHandler.getRandomInRange(-radius, radius);
            BlockPos pos = new BlockPos(x, y, z = center.m_123343_() + ChallengeEventHandler.getRandomInRange(-radius, radius));
            boolean clear = level.m_46859_(pos) && level.m_46859_(pos.m_7494_());
            boolean solidBlock = level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos.m_7495_());
            if (!clear || !solidBlock) continue;
            return pos;
        }
        return null;
    }

    private static void applyRandomSkillLogic(LivingEntity living) {
        TensuraEPCapability.getFrom((LivingEntity)living).ifPresent(cap -> {
            BeyondEntityEPHandler.assignRandomSkill(living, UNIQUE_SKILL_MAP, UNIQUE_SKILL);
            BeyondEntityEPHandler.assignRandomSkill(living, EXTRA_SKILL_MAP, EXTRA_SKILL);
        });
    }

    private static void assignRandomSkill(LivingEntity living, Map<String, RegistryObject<? extends Skill>> skillMap, String[] skillArray) {
        String randomSkill = skillArray[new Random().nextInt(skillArray.length)];
        RegistryObject<? extends Skill> skillRegistryObject = skillMap.get(randomSkill);
        if (skillRegistryObject != null) {
            ResourceLocation skillId = skillRegistryObject.getId();
            ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillId);
            if (skill != null) {
                TensuraSkillInstance instance = new TensuraSkillInstance(skill);
                SkillAPI.getSkillsFrom((Entity)living).learnSkill((ManasSkillInstance)instance);
                if (instance.canBeToggled(living)) {
                    instance.setToggled(true);
                }
                instance.setMastery(skill.getMaxMastery());
                instance.markDirty();
                SkillAPI.getSkillsFrom((Entity)living).syncChanges();
                if (living instanceof LivingEntity) {
                    instance.onSkillMastered(living);
                }
                living.m_213846_((Component)Component.m_237110_((String)"tensura.skill.mastery", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    private static void applyEPToEntity(LivingEntity entity, double amount, boolean updateStats) {
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        LazyOptional capOptional = TensuraEPCapability.getFrom((LivingEntity)entity);
        if (capOptional.isPresent()) {
            TensuraEPCapability cap = (TensuraEPCapability)capOptional.orElseThrow(() -> new IllegalStateException("Missing EP capability!"));
            cap.setEP(entity, amount * 10.0, updateStats);
            cap.setCurrentEP(entity, cap.getEP());
            TensuraEPCapability.sync((LivingEntity)entity);
        } else {
            System.out.println("No EP Capability found for: " + String.valueOf(entity.m_6095_()));
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        double y = entity.m_20186_();
        Level level = entity.f_19853_;
        if (level.f_46443_) {
            return;
        }
        if (y >= 115.0 && y <= 130.0) {
            TamableAnimal tame;
            UUID permanentOwner;
            if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            if (entity instanceof ServerPlayer) {
                return;
            }
            if (entity instanceof DryadEntity || entity instanceof KaijinEntity || entity instanceof KaoruEntity || entity instanceof KobyEntity || entity instanceof GuildLadyEntity || entity instanceof MjollmileEntity) {
                return;
            }
            if (entity instanceof TamableAnimal && (permanentOwner = TensuraEPCapability.getPermanentOwner((LivingEntity)(tame = (TamableAnimal)entity))) != null) {
                return;
            }
            entity.m_146870_();
        }
    }

    static {
        UNIQUE_SKILL_MAP.put("OBSERVER", (RegistryObject<? extends Skill>)UniqueSkills.OBSERVER);
        UNIQUE_SKILL_MAP.put("REAPER", (RegistryObject<? extends Skill>)UniqueSkills.REAPER);
        UNIQUE_SKILL_MAP.put("SEER", (RegistryObject<? extends Skill>)UniqueSkills.SEER);
        UNIQUE_SKILL_MAP.put("FIGHTER", (RegistryObject<? extends Skill>)UniqueSkills.FIGHTER);
        UNIQUE_SKILL_MAP.put("SHADOW_STRIKER", (RegistryObject<? extends Skill>)UniqueSkills.SHADOW_STRIKER);
        UNIQUE_SKILL_MAP.put("SNIPER", (RegistryObject<? extends Skill>)UniqueSkills.SNIPER);
        UNIQUE_SKILL_MAP.put("SURVIVOR", (RegistryObject<? extends Skill>)UniqueSkills.SURVIVOR);
        UNIQUE_SKILL_MAP.put("TUNER", (RegistryObject<? extends Skill>)UniqueSkills.TUNER);
        UNIQUE_SKILL_MAP.put("GOURMAND", (RegistryObject<? extends Skill>)UniqueSkills.GOURMAND);
        UNIQUE_SKILL_MAP.put("ANTI_SKILL", (RegistryObject<? extends Skill>)UniqueSkills.ANTI_SKILL);
        UNIQUE_SKILL_MAP.put("CHOSEN_ONE", (RegistryObject<? extends Skill>)UniqueSkills.CHOSEN_ONE);
        UNIQUE_SKILL_MAP.put("COMMANDER", (RegistryObject<? extends Skill>)UniqueSkills.COMMANDER);
        UNIQUE_SKILL_MAP.put("COOK", (RegistryObject<? extends Skill>)UniqueSkills.COOK);
        UNIQUE_SKILL_MAP.put("ENGORGER", (RegistryObject<? extends Skill>)UniqueSkills.ENGORGER);
        UNIQUE_SKILL_MAP.put("GUARDIAN", (RegistryObject<? extends Skill>)UniqueSkills.GUARDIAN);
        UNIQUE_SKILL_MAP.put("MARTIAL_MASTER", (RegistryObject<? extends Skill>)UniqueSkills.MARTIAL_MASTER);
        UNIQUE_SKILL_MAP.put("MATHEMATICIAN", (RegistryObject<? extends Skill>)UniqueSkills.MATHEMATICIAN);
        EXTRA_SKILL_MAP = new HashMap<String, RegistryObject<? extends Skill>>();
        EXTRA_SKILL_MAP.put("ALL_SEEING_EYE", (RegistryObject<? extends Skill>)ExtraSkills.ALL_SEEING_EYE);
        EXTRA_SKILL_MAP.put("STRENGTHEN_BODY", (RegistryObject<? extends Skill>)ExtraSkills.STRENGTHEN_BODY);
        EXTRA_SKILL_MAP.put("STEEL_STRENGTH", (RegistryObject<? extends Skill>)ExtraSkills.STEEL_STRENGTH);
        EXTRA_SKILL_MAP.put("BLACK_FLAME", (RegistryObject<? extends Skill>)ExtraSkills.BLACK_FLAME);
        EXTRA_SKILL_MAP.put("ULTRA_INSTINCT", (RegistryObject<? extends Skill>)ExtraSkills.ULTRA_INSTINCT);
        EXTRA_SKILL_MAP.put("HEAVENLY_EYE", (RegistryObject<? extends Skill>)ExtraSkills.HEAVENLY_EYE);
        EXTRA_SKILL_MAP.put("MAGIC_JAMMING", (RegistryObject<? extends Skill>)ExtraSkills.MAGIC_JAMMING);
        EXTRA_SKILL_MAP.put("ULTRA_REGENERATION", (RegistryObject<? extends Skill>)ExtraSkills.ULTRASPEED_REGENERATION);
    }
}

