/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import io.github.Memoires.trbeyond.capability.boss.BeyondBossCapability;
import io.github.Memoires.trbeyond.capability.boss.IBeyondBossCapability;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BossCapabilityHandler {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.register(IBeyondBossCapability.class);
    }

    @SubscribeEvent
    static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        BeyondBossCapability.sync(player);
    }

    @SubscribeEvent
    static void onPlayerTrack(PlayerEvent.StartTracking e) {
        Entity entity = e.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BeyondBossCapability.sync(player);
            BeyondBossCapability.sync(e.getEntity());
        }
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone e) {
        e.getOriginal().reviveCaps();
        Player newPlayer = e.getEntity();
        BeyondBossCapability.getFrom(e.getOriginal()).ifPresent(oldData -> BeyondBossCapability.getFrom(newPlayer).ifPresent(data -> data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        if (!e.isWasDeath()) {
            newPlayer.m_6210_();
        }
        e.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        BeyondBossCapability.sync(player);
        BeyondPlayerCapability.getFrom(e.getEntity()).ifPresent(cap -> {
            cap.setReturned(true);
            cap.setUsedTicket(false);
        });
        BeyondPlayerCapability.sync(e.getEntity());
    }

    @SubscribeEvent
    static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        BeyondBossCapability.sync(e.getEntity());
        BeyondPlayerCapability.getFrom(e.getEntity()).ifPresent(cap -> {
            cap.setReturned(true);
            cap.setUsedTicket(false);
        });
        BeyondPlayerCapability.sync(e.getEntity());
    }

    @Nullable
    public static <T> T getCapability(Entity entity, Capability<T> capability) {
        return (T)(entity.getCapability(capability).isPresent() ? entity.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }
}

