/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.manascore.api.skills.event.SkillToggleEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import io.github.Memoires.trbeyond.TRBeyond;
import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.capability.entities.IEliteMobCapability;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.capability.player.IBeyondPlayerCapability;
import io.github.Memoires.trbeyond.data.BeyondTags;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.entity.custom.MinhSlimeEntity;
import io.github.Memoires.trbeyond.entity.custom.ShrineEntity;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.util.ChallengeType;
import io.github.Memoires.trbeyond.util.ResistHelper;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="trbeyond")
public class ChallengeEventHandler {
    public static List<ChallengeType> challengeTypes = List.of(new ChallengeType("kill_slimes", "kill", "tensura:slime", 10, false, "tensura:silver_coin", 3, 60, true), new ChallengeType("kill_leech_lizard", "kill", "tensura:leech_lizard", 10, false, "tensura:silver_coin", 3, 60, true), new ChallengeType("collect_stone", "collect", "minecraft:cobblestone", 16, false, "tensura:gold_coin", 1, 0, false), new ChallengeType("explore_illusion", "explore", "trbeyond:illusionary_block", 2, false, "tensura:gold_coin", 1, 0, false), new ChallengeType("kill_elite_horned_rabbit", "kill", "tensura:horned_rabbit", 1, false, "tensura:gold_coin", 1, 0, false), new ChallengeType("dont_take_damage", "misc", "", 1, false, "tensura:silver_coin", 3, 60, true), new ChallengeType("kill_floor_boss", "kill", "trbeyond:boss_black_spider", 1, false, "tensura:gold_coin", 3, 960, true), new ChallengeType("kill_minh_slime", "kill", "trbeyond:minh_slime", 1, true, "tensura:gold_coin", 1, 60, false), new ChallengeType("kill_hound_dog", "kill", "tensura:hound_dog", 10, false, "tensura:silver_coin", 1, 60, true), new ChallengeType("kill_projectile", "special_kill", "", 50, false, "tensura:silver_coin", 5, 300, true), new ChallengeType("kill_stunned", "special_kill", "", 5, false, "tensura:silver_coin", 1, 300, false), new ChallengeType("kill_no_weapon", "special_kill", "", 50, false, "tensura:silver_coin", 1, 960, true), new ChallengeType("kill_floor_boss_no_heal", "kill", "trbeyond:boss_black_spider", 1, false, "tensura:gold_coin", 1, 960, false), new ChallengeType("kill_floor_boss_no_resist", "kill", "trbeyond:boss_black_spider", 1, false, "tensura:gold_coin", 1, 960, false), new ChallengeType("locate_majin", "locate", "", 1, false, "tensura:silver_coin", 3, 300, true), new ChallengeType("protect_or_kill_majin", "protect", "", 1, false, "tensura:silver_coin", 3, 0, false), new ChallengeType("kill_otherworlders", "group_kill", "", 3, false, "tensura:silver_coin", 10, 300, false), new ChallengeType("kill_dominators", "group_kill", "", 3, false, "tensura:silver_coin", 10, 300, false), new ChallengeType("one_shot_a_hundred", "group_kill", "", 100, false, "tensura:silver_coin", 3, 180, true), new ChallengeType("tame_kill_boss", "tame_kill", "trbeyond:boss_black_spider", 1, false, "tensura:gold_coin", 3, 960, true));

    private static boolean challengesDisabled(Level level) {
        return BeyondGamerules.getBoolean(level, BeyondGamerules.DISABLE_CHALLENGES);
    }

    public static boolean shrineChallengesDisabled(Level level, Player player) {
        if (BeyondGamerules.getBoolean(level, BeyondGamerules.DISABLE_SHRINES)) {
            player.m_213846_((Component)Component.m_237115_((String)"trbeyond.challenge.shrine_disabled").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true))));
            return true;
        }
        return false;
    }

    public static void giveChallengeType(Player player, String challengeType) {
        LazyOptional<IBeyondPlayerCapability> capabilityLazy = BeyondPlayerCapability.getFrom(player);
        if (challengeType == null) {
            return;
        }
        if (ChallengeEventHandler.challengesDisabled(player.m_9236_())) {
            return;
        }
        capabilityLazy.ifPresent(capability -> {
            ChallengeType type = challengeTypes.stream().filter(t -> t.getName().equals(challengeType)).findFirst().orElse(null);
            if (type == null) {
                return;
            }
            capability.setChallengeType(ChallengeType.getChallengeType(type));
            BeyondPlayerCapability.sync(player);
            player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.give_challenge", (Object[])new Object[]{Component.m_237115_((String)("trbeyond.challenge." + challengeType))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)65280)).m_131136_(Boolean.valueOf(true))));
        });
    }

    public static boolean giveChallengeType(Player player, ChallengeType challengeType, boolean ignoreGlobalDisable) {
        AtomicBoolean success = new AtomicBoolean(false);
        if (challengeType == null) {
            return false;
        }
        if (!ignoreGlobalDisable && ChallengeEventHandler.challengesDisabled(player.m_9236_())) {
            return false;
        }
        if (player.getPersistentData().m_128451_("floor") == 1 || player.getPersistentData().m_128451_("floor") == 95) {
            return false;
        }
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            if (capability.getChallengeType() == null) {
                if (challengeType.getName().contains("no_resist") && !ResistHelper.checkResistSkills((LivingEntity)player)) {
                    player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.fail_challenge", (Object[])new Object[]{Component.m_237115_((String)("trbeyond.challenge." + challengeType.getName()))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true))));
                    player.m_213846_((Component)Component.m_237113_((String)"Reason: You already have resists enabled").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                    return;
                }
                capability.setChallengeType(ChallengeType.getChallengeType(challengeType));
                BeyondPlayerCapability.sync(player);
                player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.give_challenge", (Object[])new Object[]{Component.m_237115_((String)("trbeyond.challenge." + challengeType.getName()))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)65280)).m_131136_(Boolean.valueOf(true))));
                if (challengeType.getName().equals("kill_elite")) {
                    player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.target_entity", (Object[])new Object[]{Component.m_237115_((String)String.format("entity.%s.%s", challengeType.getObjective().substring(0, challengeType.getObjective().indexOf(":")), challengeType.getObjective().substring(challengeType.getObjective().indexOf(":") + 1)))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)65280)).m_131136_(Boolean.valueOf(true))));
                }
                success.set(true);
            }
        });
        return success.get();
    }

    public static boolean giveChallengeType(Player player, ChallengeType challengeType, Component customName) {
        AtomicBoolean success = new AtomicBoolean(false);
        if (challengeType == null) {
            return false;
        }
        if (ChallengeEventHandler.challengesDisabled(player.m_9236_())) {
            return false;
        }
        if (player.getPersistentData().m_128451_("floor") == 1) {
            return false;
        }
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            if (capability.getChallengeType() == null) {
                if (challengeType.getName().contains("no_resist") && !ResistHelper.checkResistSkills((LivingEntity)player)) {
                    player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.fail_challenge", (Object[])new Object[]{challengeType.getName()}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true))));
                    player.m_213846_((Component)Component.m_237113_((String)"Reason: You already have resists enabled").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                    return;
                }
                capability.setChallengeType(ChallengeType.getChallengeType(challengeType));
                BeyondPlayerCapability.sync(player);
                player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.give_challenge", (Object[])new Object[]{customName}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)200)).m_131136_(Boolean.valueOf(true))));
                success.set(true);
            }
        });
        return success.get();
    }

    public static Component getItemDisplayName(String itemLocation) {
        ResourceLocation loc = new ResourceLocation(itemLocation);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
        if (item == null) {
            return Component.m_237113_((String)itemLocation);
        }
        return new ItemStack((ItemLike)item).m_41786_();
    }

    public static void failChallenge(Player player, ChallengeType challengeType) {
        if (challengeType == null) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            String challengeKey = "trbeyond.challenge." + challengeType.getName();
            MutableComponent challengeName = Component.m_237115_((String)challengeKey);
            player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.fail_challenge", (Object[])new Object[]{challengeName}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true))));
            capability.setChallengeType(null);
            BeyondPlayerCapability.sync(player);
        });
    }

    public static Optional<IBeyondPlayerCapability> getPlayerCapability(Player player) {
        LazyOptional<IBeyondPlayerCapability> lazyOptional = BeyondPlayerCapability.getFrom(player);
        if (lazyOptional.isPresent()) {
            return lazyOptional.map(Optional::of).orElseGet(Optional::empty);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (!event.getLevel().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        List<ChallengeType> killChallengeTypes = challengeTypes.stream().filter(type -> type.getCategory().equals("kill") && type.isOnSpawn()).toList();
        boolean matchedKillChallenge = killChallengeTypes.stream().anyMatch(type -> event.getEntity().m_6095_().toString().contains(type.getObjective().split(":")[0]) && event.getEntity().m_6095_().toString().contains(type.getObjective().split(":")[1]));
        if (matchedKillChallenge) {
            event.getLevel().m_45976_(Player.class, event.getEntity().m_20191_().m_82400_(20.0)).forEach(player -> ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                if (capability.getChallengeType() == null) {
                    ChallengeType challengeType = killChallengeTypes.stream().filter(type -> event.getEntity().m_6095_().toString().contains(type.getObjective().split(":")[0]) && event.getEntity().m_6095_().toString().contains(type.getObjective().split(":")[1])).findFirst().orElse(null);
                    ChallengeEventHandler.giveChallengeType(player, challengeType, false);
                }
            }));
        }
        List<String> majinCandidates = List.of("tensura:orc", "tensura:lizardman", "tensura:goblin");
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity majinEntity = (LivingEntity)entity;
            String typeId = majinEntity.m_6095_().toString();
            boolean isMajinCandidate = majinCandidates.stream().anyMatch(typeId::contains);
            if (isMajinCandidate && majinEntity.m_8077_()) {
                event.getLevel().m_45976_(Player.class, majinEntity.m_20191_().m_82400_(40.0)).forEach(player -> ChallengeEventHandler.getPlayerCapability(player).ifPresent(cap -> {
                    if (cap.getChallengeType() == null) {
                        ChallengeType locateMajin = ChallengeType.getChallengeType("locate_majin_name", "locate", majinEntity.m_20149_(), 1, false, "tensura:silver_coin", 3, 300, false);
                        if (ChallengeEventHandler.giveChallengeType(player, locateMajin, (Component)Component.m_237110_((String)"trbeyond.challenge.locate_majin_name", (Object[])new Object[]{majinEntity.m_7755_()}))) {
                            player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.locate_majin.hint", (Object[])new Object[]{majinEntity.m_7755_()}).m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)65535)).m_131136_(Boolean.valueOf(true))));
                        }
                    }
                }));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Object shrineBlock;
        Entity entity;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!event.getEntity().m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        LivingEntity entity2 = event.getEntity();
        if (entity2.m_6095_().m_204039_(BeyondTags.DUNGEON_BOSS) && !(event.getSource().m_7639_() instanceof Player)) {
            entity2.m_9236_().m_45976_(Player.class, entity2.m_20191_().m_82400_(50.0)).forEach(player -> ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType;
                if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getName().contains("kill_floor_boss") && (challengeType.getName().contains("no_heal") || challengeType.getName().contains("no_resist"))) {
                    ChallengeEventHandler.failChallenge(player, challengeType);
                    player.m_213846_((Component)Component.m_237113_((String)"Reason: The floor boss wasn't killed by you").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                }
            }));
        }
        if ((entity2.m_6095_().toString().contains("mark_lauren") || entity2.m_6095_().toString().contains("shinji_tanimura") || entity2.m_6095_().toString().contains("shin_ryusei")) && !(event.getSource().m_7639_() instanceof Player)) {
            entity2.m_9236_().m_45976_(Player.class, entity2.m_20191_().m_82400_(50.0)).forEach(player -> ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType = capability.getChallengeType();
                if (challengeType != null && challengeType.getName().equals("kill_otherworlders")) {
                    ChallengeEventHandler.failChallenge(player, challengeType);
                    player.m_213846_((Component)Component.m_237113_((String)"Reason: The otherworlder wasn't killed by you").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                }
            }));
        }
        if ((entity2.m_6095_().toString().contains("living_armor") || entity2.m_6095_().toString().contains("milim_slime_scarlet") || entity2.m_6095_().toString().contains("mage") || entity2.m_6095_().toString().contains("skull_night")) && !(event.getSource().m_7639_() instanceof Player)) {
            entity2.m_9236_().m_45976_(Player.class, entity2.m_20191_().m_82400_(50.0)).forEach(player -> ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType = capability.getChallengeType();
                if (challengeType != null && challengeType.getName().equals("kill_dominators")) {
                    ChallengeEventHandler.failChallenge(player, challengeType);
                    player.m_213846_((Component)Component.m_237113_((String)"Reason: The dominator wasn't killed by you").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                }
            }));
        }
        if (entity2.getPersistentData().m_128441_("challengeMob") && entity2.getPersistentData().m_128441_("shrinePos")) {
            BlockPos shrinePos = BlockPos.m_122022_((long)entity2.getPersistentData().m_128454_("shrinePos"));
            if (entity2.f_19797_ < 2400 && (entity = entity2.m_9236_().m_8055_(shrinePos).m_60734_()) instanceof ShrineBlock) {
                shrineBlock = (ShrineBlock)entity;
                ((ShrineBlock)((Object)shrineBlock)).mobKilled();
            }
        }
        if ((shrineBlock = event.getSource().m_7639_()) instanceof Player) {
            Player player2 = (Player)shrineBlock;
            ChallengeEventHandler.getPlayerCapability(player2).ifPresent(capability -> {
                if (capability.getChallengeType() != null) {
                    ChallengeType challengeType = capability.getChallengeType();
                    switch (challengeType.getCategory()) {
                        case "kill": {
                            String entityType = event.getEntity().m_6095_().toString();
                            if (!entityType.contains(challengeType.getObjective().split(":")[0]) || !entityType.contains(challengeType.getObjective().split(":")[1])) break;
                            if (challengeType.getName().contains("elite") && !EliteMobCapability.getFrom(event.getEntity()).map(IEliteMobCapability::isElite).orElse(false).booleanValue()) {
                                return;
                            }
                            challengeType.setCountDone(challengeType.getCountDone() + 1);
                            break;
                        }
                        case "special_kill": {
                            if (challengeType.getName().equals("kill_projectile") && event.getSource().m_7640_() instanceof Projectile) {
                                challengeType.setCountDone(challengeType.getCountDone() + 1);
                                break;
                            }
                            if (challengeType.getName().equals("kill_stunned") && player2.m_21023_((MobEffect)TensuraMobEffects.PARALYSIS.get())) {
                                challengeType.setCountDone(challengeType.getCountDone() + 1);
                                break;
                            }
                            if (!challengeType.getName().equals("kill_no_weapon") || !player2.m_21205_().m_41619_() || !player2.m_21206_().m_41619_()) break;
                            challengeType.setCountDone(challengeType.getCountDone() + 1);
                            break;
                        }
                        case "group_kill": {
                            String typeStr = entity2.m_6095_().toString();
                            if ((typeStr.contains("mark_lauren") || typeStr.contains("shinji_tanimura") || typeStr.contains("shin_ryusei")) && challengeType.getName().equals("kill_otherworlders")) {
                                challengeType.setCountDone(challengeType.getCountDone() + 1);
                            }
                            if (!typeStr.contains("living_armor") && !typeStr.contains("milim_slime_scarlet") && !typeStr.contains("mage") && !typeStr.contains("skull_night") || !challengeType.getName().equals("kill_dominators")) break;
                            challengeType.setCountDone(challengeType.getCountDone() + 1);
                            break;
                        }
                        case "tame_kill": {
                            ChallengeEventHandler.failChallenge(player2, capability.getChallengeType());
                        }
                    }
                    String targetUuid = challengeType.getObjective();
                    if (targetUuid != null && !targetUuid.isEmpty() && event.getEntity().m_20148_().toString().equals(targetUuid)) {
                        if (challengeType.getName().startsWith("protect_or_kill_majin_")) {
                            challengeType.setCountDone(1);
                            player2.getPersistentData().m_128473_("protect_challenge_time");
                        } else if (challengeType.getName().startsWith("locate_majin_") && challengeType.getCountDone() < challengeType.getCount()) {
                            player2.getPersistentData().m_128473_("protect_challenge_time");
                            ChallengeEventHandler.failChallenge(player2, challengeType);
                        }
                    }
                    BeyondPlayerCapability.sync(player2);
                }
            });
        } else {
            LivingEntity attacker;
            entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) instanceof TamableAnimal) {
                LivingEntity livingEntity;
                Player player3;
                TamableAnimal tame = (TamableAnimal)attacker;
                LivingEntity owner = tame.m_21826_();
                if (owner instanceof Player) {
                    player3 = (Player)owner;
                    ChallengeEventHandler.getPlayerCapability(player3).ifPresent(capability -> {
                        if (capability.getChallengeType() != null) {
                            ChallengeType challengeType = capability.getChallengeType();
                            switch (challengeType.getCategory()) {
                                case "kill": {
                                    String entityType = event.getEntity().m_6095_().toString();
                                    if (!entityType.contains(challengeType.getObjective().split(":")[0]) || !entityType.contains(challengeType.getObjective().split(":")[1])) break;
                                    if (challengeType.getName().contains("elite") && !EliteMobCapability.getFrom(event.getEntity()).map(IEliteMobCapability::isElite).orElse(false).booleanValue()) {
                                        return;
                                    }
                                    challengeType.setCountDone(challengeType.getCountDone() + 1);
                                    break;
                                }
                                case "special_kill": {
                                    if (challengeType.getName().equals("kill_projectile") && event.getSource().m_7640_() instanceof Projectile) {
                                        challengeType.setCountDone(challengeType.getCountDone() + 1);
                                        break;
                                    }
                                    if (challengeType.getName().equals("kill_stunned") && player3.m_21023_((MobEffect)TensuraMobEffects.PARALYSIS.get())) {
                                        challengeType.setCountDone(challengeType.getCountDone() + 1);
                                        break;
                                    }
                                    if (!challengeType.getName().equals("kill_no_weapon") || !player3.m_21205_().m_41619_() || !player3.m_21206_().m_41619_()) break;
                                    challengeType.setCountDone(challengeType.getCountDone() + 1);
                                    break;
                                }
                                case "group_kill": {
                                    String typeStr = entity2.m_6095_().toString();
                                    if ((typeStr.contains("mark_lauren") || typeStr.contains("shinji_tanimura") || typeStr.contains("shin_ryusei")) && challengeType.getName().equals("kill_otherworlders")) {
                                        challengeType.setCountDone(challengeType.getCountDone() + 1);
                                    }
                                    if (!typeStr.contains("living_armor") && !typeStr.contains("milim_slime_scarlet") && !typeStr.contains("mage") && !typeStr.contains("skull_night") || !challengeType.getName().equals("kill_dominators")) break;
                                    challengeType.setCountDone(challengeType.getCountDone() + 1);
                                }
                            }
                            String targetUuid = challengeType.getObjective();
                            if (targetUuid != null && !targetUuid.isEmpty() && event.getEntity().m_20148_().toString().equals(targetUuid)) {
                                if (challengeType.getName().startsWith("protect_or_kill_majin_")) {
                                    challengeType.setCountDone(1);
                                    player3.getPersistentData().m_128473_("protect_challenge_time");
                                } else if (challengeType.getName().startsWith("locate_majin_") && challengeType.getCountDone() < challengeType.getCount()) {
                                    player3.getPersistentData().m_128473_("protect_challenge_time");
                                    ChallengeEventHandler.failChallenge(player3, challengeType);
                                }
                            }
                            BeyondPlayerCapability.sync(player3);
                        }
                    });
                }
                if (entity2 instanceof BossBlackSpiderEntity && (livingEntity = tame.m_21826_()) instanceof Player) {
                    player3 = (Player)livingEntity;
                    ChallengeEventHandler.getPlayerCapability(player3).ifPresent(capability -> {
                        if (capability.getChallengeType() != null) {
                            ChallengeType challengeType = capability.getChallengeType();
                            if (challengeType.getCategory().equals("tame_kill")) {
                                challengeType.setCountDone(challengeType.getCountDone() + 1);
                            }
                            BeyondPlayerCapability.sync(player3);
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.m_5776_()) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
            if (capability.getChallengeType() != null) {
                ChallengeType challengeType = capability.getChallengeType();
                switch (challengeType.getCategory()) {
                    case "collect": {
                        event.player.m_150109_().f_35974_.forEach(itemStack -> {
                            if (itemStack.m_41720_().toString().equals(challengeType.getObjective()) && itemStack.m_41613_() >= challengeType.getCount()) {
                                challengeType.setCountDone(challengeType.getCount());
                                BeyondPlayerCapability.sync(event.player);
                            }
                        });
                        break;
                    }
                    case "locate": {
                        try {
                            UUID uuid = UUID.fromString(challengeType.getObjective());
                            Entity majin = ((ServerLevel)event.player.f_19853_).m_8791_(uuid);
                            if (majin instanceof LivingEntity) {
                                LivingEntity living = (LivingEntity)majin;
                                if (challengeType.getCountDone() >= challengeType.getCount()) break;
                                if (living.m_21224_()) {
                                    ChallengeEventHandler.failChallenge(event.player, challengeType);
                                    break;
                                }
                                if (!(event.player.m_20270_((Entity)living) < 5.0f)) break;
                                challengeType.setCountDone(1);
                                BeyondPlayerCapability.sync(event.player);
                                break;
                            }
                            if (challengeType.getCountDone() >= challengeType.getCount()) break;
                            ChallengeEventHandler.failChallenge(event.player, challengeType);
                        }
                        catch (IllegalArgumentException uuid) {}
                        break;
                    }
                    case "protect": {
                        try {
                            UUID uuid = UUID.fromString(challengeType.getObjective());
                            Entity majin = ((ServerLevel)event.player.f_19853_).m_8791_(uuid);
                            if (majin instanceof LivingEntity) {
                                LivingEntity living = (LivingEntity)majin;
                                if (challengeType.getCountDone() >= challengeType.getCount()) {
                                    return;
                                }
                                if (living.m_21224_()) {
                                    event.player.getPersistentData().m_128473_("protect_challenge_time");
                                    ChallengeEventHandler.failChallenge(event.player, challengeType);
                                    break;
                                }
                                if (event.player.f_19797_ % 20 != 0) break;
                                int timer = event.player.getPersistentData().m_128451_("protect_challenge_time");
                                event.player.getPersistentData().m_128405_("protect_challenge_time", ++timer);
                                if (timer < 30) break;
                                challengeType.setCountDone(1);
                                event.player.getPersistentData().m_128473_("protect_challenge_time");
                                BeyondPlayerCapability.sync(event.player);
                                break;
                            }
                            if (challengeType.getCountDone() >= challengeType.getCount()) break;
                            event.player.getPersistentData().m_128473_("protect_challenge_time");
                            ChallengeEventHandler.failChallenge(event.player, challengeType);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void ChallengeRewardTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.m_5776_()) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
            ChallengeType challengeType;
            if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getCountDone() >= challengeType.getCount()) {
                ItemStack reward = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(challengeType.getReward())), challengeType.getRewardAmount());
                if (!event.player.m_150109_().m_36054_(reward)) {
                    event.player.f_19853_.m_7967_((Entity)new ItemEntity(event.player.f_19853_, event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_(), reward));
                }
                capability.setChallengeType(null);
                BeyondPlayerCapability.sync(event.player);
                event.player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.complete_challenge", (Object[])new Object[]{Component.m_237115_((String)("trbeyond.challenge." + challengeType.getName()))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)65280)).m_131136_(Boolean.valueOf(true))));
                if (challengeType.getReward() != "minecraft:air") {
                    event.player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.reward", (Object[])new Object[]{ChallengeEventHandler.getItemDisplayName(challengeType.getReward()), challengeType.getRewardAmount()}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)65280)).m_131136_(Boolean.valueOf(true))));
                }
                if (event.player.getPersistentData().m_128441_("challenge_time")) {
                    event.player.getPersistentData().m_128473_("challenge_time");
                }
                if (challengeType.getName().startsWith("locate_majin_")) {
                    Entity entity = SkillHelper.getEntityFromUUID((ServerLevel)((ServerLevel)event.player.f_19853_), (UUID)UUID.fromString(challengeType.getObjective()));
                    if (entity == null) {
                        TRBeyond.getLogger().warn("Failed to find Majin entity with UUID: {} for challenge completion.", (Object)challengeType.getObjective());
                        return;
                    }
                    ChallengeType next = ChallengeType.getChallengeType("protect_or_kill_majin_name", "protect", challengeType.getObjective(), 1, false, "tensura:silver_coin", 3, 0, false);
                    ChallengeEventHandler.giveChallengeType(event.player, next, (Component)Component.m_237110_((String)"trbeyond.challenge.protect_or_kill_majin_name", (Object[])new Object[]{entity.m_7755_()}));
                }
            }
        });
    }

    @SubscribeEvent
    public static void nearEliteChallenge(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_)) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 100 != 0) {
            return;
        }
        boolean[] hasElite = new boolean[]{false};
        List<ChallengeType> killChallengeTypes = challengeTypes.stream().filter(type -> type.getCategory().equals("kill")).toList();
        player.f_19853_.m_45976_(LivingEntity.class, player.m_20191_().m_82377_(20.0, 6.0, 20.0)).forEach(entity -> {
            if (entity == null || entity.m_21224_()) {
                return;
            }
            if (EliteMobCapability.getFrom(entity).map(IEliteMobCapability::isElite).orElse(false).booleanValue()) {
                ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                    if (capability.getChallengeType() == null) {
                        if (killChallengeTypes.stream().anyMatch(type -> type.getName().contains("elite") && type.getObjective().contains(entity.m_6095_().toString().substring(entity.m_6095_().toString().indexOf(46) + 1).substring(entity.m_6095_().toString().substring(entity.m_6095_().toString().indexOf(46) + 1).indexOf(46) + 1)) && type.getObjective().contains(entity.m_6095_().toString().substring(entity.m_6095_().toString().indexOf(46) + 1).substring(0, entity.m_6095_().toString().substring(entity.m_6095_().toString().indexOf(46) + 1).indexOf(46))))) {
                            ChallengeType existingChallenge = killChallengeTypes.stream().filter(type -> type.getName().contains("elite") && type.getObjective().contains(entity.m_6095_().toString().substring(entity.m_6095_().toString().indexOf(46) + 1)) && type.getObjective().contains(entity.m_6095_().toString().split("\\.")[2])).findFirst().orElse(null);
                            ChallengeEventHandler.giveChallengeType(player, existingChallenge, false);
                            return;
                        }
                        String entityName = entity.m_6095_().toString().substring(entity.m_6095_().toString().indexOf(46) + 1).replace(".", ":");
                        ChallengeType challengeType = ChallengeType.getChallengeType("kill_elite", "kill", entityName, 1, false, "tensura:gold_coin", 1, 0, false);
                        ChallengeEventHandler.giveChallengeType(player, challengeType, false);
                    }
                    hasElite[0] = true;
                });
            }
        });
        if (!hasElite[0]) {
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType;
                if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getName().contains("elite")) {
                    ChallengeEventHandler.failChallenge(player, challengeType);
                }
            });
        }
    }

    @SubscribeEvent
    public static void nearFloorBossChallenge(TickEvent.PlayerTickEvent event) {
        boolean foundBoss;
        if (event.phase != TickEvent.Phase.START || event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_)) {
            return;
        }
        if (event.player.f_19797_ % 100 != 0) {
            return;
        }
        double radius = 50.0;
        List bosses = event.player.f_19853_.m_6443_(LivingEntity.class, event.player.m_20191_().m_82377_(radius, 0.0, radius), entity -> {
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            return entityId != null && entityId.toString().equals("trbeyond:boss_black_spider");
        });
        boolean bl = foundBoss = !bosses.isEmpty();
        if (foundBoss) {
            ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
                List<ChallengeType> bossChallengeTypes;
                if (capability.getChallengeType() == null && !(bossChallengeTypes = challengeTypes.stream().filter(type -> type.getObjective().equals("trbeyond:boss_black_spider")).toList()).isEmpty()) {
                    int dayLength = 86400;
                    if (ChallengeEventHandler.getRandomInRange(1, 100) <= 25) {
                        String[] specialChallenges = new String[]{"kill_floor_boss_no_heal", "kill_floor_boss_no_resist", "kill_floor_boss_no_heal_no_resist", "tame_kill_boss"};
                        for (int i = specialChallenges.length - 1; i > 0; --i) {
                            int j = ChallengeEventHandler.getRandomInRange(0, i);
                            String temp = specialChallenges[i];
                            specialChallenges[i] = specialChallenges[j];
                            specialChallenges[j] = temp;
                        }
                        for (String challengeKey : specialChallenges) {
                            ChallengeType specialChallenge;
                            String cooldownKey = challengeKey + "_cooldown";
                            if (event.player.getPersistentData().m_128441_(cooldownKey) || (specialChallenge = !challengeKey.equals("kill_floor_boss_no_heal_no_resist") ? (ChallengeType)bossChallengeTypes.stream().filter(type -> type.getName().equals(challengeKey)).findFirst().orElse(null) : new ChallengeType("kill_floor_boss_no_heal_no_resist", "kill", "trbeyond:boss_black_spider", 1, false, "tensura:gold_coin", 5, 960, false)) == null) continue;
                            ChallengeEventHandler.giveChallengeType(event.player, specialChallenge, false);
                            event.player.getPersistentData().m_128405_(cooldownKey, dayLength);
                            if (challengeKey.equals("kill_floor_boss_no_heal_no_resist")) {
                                event.player.m_213846_((Component)Component.m_237113_((String)"Special Challenge: Defeat the floor boss without healing or resistance!").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFFAA00)).m_131136_(Boolean.valueOf(true))));
                            }
                            return;
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void randomChallenge(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_) || !event.player.f_19853_.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (event.player.f_19797_ % 1200 == 0) {
            Player player = event.player;
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                int chance;
                if (capability.getChallengeType() != null) {
                    return;
                }
                if (player.getPersistentData().m_128441_("challenge_cooldown")) {
                    int cooldown = player.getPersistentData().m_128451_("challenge_cooldown");
                    if (cooldown > 0) {
                        player.getPersistentData().m_128405_("challenge_cooldown", cooldown - 1);
                        return;
                    }
                    player.getPersistentData().m_128473_("challenge_cooldown");
                }
                if (player.getPersistentData().m_128441_("challenge_chance")) {
                    chance = player.getPersistentData().m_128451_("challenge_chance");
                    if (chance < 100) {
                        chance = chance < 20 ? ++chance : (chance += 2);
                        player.getPersistentData().m_128405_("challenge_chance", chance);
                    }
                } else {
                    player.getPersistentData().m_128405_("challenge_chance", 1);
                }
                chance = player.getPersistentData().m_128451_("challenge_chance");
                if (chance < 100 && ChallengeEventHandler.getRandomInRange(1, 100) > chance) {
                    return;
                }
                player.getPersistentData().m_128473_("challenge_chance");
                if (capability.getChallengeType() == null) {
                    List<ChallengeType> randomChallenges = challengeTypes.stream().filter(ChallengeType::isRandom).toList();
                    ChallengeType selected = randomChallenges.get((int)(Math.random() * (double)randomChallenges.size()));
                    if ("locate_majin".equals(selected.getName())) {
                        Entity patt54158$temp;
                        ServerLevel level = (ServerLevel)player.f_19853_;
                        List<String> majinEntities = List.of("tensura:orc", "tensura:lizardman", "tensura:goblin");
                        List<String> goblinNames = List.of("Gobrin", "Gobuya", "Gobsha", "Gobnari", "Gobbiko", "Gobmori", "Gobzai", "Gobrinchi", "Gobufu", "Gobtoki");
                        List<String> orcNames = List.of("Geldar", "Brakto", "Dorgel", "Makrid", "Grudon", "Vorgul", "Kelbar", "Rendor", "Beldrak", "Orgram");
                        List<String> dragonewtNames = List.of("Saryon", "Vaskir", "Drakoru", "Zarenth", "Kurasyl", "Thalvik", "Ryugar", "Myzoth", "Dravak", "Ozarien");
                        List<String> tensuraNames = List.of("Miyaka", "Renjou", "Teshka", "Okamaru", "Zegrah", "Hinoro", "Kaelvi", "Nadeka", "Retsu", "Valmere");
                        String entityId = majinEntities.get(ChallengeEventHandler.getRandomInRange(0, majinEntities.size() - 1));
                        ArrayList<String> namePool = new ArrayList<String>();
                        if (entityId.contains("goblin")) {
                            namePool.addAll(goblinNames);
                        } else if (entityId.contains("orc")) {
                            namePool.addAll(orcNames);
                        } else {
                            namePool.addAll(dragonewtNames);
                        }
                        namePool.addAll(tensuraNames);
                        String name = (String)namePool.get(ChallengeEventHandler.getRandomInRange(0, namePool.size() - 1));
                        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
                        if (type != null && (patt54158$temp = type.m_20615_((Level)level)) instanceof LivingEntity) {
                            LivingEntity majin = (LivingEntity)patt54158$temp;
                            double spawnX = player.m_20185_();
                            double spawnZ = player.m_20189_();
                            double spawnY = player.m_20186_();
                            boolean foundPos = false;
                            for (int attempt = 0; attempt < 20 && !foundPos; ++attempt) {
                                double angle = Math.random() * Math.PI * 2.0;
                                double distance = 5.0 + Math.random() * 25.0;
                                double candidateX = player.m_20185_() + Math.cos(angle) * distance;
                                double candidateZ = player.m_20189_() + Math.sin(angle) * distance;
                                BlockPos candidatePos = new BlockPos((int)Math.floor(candidateX), (int)Math.floor(spawnY), (int)Math.floor(candidateZ));
                                if (!level.m_46859_(candidatePos) || level.m_46859_(candidatePos.m_7495_())) continue;
                                majin.m_7678_(candidateX + 0.5, spawnY, candidateZ + 0.5, majin.m_146908_(), majin.m_146909_());
                                if (!level.m_45786_((Entity)majin)) continue;
                                spawnX = candidateX;
                                spawnZ = candidateZ;
                                foundPos = true;
                            }
                            majin.m_7678_(spawnX + 0.5, spawnY, spawnZ + 0.5, majin.m_146908_(), majin.m_146909_());
                            majin.m_6593_((Component)Component.m_237113_((String)name));
                            majin.m_20340_(true);
                            if (majin instanceof Mob) {
                                Mob mob = (Mob)majin;
                                mob.m_21530_();
                            }
                            level.m_7967_((Entity)majin);
                            ChallengeType dynamic = ChallengeType.getChallengeType("locate_majin_name" + String.valueOf(majin.m_7755_()), "locate", majin.m_20149_(), 1, false, "tensura:silver_coin", 3, 300, false);
                            if (ChallengeEventHandler.giveChallengeType(player, dynamic, (Component)Component.m_237110_((String)"trbeyond.challenge.locate_majin_name", (Object[])new Object[]{majin.m_7755_()}))) {
                                player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.locate_majin.hint", (Object[])new Object[]{majin.m_7755_()}).m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)65535)).m_131136_(Boolean.valueOf(true))));
                            }
                        }
                    } else {
                        if (selected.getName().contains("floor_boss") && (!player.getPersistentData().m_128441_("floor") || player.getPersistentData().m_128451_("floor") < 2 || player.getPersistentData().m_128451_("floor") > 5)) {
                            return;
                        }
                        ChallengeEventHandler.giveChallengeType(player, selected, false);
                    }
                    player.getPersistentData().m_128405_("challenge_cooldown", 15);
                }
            });
        }
    }

    @SubscribeEvent
    public static void ChallengeTimer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player.f_19853_.m_5776_()) {
            return;
        }
        Player player = event.player;
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            ChallengeType challengeType;
            if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getTimeLimit() > 0 && player.f_19797_ % 20 == 0) {
                if (player.getPersistentData().m_128441_("challenge_time")) {
                    int timer = player.getPersistentData().m_128451_("challenge_time");
                    player.getPersistentData().m_128405_("challenge_time", ++timer);
                    if (timer > challengeType.getTimeLimit()) {
                        if (challengeType.getName().equals("dont_take_damage")) {
                            challengeType.setCountDone(challengeType.getCount());
                            return;
                        }
                        player.getPersistentData().m_128473_("challenge_time");
                        ChallengeEventHandler.failChallenge(player, challengeType);
                    }
                } else {
                    player.getPersistentData().m_128405_("challenge_time", 1);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(player.f_19853_)) {
                return;
            }
            if (!player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType;
                if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getName().equals("dont_take_damage")) {
                    ChallengeEventHandler.failChallenge(player, challengeType);
                }
            });
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof Player) {
            player = (Player)livingEntity;
            if (player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(player.f_19853_)) {
                return;
            }
            if (!player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType;
                if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getName().equals("one_shot_a_hundred")) {
                    LivingEntity target = event.getEntity();
                    if (event.getAmount() >= target.m_21233_()) {
                        challengeType.setCountDone(challengeType.getCountDone() + 1);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void syncChallenge(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player.f_19853_.m_5776_()) {
            return;
        }
        Player player = event.player;
        if (!player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            BeyondPlayerCapability.sync(player);
            if (capability.getChallengeType() != null && capability.getChallengeType().getTimeLimit() > 0 && player.getPersistentData().m_128441_("challenge_time")) {
                capability.getChallengeType().setTime(player.getPersistentData().m_128451_("challenge_time"));
            }
        });
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_19853_.m_5776_()) {
                return;
            }
            if (!player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            if (event.getEffectInstance().m_19544_() == TensuraMobEffects.PARALYSIS.get()) {
                ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                    if (capability.getChallengeType() == null && ChallengeEventHandler.getRandomInRange(1, 100) <= 1) {
                        challengeTypes.stream().filter(type -> type.getName().equals("kill_stunned")).findFirst().ifPresent(stunChallenge -> ChallengeEventHandler.giveChallengeType(player, stunChallenge, false));
                    }
                });
            } else if (event.getEffectInstance().m_19544_() == TensuraMobEffects.SELF_REGENERATION.get() || event.getEffectInstance().m_19544_() == TensuraMobEffects.INSTANT_REGENERATION.get()) {
                ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                    ChallengeType challengeType;
                    if (capability.getChallengeType() != null && ((challengeType = capability.getChallengeType()).getName().equals("kill_floor_boss_no_heal") || challengeType.getName().equals("kill_floor_boss_no_heal_no_resist"))) {
                        ChallengeEventHandler.failChallenge(player, challengeType);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onSkillToggleEvent(SkillToggleEvent event) {
        Player player = event.getEntity();
        if (ChallengeEventHandler.challengesDisabled(player.f_19853_)) {
            return;
        }
        if (event.getSkillInstance().getSkill() instanceof ResistSkill && event.isToggleOn()) {
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                ChallengeType challengeType;
                if (capability.getChallengeType() != null && ((challengeType = capability.getChallengeType()).getName().equals("kill_floor_boss_no_resist") || challengeType.getName().equals("kill_floor_boss_no_heal_no_resist"))) {
                    capability.setChallengeType(null);
                    BeyondPlayerCapability.sync(player);
                    player.m_213846_((Component)Component.m_237110_((String)"trbeyond.challenge.fail_challenge", (Object[])new Object[]{challengeType.getName()}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true))));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onShrineEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ShrineEntity) {
            ShrineEntity shrine = (ShrineEntity)livingEntity;
            pos = BlockPos.m_122022_((long)shrine.getPersistentData().m_128454_("blockPos"));
            Block block = shrine.m_9236_().m_8055_(pos).m_60734_();
            if (block instanceof ShrineBlock) {
                ShrineBlock shrineBlock = (ShrineBlock)block;
                if (shrine.getPersistentData().m_128461_("challenge").equals("Protect the Shrine")) {
                    shrineBlock.failChallenge(shrine.m_9236_(), pos, shrine.m_9236_().m_46003_(UUID.fromString(shrine.getPersistentData().m_128461_("player"))));
                } else if (shrine.getPersistentData().m_128461_("challengeMob").equals("Destroy the Shrine")) {
                    shrineBlock.completeChallenge(shrine.m_9236_().m_8055_(pos), shrine.m_9236_(), pos, shrine.m_9236_().m_46003_(UUID.fromString(shrine.getPersistentData().m_128461_("player"))), true, true);
                }
            }
        } else if (event.getEntity().getPersistentData().m_128461_("challengeMob").equals("Defeat the Boss")) {
            pos = BlockPos.m_122022_((long)event.getEntity().getPersistentData().m_128454_("blockPos"));
            Block block = event.getEntity().m_9236_().m_8055_(pos).m_60734_();
            if (block instanceof ShrineBlock) {
                ShrineBlock shrineBlock = (ShrineBlock)block;
                shrineBlock.completeChallenge(event.getEntity().m_9236_().m_8055_(pos), event.getEntity().m_9236_(), pos, event.getEntity().m_9236_().m_46003_(UUID.fromString(event.getEntity().getPersistentData().m_128461_("player"))), true, true);
            }
        }
    }

    @SubscribeEvent
    public static void onShrineEntityDamage(LivingHurtEvent event) {
        ShrineEntity shrine;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ShrineEntity && (shrine = (ShrineEntity)livingEntity).getPersistentData().m_128461_("challenge").equals("Protect the Shrine")) {
            if (event.getSource().m_7639_() instanceof Player) {
                event.setCanceled(true);
            } else {
                Entity entity = event.getSource().m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    if (!living.getPersistentData().m_128461_("challengeMob").equals("Protect the Shrine")) {
                        event.setCanceled(true);
                    }
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.m_5776_()) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 200 != 0) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            ChallengeType challengeType;
            if (capability.getChallengeType() != null && (challengeType = capability.getChallengeType()).getCategory().contains("shrine") && ChallengeEventHandler.getRandomInRange(1, 100) <= 5 && player.getPersistentData().m_128441_("shrineTier")) {
                String shrineTier = player.getPersistentData().m_128461_("shrineTier");
                if (shrineTier.equals("stellar") && player.getPersistentData().m_128461_("shrineChallenge").equals("waves")) {
                    int effectChance = ChallengeEventHandler.getRandomInRange(1, 100);
                    if (effectChance <= 33) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, ChallengeEventHandler.getRandomInRange(100, 200), 0, false, false));
                    } else if (effectChance <= 66) {
                        player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), ChallengeEventHandler.getRandomInRange(100, 200), 1, false, false));
                    } else {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, ChallengeEventHandler.getRandomInRange(100, 200), 0, false, false));
                    }
                }
                if ((shrineTier.equals("gold") || shrineTier.equals("stellar")) && ChallengeEventHandler.getRandomInRange(1, 3) <= 1) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double distance = 5.0 + Math.random() * 10.0;
                    double knockbackX = Math.cos(angle) * distance;
                    double knockbackZ = Math.sin(angle) * distance;
                    player.m_5997_(knockbackX, 0.5, knockbackZ);
                    player.m_6469_(DamageSource.f_19318_, (float)ChallengeEventHandler.getRandomInRange(1, 3));
                }
            }
        });
    }

    @SubscribeEvent
    public static void giveOtherWorlderChallengeInRange(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_)) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (event.player.f_19797_ % 200 == 0) {
            ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
                long otherworlderCount;
                ChallengeType challengeType = capability.getChallengeType();
                if (challengeType == null && (otherworlderCount = event.player.f_19853_.m_45976_(LivingEntity.class, event.player.m_20191_().m_82377_(50.0, 0.0, 50.0)).stream().filter(e -> e.m_6095_().toString().matches(".*(mark_lauren|shinji_tanimura|shin_ryusei).*")).count()) > 0L) {
                    ChallengeEventHandler.giveChallengeType(event.player, "kill_otherworlders");
                }
            });
        }
    }

    @SubscribeEvent
    public static void checkForOtherWorlders(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_)) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (event.player.f_19797_ % 200 == 0) {
            ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
                long otherworlderCount;
                ChallengeType challengeType = capability.getChallengeType();
                if (challengeType != null && challengeType.getName().equals("kill_otherworlders") && (otherworlderCount = event.player.f_19853_.m_45976_(LivingEntity.class, event.player.m_20191_().m_82377_(50.0, 0.0, 50.0)).stream().filter(e -> e.m_6095_().toString().matches(".*(mark_lauren|shinji_tanimura|shin_ryusei).*")).count()) == 0L) {
                    ChallengeEventHandler.failChallenge(event.player, challengeType);
                    event.player.m_213846_((Component)Component.m_237113_((String)"Reason: You left the otherworlders behind!").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                }
            });
        }
    }

    @SubscribeEvent
    public static void giveDominatorsChallengeInRange(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_)) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (event.player.f_19797_ % 200 == 0) {
            ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
                long dominatorCount;
                ChallengeType challengeType = capability.getChallengeType();
                if (challengeType == null && (dominatorCount = event.player.f_19853_.m_45976_(LivingEntity.class, event.player.m_20191_().m_82377_(50.0, 0.0, 50.0)).stream().filter(e -> e.m_6095_().toString().matches(".*(living_armor|milim_slime_scarlet|mage|skull_night).*")).count()) > 0L) {
                    ChallengeEventHandler.giveChallengeType(event.player, "kill_dominators");
                }
            });
        }
    }

    @SubscribeEvent
    public static void checkForDominators(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.m_5776_() || ChallengeEventHandler.challengesDisabled(event.player.f_19853_)) {
            return;
        }
        if (!event.player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (event.player.f_19797_ % 200 == 0) {
            ChallengeEventHandler.getPlayerCapability(event.player).ifPresent(capability -> {
                long dominatorCount;
                ChallengeType challengeType = capability.getChallengeType();
                if (challengeType != null && challengeType.getName().equals("kill_dominators") && (dominatorCount = event.player.f_19853_.m_45976_(LivingEntity.class, event.player.m_20191_().m_82377_(50.0, 0.0, 50.0)).stream().filter(e -> e.m_6095_().toString().matches(".*(living_armor|milim_slime_scarlet|mage|skull_night).*")).count()) == 0L) {
                    ChallengeEventHandler.failChallenge(event.player, challengeType);
                    event.player.m_213846_((Component)Component.m_237113_((String)"Reason: You left the dominators behind!").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000))));
                }
            });
        }
    }

    @SubscribeEvent
    public static void minhSlimeChallenge(EntityLeaveLevelEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!serverLevel.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof MinhSlimeEntity)) {
            return;
        }
        MinhSlimeEntity minhSlime = (MinhSlimeEntity)entity;
        if (minhSlime.m_146911_() == Entity.RemovalReason.DISCARDED) {
            for (ServerPlayer player : serverLevel.m_6907_()) {
                ChallengeEventHandler.getPlayerCapability((Player)player).ifPresent(capability -> {
                    if (capability.getChallengeType() != null && "kill_minh_slime".equals(capability.getChallengeType().getName())) {
                        ChallengeEventHandler.failChallenge((Player)player, capability.getChallengeType());
                        player.m_213846_((Component)Component.m_237113_((String)"Reason: You let the Minh Slime escape!").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true))));
                    }
                });
            }
        }
    }

    private static BlockPos findSafeSpawnPos(Level level, BlockPos center, int radius) {
        int y = center.m_123342_();
        for (int attempts = 0; attempts < 20; ++attempts) {
            int z;
            int x = center.m_123341_() + ChallengeEventHandler.getRandomInRange(-radius, radius);
            BlockPos pos = new BlockPos(x, y, z = center.m_123343_() + ChallengeEventHandler.getRandomInRange(-radius, radius));
            boolean clear = level.m_46859_(pos) && level.m_46859_(pos.m_7494_());
            boolean solidBlock = level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos.m_7495_());
            if (!clear || !solidBlock) continue;
            return pos;
        }
        return null;
    }

    public static int getRandomInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }
}

