/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import io.github.Memoires.trbeyond.Database;
import io.github.Memoires.trbeyond.block.DungeonAnchor;
import io.github.Memoires.trbeyond.block.DungeonUnlockerBlock;
import io.github.Memoires.trbeyond.block.entity.AnchorBlockEntity;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.util.FunctionSpecifications;
import io.github.Memoires.trbeyond.util.MatrixTraversal;
import io.github.Memoires.trbeyond.util.MutableBlockPos;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DungeonGenerationHandler {
    @SubscribeEvent
    public static void loadDungeon(LevelEvent.Load event) {
        if (event.isCanceled()) {
            return;
        }
        if (!event.isCanceled()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (serverLevel.m_46472_() != BeyondDungeon.DUNGEON_LEVEL_KEY) {
            return;
        }
        MinecraftServer server = serverLevel.m_7654_();
        DungeonSaveData saveData = DungeonSaveData.get(server.m_129783_());
        if (saveData.isLoaded()) {
            return;
        }
        ServerLevel level = server.m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
        if (level == null) {
            return;
        }
        saveData.setLoaded(true);
        BlockPos destinationPos = new BlockPos(saveData.getStartGenPos().m_7096_(), saveData.getStartGenPos().m_7098_(), saveData.getStartGenPos().m_7094_());
        BlockState state = serverLevel.m_8055_(destinationPos);
        if (!state.m_61138_((Property)DungeonAnchor.GENERATED)) {
            serverLevel.m_46597_(destinationPos, ((DungeonAnchor)((Object)BeyondBlocks.DUNGEON_ANCHOR.get())).m_49966_());
            BlockEntity blockEntity = serverLevel.m_7702_(destinationPos);
            if (blockEntity instanceof AnchorBlockEntity) {
                AnchorBlockEntity anchor = (AnchorBlockEntity)blockEntity;
                anchor.setCurrentFloor(0);
            }
            StructureTemplateManager manager = serverLevel.m_215082_();
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(true);
            BlockPos leftPos = destinationPos.m_6625_(20).m_6625_(5).m_122025_(15);
            DungeonGenerationHandler.placeStructure(manager, serverLevel, leftPos, "dungeon/enter/enter_back_left", settings);
            BlockPos rightPos = leftPos.m_122013_(12);
            DungeonGenerationHandler.placeStructure(manager, serverLevel, rightPos, "dungeon/enter/enter_back_right", settings);
            BlockPos leftEnterPos = leftPos.m_122030_(17).m_6630_(5);
            DungeonGenerationHandler.placeStructure(manager, serverLevel, leftEnterPos, "dungeon/enter/enter_forward_left", settings);
            BlockPos rightEnterPos = rightPos.m_122030_(17).m_6630_(5);
            DungeonGenerationHandler.placeStructure(manager, serverLevel, rightEnterPos, "dungeon/enter/enter_forward_right", settings);
            StructurePlaceSettings hallwaySettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(true);
            String direction = "west";
            BlockPos firstHallwayPos = destinationPos.m_6625_(25).m_122025_(29).m_122013_(2);
            DungeonGenerationHandler.placeStructure(manager, serverLevel, firstHallwayPos, "dungeon/hallway/thin_hallway", hallwaySettings);
            MutableBlockPos previousHallwayPos = new MutableBlockPos(firstHallwayPos, hallwaySettings, direction);
            DungeonGenerationHandler.generateMaze(previousHallwayPos, manager, serverLevel);
        }
    }

    static void placeBossRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        Direction dir;
        BlockPos basePos = previousHallwayPos.pos;
        if (Objects.equals(previousHallwayPos.direction, "west")) {
            dir = Direction.WEST;
            basePos = previousHallwayPos.pos.m_122020_(2).m_6630_(2);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            dir = Direction.SOUTH;
            basePos = previousHallwayPos.pos.m_122030_(2).m_6630_(2);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            dir = Direction.NORTH;
            basePos = previousHallwayPos.pos.m_122025_(2).m_6630_(2);
        } else if (Objects.equals(previousHallwayPos.direction, "east")) {
            dir = Direction.EAST;
            basePos = previousHallwayPos.pos.m_122013_(2).m_6630_(2);
        } else {
            dir = Direction.WEST;
            basePos = previousHallwayPos.pos.m_122020_(2).m_6630_(2);
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(BeyondDungeon.getRotFromFacing(Rotation.CLOCKWISE_90.m_55954_(dir))).m_74392_(true);
        BlockPos rightPart = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 26).m_5484_(dir, 15).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, rightPart, "dungeon/room_boss/10bossroom_1", settings);
        BlockPos placePos = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 10).m_5484_(dir, 15).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, placePos, "dungeon/room_boss/10bossroom_2", settings);
        BlockPos leftPart = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -6).m_5484_(dir, 15).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, leftPart, "dungeon/room_boss/10bossroom_3", settings);
        BlockPos leftPart2 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -22).m_5484_(dir, 15).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, leftPart2, "dungeon/room_boss/10bossroom_4", settings);
        BlockPos rightPart2 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 26).m_5484_(dir, 31).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, rightPart2, "dungeon/room_boss/10bossroom_5", settings);
        BlockPos placePos2 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 10).m_5484_(dir, 31).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, placePos2, "dungeon/room_boss/10bossroom_6", settings);
        BlockPos leftPart3 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -6).m_5484_(dir, 31).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, leftPart3, "dungeon/room_boss/10bossroom_7", settings);
        BlockPos leftPart4 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -22).m_5484_(dir, 31).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, leftPart4, "dungeon/room_boss/10bossroom_8", settings);
        BlockPos rightPart3 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 26).m_5484_(dir, 47).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, rightPart3, "dungeon/room_boss/10bossroom_9", settings);
        BlockPos placePos3 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 10).m_5484_(dir, 47).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, placePos3, "dungeon/room_boss/10bossroom_10", settings);
        BlockPos leftPart5 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -6).m_5484_(dir, 47).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, leftPart5, "dungeon/room_boss/10bossroom_11", settings);
        BlockPos leftPart6 = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -22).m_5484_(dir, 47).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, leftPart6, "dungeon/room_boss/10bossroom_12", settings);
        BlockPos preLastPart = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 14).m_5484_(dir, 52).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, preLastPart, "dungeon/room_boss/10bossroom_13", settings);
        BlockPos lastPart = basePos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -1).m_5484_(dir, 52).m_6625_(2);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, lastPart, "dungeon/room_boss/10bossroom_14", settings);
    }

    static void placeOnewayRoomWithoutDoors(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos, String room_name) {
        BlockPos newHallwayPos = DungeonGenerationHandler.RoomblockPosByDirectionInverted(previousHallwayPos.direction, 10, previousHallwayPos.pos);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            previousHallwayPos.pos = newHallwayPos.m_122013_(3);
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            previousHallwayPos.pos = newHallwayPos.m_122020_(3);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            previousHallwayPos.pos = newHallwayPos.m_122030_(3);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            previousHallwayPos.pos = newHallwayPos.m_122025_(3);
        }
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway");
    }

    static void placeHallwayRandomSideRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        int prob = DungeonGenerationHandler.getRandomInRange(1, 9);
        if (prob == 9) {
            DungeonGenerationHandler.placeHallwayBothSideRoom(manager, destinationWorld, previousHallwayPos);
            return;
        }
        if (prob <= 4) {
            DungeonGenerationHandler.placeHallwayLeftSideRoom(manager, destinationWorld, previousHallwayPos);
        } else {
            DungeonGenerationHandler.placeHallwayRightSideRoom(manager, destinationWorld, previousHallwayPos);
        }
    }

    static void placeHallwayBothSideRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        BlockPos newHallwayPos;
        BlockPos pos;
        BlockPos prevPos;
        int distance;
        String direction;
        String room_name;
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/2doorway-thin");
        String originalDirection = previousHallwayPos.direction;
        BlockPos originalPos = previousHallwayPos.pos;
        StructurePlaceSettings originalSettings = previousHallwayPos.hallwaySettings;
        if (Objects.equals(previousHallwayPos.direction, "west")) {
            room_name = "dungeon/room/small_room_end";
            direction = "south";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            distance = 15;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122020_(distance).m_122030_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122030_(5).m_122013_(10).m_6630_(2), Rotation.NONE, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
        } else if (Objects.equals(previousHallwayPos.direction, "east")) {
            room_name = "dungeon/room/small_room_end";
            direction = "north";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            distance = 15;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122013_(distance).m_122025_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122025_(5).m_122020_(10).m_6630_(2), Rotation.CLOCKWISE_180, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            room_name = "dungeon/room/small_room_end";
            direction = "east";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            distance = 15;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122030_(distance).m_122013_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122013_(5).m_122025_(10).m_6630_(2), Rotation.COUNTERCLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            room_name = "dungeon/room/small_room_end";
            direction = "west";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            distance = 15;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122025_(distance).m_122020_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122020_(5).m_122030_(10).m_6630_(2), Rotation.CLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
        }
        previousHallwayPos.direction = originalDirection;
        previousHallwayPos.pos = originalPos;
        originalDirection = previousHallwayPos.direction;
        originalPos = previousHallwayPos.pos;
        originalSettings = previousHallwayPos.hallwaySettings;
        if (Objects.equals(previousHallwayPos.direction, "west")) {
            room_name = "dungeon/room/small_room_end";
            direction = "north";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            distance = 11;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122013_(distance).m_122030_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122025_(5).m_122020_(10).m_6630_(2), Rotation.NONE, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
        } else if (Objects.equals(previousHallwayPos.direction, "east")) {
            room_name = "dungeon/room/small_room_end";
            direction = "south";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            distance = 11;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122020_(distance).m_122025_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122030_(5).m_122013_(10).m_6630_(2), Rotation.CLOCKWISE_180, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            room_name = "dungeon/room/small_room_end";
            direction = "west";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            distance = 11;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122025_(distance).m_122013_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122020_(5).m_122030_(10).m_6630_(2), Rotation.COUNTERCLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            room_name = "dungeon/room/small_room_end";
            direction = "east";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            distance = 11;
            pos = prevPos = previousHallwayPos.pos;
            newHallwayPos = pos = prevPos.m_122030_(distance).m_122020_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122013_(5).m_122025_(10).m_6630_(2), Rotation.CLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
        }
        previousHallwayPos.direction = originalDirection;
        previousHallwayPos.pos = originalPos;
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 2, "dungeon/hallway/long_thin_hallway");
    }

    static void placeHallwayRightSideRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/1doorwayright-thin");
        String originalDirection = previousHallwayPos.direction;
        BlockPos originalPos = previousHallwayPos.pos;
        StructurePlaceSettings originalSettings = previousHallwayPos.hallwaySettings;
        if (Objects.equals(previousHallwayPos.direction, "west")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "north";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            int distance = 11;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122013_(distance).m_122030_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122025_(5).m_122020_(10).m_6630_(2), Rotation.NONE, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
        } else if (Objects.equals(previousHallwayPos.direction, "east")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "south";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            int distance = 11;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122020_(distance).m_122025_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122030_(5).m_122013_(10).m_6630_(2), Rotation.CLOCKWISE_180, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "west";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            int distance = 11;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122025_(distance).m_122013_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122020_(5).m_122030_(10).m_6630_(2), Rotation.COUNTERCLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "east";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            int distance = 11;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122030_(distance).m_122020_(12);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122013_(5).m_122025_(10).m_6630_(2), Rotation.CLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
        }
        previousHallwayPos.direction = originalDirection;
        previousHallwayPos.pos = originalPos;
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 2, "dungeon/hallway/long_thin_hallway");
    }

    static void placeHallwayLeftSideRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/1doorwayleft-thin");
        String originalDirection = previousHallwayPos.direction;
        BlockPos originalPos = previousHallwayPos.pos;
        StructurePlaceSettings originalSettings = previousHallwayPos.hallwaySettings;
        if (Objects.equals(previousHallwayPos.direction, "west")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "south";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            int distance = 15;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122020_(distance).m_122030_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122030_(5).m_122013_(10).m_6630_(2), Rotation.NONE, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
        } else if (Objects.equals(previousHallwayPos.direction, "east")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "north";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            int distance = 15;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122013_(distance).m_122025_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122025_(5).m_122020_(10).m_6630_(2), Rotation.CLOCKWISE_180, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "east";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            int distance = 15;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122030_(distance).m_122013_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122013_(5).m_122025_(10).m_6630_(2), Rotation.COUNTERCLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            BlockPos prevPos;
            String room_name = "dungeon/room/small_room_end";
            String direction = "west";
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            int distance = 15;
            BlockPos pos = prevPos = previousHallwayPos.pos;
            BlockPos newHallwayPos = pos = prevPos.m_122025_(distance).m_122020_(2);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, newHallwayPos.m_122020_(5).m_122030_(10).m_6630_(2), Rotation.CLOCKWISE_90, true);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
        }
        previousHallwayPos.direction = originalDirection;
        previousHallwayPos.pos = originalPos;
    }

    static void generateMaze(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld) {
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/long_thin_hallway");
        int floorCount = ((GameRules.IntegerValue)destinationWorld.m_46469_().m_46170_(BeyondGamerules.DUNGEON_FLOOR_SIZE)).m_46288_();
        MatrixTraversal traversal = new MatrixTraversal(floorCount, 0.75, 0.6, previousHallwayPos.direction);
        traversal.generateMaze();
        List<FunctionSpecifications> list = traversal.getFunctions();
        for (FunctionSpecifications func : list) {
            int prob;
            if (Objects.equals(func.getFunctionName(), "hallway")) {
                prob = DungeonGenerationHandler.getRandomInRange(1, 6);
                if (prob == 6) {
                    DungeonGenerationHandler.placeHallwayRandomSideRoom(manager, destinationWorld, previousHallwayPos);
                    continue;
                }
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/long_thin_hallway");
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "deadend")) {
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway_end");
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "corner_deadend")) {
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway_end");
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "stairs")) {
                DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "room")) {
                prob = DungeonGenerationHandler.getRandomInRange(1, 3);
                if (prob == 3) {
                    int prob2 = DungeonGenerationHandler.getRandomInRange(1, 10);
                    if (prob2 == 10) {
                        DungeonGenerationHandler.placeOnewayRoomWithoutDoors(manager, destinationWorld, previousHallwayPos, "dungeon/treasure/gold_chest_loot");
                        continue;
                    }
                    if (prob2 > 6) {
                        DungeonGenerationHandler.placeOnewayRoomWithoutDoors(manager, destinationWorld, previousHallwayPos, "dungeon/treasure/silver_chest_loot");
                        continue;
                    }
                    DungeonGenerationHandler.placeOnewayRoomWithoutDoors(manager, destinationWorld, previousHallwayPos, "dungeon/treasure/bronze_chest_loot");
                    continue;
                }
                DungeonGenerationHandler.placeOnewayRoom(manager, destinationWorld, previousHallwayPos, "dungeon/room/small_room_2");
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "corner")) {
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/long_thin_hallway");
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "three_way")) {
                DungeonGenerationHandler.place2wayHallway(previousHallwayPos, manager, destinationWorld, func.getSuccessDirection(), func.getNotSuccessCase(), func.getHallwayLen());
                continue;
            }
            DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/long_thin_hallway");
        }
    }

    static void presetMaze_1(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld) {
        String thin_hallway = "dungeon/hallway/thin_hallway";
        String thin_hallway_end = "dungeon/hallway/thin_hallway_end";
        String room_name = "dungeon/room/small_room_2";
        int n = 2;
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, n, thin_hallway);
        DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, thin_hallway);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, n, thin_hallway);
        DungeonGenerationHandler.placeOnewayRoom(manager, destinationWorld, previousHallwayPos, room_name);
        DungeonGenerationHandler.place2wayHallway(previousHallwayPos, manager, destinationWorld, "left", "loopback", 1);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, thin_hallway);
        DungeonGenerationHandler.placeOnewayRoom(manager, destinationWorld, previousHallwayPos, room_name);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, thin_hallway);
        DungeonGenerationHandler.placeOnewayRoom(manager, destinationWorld, previousHallwayPos, room_name);
        DungeonGenerationHandler.place2wayHallway(previousHallwayPos, manager, destinationWorld, "left", "loopback", 1);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 3, thin_hallway);
        DungeonGenerationHandler.place2wayHallway(previousHallwayPos, manager, destinationWorld, "right", "loopback", 1);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, thin_hallway);
        DungeonGenerationHandler.placeOnewayRoom(manager, destinationWorld, previousHallwayPos, room_name);
        DungeonGenerationHandler.place2wayHallway(previousHallwayPos, manager, destinationWorld, "right", "deadend", 6);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 2, thin_hallway);
        DungeonGenerationHandler.place2wayHallway(previousHallwayPos, manager, destinationWorld, "left", "deadend", 2);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, thin_hallway);
        DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, thin_hallway);
        DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 5, thin_hallway);
        DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, thin_hallway);
        DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
    }

    static void placeStairswithoutGeneration(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld, int numStairs) {
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            BlockPos finalStairCasePos = previousHallwayPos.pos.m_122030_(9).m_6625_(8);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
            previousHallwayPos.stairsplaced = true;
            MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122013_(8).m_122025_(0).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
            newHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            newHallwayPos.direction = "west";
            newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
            newHallwayPos.stairsplaced = false;
            if (numStairs == 0) {
                for (int i = 0; i < 2; ++i) {
                    BlockPos newBlockPos = DungeonGenerationHandler.blockPosByDirection(newHallwayPos.direction, 14, newHallwayPos.pos);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, newBlockPos, "dungeon/hallway/thin_hallway", previousHallwayPos.hallwaySettings);
                    newHallwayPos.pos = newBlockPos;
                }
                DungeonGenerationHandler.placeBossRoom(manager, destinationWorld, newHallwayPos);
                return;
            }
            DungeonGenerationHandler.placeStairswithoutGeneration(newHallwayPos, manager, destinationWorld, numStairs - 1);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            BlockPos finalStairCasePos = previousHallwayPos.pos.m_122020_(9).m_6625_(8);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
            previousHallwayPos.stairsplaced = true;
            MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122030_(8).m_122013_(0).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
            newHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            newHallwayPos.direction = "north";
            newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
            newHallwayPos.stairsplaced = false;
            if (numStairs == 0) {
                for (int i = 0; i < 2; ++i) {
                    BlockPos newBlockPos = DungeonGenerationHandler.blockPosByDirection(newHallwayPos.direction, 14, newHallwayPos.pos);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, newBlockPos, "dungeon/hallway/thin_hallway", previousHallwayPos.hallwaySettings);
                    newHallwayPos.pos = newBlockPos;
                }
                DungeonGenerationHandler.placeBossRoom(manager, destinationWorld, newHallwayPos);
                return;
            }
            DungeonGenerationHandler.placeStairswithoutGeneration(newHallwayPos, manager, destinationWorld, numStairs - 1);
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            BlockPos finalStairCasePos = previousHallwayPos.pos.m_122025_(9).m_6625_(8);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
            previousHallwayPos.stairsplaced = true;
            MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122020_(8).m_122030_(0).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
            newHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            newHallwayPos.direction = "east";
            newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
            newHallwayPos.stairsplaced = false;
            if (numStairs == 0) {
                for (int i = 0; i < 2; ++i) {
                    BlockPos newBlockPos = DungeonGenerationHandler.blockPosByDirection(newHallwayPos.direction, 14, newHallwayPos.pos);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, newBlockPos, "dungeon/hallway/thin_hallway", previousHallwayPos.hallwaySettings);
                    newHallwayPos.pos = newBlockPos;
                }
                DungeonGenerationHandler.placeBossRoom(manager, destinationWorld, newHallwayPos);
                return;
            }
            DungeonGenerationHandler.placeStairswithoutGeneration(newHallwayPos, manager, destinationWorld, numStairs - 1);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            BlockPos finalStairCasePos = previousHallwayPos.pos.m_122013_(9).m_6625_(8);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
            previousHallwayPos.stairsplaced = true;
            MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122025_(8).m_122020_(0).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
            newHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            newHallwayPos.direction = "south";
            newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
            newHallwayPos.stairsplaced = false;
            if (numStairs == 0) {
                for (int i = 0; i < 2; ++i) {
                    BlockPos newBlockPos = DungeonGenerationHandler.blockPosByDirection(newHallwayPos.direction, 14, newHallwayPos.pos);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, newBlockPos, "dungeon/hallway/thin_hallway", previousHallwayPos.hallwaySettings);
                    newHallwayPos.pos = newBlockPos;
                }
                DungeonGenerationHandler.placeBossRoom(manager, destinationWorld, newHallwayPos);
                return;
            }
            DungeonGenerationHandler.placeStairswithoutGeneration(newHallwayPos, manager, destinationWorld, numStairs - 1);
        }
    }

    static void placeStairs(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld) {
        if (!previousHallwayPos.stairsplaced && previousHallwayPos.floorcount < 10) {
            if (Objects.equals(previousHallwayPos.direction, "east")) {
                BlockPos finalStairCasePos = previousHallwayPos.pos.m_122030_(9).m_6625_(8);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
                previousHallwayPos.stairsplaced = true;
                MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122013_(8).m_122025_(4).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
                newHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
                newHallwayPos.direction = "west";
                newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
                newHallwayPos.stairsplaced = false;
                DungeonGenerationHandler.generateMaze(newHallwayPos, manager, destinationWorld);
            } else if (Objects.equals(previousHallwayPos.direction, "south")) {
                BlockPos finalStairCasePos = previousHallwayPos.pos.m_122020_(9).m_6625_(8);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
                previousHallwayPos.stairsplaced = true;
                MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122030_(8).m_122013_(4).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
                newHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
                newHallwayPos.direction = "north";
                newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
                newHallwayPos.stairsplaced = false;
                DungeonGenerationHandler.generateMaze(newHallwayPos, manager, destinationWorld);
            } else if (Objects.equals(previousHallwayPos.direction, "west")) {
                BlockPos finalStairCasePos = previousHallwayPos.pos.m_122025_(9).m_6625_(8);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
                previousHallwayPos.stairsplaced = true;
                MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122020_(8).m_122030_(4).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
                newHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
                newHallwayPos.direction = "east";
                newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
                newHallwayPos.stairsplaced = false;
                DungeonGenerationHandler.generateMaze(newHallwayPos, manager, destinationWorld);
            } else if (Objects.equals(previousHallwayPos.direction, "north")) {
                BlockPos finalStairCasePos = previousHallwayPos.pos.m_122013_(9).m_6625_(8);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, finalStairCasePos, "dungeon/stairs/small_stairs", previousHallwayPos.hallwaySettings);
                previousHallwayPos.stairsplaced = true;
                MutableBlockPos newHallwayPos = new MutableBlockPos(previousHallwayPos.pos.m_122025_(8).m_122020_(4).m_6625_(8), previousHallwayPos.hallwaySettings, previousHallwayPos.direction);
                newHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                newHallwayPos.direction = "south";
                newHallwayPos.floorcount = previousHallwayPos.floorcount + 1;
                newHallwayPos.stairsplaced = false;
                DungeonGenerationHandler.generateMaze(newHallwayPos, manager, destinationWorld);
            }
        } else {
            if (previousHallwayPos.floorcount >= 10) {
                DungeonGenerationHandler.placeStairswithoutGeneration(previousHallwayPos, manager, destinationWorld, 3);
                return;
            }
            DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway_end");
        }
    }

    static void placeDeadendRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        String room_name = "dungeon/room/small_room_end";
        BlockPos newHallwayPos = DungeonGenerationHandler.RoomblockPosByDirectionInverted(previousHallwayPos.direction, 11, previousHallwayPos.pos);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings);
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            previousHallwayPos.pos = newHallwayPos.m_122013_(3);
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            previousHallwayPos.pos = newHallwayPos.m_122020_(3);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            previousHallwayPos.pos = newHallwayPos.m_122030_(3);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            previousHallwayPos.pos = newHallwayPos.m_122025_(3);
        }
    }

    public static BlockPos RoomblockPosByDirectionInverted(String direction, int distance, BlockPos prevPos) {
        BlockPos pos = prevPos;
        pos = Objects.equals(direction, "east") ? prevPos.m_122030_(distance).m_122020_(3) : (Objects.equals(direction, "west") ? prevPos.m_122025_(distance).m_122013_(3) : (Objects.equals(direction, "south") ? prevPos.m_122020_(distance).m_122025_(3) : prevPos.m_122013_(distance).m_122030_(3)));
        return pos;
    }

    static void placeOnewayRoom(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos, String room_name) {
        ++MutableBlockPos.room_count;
        BlockPos originalPos = previousHallwayPos.pos;
        BlockPos newHallwayPos = DungeonGenerationHandler.RoomblockPosByDirection(previousHallwayPos.direction, 0, previousHallwayPos.pos);
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE));
            previousHallwayPos.pos = newHallwayPos.m_122030_(10).m_122020_(7);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            if (!Objects.equals(room_name, "dungeon/room/small_room_end")) {
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway");
            }
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, originalPos.m_122030_(10).m_122013_(2).m_6630_(2), Rotation.CLOCKWISE_90, true);
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180));
            previousHallwayPos.pos = newHallwayPos.m_122025_(10).m_122013_(7);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            if (!Objects.equals(room_name, "dungeon/room/small_room_end")) {
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway");
            }
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, originalPos.m_122025_(10).m_122020_(2).m_6630_(2), Rotation.COUNTERCLOCKWISE_90, true);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90));
            previousHallwayPos.pos = newHallwayPos.m_122020_(10).m_122025_(7);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            if (!Objects.equals(room_name, "dungeon/room/small_room_end")) {
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway");
            }
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, originalPos.m_122020_(10).m_122030_(2).m_6630_(2), Rotation.CLOCKWISE_180, true);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, room_name, previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90));
            previousHallwayPos.pos = newHallwayPos.m_122013_(10).m_122030_(7);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            if (!Objects.equals(room_name, "dungeon/room/small_room_end")) {
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway");
            }
            DungeonGenerationHandler.placeDungeonUnlockerBlockWithRotation(destinationWorld, originalPos.m_122013_(10).m_122025_(2).m_6630_(2), Rotation.NONE, true);
        }
    }

    public static BlockPos RoomblockPosByDirection(String direction, int distance, BlockPos prevPos) {
        BlockPos pos = prevPos;
        pos = Objects.equals(direction, "east") ? prevPos.m_122030_(distance).m_122013_(7) : (Objects.equals(direction, "west") ? prevPos.m_122025_(distance).m_122020_(7) : (Objects.equals(direction, "south") ? prevPos.m_122020_(distance).m_122030_(7) : prevPos.m_122013_(distance).m_122025_(7)));
        return pos;
    }

    static void loopbackLeft(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld) {
        int prob = DungeonGenerationHandler.getRandomInRange(1, 6);
        if (prob == 1 || prob == 2 || prob == 3 || prob == 4) {
            DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
            DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
            DungeonGenerationHandler.placeLongCornerHallway(previousHallwayPos, manager, destinationWorld, 19);
        } else {
            int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
            DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
            if (probroomend == 5 || probroomend == 6) {
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway_end");
            } else {
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
                DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
            }
        }
    }

    static void loopbackRight(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld) {
        int prob = DungeonGenerationHandler.getRandomInRange(1, 6);
        if (prob == 1 || prob == 2 || prob == 3 || prob == 4) {
            int prob2 = DungeonGenerationHandler.getRandomInRange(1, 2);
            if (prob2 == 1) {
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
                DungeonGenerationHandler.placeLongCornerHallway(previousHallwayPos, manager, destinationWorld, 19);
            } else {
                DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, "dungeon/hallway/thin_hallway");
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
                DungeonGenerationHandler.placeLongCornerHallway(previousHallwayPos, manager, destinationWorld, 19);
            }
        } else {
            int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
            DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway");
            if (probroomend == 5 || probroomend == 6) {
                DungeonGenerationHandler.placeCornerHallway(previousHallwayPos, manager, destinationWorld, "dungeon/hallway/thin_hallway_end");
            } else {
                if (Objects.equals(previousHallwayPos.direction, "east")) {
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(9).m_122020_(5);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
                    previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                    previousHallwayPos.direction = "south";
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(0).m_122025_(4);
                } else if (Objects.equals(previousHallwayPos.direction, "south")) {
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(9).m_122025_(5);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
                    previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
                    previousHallwayPos.direction = "west";
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(0).m_122013_(4);
                } else if (Objects.equals(previousHallwayPos.direction, "west")) {
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(9).m_122013_(5);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
                    previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
                    previousHallwayPos.direction = "north";
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(0).m_122030_(4);
                } else if (Objects.equals(previousHallwayPos.direction, "north")) {
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(9).m_122030_(5);
                    DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
                    previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
                    previousHallwayPos.direction = "east";
                    previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(0).m_122020_(4);
                }
                DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
            }
        }
    }

    static void place2wayHallway(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld, String success_direction_left_or_right, String not_success_loopback_or_deadend_or_stairs, int hallway_length) {
        boolean left_success = false;
        int not_success_case = 1;
        if (Objects.equals(not_success_loopback_or_deadend_or_stairs, "loopback")) {
            not_success_case = DungeonGenerationHandler.getRandomInRange(1, 3);
        } else if (Objects.equals(not_success_loopback_or_deadend_or_stairs, "deadend")) {
            not_success_case = DungeonGenerationHandler.getRandomInRange(4, 5);
        } else if (Objects.equals(not_success_loopback_or_deadend_or_stairs, "stairs")) {
            not_success_case = 6;
        }
        if (Objects.equals(success_direction_left_or_right, "left")) {
            left_success = true;
        }
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(9).m_122020_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_t", previousHallwayPos.hallwaySettings);
            String original_direction = previousHallwayPos.direction;
            BlockPos original_pos = previousHallwayPos.pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
                previousHallwayPos.direction = "north";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackLeft(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            } else {
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                previousHallwayPos.direction = "south";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(14).m_122025_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackRight(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            }
            previousHallwayPos.pos = original_pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                previousHallwayPos.direction = "south";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(14).m_122025_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            } else if (left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
                previousHallwayPos.direction = "north";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            }
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(9).m_122025_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_t", previousHallwayPos.hallwaySettings);
            String original_direction = previousHallwayPos.direction;
            BlockPos original_pos = previousHallwayPos.pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
                previousHallwayPos.direction = "east";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackLeft(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            } else {
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
                previousHallwayPos.direction = "west";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(14).m_122013_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackRight(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            }
            previousHallwayPos.pos = original_pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
                previousHallwayPos.direction = "west";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(14).m_122013_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            } else if (left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
                previousHallwayPos.direction = "east";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            }
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            BlockPos original_pos;
            previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(9).m_122013_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_t", previousHallwayPos.hallwaySettings);
            String original_direction = previousHallwayPos.direction;
            previousHallwayPos.pos = original_pos = previousHallwayPos.pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                previousHallwayPos.direction = "south";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackLeft(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            } else {
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
                previousHallwayPos.direction = "north";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(14).m_122030_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackRight(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            }
            previousHallwayPos.pos = original_pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
                previousHallwayPos.direction = "north";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(14).m_122030_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            } else if (left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                previousHallwayPos.direction = "south";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            }
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            BlockPos original_pos;
            previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(9).m_122030_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_t", previousHallwayPos.hallwaySettings);
            String original_direction = previousHallwayPos.direction;
            previousHallwayPos.pos = original_pos = previousHallwayPos.pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
                previousHallwayPos.direction = "west";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackLeft(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            } else {
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
                previousHallwayPos.direction = "east";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(14).m_122020_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
                if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                    DungeonGenerationHandler.loopbackRight(previousHallwayPos, manager, destinationWorld);
                } else if (not_success_case == 4 || not_success_case == 5) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
                    int probroomend = DungeonGenerationHandler.getRandomInRange(1, 6);
                    if (probroomend == 5 || probroomend == 6) {
                        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/thin_hallway_end", previousHallwayPos.hallwaySettings);
                    } else {
                        DungeonGenerationHandler.placeDeadendRoom(manager, destinationWorld, previousHallwayPos);
                    }
                } else if (not_success_case == 6) {
                    DungeonGenerationHandler.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, "dungeon/hallway/thin_hallway");
                    DungeonGenerationHandler.placeStairs(previousHallwayPos, manager, destinationWorld);
                }
            }
            previousHallwayPos.pos = original_pos;
            previousHallwayPos.direction = original_direction;
            if (!left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
                previousHallwayPos.direction = "east";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(14).m_122020_(4);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            } else if (left_success) {
                previousHallwayPos.direction = original_direction;
                previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
                previousHallwayPos.direction = "west";
                previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(28);
                DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            }
        }
    }

    static void placeCornerHallway(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld, String thin_hallway) {
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(9).m_122020_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            previousHallwayPos.direction = "south";
            previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(14).m_122025_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, thin_hallway, previousHallwayPos.hallwaySettings);
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(9).m_122025_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            previousHallwayPos.direction = "west";
            previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(14).m_122013_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, thin_hallway, previousHallwayPos.hallwaySettings);
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(9).m_122013_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            previousHallwayPos.direction = "north";
            previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(14).m_122030_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, thin_hallway, previousHallwayPos.hallwaySettings);
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(9).m_122030_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            previousHallwayPos.direction = "east";
            previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(14).m_122020_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, thin_hallway, previousHallwayPos.hallwaySettings);
        }
    }

    static void placeLongCornerHallway(MutableBlockPos previousHallwayPos, StructureTemplateManager manager, ServerLevel destinationWorld, int length) {
        if (Objects.equals(previousHallwayPos.direction, "east")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122030_(9).m_122020_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings = previousHallwayPos.hallwaySettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            previousHallwayPos.direction = "south";
            if (length < 14) {
                length = 14;
            } else if (length > 28) {
                length = 28;
            }
            BlockPos newHallwayPos = previousHallwayPos.pos.m_122020_(14).m_122025_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
            newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, length - 14, previousHallwayPos.pos);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
        } else if (Objects.equals(previousHallwayPos.direction, "south")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122020_(9).m_122025_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.NONE);
            previousHallwayPos.direction = "west";
            if (length < 14) {
                length = 14;
            } else if (length > 28) {
                length = 28;
            }
            BlockPos newHallwayPos = previousHallwayPos.pos.m_122025_(14).m_122013_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
            newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, length - 14, previousHallwayPos.pos);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
        } else if (Objects.equals(previousHallwayPos.direction, "west")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122025_(9).m_122013_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_90);
            previousHallwayPos.direction = "north";
            if (length < 14) {
                length = 14;
            } else if (length > 28) {
                length = 28;
            }
            BlockPos newHallwayPos = previousHallwayPos.pos.m_122013_(14).m_122030_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
            newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, length - 14, previousHallwayPos.pos);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
        } else if (Objects.equals(previousHallwayPos.direction, "north")) {
            previousHallwayPos.pos = previousHallwayPos.pos.m_122013_(9).m_122030_(5);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, previousHallwayPos.pos, "dungeon/hallway/thin_hallway_corner", previousHallwayPos.hallwaySettings);
            previousHallwayPos.hallwaySettings.m_74379_(Rotation.CLOCKWISE_180);
            previousHallwayPos.direction = "east";
            if (length < 14) {
                length = 14;
            } else if (length > 28) {
                length = 28;
            }
            BlockPos newHallwayPos = previousHallwayPos.pos.m_122030_(14).m_122020_(4);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
            newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, length - 14, previousHallwayPos.pos);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, "dungeon/hallway/long_thin_hallway", previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
        }
    }

    static void placeThinHallways(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos, int n, String thin_hallway) {
        for (int i = 0; i < n; ++i) {
            BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
            DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, thin_hallway, previousHallwayPos.hallwaySettings);
            previousHallwayPos.pos = newHallwayPos;
        }
    }

    static void placeLongThinHallways(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos, int length_min14_max28, String thin_hallway) {
        if (length_min14_max28 < 14) {
            length_min14_max28 = 14;
        } else if (length_min14_max28 > 28) {
            length_min14_max28 = 28;
        }
        BlockPos newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, 14, previousHallwayPos.pos);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, thin_hallway, previousHallwayPos.hallwaySettings);
        previousHallwayPos.pos = newHallwayPos;
        newHallwayPos = DungeonGenerationHandler.blockPosByDirection(previousHallwayPos.direction, length_min14_max28 - 14, previousHallwayPos.pos);
        DungeonGenerationHandler.placeStructure(manager, destinationWorld, newHallwayPos, thin_hallway, previousHallwayPos.hallwaySettings);
        previousHallwayPos.pos = newHallwayPos;
    }

    public static BlockPos blockPosByDirection(String direction, int distance, BlockPos prevPos) {
        BlockPos pos = prevPos;
        pos = Objects.equals(direction, "east") ? prevPos.m_122030_(distance) : (Objects.equals(direction, "west") ? prevPos.m_122025_(distance) : (Objects.equals(direction, "south") ? prevPos.m_122020_(distance) : prevPos.m_122013_(distance)));
        return pos;
    }

    public static int getRandomInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    private static void placeStructure(StructureTemplateManager manager, ServerLevel world, BlockPos pos, String structurePath, StructurePlaceSettings settings) {
        manager.m_230407_(Database.rl(structurePath)).ifPresent(template -> template.m_230328_((ServerLevelAccessor)world, pos, pos, settings, world.m_213780_(), 3));
    }

    public static void placeDungeonUnlockerBlockWithRotation(ServerLevel destinationWorld, BlockPos pos, Rotation rotation, boolean canGenerate) {
        if (rotation == null) {
            throw new IllegalArgumentException("Rotation cannot be null.");
        }
        Direction baseDirection = Direction.NORTH;
        Direction facing = rotation.m_55954_(baseDirection);
        if (!facing.m_122434_().m_122479_()) {
            throw new IllegalArgumentException("DungeonUnlockerBlock can only face horizontal directions.");
        }
        BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)((DungeonUnlockerBlock)((Object)BeyondBlocks.DUNGEON_UNLOCKER_BLOCK.get())).m_49966_().m_61124_((Property)DungeonUnlockerBlock.FACING, (Comparable)facing)).m_61124_((Property)DungeonUnlockerBlock.CAN_GENERATE, (Comparable)Boolean.valueOf(canGenerate))).m_61124_((Property)DungeonUnlockerBlock.ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DungeonUnlockerBlock.ANIM_STAGE, (Comparable)Integer.valueOf(0));
        Block existingBlock = destinationWorld.m_8055_(pos).m_60734_();
        if (existingBlock != Blocks.f_50016_) {
            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)existingBlock);
            System.err.println("Cannot place DungeonUnlockerBlock at " + String.valueOf(pos) + " as it is already occupied by " + (registryName != null ? registryName.toString() : "Unknown Block"));
            return;
        }
        boolean success = destinationWorld.m_7731_(pos, blockState, 3);
        if (!success) {
            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)existingBlock);
            System.err.println("Failed to place DungeonUnlockerBlock at " + String.valueOf(pos) + " with rotation " + String.valueOf(rotation) + " and canGenerate " + canGenerate);
        } else {
            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)((Block)BeyondBlocks.DUNGEON_UNLOCKER_BLOCK.get()));
            System.out.println("Successfully placed DungeonUnlockerBlock (" + (registryName != null ? registryName.toString() : "Unknown") + ") at " + String.valueOf(pos) + " facing " + String.valueOf(facing) + " with canGenerate=" + canGenerate);
        }
    }
}

