/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraArmorItems;
import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import io.github.Memoires.trbeyond.block.DungeonChestBlock;
import io.github.Memoires.trbeyond.block.entity.DungeonChestBlockEntity;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.capability.dungeon.IDungeonCapability;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.capability.entities.IEliteMobCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.data.BeyondTags;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DungeonLootHandler {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        if (entity.m_9236_().m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeathLowPriority(LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity entity = e.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY) && !(entity instanceof Player)) {
            ServerLevel serverLevel;
            MinecraftServer server;
            Object saveData;
            Player player;
            Entity entity2;
            if (entity.m_6095_().m_204039_(BeyondTags.DUNGEON_BOSS) && (entity2 = e.getSource().m_7639_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                LivingEntity livingEntity = SkillHelper.getSubordinateOwner((LivingEntity)attacker);
                if (livingEntity instanceof Player) {
                    player = (Player)livingEntity;
                    attacker = player;
                }
                if (attacker instanceof Player) {
                    player = (Player)attacker;
                    saveData = DungeonSaveData.getOverworld(level);
                    if (saveData != null && !saveData.isOnBossCooldown(entity, player)) {
                        DungeonChestBlockEntity chest;
                        Object object;
                        int i;
                        saveData.setBossCooldown(entity, player, 72000);
                        BlockPos chestPos = entity.m_20183_();
                        BlockPos chestPos2 = entity.m_20183_().m_6625_(1);
                        for (i = 0; i < 10; ++i) {
                            chestPos = entity.m_20183_().m_6625_(i);
                            if (level.m_8055_(chestPos).m_60795_() && level.m_8055_(chestPos.m_121945_(Direction.NORTH)).m_60795_() && level.m_8055_(chestPos.m_121945_(Direction.EAST)).m_60795_() && level.m_8055_(chestPos.m_121945_(Direction.SOUTH)).m_60795_() && level.m_8055_(chestPos.m_121945_(Direction.WEST)).m_60795_()) continue;
                            chestPos = chestPos.m_7494_();
                            break;
                        }
                        if (level.m_8055_(chestPos).m_60795_()) {
                            level.m_7731_(chestPos, ((Block)BeyondBlocks.GOLD_CHEST.get()).m_49966_(), 3);
                            DungeonChestBlock dun = (DungeonChestBlock)level.m_8055_(chestPos).m_60734_();
                            chestPos2 = chestPos.m_121945_(DungeonChestBlock.getConnectedDirection(level.m_8055_(chestPos)));
                            level.m_7731_(chestPos2, (BlockState)dun.m_49966_().m_61124_(DungeonChestBlock.TYPE, (Comparable)((ChestType)level.m_8055_(chestPos).m_61143_(DungeonChestBlock.TYPE)).m_61486_()), 3);
                            level.m_8055_(chestPos).m_60701_((LevelAccessor)level, chestPos, 3);
                            object = level.m_7702_(chestPos);
                            if (object instanceof DungeonChestBlockEntity) {
                                chest = (DungeonChestBlockEntity)((Object)object);
                                chest.getPersistentData().m_128356_("placedTime", level.m_46467_());
                            }
                            DungeonSaveData.getOverworld(level).addBossChest(chestPos);
                        }
                        for (i = 0; i < 2; ++i) {
                            object = level.m_7702_(i == 0 ? chestPos : chestPos2);
                            if (!(object instanceof DungeonChestBlockEntity)) continue;
                            chest = (DungeonChestBlockEntity)((Object)object);
                            chest.m_59626_(ResourceLocation.m_135822_((String)((String)ServerConfig.INSTANCE.dungeonConfig.bossChestLoot.get()), (char)':'), level.m_213780_().m_188505_());
                            chest.m_59640_(player);
                            chest.m_6596_();
                            if (i != 0) continue;
                            chest.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                                if (level.m_213780_().m_188501_() < 0.05f) {
                                    ItemStack loot = new ItemStack((ItemLike)TensuraMaterialItems.GOLD_COIN.get());
                                    if (entity instanceof BossBlackSpiderEntity) {
                                        loot = new ItemStack((ItemLike)BeyondToolItems.SPIDER_DAGGER_SPECIAL.get());
                                    }
                                    for (int j = 0; j < h.getSlots(); ++j) {
                                        if (!h.getStackInSlot(j).m_41619_()) continue;
                                        h.insertItem(j, loot, false);
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
            }
            float chance = (float)entity.f_19853_.m_46469_().m_46215_(BeyondGamerules.LOOT_EXPLOSION_CHANCE) / 1000.0f;
            if (entity.getPersistentData().m_128441_("challengeMob") && (saveData = e.getSource().m_7639_()) instanceof Player && DungeonCapability.getFrom((LivingEntity)(player = (Player)saveData)).isPresent()) {
                chance += (float)((double)((IDungeonCapability)DungeonCapability.getFrom((LivingEntity)player).resolve().get()).getTotalChallengeCompletionCount() * 0.001);
            }
            boolean loot = entity.m_217043_().m_188501_() < chance;
            EntityType entityType = entity.m_6095_();
            if (entityType.m_204039_(BeyondTags.LOOT_T1)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get()), 0.01f, 1, 3, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.LOW_POTION.get()), 5.0E-4f, 1, 1, loot);
            } else if (entityType.m_204039_(BeyondTags.LOOT_T2)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get()), 0.02f, 1, 3, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.LOW_POTION.get()), 0.01f, 1, 1, loot);
            } else if (entityType.m_204039_(BeyondTags.LOOT_T3)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get()), 0.03f, 1, 3, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get()), 0.001f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.LOW_POTION.get()), 0.01f, 1, 1, false);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.HIGH_POTION.get()), 0.005f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.T3_GEAR, 0.01f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.ELEMENTAL_CORES, 0.005f, 1, 1, false);
            } else if (entityType.m_204039_(BeyondTags.LOOT_T4)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get()), 0.02f, 1, 3, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get()), 0.01f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.HIGH_POTION.get()), 0.005f, 1, 1, loot);
            } else if (entityType.m_204039_(BeyondTags.LOOT_T5)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get()), 0.04f, 5, 10, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get()), 0.005f, 1, 3, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.HIGH_POTION.get()), 0.02f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.T5_GEAR, 0.01f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.ELEMENTAL_CORES, 0.01f, 1, 1, false);
            } else if (entityType.m_204039_(BeyondTags.LOOT_T6)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get()), 0.04f, 5, 10, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get()), 0.005f, 1, 10, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.HIGH_POTION.get()), 0.02f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.T6_GEAR, 0.05f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.ELEMENTAL_CORES, 0.05f, 1, 1, loot);
            } else if (entityType.m_204039_(BeyondTags.LOOT_T7)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get()), 1.0f, 1, 10, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.FULL_POTION.get()), 0.5f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.T7_GEAR, 0.1f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.ELEMENTAL_CORES, 0.1f, 1, 1, loot);
            } else if (entityType == BeyondEntities.BOSS_BLACK_SPIDER.get()) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get()), 0.5f, 1, 2, loot);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraConsumableItems.HIGH_POTION.get()), 0.2f, 1, 1, loot);
                DungeonLootHandler.spawnLoot(entity, LootTables.T7_GEAR, 0.1f, 1, 1, false);
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)BeyondToolItems.SPIDER_DAGGER_RARE.get()), 0.15f, 1, 1, loot);
            }
            if (entityType == TensuraEntityTypes.BLADE_TIGER.get()) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraToolItems.BLADE_TIGER_SCYTHE.get()), 0.05f, 1, 1, loot);
            } else if (entityType.m_204039_(BeyondTags.SLIME_DOLLS)) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMobDropItems.SLIME_CORE.get()), 0.01f, 1, 1, loot);
            } else if (entityType == BeyondEntities.SLIME_DOLL_BOSS.get()) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMobDropItems.SLIME_CORE.get()), 0.05f, 1, 1, loot);
            } else if (entityType == BeyondEntities.STELLAR_MIMIC_BOSS.get()) {
                DungeonLootHandler.spawnLoot(entity, new ItemStack((ItemLike)TensuraMaterialItems.GOLD_COIN.get()), 0.05f, 1, 1, loot);
            }
            if (EliteMobCapability.getFrom(entity).map(IEliteMobCapability::isElite).orElse(false).booleanValue() && (server = level.m_7654_()) != null && (serverLevel = server.m_129880_(level.m_46472_())) != null) {
                LootTable lootTable = entity.getPersistentData().m_128441_("") ? level.m_7654_().m_129898_().m_79217_(new ResourceLocation("trbeyond", "elites/shrine_elite")) : level.m_7654_().m_129898_().m_79217_(new ResourceLocation("trbeyond", "elites/dungeon_elite"));
                ObjectArrayList items = lootTable.m_230922_(new LootContext.Builder(serverLevel).m_78975_(LootContextParamSets.f_81410_));
                for (ItemStack item : items) {
                    entity.m_19983_(item);
                }
            }
            if (loot) {
                DungeonLootHandler.lootExplosion(entity);
            }
        }
    }

    private static void spawnLoot(LivingEntity entity, Object itemOrList, float chance, int min, int max, boolean loot) {
        List list;
        Random random = new Random();
        if (loot) {
            chance = 1.0f;
            if (itemOrList instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)itemOrList;
                if (itemStack.m_41720_() == TensuraMaterialItems.BRONZE_COIN.get() || itemStack.m_150930_((Item)TensuraMaterialItems.SILVER_COIN.get()) || itemStack.m_150930_((Item)TensuraMaterialItems.GOLD_COIN.get())) {
                    min *= 10;
                    max *= 10;
                } else {
                    ++min;
                    max += 2;
                }
            } else if (itemOrList instanceof List) {
                ++min;
                max += 2;
            }
        }
        if (EliteMobCapability.getFrom(entity).map(IEliteMobCapability::isElite).orElse(false).booleanValue()) {
            chance = Math.min(chance * 10.0f, 1.0f);
        }
        if (random.nextFloat() > chance) {
            return;
        }
        if (itemOrList instanceof ItemStack) {
            ItemStack item = (ItemStack)itemOrList;
            if (item.m_41720_().m_41459_() > 1) {
                for (amount = DungeonLootHandler.getRandomInRange(min, max); amount > 0; amount -= item.m_41613_()) {
                    item.m_41764_(Math.min(amount, item.m_41741_()));
                    entity.m_19983_(item);
                }
            } else {
                for (int i = 0; i < amount; ++i) {
                    entity.m_19983_(item);
                }
            }
        } else if (itemOrList instanceof List && !(list = (List)itemOrList).isEmpty()) {
            Object chosenItem = list.get(random.nextInt(list.size()));
            if (chosenItem instanceof ItemStack) {
                ItemStack item = (ItemStack)chosenItem;
                if (item.m_41720_().m_41459_() > 1) {
                    while (amount > 0) {
                        item.m_41764_(Math.min(amount, item.m_41741_()));
                        amount -= item.m_41613_();
                        entity.m_19983_(item);
                    }
                } else {
                    for (int i = 0; i < amount; ++i) {
                        entity.m_19983_(item);
                    }
                }
            } else if (chosenItem instanceof List) {
                DungeonLootHandler.spawnLoot(entity, chosenItem, 1.0f, amount, amount, false);
            }
        }
    }

    private static void lootExplosion(LivingEntity entity) {
        entity.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_11928_, SoundSource.HOSTILE, 1.0f, 1.0f);
        entity.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_11928_, SoundSource.HOSTILE, 1.0f, 1.0f);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
            CompoundTag tag = new CompoundTag();
            CompoundTag explosion = new CompoundTag();
            int[] colors = new int[]{0xFF0000, 0xFF7F00, 0xFFFF00, 65280, 255, 4915330, 9109759};
            explosion.m_128385_("Colors", colors);
            explosion.m_128379_("Flicker", true);
            explosion.m_128379_("Trail", true);
            explosion.m_128344_("Type", (byte)0);
            ListTag explosions = new ListTag();
            explosions.add((Object)explosion);
            CompoundTag fireworksTag = new CompoundTag();
            fireworksTag.m_128365_("Explosions", (Tag)explosions);
            fireworksTag.m_128344_("Flight", (byte)1);
            tag.m_128365_("Fireworks", (Tag)fireworksTag);
            firework.m_41751_(tag);
            FireworkRocketEntity fireworkEntity = new FireworkRocketEntity((Level)serverLevel, firework, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), true);
            serverLevel.m_7967_((Entity)fireworkEntity);
        }
        entity.m_146870_();
    }

    private static ItemStack getCoinDropFor(LivingEntity entity) {
        if (entity.m_6095_().m_204039_(BeyondTags.DUNGEON_BOSS)) {
            return new ItemStack((ItemLike)TensuraMaterialItems.GOLD_COIN.get());
        }
        if (entity.m_6095_().m_204039_(BeyondTags.LOOT_T3) || entity.m_6095_().m_204039_(BeyondTags.LOOT_T4) || entity.m_6095_().m_204039_(BeyondTags.LOOT_T5) || entity.m_6095_().m_204039_(BeyondTags.LOOT_T6) || entity.m_6095_().m_204039_(BeyondTags.LOOT_T7)) {
            return new ItemStack((ItemLike)TensuraMaterialItems.SILVER_COIN.get());
        }
        return new ItemStack((ItemLike)TensuraMaterialItems.BRONZE_COIN.get());
    }

    public static int getRandomInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    private static class LootTables {
        private static final List<ItemStack> ANT_ARMOR = List.of(new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_CHESTPLATE.get()), new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_BOOTS.get()), new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_HELMET.get()), new ItemStack((ItemLike)TensuraArmorItems.ANT_CARAPACE_LEGGINGS.get()));
        private static final List<ItemStack> KNIGHT_SPIDER_ARMOR = List.of(new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_BOOTS.get()), new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_CHESTPLATE.get()), new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_LEGGINGS.get()), new ItemStack((ItemLike)TensuraArmorItems.KNIGHT_SPIDER_CARAPACE_HELMET.get()));
        private static final List<ItemStack> ARMOURSAURUS_ARMOR = List.of(new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_BOOTS.get()), new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_CHESTPLATE.get()), new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_HELMET.get()), new ItemStack((ItemLike)TensuraArmorItems.ARMOURSAURUS_SCALEMAIL_LEGGINGS.get()));
        private static final List<ItemStack> SERPENT_ARMOR = List.of(new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_BOOTS.get()), new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_CHESTPLATE.get()), new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_HELMET.get()), new ItemStack((ItemLike)TensuraArmorItems.SERPENT_SCALEMAIL_LEGGINGS.get()));
        private static final List<ItemStack> LOW_MAGISTEEL_WEAPONS = List.of(new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_AXE.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_SWORD.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_SHORT_SWORD.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_LONG_SWORD.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_GREAT_SWORD.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_KATANA.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_KODACHI.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_TACHI.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_ODACHI.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.LOW_MAGISTEEL_SCYTHE.get()));
        private static final List<ItemStack> LOW_MAGISTEEL_ARMOR = List.of(new ItemStack((ItemLike)TensuraArmorItems.LOW_MAGISTEEL_BOOTS.get()), new ItemStack((ItemLike)TensuraArmorItems.LOW_MAGISTEEL_CHESTPLATE.get()), new ItemStack((ItemLike)TensuraArmorItems.LOW_MAGISTEEL_HELMET.get()), new ItemStack((ItemLike)TensuraArmorItems.LOW_MAGISTEEL_LEGGINGS.get()));
        private static final List<ItemStack> ELEMENTAL_CORES = List.of(new ItemStack((ItemLike)TensuraMaterialItems.ELEMENT_CORE_FIRE.get()), new ItemStack((ItemLike)TensuraMaterialItems.ELEMENT_CORE_EARTH.get()), new ItemStack((ItemLike)TensuraMaterialItems.ELEMENT_CORE_EMPTY.get()), new ItemStack((ItemLike)TensuraMaterialItems.ELEMENT_CORE_SPACE.get()), new ItemStack((ItemLike)TensuraMaterialItems.ELEMENT_CORE_WATER.get()), new ItemStack((ItemLike)TensuraMaterialItems.ELEMENT_CORE_WIND.get()));
        private static final List<Object> T3_GEAR = List.of(new ItemStack((ItemLike)TensuraToolItems.SPIDER_BOW.get()), new ItemStack((ItemLike)TensuraToolItems.ANT_CROSSBOW.get()), new ItemStack((ItemLike)TensuraToolItems.GOBLIN_CLUB.get()), ANT_ARMOR, KNIGHT_SPIDER_ARMOR);
        private static final List<Object> T5_GEAR = List.of(new ItemStack((ItemLike)TensuraToolItems.SPIDER_BOW.get()), new ItemStack((ItemLike)TensuraToolItems.ANT_CROSSBOW.get()), new ItemStack((ItemLike)TensuraToolItems.GOBLIN_CLUB.get()), ANT_ARMOR, KNIGHT_SPIDER_ARMOR, LOW_MAGISTEEL_ARMOR, LOW_MAGISTEEL_WEAPONS);
        private static final List<Object> T6_GEAR = List.of(new ItemStack((ItemLike)TensuraToolItems.KANABO.get()), new ItemStack((ItemLike)TensuraToolItems.BEAST_HORN_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.UNICORN_HORN_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.ICE_BLADE.get()), new ItemStack((ItemLike)TensuraToolItems.VORTEX_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_KNIFE.get()), new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_SWORD.get()), new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_SHIELD.get()), ARMOURSAURUS_ARMOR, SERPENT_ARMOR, LOW_MAGISTEEL_ARMOR, LOW_MAGISTEEL_WEAPONS);
        private static final List<Object> T7_GEAR = List.of(new ItemStack((ItemLike)TensuraToolItems.KANABO.get()), new ItemStack((ItemLike)TensuraToolItems.BEAST_HORN_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.UNICORN_HORN_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.ICE_BLADE.get()), new ItemStack((ItemLike)TensuraToolItems.VORTEX_SPEAR.get()), new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_KNIFE.get()), new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_SWORD.get()), new ItemStack((ItemLike)TensuraToolItems.TEMPEST_SCALE_SHIELD.get()), ARMOURSAURUS_ARMOR, SERPENT_ARMOR);

        private LootTables() {
        }
    }
}

