/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.block.HipokuteGrass;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.event.NamingEvent;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import io.github.Memoires.trbeyond.capability.boss.BeyondBossCapability;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.data.BeyondTags;
import io.github.Memoires.trbeyond.entity.custom.KillerDryadEntity;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.util.TimerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class DungeonRulesHandler {
    public static final Map<UUID, BlockPos> playerPositions = new HashMap<UUID, BlockPos>();
    public static final int CAMP_TIME = 12000;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            if (level.m_5776_()) {
                return;
            }
            if (level.m_46472_().equals((Object)Level.f_46428_)) {
                DungeonSaveData saveData = DungeonSaveData.getOverworld(level);
                if (saveData == null) {
                    return;
                }
                saveData.tickBossCooldown();
            }
            if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            block4: for (Player player : level.m_6907_()) {
                if (player.m_7500_() || player.m_5833_() || !player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) continue;
                BlockPos currentPos = player.m_20183_();
                BlockPos lastPos = playerPositions.get(player.m_20148_());
                TimerUtils.Timer timer = TimerUtils.getOrCreateTimer(player.m_5446_().getString() + "_idle");
                if (!(player.m_20186_() < 116.0)) continue;
                if (lastPos == null || !DungeonRulesHandler.isWithinArea(currentPos, lastPos)) {
                    timer.start(12000, () -> {});
                    playerPositions.put(player.m_20148_(), currentPos);
                    player.m_21195_(MobEffects.f_19604_);
                    timer.reset();
                    continue;
                }
                switch (timer.getTicks()) {
                    case 6000: {
                        player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
                        player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.rule_violation.confirmed").m_130940_(ChatFormatting.RED), true);
                        continue block4;
                    }
                    case 10800: {
                        player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.rule_violation.one_minute").m_130940_(ChatFormatting.RED), true);
                        level.m_5594_(null, player.m_20183_(), SoundEvents.f_12507_, player.m_5720_(), 1.0f, 1.0f);
                        KillerDryadEntity dryad = new KillerDryadEntity((EntityType<? extends TensuraTamableEntity>)((EntityType)BeyondEntities.KILLER_DRYAD.get()), level);
                        dryad.m_146884_(player.m_20182_());
                        dryad.m_21828_(player);
                        dryad.teleportTowards((LivingEntity)dryad, (Entity)player, 5.0);
                        level.m_7967_((Entity)dryad);
                        continue block4;
                    }
                }
                if (timer.getTicks() < 11600 || timer.getTicks() > 12000) continue;
                player.m_5661_((Component)Component.m_237110_((String)"trbeyond.message.rule_violation.seconds", (Object[])new Object[]{(12000 - timer.getTicks()) / 20}).m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void maxDungeonTime(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            if (level.m_5776_()) {
                return;
            }
            if (level.m_46472_().equals((Object)Level.f_46428_)) {
                DungeonSaveData saveData = DungeonSaveData.getOverworld(level);
                if (saveData == null) {
                    return;
                }
                saveData.tickBossCooldown();
            }
            if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            if ((Integer)ServerConfig.INSTANCE.dungeonConfig.maxDungeonTime.get() == 0) {
                return;
            }
            for (Player player : new ArrayList(level.m_6907_())) {
                if (player.m_7500_() || player.m_5833_() || !player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) continue;
                TimerUtils.Timer timer = TimerUtils.getOrCreateTimer(player.m_5446_().getString() + "_max");
                if (!(player.m_20186_() < 116.0)) continue;
                if (!timer.active) {
                    timer.start((Integer)ServerConfig.INSTANCE.dungeonConfig.maxDungeonTime.get() * 20 * 60, () -> {});
                    continue;
                }
                int maxTicks = (Integer)ServerConfig.INSTANCE.dungeonConfig.maxDungeonTime.get() * 20 * 60;
                int ticks = timer.getTicks();
                if (ticks == (int)((double)maxTicks * 0.8)) {
                    player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.dungeon_ejection").m_130940_(ChatFormatting.RED), true);
                    continue;
                }
                if ((double)ticks == (double)maxTicks * 0.9) {
                    DungeonCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
                        BlockPos overworldCoords = cap.getOverworldCoords();
                        level.m_7654_().execute(() -> SkillHelper.moveAcrossDimensionTo((Entity)player, (double)overworldCoords.m_123341_(), (double)overworldCoords.m_123342_(), (double)overworldCoords.m_123343_(), (float)player.m_146908_(), (float)player.m_146909_(), (ServerLevel)level.m_7654_().m_129783_()));
                    });
                    continue;
                }
                if (ticks < maxTicks - 400 || ticks > maxTicks) continue;
                player.m_5661_((Component)Component.m_237110_((String)"trbeyond.message.rule_violation.seconds", (Object[])new Object[]{(maxTicks - ticks) / 20 - 6}).m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!event.player.f_19853_.f_46443_) {
            event.player.getCapability(BeyondBossCapability.CAPABILITY).ifPresent(cap -> {
                long now = System.currentTimeMillis();
                if (cap.killedSpider() > 0 && now - cap.getSpiderLastKillTime() >= 3600000L) {
                    cap.setKilledSpider(0);
                    cap.setSpiderLastKillTime(0L);
                }
                if (cap.killedCentipede() > 0 && now - cap.getCentipedeLastKillTime() >= 3600000L) {
                    cap.setKilledCentipede(0);
                    cap.setCentipedeLastKillTime(0L);
                }
                if (cap.killedSerpent() > 0 && now - cap.getSerpentLastKillTime() >= 3600000L) {
                    cap.setKilledSerpent(0);
                    cap.setSerpentLastKillTime(0L);
                }
                if (cap.killedOgre() > 0 && now - cap.getOgreLastKillTime() >= 3600000L) {
                    cap.setKilledOgre(0);
                    cap.setOgreLastKillTime(0L);
                }
                if (cap.killedGozul() > 0 && now - cap.getGozulLastKillTime() >= 3600000L) {
                    cap.setKilledGozul(0);
                    cap.setGozulLastKillTime(0L);
                }
                if (cap.killedMezul() > 0 && now - cap.getMezulLastKillTime() >= 3600000L) {
                    cap.setKilledMezul(0);
                    cap.setMezulLastKillTime(0L);
                }
            });
            BeyondPlayerCapability.sync(event.player);
        }
    }

    @SubscribeEvent
    public static void playerInBossRoom(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            if (level.m_5776_()) {
                return;
            }
            if (level.m_46472_().equals((Object)Level.f_46428_)) {
                DungeonSaveData saveData = DungeonSaveData.getOverworld(level);
                if (saveData == null) {
                    return;
                }
                saveData.tickBossCooldown();
            }
            if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                return;
            }
            for (Player player : level.m_6907_()) {
                if (player.m_7500_() || player.m_5833_() || !player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) continue;
                TimerUtils.Timer timer = TimerUtils.getOrCreateTimer(player.m_5446_().getString() + "_boss");
                if (player.m_20186_() <= 42.0) {
                    BeyondBossCapability.getFrom(player).ifPresent(cap -> {
                        if (cap.killedSpider() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get()) {
                            player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
                            player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.boss_rule_violation.confirmed").m_130940_(ChatFormatting.RED), true);
                        }
                        if (cap.killedSpider() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() + 1) {
                            if (!timer.active) {
                                timer.start(20, () -> {});
                            }
                            DungeonRulesHandler.spawnDryad(player, level, timer);
                        }
                    });
                    continue;
                }
                if (player.m_20186_() >= 166.0 && player.m_20186_() < 178.0) {
                    BeyondBossCapability.getFrom(player).ifPresent(cap -> {
                        if (cap.killedCentipede() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() || cap.killedOgre() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() || cap.killedSerpent() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() || cap.killedMezul() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() || cap.killedGozul() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get()) {
                            player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
                            player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.boss_rule_violation.confirmed").m_130940_(ChatFormatting.RED), true);
                        }
                        if (cap.killedCentipede() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() + 1 || cap.killedOgre() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() + 1 || cap.killedSerpent() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() + 1 || cap.killedMezul() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() + 1 || cap.killedGozul() >= (Integer)ServerConfig.INSTANCE.bossConfig.bossKillCap.get() + 1) {
                            if (!timer.active) {
                                timer.start(200, () -> {});
                            }
                            DungeonRulesHandler.spawnDryad(player, level, timer);
                        }
                    });
                    continue;
                }
                timer.reset();
            }
        }
    }

    private static void spawnDryad(Player player, Level level, TimerUtils.Timer timer) {
        switch (timer.getTicks()) {
            case 40: {
                KillerDryadEntity dryad = new KillerDryadEntity((EntityType<? extends TensuraTamableEntity>)((EntityType)BeyondEntities.KILLER_DRYAD.get()), level);
                dryad.m_146884_(player.m_20182_());
                dryad.m_21828_(player);
                dryad.teleportTowards((LivingEntity)dryad, (Entity)player, 5.0);
                break;
            }
            default: {
                if (timer.getTicks() >= -380 && timer.getTicks() > 20) break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onSkillGrief(SkillGriefEvent event) {
        if (event.getSkillCaster() == null) {
            return;
        }
        Level level = event.getSkillCaster().m_9236_();
        if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onNaming(NamingEvent event) {
        Player player = event.getNamer();
        LivingEntity named = event.getEntity();
        if (named instanceof Player) {
            return;
        }
        if (player.m_7500_() || player.m_21205_().m_150930_((Item)TensuraToolItems.ORB_OF_DOMINATION.get())) {
            return;
        }
        Level level = player.m_9236_();
        if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.rule_violation.prohibited").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAnimalTame(AnimalTameEvent event) {
        Player player = event.getTamer();
        if (player.m_7500_() || player.m_21205_().m_150930_((Item)TensuraToolItems.ORB_OF_DOMINATION.get())) {
            return;
        }
        Level level = player.m_9236_();
        if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.rule_violation.prohibited").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onBlockToolModification(BlockEvent.BlockToolModificationEvent e) {
        Player player = e.getPlayer();
        if (player == null) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        if (!player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        e.setCanceled(true);
    }

    @SubscribeEvent
    public static void getBreakSpeed(PlayerEvent.BreakSpeed e) {
        Player player = e.getEntity();
        if (player.m_7500_()) {
            return;
        }
        if (e.getState().m_60734_() instanceof HipokuteGrass) {
            return;
        }
        if (!player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        if (e.getState().m_204336_(BeyondTags.DUNGEON_PLACEABLE)) {
            return;
        }
        e.setCanceled(true);
        e.setNewSpeed(0.0f);
    }

    public static boolean isWithinArea(BlockPos pos1, @NotNull BlockPos pos2) {
        return Math.abs(pos1.m_123341_() - pos2.m_123341_()) <= 10 && Math.abs(pos1.m_123343_() - pos2.m_123343_()) <= 10 && Math.abs(pos1.m_123342_() - pos2.m_123342_()) <= 10;
    }
}

