/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.manascore.api.attribute.AttributeModifierHelper;
import com.github.manasmods.manascore.api.skills.event.SkillDamageEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.event.EngravingEvent;
import com.github.manasmods.tensura.event.ItemDamageEvent;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import io.github.Memoires.trbeyond.enchantment.InfusionEnchantment;
import io.github.Memoires.trbeyond.enchantment.SpatialInfusionEnchantment;
import io.github.Memoires.trbeyond.items.armor.BenimaruArmorItem;
import io.github.Memoires.trbeyond.items.armor.DiabloArmorItem;
import io.github.Memoires.trbeyond.items.armor.GabiruArmorItem;
import io.github.Memoires.trbeyond.items.armor.GeldArmorItem;
import io.github.Memoires.trbeyond.items.armor.MinosArmorItem;
import io.github.Memoires.trbeyond.items.armor.OgreArmorItem;
import io.github.Memoires.trbeyond.items.armor.SerpentArmorItem;
import io.github.Memoires.trbeyond.items.armor.ShionArmorItem;
import io.github.Memoires.trbeyond.items.armor.SoueiArmorItem;
import io.github.Memoires.trbeyond.items.weapons.DiabloClawItem;
import io.github.Memoires.trbeyond.items.weapons.GorikimaruItem;
import io.github.Memoires.trbeyond.items.weapons.GurenItem;
import io.github.Memoires.trbeyond.items.weapons.MeatCleaverItem;
import io.github.Memoires.trbeyond.items.weapons.MinosBardicheItem;
import io.github.Memoires.trbeyond.items.weapons.MinosTridentItem;
import io.github.Memoires.trbeyond.items.weapons.OgreAxeItem;
import io.github.Memoires.trbeyond.items.weapons.ShibkoboItem;
import io.github.Memoires.trbeyond.items.weapons.VortexSpearItem;
import io.github.Memoires.trbeyond.items.weapons.scaleShieldItem;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnchantmentHandler {
    public static final UUID EARTH_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("48577585-c015-4b88-8e29-2d136c10666e");
    public static final UUID LAND_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("73456a7f-dc01-4953-87d6-735a2221b9d3");
    public static final UUID WIND_FLYING_SPEED_UUID = UUID.fromString("6324ba8c-f62d-4b18-ada3-4db34fd9eb9b");
    public static final UUID SWIM_SPEED_UUID = UUID.fromString("7d66ee5f-a616-4eff-9768-ce26f673f43c");

    @SubscribeEvent
    public static void onEngraving(EngravingEvent event) {
        ItemStack stack = event.getStack();
        if (stack.m_41720_() instanceof SerpentArmorItem) {
            if (!event.getEnchantment().equals(TensuraEnchantments.STURDY.get())) {
                event.setCanceled(true);
            }
        } else if (stack.m_41720_() instanceof MinosArmorItem && !event.getEnchantment().equals(TensuraEnchantments.HOLY_COAT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void updateEnchantments(LivingEquipmentChangeEvent event) {
        ItemStack fromStack;
        ItemStack toStack = event.getTo();
        if (ItemStack.m_41746_((ItemStack)toStack, (ItemStack)(fromStack = event.getFrom()))) {
            return;
        }
        LivingEntity entity = event.getEntity();
        OgreArmorItem.applyEffects(toStack, fromStack, entity, event.getSlot());
        SerpentArmorItem.applySturdy(toStack, fromStack, entity, event.getSlot());
        MinosArmorItem.applyHolyCoat(toStack, fromStack, entity, event.getSlot());
        GorikimaruItem.applyEnchants(toStack, fromStack, event.getSlot());
        GurenItem.applyEnchants(toStack, fromStack, event.getSlot());
        DiabloClawItem.applyEnchants(toStack, fromStack, event.getSlot());
        GeldArmorItem.applyEnchants(toStack, fromStack, event.getSlot());
        ShionArmorItem.applyBattleInfusion(toStack, fromStack, entity, event.getSlot());
        BenimaruArmorItem.applyFlameCoat(toStack, fromStack, entity, event.getSlot());
        DiabloArmorItem.applyEnchants(toStack, fromStack, event.getSlot());
        SoueiArmorItem.applyEnchants(toStack, fromStack, event.getSlot());
        GabiruArmorItem.applyEnchants(toStack, fromStack, event.getSlot());
        MinosTridentItem.applyEnchants(entity);
        MinosBardicheItem.applyEnchants(toStack, entity, event.getSlot());
        MeatCleaverItem.applyEnchants(toStack, fromStack, event.getSlot());
        scaleShieldItem.applyEnchants(toStack, fromStack, event.getSlot());
        ShibkoboItem.applyEnchants(toStack, fromStack, event.getSlot());
        VortexSpearItem.applyEnchants(toStack, fromStack, event.getSlot());
        InfusionEnchantment.addInfusionAttribute(event, (Enchantment)BeyondEnchantments.EARTH_INFUSION.get(), Attributes.f_22278_, EARTH_KNOCKBACK_RESISTANCE_UUID, 0.25f);
        InfusionEnchantment.addInfusionAttribute(event, (Enchantment)BeyondEnchantments.LAND_INFUSION.get(), Attributes.f_22278_, LAND_KNOCKBACK_RESISTANCE_UUID, 0.5f);
        InfusionEnchantment.addInfusionAttribute(event, (Enchantment)BeyondEnchantments.WIND_INFUSION.get(), (Attribute)ManasCoreAttributes.FLYING_SPEED_MULTIPLIER.get(), WIND_FLYING_SPEED_UUID, 1.0f);
        InfusionEnchantment.addInfusionAttribute(event, (Enchantment)BeyondEnchantments.WIND_INFUSION.get(), Attributes.f_22283_, WIND_FLYING_SPEED_UUID, 0.2f);
        if (InfusionEnchantment.hasFullSetEffect(entity, (Enchantment)BeyondEnchantments.WATER_INFUSION.get())) {
            AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (AttributeModifier)new AttributeModifier(SWIM_SPEED_UUID, "Water Infusion", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else {
            AttributeModifierHelper.removeModifier((LivingEntity)entity, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)SWIM_SPEED_UUID);
        }
    }

    @SubscribeEvent
    public static void onGearUseEP(ItemDamageEvent e) {
        ItemStack stack = e.getStack();
        if (stack.m_41720_() instanceof SerpentArmorItem) {
            ServerPlayer player = e.getPlayer();
            if (player == null) {
                return;
            }
            if (player.m_21023_((MobEffect)TensuraMobEffects.CORROSION.get())) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (!player.m_204029_(FluidTags.f_13131_)) {
            return;
        }
        if (InfusionEnchantment.hasFullSetEffect((LivingEntity)player, (Enchantment)BeyondEnchantments.WATER_INFUSION.get())) {
            event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void preCalculation(SkillDamageEvent.PreCalculation e) {
        if (OgreAxeItem.canBoostDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 1.2f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        DamageSource originalSource = event.getSource();
        if (originalSource.m_19378_()) {
            return;
        }
        if (originalSource.m_19385_().equals("physical")) {
            return;
        }
        if (entity2 instanceof Player && (entity = originalSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (InfusionEnchantment.hasFullSetEffect(entity2, (Enchantment)BeyondEnchantments.BATTLE_INFUSION.get())) {
                float damage = event.getAmount();
                event.setCanceled(true);
                DamageSource physical = EnchantmentHandler.makePhysical(attacker);
                entity2.m_6469_(physical, damage);
            }
        }
    }

    private static DamageSource makePhysical(LivingEntity attacker) {
        return new EntityDamageSource("physical", (Entity)attacker);
    }

    @SubscribeEvent
    public void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        MobEffectInstance effect = event.getEffectInstance();
        if (effect.m_19544_() == TensuraMobEffects.SEVERANCE_BLADE.get() && EnchantmentHandler.hasSpatialInfusionInArmor(entity)) {
            event.setCanceled(true);
        }
    }

    private static boolean hasSpatialInfusionInArmor(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armorItem;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorItem = entity.m_6844_(slot)).m_41619_()) continue;
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)armorItem);
            return enchantments.keySet().stream().anyMatch(e -> e instanceof SpatialInfusionEnchantment);
        }
        return false;
    }
}

