/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestTotemDisplayPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.items.weapons.DiabloClawItem;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.registry.items.BeyondItems;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract e) {
        if (e.isCanceled()) {
            return;
        }
        Player player = e.getEntity();
        if (player.f_19853_.m_5776_()) {
            return;
        }
        Entity entity = e.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2 instanceof Player) {
            return;
        }
        if (!player.m_21205_().m_150930_((Item)BeyondItems.REVIVAL_BRACELET.get())) {
            return;
        }
        DungeonCapability.getFrom(entity2).ifPresent(cap -> {
            if (!cap.isRevivalBracelet()) {
                cap.setRevivalBracelet(true);
                DungeonCapability.sync(entity2);
                player.m_21205_().m_41774_(1);
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                entity2.m_9236_().m_6263_(null, entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
                e.setCanceled(true);
            } else if (player.m_6047_()) {
                cap.setRevivalBracelet(false);
                DungeonCapability.sync(entity2);
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                SkillHelper.dropItem((Entity)entity2, (RandomSource)player.m_217043_(), (ItemStack)new ItemStack((ItemLike)BeyondItems.REVIVAL_BRACELET.get()), (int)10, (float)1.0f);
                entity2.m_9236_().m_6263_(null, entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), SoundEvents.f_12016_, SoundSource.PLAYERS, 1.0f, 1.0f);
                e.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDeathLowPriority(LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (entity.m_9236_().m_46472_() != BeyondDungeon.DUNGEON_LEVEL_KEY) {
            return;
        }
        if (e.getSource().m_19378_()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_5833_()) {
                BlockPos deathPos = player.m_20183_();
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!stack.m_150930_((Item)BeyondItems.AUTO_RECORDING_CRYSTAL.get())) continue;
                    stack.m_41784_().m_128347_("savedX", (double)deathPos.m_123341_() + 0.5);
                    stack.m_41784_().m_128347_("savedY", (double)deathPos.m_123342_());
                    stack.m_41784_().m_128347_("savedZ", (double)deathPos.m_123343_() + 0.5);
                    stack.m_41784_().m_128359_("savedDimension", player.f_19853_.m_46472_().m_135782_().toString());
                }
                ItemStack offhandAuto = player.m_21206_();
                if (offhandAuto.m_150930_((Item)BeyondItems.AUTO_RECORDING_CRYSTAL.get())) {
                    offhandAuto.m_41784_().m_128347_("savedX", (double)deathPos.m_123341_() + 0.5);
                    offhandAuto.m_41784_().m_128347_("savedY", (double)deathPos.m_123342_());
                    offhandAuto.m_41784_().m_128347_("savedZ", (double)deathPos.m_123343_() + 0.5);
                    offhandAuto.m_41784_().m_128359_("savedDimension", player.f_19853_.m_46472_().m_135782_().toString());
                }
            }
            if (entity.m_20186_() > 113.0) {
                ItemHandler.revive((LivingEntity)player, e);
                return;
            }
            ItemStack offhand = player.m_21206_();
            if (offhand.m_150930_((Item)BeyondItems.REVIVAL_BRACELET.get())) {
                ItemHandler.revive((LivingEntity)player, e);
                offhand.m_41774_(1);
                return;
            }
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!stack.m_150930_((Item)BeyondItems.REVIVAL_BRACELET.get())) continue;
                ItemHandler.revive((LivingEntity)player, e);
                stack.m_41774_(1);
                break;
            }
        } else if (DungeonCapability.hasRevivalBracelet(entity)) {
            ItemHandler.revive(entity, e);
            DungeonCapability.setRevivalBracelet(entity, false);
        }
    }

    private static void revive(LivingEntity entity, LivingDeathEvent event) {
        ServerPlayer player;
        DungeonSaveData saveData;
        entity.m_21153_(entity.m_21233_());
        TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
            double SHP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (cap.getSpiritualHealth() < SHP * 0.5) {
                cap.setSpiritualHealth(SHP * 0.5);
            }
        });
        event.setCanceled(true);
        entity.f_19802_ = 20;
        SkillHelper.removePredicateEffect((LivingEntity)entity, effect -> true);
        float height = TensuraEffectsCapability.getHeight((LivingEntity)entity);
        TensuraEffectsCapability.resetEverything((LivingEntity)entity, (boolean)false, (boolean)false);
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            TensuraPlayerCapability.getFrom((Player)player2).ifPresent(cap -> cap.setMagicule(Math.max(cap.getMagicule(), player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()) / 100.0)));
            TensuraEffectsCapability.setHeight((Player)player2, (float)height);
            TensuraPlayerCapability.sync((Player)player2);
            TensuraEffectsCapability.sync((LivingEntity)player2);
        }
        if ((saveData = DungeonSaveData.getOverworld(entity.m_9236_())) != null) {
            Vec3 pos = saveData.getStartGenPos();
            entity.m_19877_();
            SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)(pos.m_7096_() + 9.5), (double)(pos.m_7098_() - 23.0), (double)(pos.m_7094_() - 6.5), (float)entity.m_146908_(), (float)entity.m_146909_(), (ServerLevel)entity.m_20194_().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY));
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestTotemDisplayPacket(((Item)BeyondItems.REVIVAL_BRACELET.get()).m_7968_()));
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (entity instanceof ServerPlayer) {
            AdvancementProgress progress;
            player = (ServerPlayer)entity;
            ResourceLocation advId = new ResourceLocation("trbeyond", "it_really_works");
            Advancement advancement = player.f_8924_.m_129889_().m_136041_(advId);
            if (advancement != null && !(progress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
                for (String criterion : progress.m_8219_()) {
                    player.m_8960_().m_135988_(advancement, criterion);
                }
            }
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123767_, (double)1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
    }

    @SubscribeEvent
    public static void diabloDeflect(ProjectileImpactEvent event) {
        Player player;
        EntityHitResult entityHitResult;
        Entity entity;
        Projectile projectile = event.getProjectile();
        if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = (entityHitResult = (EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof Player && (entity = (player = (Player)entity).m_21211_().m_41720_()) instanceof DiabloClawItem) {
            DiabloClawItem diabloClawItem = (DiabloClawItem)entity;
            if (!((List)ServerConfig.INSTANCE.diabloClawBlacklist.get()).contains(projectile.m_6095_().m_204041_().m_205785_().m_135782_().toString())) {
                event.setCanceled(true);
                projectile.m_20256_(player.m_20154_().m_82541_().m_82490_(projectile.m_20184_().m_82553_() * 1.1));
                player.m_6672_(InteractionHand.MAIN_HAND);
                diabloClawItem.hasReflected = true;
                projectile.m_5602_((Entity)player);
                if (projectile instanceof TensuraProjectile) {
                    TensuraProjectile tensuraProjectile = (TensuraProjectile)projectile;
                    tensuraProjectile.m_5602_((Entity)player);
                    tensuraProjectile.setDamage(tensuraProjectile.getDamage() * 1.05f);
                }
                if (player.f_19853_.f_46443_) {
                    player.f_19853_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BeyondSoundEvents.diablo_claw_deflect.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void diabloCooldown(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = event.getItem().m_41720_();
            if (livingEntity instanceof DiabloClawItem) {
                int maxTime;
                DiabloClawItem diabloClawItem = (DiabloClawItem)livingEntity;
                int useTime = event.getItem().m_41779_() - event.getDuration();
                int n = maxTime = diabloClawItem.hasReflected ? 200 : 40;
                if (useTime >= maxTime) {
                    player.m_5810_();
                    player.m_36335_().m_41524_((Item)diabloClawItem, 40);
                    diabloClawItem.hasReflected = false;
                }
            }
        }
    }
}

