/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.manascore.api.skills.event.SkillActivationEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.entity.BlackSpiderEntity;
import com.github.manasmods.tensura.entity.SupermassiveSlimeEntity;
import com.github.manasmods.tensura.entity.magic.projectile.AuraSlashProjectile;
import com.github.manasmods.tensura.event.SpiritualHurtEvent;
import com.github.manasmods.tensura.registry.battlewill.ProjectileArts;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.Memoires.trbeyond.TRBeyond;
import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.entity.custom.ShrineEntity;
import io.github.Memoires.trbeyond.handlers.ChallengeEventHandler;
import io.github.Memoires.trbeyond.items.custom.SubspacePocketItem;
import io.github.Memoires.trbeyond.items.weapons.GorikimaruItem;
import io.github.Memoires.trbeyond.items.weapons.HakuroItem;
import io.github.Memoires.trbeyond.items.weapons.NinjatoItem;
import io.github.Memoires.trbeyond.items.weapons.scaleShieldItem;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.network.worldgen.portal.BeyondTeleporterUpdated;
import io.github.Memoires.trbeyond.registry.effects.BeyondEffects;
import io.github.Memoires.trbeyond.registry.items.BeyondItems;
import io.github.Memoires.trbeyond.util.BeyondDamageHelper;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import io.github.Memoires.trbeyond.util.BeyondSpawnUtils;
import io.github.Memoires.trbeyond.util.ChallengeType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trbeyond")
public class ServerEventHandler {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_) {
            Int2ObjectMap trades = event.getTrades();
            ItemStack stack = new ItemStack((ItemLike)BeyondItems.DUNGEON_MAP.get(), 1);
            int villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), stack, 10, 0, 0.0f));
        }
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance == null) {
            return;
        }
        if (effectInstance.m_19544_().equals(BeyondEffects.LIMITED.get())) {
            DungeonCapability.setEpLimit(event.getEntity(), 0.0);
        }
    }

    @SubscribeEvent
    public static void BlockSpiritualDamage(SpiritualHurtEvent event) {
        LivingEntity target = event.getEntity();
        ItemStack stack = target.m_21206_();
        if (target instanceof Player) {
            scaleShieldItem scaleShieldItem2;
            Player player = (Player)target;
            Item item = stack.m_41720_();
            if (item instanceof scaleShieldItem && (scaleShieldItem2 = (scaleShieldItem)item).m_41460_(stack) == BeyondRarity.GOD && player.m_21254_()) {
                stack.m_41721_(stack.m_41773_() + 1);
                event.setAmount(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void advancementGain(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        Advancement advancement = event.getAdvancement();
        if (advancement.m_138327_().equals((Object)new ResourceLocation("trbeyond", "e_rank_card")) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int p = serverPlayer.m_150109_().m_36030_(new ItemStack((ItemLike)BeyondItems.ID_CARD.get()));
            serverPlayer.m_150109_().m_6836_(p, ((Item)BeyondItems.E_RANK_CARD.get()).m_7968_());
        }
    }

    @SubscribeEvent
    public static void increasedDamageHakuroSword(LivingHurtEvent e) {
        DamageSource source = e.getSource();
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entity2;
            ItemStack stackOffHand = entity.m_21206_();
            ItemStack stackMainHand = entity.m_21205_();
            if (BeyondDamageHelper.isBattleWill(source)) {
                if (stackOffHand.m_41720_() instanceof HakuroItem) {
                    e.setAmount(e.getAmount() * 2.0f);
                }
                if (stackMainHand.m_41720_() instanceof HakuroItem) {
                    e.setAmount(e.getAmount() * 2.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void changeTargets(LivingChangeTargetEvent event) {
        if (event.getEntity() instanceof BlackSpiderEntity && event.getOriginalTarget() instanceof BossBlackSpiderEntity) {
            event.setCanceled(true);
        }
        if (event.getNewTarget() != null && event.getEntity().getPersistentData().m_128441_("challengeMob") && !(event.getNewTarget() instanceof ShrineEntity) && event.getNewTarget().getPersistentData().m_128441_("challengeMob") && event.getEntity().getPersistentData().m_128461_("challengeMob").equals(event.getNewTarget().getPersistentData().m_128461_("challengeMob"))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().m_7639_() != null && !(event.getEntity() instanceof ShrineEntity) && event.getSource().m_7639_().getPersistentData().m_128441_("challengeMob") && event.getEntity().getPersistentData().m_128441_("challengeMob") && event.getSource().m_7639_().getPersistentData().m_128461_("challengeMob").equals(event.getEntity().getPersistentData().m_128461_("challengeMob"))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void lockAgreCannon(SkillActivationEvent event) {
        if (event.getSkillInstance().getSkill().equals(ProjectileArts.OGRE_SWORD_CANNON.get()) && event.getEntity().m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GorikimaruItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void bypassArmor(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        Entity directEntity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (directEntity instanceof AuraSlashProjectile && living.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof GorikimaruItem) {
                source = new TensuraDamageSource(source).setIgnoreResistance(1.0f).m_19380_();
                event.getEntity().m_6469_(source, event.getAmount());
            }
        }
    }

    @SubscribeEvent
    public static void OnEquipmentChange(LivingEquipmentChangeEvent event) {
        Item item = event.getTo().m_41720_();
        if (item instanceof NinjatoItem) {
            NinjatoItem item2 = (NinjatoItem)item;
            if (event.getEntity() != null) {
                item2.setUser(event.getEntity());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            if (!player2.getPersistentData().m_128441_("floor")) {
                player2.getPersistentData().m_128405_("floor", -1);
            }
            int currentFloor = BeyondSpawnUtils.GetFloorFromBlockPos(player2.m_20097_());
            if (player2.getPersistentData().m_128451_("floor") != currentFloor) {
                player2.getPersistentData().m_128405_("floor", currentFloor);
                if (currentFloor == 1) {
                    ServerEventHandler.showTitle(player2, (Component)Component.m_237115_((String)"trbeyond.message.floor_display.lobby"));
                } else {
                    ServerEventHandler.showTitle(player2, (Component)Component.m_237110_((String)"trbeyond.message.floor_display", (Object[])new Object[]{currentFloor}));
                }
            }
            if (player2.m_20186_() >= 116.0 && player2.m_20186_() < 130.0) {
                if (player2.m_7500_() || player2.m_5833_()) {
                    return;
                }
                BeyondPlayerCapability.getFrom((Player)player2).ifPresent(cap -> {
                    if (!cap.isReturned() && !cap.isUsedTicket()) {
                        cap.setUsedTicket(false);
                        cap.setReturned(true);
                    }
                });
                BeyondPlayerCapability.sync((Player)player2);
            }
            if (player2.m_20186_() < 110.0) {
                ServerEventHandler.tpToLobby((Player)player2);
            }
        }
    }

    private static void showTitle(ServerPlayer player, Component pTitle) {
        ServerEventHandler.showTitle(player, pTitle, ClientboundSetTitleTextPacket::new);
        ServerEventHandler.setTimes(player, 10, 25, 10);
    }

    private static void showTitle(ServerPlayer player, Component pTitle, Function<Component, Packet<?>> packet) {
        try {
            player.f_8906_.m_9829_(packet.apply((Component)ComponentUtils.m_130731_(null, (Component)pTitle, (Entity)player, (int)0)));
        }
        catch (CommandSyntaxException e) {
            TRBeyond.getLogger().error("Error showing title to player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
        }
    }

    private static void setTimes(ServerPlayer player, int pFade, int pStay, int pFadeOut) {
        ClientboundSetTitlesAnimationPacket clientboundsettitlesanimationpacket = new ClientboundSetTitlesAnimationPacket(pFade, pStay, pFadeOut);
        player.f_8906_.m_9829_((Packet)clientboundsettitlesanimationpacket);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BeyondPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setReturned(true);
                ChallengeType currentChallenge = cap.getChallengeType();
                cap.setUsedTicket(false);
                if (currentChallenge != null && currentChallenge.getCategory() == "shrine") {
                    String shrineCoords = currentChallenge.getObjective();
                    String[] coordStrings = shrineCoords.trim().split("[^\\d-]+");
                    if (coordStrings.length == 3) {
                        BlockPos shrinePos = new BlockPos(Integer.parseInt(coordStrings[0]), Integer.parseInt(coordStrings[1]), Integer.parseInt(coordStrings[2]));
                        BlockState shrineState = player.m_9236_().m_8055_(shrinePos);
                        Block patt13846$temp = shrineState.m_60734_();
                        if (patt13846$temp instanceof ShrineBlock) {
                            ShrineBlock shrineBlock = (ShrineBlock)patt13846$temp;
                            shrineBlock.failChallenge(player.m_9236_(), shrinePos, player);
                        }
                    }
                    ChallengeEventHandler.failChallenge(player, currentChallenge);
                }
            });
            BeyondPlayerCapability.sync(player);
            if (player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                player.getPersistentData().m_128356_("dungeonEnterCooldown", System.currentTimeMillis() / 1000L);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        BeyondPlayerCapability.getFrom(e.getEntity()).ifPresent(cap -> {
            cap.setReturned(true);
            cap.setUsedTicket(false);
            ChallengeType currentChallenge = cap.getChallengeType();
            if (currentChallenge != null && currentChallenge.getCategory() == "shrine") {
                String shrineCoords = currentChallenge.getObjective();
                String[] coordStrings = shrineCoords.trim().split("[^\\d-]+");
                if (coordStrings.length == 3) {
                    BlockPos shrinePos = new BlockPos(Integer.parseInt(coordStrings[0]), Integer.parseInt(coordStrings[1]), Integer.parseInt(coordStrings[2]));
                    BlockState shrineState = e.getEntity().m_9236_().m_8055_(shrinePos);
                    Block patt15462$temp = shrineState.m_60734_();
                    if (patt15462$temp instanceof ShrineBlock) {
                        ShrineBlock shrineBlock = (ShrineBlock)patt15462$temp;
                        shrineBlock.failChallenge((Level)Objects.requireNonNull(Objects.requireNonNull(e.getEntity().m_9236_().m_7654_()).m_129880_(e.getFrom())), shrinePos, e.getEntity());
                    }
                }
                ChallengeEventHandler.failChallenge(e.getEntity(), currentChallenge);
            }
        });
        BeyondPlayerCapability.sync(e.getEntity());
        if (e.getFrom().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            e.getEntity().getPersistentData().m_128356_("dungeonEnterCooldown", System.currentTimeMillis() / 1000L);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone e) {
        if (e.isWasDeath()) {
            CompoundTag originalData = e.getOriginal().getPersistentData();
            if (originalData.m_128441_("dungeonEnterCooldown")) {
                e.getEntity().getPersistentData().m_128356_("dungeonEnterCooldown", originalData.m_128454_("dungeonEnterCooldown"));
            }
            DungeonCapability.getFrom((LivingEntity)e.getOriginal()).ifPresent(oldCap -> DungeonCapability.getFrom((LivingEntity)e.getEntity()).ifPresent(newCap -> newCap.deserializeNBT((Tag)((CompoundTag)oldCap.serializeNBT()))));
        }
    }

    public static void tpToLobby(Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        BeyondPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.isUsedTicket()) {
                cap.setReturned(false);
            }
            if (!cap.isUsedTicket() && cap.isReturned()) {
                ServerLevel dungeonLevel;
                if (!(player instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_19877_();
                MinecraftServer server = serverPlayer.m_20194_();
                if (server != null && (dungeonLevel = server.m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY)) != null) {
                    double lobbyX = 9.5;
                    double lobbyY = 116.0;
                    double lobbyZ = 9.5;
                    BlockPos lobbyPos = new BlockPos(9, 116, 9);
                    ChunkPos chunkPos = new ChunkPos(lobbyPos);
                    dungeonLevel.m_7726_().m_8387_(TicketType.f_9447_, chunkPos, 3, (Object)lobbyPos);
                    dungeonLevel.m_7726_().m_7587_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                    server.execute(() -> {
                        try {
                            serverPlayer.m_8999_(dungeonLevel, lobbyX, lobbyY, lobbyZ, 0.0f, 0.0f);
                            serverPlayer.m_6034_(lobbyX, lobbyY, lobbyZ);
                            serverPlayer.m_20256_(Vec3.f_82478_);
                            serverPlayer.f_19812_ = false;
                            server.execute(() -> {
                                serverPlayer.f_8906_.m_9774_(lobbyX, lobbyY, lobbyZ, 0.0f, 0.0f);
                                serverPlayer.f_8906_.m_9953_();
                                serverPlayer.m_19890_(lobbyX, lobbyY, lobbyZ, 0.0f, 0.0f);
                                server.execute(() -> BeyondPlayerCapability.sync((Player)serverPlayer));
                            });
                        }
                        catch (Exception e) {
                            System.out.println("teleportTo failed, using command fallback: " + e.getMessage());
                            String dimensionName = dungeonLevel.m_46472_().m_135782_().toString();
                            String command = String.format("execute in %s run tp %s %.1f %.1f %.1f", dimensionName, serverPlayer.m_36316_().getName(), lobbyX, lobbyY, lobbyZ);
                            server.m_129892_().m_230957_(server.m_129893_(), command);
                            server.execute(() -> {
                                serverPlayer.m_6034_(lobbyX, lobbyY, lobbyZ);
                                serverPlayer.m_20256_(Vec3.f_82478_);
                                BeyondPlayerCapability.sync((Player)serverPlayer);
                            });
                        }
                    });
                }
            }
        });
    }

    @SubscribeEvent
    public static void playerDungeonTeleport(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.getServer().m_129783_().m_46467_() % 20L != 0L) {
            return;
        }
        if (DungeonSaveData.getOverworld((Level)event.getServer().m_129783_()).getTpToDungeonPlayers().isEmpty()) {
            return;
        }
        ArrayList<ServerPlayer> tpToDungeonPlayers = new ArrayList<ServerPlayer>();
        for (UUID uUID : DungeonSaveData.getOverworld((Level)event.getServer().m_129783_()).getTpToDungeonPlayers()) {
            tpToDungeonPlayers.add(event.getServer().m_6846_().m_11259_(uUID));
        }
        if (!tpToDungeonPlayers.isEmpty() && !BeyondTeleporterUpdated.generateDungeon(event.getServer().m_129783_(), event.getServer().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY))) {
            for (Player player : tpToDungeonPlayers) {
                if (player == null) continue;
                DungeonSaveData.getOverworld((Level)event.getServer().m_129783_()).removeTpToDungeonPlayer(player.m_20148_());
                DungeonCapability.sync((LivingEntity)player);
                ServerLevel serverLevel = event.getServer().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
                if (serverLevel != null) {
                    SkillHelper.moveAcrossDimensionTo((Entity)player, (double)9.5, (double)118.0, (double)-23.5, (float)0.0f, (float)0.0f, (ServerLevel)serverLevel);
                    continue;
                }
                TRBeyond.getLogger().warn("Dungeon level is null, cannot teleport player: {}", (Object)player.m_7755_().getString());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY && event.getItemStack().m_41619_() && event.getLevel().m_8055_(event.getPos()).m_60734_().isBed(event.getLevel().m_8055_(event.getPos()), (BlockGetter)event.getLevel(), event.getPos(), (Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getEntity().m_21205_().m_41720_() instanceof SubspacePocketItem) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getEntity().m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof SubspacePocketItem) {
            SubspacePocketItem subspacePocketItem = (SubspacePocketItem)item;
            if (event.getEntity().m_6047_() && (item = event.getTarget()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)item;
                event.setCanceled(true);
                event.setCancellationResult(subspacePocketItem.m_6880_(stack, event.getEntity(), livingEntity, InteractionHand.MAIN_HAND));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathSupermassiveSlime(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof SupermassiveSlimeEntity) {
            SupermassiveSlimeEntity slime = (SupermassiveSlimeEntity)livingEntity;
            if (event.getSource().m_7639_().f_19853_.m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY) {
                for (ServerPlayer player2 : event.getEntity().f_19853_.m_7654_().m_6846_().m_11314_().stream().filter(player -> player.m_20280_((Entity)slime) < 100.0).toList()) {
                    TRBeyond.getLogger().info("Supermassive Slime killed near player: " + player2.m_7755_().getString());
                    slime.m_6452_(player2);
                }
            }
        }
    }
}

