/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.handlers;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.client.collision.OBB;
import io.github.Memoires.trbeyond.client.collision.TargetFinder;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VortexCrashHandler {
    public static void useSkillServerSide(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!SkillHelper.outOfAura((LivingEntity)player, (double)0.0)) {
            player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)BeyondSoundEvents.VORTEX_CRASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            VortexCrashTickHandler handler = new VortexCrashTickHandler(player, stack);
            MinecraftForge.EVENT_BUS.register((Object)handler);
        }
    }

    public static class VortexCrashTickHandler {
        private final ServerPlayer player;
        private final ItemStack stack;
        private int ticks = 0;

        public VortexCrashTickHandler(ServerPlayer player, ItemStack stack) {
            this.player = player;
            this.stack = stack;
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (this.player.m_213877_()) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            ++this.ticks;
            if (this.player.f_19853_.m_8055_(this.player.m_20097_().m_7495_()).m_60767_() == Material.f_76296_) {
                Vec3 deltaMovement = new Vec3(this.player.m_20184_().f_82479_, 0.0, this.player.m_20184_().f_82481_);
                this.player.m_20256_(deltaMovement);
            }
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this.player, (ParticleOptions)((ParticleOptions)TensuraParticles.WATER_EFFECT.get()));
            if (this.ticks == 49 || this.ticks == 52 || this.ticks == 55 || this.ticks == 61) {
                TargetFinder.TargetResult result = VortexCrashTickHandler.findAttackTargetResult(this.player, 22.0);
                List<Entity> entities = result.entities;
                for (Entity entity : entities) {
                    DamageSource source = DamageSource.m_19370_((LivingEntity)this.player).m_19380_();
                    entity.f_19802_ = 0;
                    entity.m_6469_(source, 50.0f);
                    entity.f_19802_ = 0;
                    entity.m_6469_(TensuraDamageSources.elementalAttack((String)"tensura.water_attack", (Entity)this.player, (boolean)true), 250.0f);
                    entity.f_19802_ = 0;
                    entity.m_6469_(TensuraDamageSources.elementalAttack((String)"tensura.water_attack", (Entity)this.player, (boolean)true).m_19380_(), 250.0f);
                }
            }
            if (this.ticks >= 65) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }

        public static TargetFinder.TargetResult findAttackTargetResult(ServerPlayer player, double attackRange) {
            Vec3 origin = TargetFinder.getInitialTracingPoint((Player)player);
            List<Entity> entities = TargetFinder.getInitialTargets((Player)player, attackRange);
            Vec3 size = new Vec3(attackRange / 6.0, attackRange / 6.0, attackRange);
            OBB obb = new OBB(origin, size, 0.0f, player.m_146908_());
            obb.updateVertex();
            TargetFinder.CollisionFilter collisionFilter = new TargetFinder.CollisionFilter(obb);
            entities = collisionFilter.filter(entities);
            TargetFinder.RadialFilter radialFilter = new TargetFinder.RadialFilter(origin, obb.axisZ, attackRange, player.m_146908_());
            entities = radialFilter.filter(entities);
            return new TargetFinder.TargetResult(entities, obb);
        }
    }
}

