/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.armor;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.Memoires.trbeyond.items.BeyondArmourMaterials;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;

public class DiabloArmorItem
extends BeyondArmorItem {
    public DiabloArmorItem(ArmorMaterial material, EquipmentSlot equipmentSlot, Rarity rarity) {
        super(material, equipmentSlot, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(rarity));
    }

    public DiabloArmorItem(EquipmentSlot slot, Grade grade) {
        this(grade.getMaterial(), slot, grade.getRarity());
    }

    public DiabloArmorItem(EquipmentSlot slot, Grade grade, Item.Properties properties) {
        super(grade.getMaterial(), slot, properties.m_41497_(grade.getRarity()));
    }

    public static void applyEnchants(ItemStack toStack, ItemStack fromStack, EquipmentSlot toSlot) {
        DiabloArmorItem diabloArmorItem;
        Item item;
        Enchantment darknessInfusion = (Enchantment)BeyondEnchantments.DARKNESS_INFUSION.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR) && (item = toStack.m_41720_()) instanceof DiabloArmorItem && (diabloArmorItem = (DiabloArmorItem)item).m_41460_(fromStack).equals((Object)Grade.GOD.getRarity()) && toStack.getEnchantmentLevel(darknessInfusion) < 1) {
            EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)darknessInfusion, (int)1);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.FEET) {
            return ImmutableMultimap.of();
        }
        return super.m_7167_(slot);
    }

    public boolean isDamageable(ItemStack stack) {
        return !this.f_40377_.equals((Object)EquipmentSlot.FEET);
    }

    public static enum Grade {
        LEGEND(BeyondArmourMaterials.DIABLO_LEGEND, BeyondRarity.LEGEND),
        GOD(BeyondArmourMaterials.DIABLO_GOD, BeyondRarity.GOD),
        SPECIAL(BeyondArmourMaterials.DIABLO_SPECIAL, BeyondRarity.SPECIAL);

        private final ArmorMaterial material;
        private final Rarity rarity;

        public ArmorMaterial getMaterial() {
            return this.material;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(ArmorMaterial material, Rarity rarity) {
            this.material = material;
            this.rarity = rarity;
        }
    }
}

