/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.armor;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import io.github.Memoires.trbeyond.items.BeyondArmourMaterials;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;

public class MinosArmorItem
extends BeyondArmorItem {
    public MinosArmorItem(ArmorMaterial material, EquipmentSlot equipmentSlot, Rarity rarity) {
        super(material, equipmentSlot, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(rarity));
    }

    public MinosArmorItem(EquipmentSlot slot, Grade grade) {
        this(grade.getMaterial(), slot, grade.getRarity());
    }

    public static void applyHolyCoat(ItemStack toStack, ItemStack fromStack, LivingEntity entity, EquipmentSlot toSlot) {
        Enchantment enchantment = (Enchantment)TensuraEnchantments.HOLY_COAT.get();
        Predicate<ItemStack> predicate = stack -> stack.m_41720_() instanceof MinosArmorItem;
        if (predicate.test(toStack) && toStack.getEnchantmentLevel(enchantment) < 2) {
            EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)enchantment, (int)2);
        }
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return;
        }
        if (BeyondArmorItem.hasFullSet(entity, predicate, 4)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack2;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (stack2 = entity.m_6844_(slot)).getEnchantmentLevel(enchantment) >= 3) continue;
                EngravingEnchantment.engrave((ItemStack)stack2, (Enchantment)enchantment, (int)3);
            }
        } else {
            if (fromStack.m_41720_() instanceof MinosArmorItem && fromStack.getEnchantmentLevel(enchantment) == 3) {
                EngravingEnchantment.engrave((ItemStack)fromStack, (Enchantment)enchantment, (int)2);
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack3;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (stack3 = entity.m_6844_(slot)).getEnchantmentLevel(enchantment) != 3) continue;
                EngravingEnchantment.engrave((ItemStack)stack3, (Enchantment)enchantment, (int)2);
            }
        }
    }

    public static enum Grade {
        UNIQUE(BeyondArmourMaterials.MINOS_UNIQUE, BeyondRarity.UNIQUE),
        LEGEND(BeyondArmourMaterials.MINOS_LEGEND, BeyondRarity.LEGEND),
        GOD(BeyondArmourMaterials.MINOS_GOD, BeyondRarity.GOD);

        private final ArmorMaterial material;
        private final Rarity rarity;

        public ArmorMaterial getMaterial() {
            return this.material;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(ArmorMaterial material, Rarity rarity) {
            this.material = material;
            this.rarity = rarity;
        }
    }
}

