/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.armor;

import com.github.manasmods.manascore.api.attribute.AttributeModifierHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import io.github.Memoires.trbeyond.items.BeyondArmourMaterials;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.items.weapons.OgreAxeItem;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;

public class OgreArmorItem
extends BeyondArmorItem {
    public static final UUID ATTACK_UUID = UUID.fromString("03d8a37a-61c6-4ed8-a4bf-0afeb6aa3383");

    public OgreArmorItem(ArmorMaterial material, EquipmentSlot equipmentSlot, Rarity rarity) {
        super(material, equipmentSlot, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(rarity));
    }

    public OgreArmorItem(EquipmentSlot slot, Grade grade) {
        this(grade.getMaterial(), slot, grade.getRarity());
    }

    public static void applyEffects(ItemStack toStack, ItemStack fromStack, LivingEntity entity, EquipmentSlot toSlot) {
        if ((toStack.m_150930_((Item)BeyondToolItems.OGRE_AXE_GOD.get()) || toStack.m_41720_() instanceof OgreArmorItem && toStack.m_41791_() == BeyondRarity.GOD) && toStack.getEnchantmentLevel((Enchantment)BeyondEnchantments.FIRE_INFUSION.get()) < 1) {
            EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)((Enchantment)BeyondEnchantments.FIRE_INFUSION.get()), (int)1);
        }
        if (BeyondArmorItem.hasFullSet(entity, stack -> stack.m_41720_() instanceof OgreArmorItem || stack.m_41720_() instanceof OgreAxeItem, 4, true)) {
            AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)Attributes.f_22281_, (AttributeModifier)new AttributeModifier(ATTACK_UUID, "Ogre Boost", 15.0, AttributeModifier.Operation.ADDITION));
        } else {
            AttributeModifierHelper.removeModifier((LivingEntity)entity, (Attribute)Attributes.f_22281_, (UUID)ATTACK_UUID);
        }
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return;
        }
        Enchantment enchantment = (Enchantment)TensuraEnchantments.MAGIC_INTERFERENCE.get();
        if (BeyondArmorItem.hasFullSet(entity, stack -> stack.m_41720_() instanceof OgreArmorItem, 3)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack2;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (stack2 = entity.m_6844_(slot)).getEnchantmentLevel(enchantment) >= 1) continue;
                EngravingEnchantment.engrave((ItemStack)stack2, (Enchantment)enchantment, (int)1);
            }
        } else {
            if (fromStack.m_41720_() instanceof OgreArmorItem && fromStack.getEnchantmentLevel(enchantment) == 1) {
                EngravingEnchantment.engrave((ItemStack)fromStack, (Enchantment)enchantment, (int)0);
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack3;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (stack3 = entity.m_6844_(slot)).getEnchantmentLevel(enchantment) != 1 || !(stack3.m_41720_() instanceof OgreArmorItem)) continue;
                EngravingEnchantment.engrave((ItemStack)stack3, (Enchantment)enchantment, (int)0);
            }
        }
    }

    public static enum Grade {
        RARE(BeyondArmourMaterials.OGRE_RARE, BeyondRarity.RARE),
        UNIQUE(BeyondArmourMaterials.OGRE_UNIQUE, BeyondRarity.UNIQUE),
        LEGEND(BeyondArmourMaterials.OGRE_LEGEND, BeyondRarity.LEGEND),
        GOD(BeyondArmourMaterials.OGRE_GOD, BeyondRarity.GOD);

        private final ArmorMaterial material;
        private final Rarity rarity;

        public ArmorMaterial getMaterial() {
            return this.material;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(ArmorMaterial material, Rarity rarity) {
            this.material = material;
            this.rarity = rarity;
        }
    }
}

